/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.Collection;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.OntologyCleaner;
import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.exception.DomainException;
import org.ontobox.box.exception.RangeException;

public class OPropertyTestCase
extends SessionTestCase {
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() throws Exception {
        this.ont.delete();
        this.con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOPropertyDomain() throws Exception {
        OntClass cl1 = this.ont.createOntClass("c1", new OntClass[0]);
        OntClass cl2 = this.ont.createOntClass("c2", new OntClass[0]);
        OntClass cl3 = this.ont.createOntClass("c3", new OntClass[0]);
        try {
            cl1.addSubClass(cl3);
            OProperty o1 = this.ont.createOProperty("o1", null, null, null, null);
            OProperty o2 = this.ont.createOProperty("o2", cl1, null, 0, 10);
            OProperty o3 = this.ont.createOProperty("o3", null, cl1, null, null);
            OProperty o4 = this.ont.createOProperty("o4", cl1, cl1, null, null);
            try {
                Collection<OProperty> oprops = this.ont.getAllOProperties();
                OPropertyTestCase.assertEquals((int)4, (int)oprops.size());
                OPropertyTestCase.assertTrue((boolean)oprops.contains(o1));
                OPropertyTestCase.assertTrue((boolean)oprops.contains(o2));
                OPropertyTestCase.assertTrue((boolean)oprops.contains(o3));
                OPropertyTestCase.assertTrue((boolean)oprops.contains(o4));
                OPropertyTestCase.assertTrue((null == o1.getMinCardinality() ? 1 : 0) != 0);
                OPropertyTestCase.assertTrue((null == o1.getMaxCardinality() ? 1 : 0) != 0);
                OPropertyTestCase.assertEquals((Object)0, (Object)o2.getMinCardinality());
                OPropertyTestCase.assertEquals((Object)10, (Object)o2.getMaxCardinality());
                OPropertyTestCase.assertTrue((o1.getDomain() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertTrue((o1.getRange() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o2.getDomain());
                OPropertyTestCase.assertTrue((o2.getRange() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertTrue((o3.getDomain() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o3.getRange());
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o4.getDomain());
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o4.getRange());
                OntClass oldDomain = o4.getDomain();
                OntClass oldRange = o4.getRange();
                o4.setDomain(cl2);
                o4.setRange(null);
                OPropertyTestCase.assertEquals((Object)cl2, (Object)o4.getDomain());
                OPropertyTestCase.assertTrue((o4.getRange() == null ? 1 : 0) != 0);
                o4.setDomain(null);
                OPropertyTestCase.assertTrue((o4.getDomain() == null ? 1 : 0) != 0);
                o4.setDomain(oldDomain);
                o4.setRange(oldRange);
                OPropertyTestCase.assertTrue((o1.getDomain() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertTrue((o1.getRange() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o2.getDomain());
                OPropertyTestCase.assertTrue((o2.getRange() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertTrue((o3.getDomain() == null ? 1 : 0) != 0);
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o3.getRange());
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o4.getDomain());
                OPropertyTestCase.assertEquals((Object)cl1, (Object)o4.getRange());
                OPropertyTestCase.assertEquals((int)4, (int)this.ont.getAllOProperties().size());
                OntObject objAll = this.ont.createOntObject(new Object[0]);
                OntObject objCl1 = this.ont.createOntObject(new Object[0]);
                objCl1.addOntClass(cl1);
                OntObject objCl2 = this.ont.createOntObject(new Object[0]);
                objCl2.addOntClass(cl2);
                OntObject objCl3 = this.ont.createOntObject(new Object[0]);
                objCl3.addOntClass(cl3);
                try {
                    oprops = objAll.getAllOProperties();
                    OPropertyTestCase.assertEquals((int)2, (int)oprops.size());
                    OPropertyTestCase.assertTrue((boolean)oprops.contains(o1));
                    OPropertyTestCase.assertTrue((boolean)oprops.contains(o3));
                    objAll.addOPropertyValue(o1, objCl1);
                    objAll.addOPropertyValue(o1, objCl2);
                    objAll.addOPropertyValue(o1, objCl3);
                    objAll.addOPropertyValue(o3, objCl1);
                    objAll.addOPropertyValue(o3, objCl3);
                    try {
                        objAll.addOPropertyValue(o2, objCl1);
                        OPropertyTestCase.fail((String)"should raise DomainException");
                    }
                    catch (DomainException e) {
                        // empty catch block
                    }
                    try {
                        objAll.addOPropertyValue(o4, objCl1);
                        OPropertyTestCase.fail((String)"should raise DomainException");
                    }
                    catch (DomainException e) {
                        // empty catch block
                    }
                    try {
                        objAll.addOPropertyValue(o3, objCl2);
                        OPropertyTestCase.fail((String)"should raise RangeException");
                    }
                    catch (RangeException e) {
                        // empty catch block
                    }
                    objCl1.addOPropertyValue(o1, objAll);
                    objCl1.addOPropertyValue(o1, objCl2);
                    objCl1.addOPropertyValue(o1, objCl3);
                    objCl1.addOPropertyValue(o2, objAll);
                    objCl1.addOPropertyValue(o2, objCl2);
                    objCl1.addOPropertyValue(o2, objCl3);
                    objCl1.addOPropertyValue(o3, objCl3);
                    objCl1.addOPropertyValue(o4, objCl3);
                    oprops = objCl1.getAllOProperties();
                    OPropertyTestCase.assertEquals((int)4, (int)oprops.size());
                    OPropertyTestCase.assertTrue((boolean)oprops.contains(o1));
                    OPropertyTestCase.assertTrue((boolean)oprops.contains(o2));
                    OPropertyTestCase.assertTrue((boolean)oprops.contains(o3));
                    OPropertyTestCase.assertTrue((boolean)oprops.contains(o4));
                    try {
                        objCl1.addOPropertyValue(o3, objAll);
                        OPropertyTestCase.fail((String)"should raise RangeException");
                    }
                    catch (RangeException e) {
                        // empty catch block
                    }
                    try {
                        objCl1.addOPropertyValue(o4, objAll);
                        OPropertyTestCase.fail((String)"should raise RangeException");
                    }
                    catch (RangeException e) {
                        // empty catch block
                    }
                    try {
                        objCl1.addOPropertyValue(o3, objCl2);
                        OPropertyTestCase.fail((String)"should raise RangeException");
                    }
                    catch (RangeException e) {
                        // empty catch block
                    }
                    try {
                        objCl1.addOPropertyValue(o4, objCl2);
                        OPropertyTestCase.fail((String)"should raise RangeException");
                    }
                    catch (RangeException e) {
                        // empty catch block
                    }
                    objCl2.addOPropertyValue(o1, objAll);
                    objCl2.addOPropertyValue(o1, objCl1);
                    objCl2.addOPropertyValue(o1, objCl3);
                    objCl2.addOPropertyValue(o3, objCl1);
                    objCl2.addOPropertyValue(o3, objCl3);
                    try {
                        objCl2.addOPropertyValue(o2, objCl1);
                        OPropertyTestCase.fail((String)"should raise DomainException");
                    }
                    catch (DomainException e) {
                        // empty catch block
                    }
                    try {
                        objCl2.addOPropertyValue(o4, objCl1);
                        OPropertyTestCase.fail((String)"should raise DomainException");
                    }
                    catch (DomainException e) {
                        // empty catch block
                    }
                }
                finally {
                    objCl3.removeAllValues();
                    objCl2.removeAllValues();
                    objCl1.removeAllValues();
                    objAll.removeAllValues();
                    objCl3.delete();
                    objCl2.delete();
                    objCl1.delete();
                    objAll.delete();
                }
            }
            finally {
                o4.delete();
                o3.delete();
                o2.delete();
                o1.delete();
            }
        }
        finally {
            cl3.delete();
            cl2.delete();
            cl1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveAllValues() throws Exception {
        TProperty tprop = this.ont.createTProperty("all", null, null, null, null);
        OProperty oprop = this.ont.createOProperty("all2", null, null, null, null);
        OntObject obj = this.ont.createOntObject(new Object[0]);
        try {
            obj.addTPropertyString(tprop, "1");
            obj.addTPropertyString(tprop, "2");
            obj.addOPropertyValue(oprop, obj);
            OPropertyTestCase.assertEquals((int)2, (int)obj.getTPropertyStrings(tprop).size());
            OPropertyTestCase.assertEquals((int)1, (int)obj.getOPropertyValues(oprop).size());
            obj.removeAllValues();
            OPropertyTestCase.assertEquals((int)0, (int)obj.getTPropertyStrings(tprop).size());
            OPropertyTestCase.assertEquals((int)0, (int)obj.getOPropertyValues(oprop).size());
            obj.addTPropertyString(tprop, "1");
            obj.addTPropertyString(tprop, "2");
            obj.addOPropertyValue(oprop, obj);
            OPropertyTestCase.assertEquals((int)2, (int)obj.getTPropertyStrings(tprop).size());
            OPropertyTestCase.assertEquals((int)1, (int)obj.getOPropertyValues(oprop).size());
            obj.removeOValues(oprop);
            OPropertyTestCase.assertEquals((int)2, (int)obj.getTPropertyStrings(tprop).size());
            OPropertyTestCase.assertEquals((int)0, (int)obj.getOPropertyValues(oprop).size());
            obj.removeTValues(tprop);
            OPropertyTestCase.assertEquals((int)0, (int)obj.getTPropertyStrings(tprop).size());
            OPropertyTestCase.assertEquals((int)0, (int)obj.getOPropertyValues(oprop).size());
        }
        finally {
            obj.delete();
            tprop.delete();
            oprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetValue() throws Exception {
        OProperty oprop = this.ont.createOProperty("testoprop", null, null, 0, null);
        try {
            OntObject v = this.ont.createOntObject(new Object[0]);
            OntObject obj = this.ont.createOntObject(new Object[0]);
            try {
                try {
                    obj.addOPropertyValue(oprop, null);
                    OPropertyTestCase.fail((String)"should raise Exception");
                }
                catch (Exception e) {
                    // empty catch block
                }
                obj.addOPropertyValue(oprop, v);
                OPropertyTestCase.assertEquals((String)obj.getOPropertyValues(oprop).get(0).getFullName(), (String)v.getFullName());
                OPropertyTestCase.assertTrue((boolean)obj.getOPropertyValues(oprop).get(0).equals(v));
                OPropertyTestCase.assertEquals((Object)obj.getOPropertyValue(oprop), (Object)v);
            }
            finally {
                obj.removeAllValues();
                v.removeAllValues();
                obj.delete();
                v.delete();
            }
        }
        finally {
            oprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRange() throws Exception {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            OntClass cl = this.ont.createOntClass("superclass", new OntClass[0]);
            cleaner.addEntity(cl);
            OntClass cl2 = this.ont.createOntClass("aaa", new OntClass[0]);
            cleaner.addEntity(cl2);
            OProperty oprop = this.ont.createOProperty("nullrange", null, null, null, null);
            cleaner.addEntity(oprop);
            OPropertyTestCase.assertTrue((oprop.getRange() == null ? 1 : 0) != 0);
            OProperty oprop2 = this.ont.createOProperty("range1", null, cl, null, null);
            cleaner.addEntity(oprop2);
            OPropertyTestCase.assertEquals((Object)cl, (Object)oprop2.getRange());
            OPropertyTestCase.assertEquals((String)cl.getFullName(), (String)oprop2.getRange().getFullName());
            OProperty oprop3 = this.ont.createOProperty("range2", null, cl2, null, null);
            cleaner.addEntity(oprop3);
            OPropertyTestCase.assertEquals((Object)cl2, (Object)oprop3.getRange());
            OPropertyTestCase.assertEquals((String)cl2.getFullName(), (String)oprop3.getRange().getFullName());
        }
        finally {
            cleaner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllProperties() throws Exception {
        OntClass cl = this.ont.createOntClass("bbbb", new OntClass[0]);
        OntClass cl2 = this.ont.createOntClass("cccc", new OntClass[0]);
        try {
            OntObject obj = this.ont.createOntObject(new Object[0]);
            try {
                obj.addOntClass(cl2);
                OPropertyTestCase.assertEquals((int)0, (int)cl.getAllOProperties().size());
                OPropertyTestCase.assertEquals((int)0, (int)cl2.getAllOProperties().size());
                OPropertyTestCase.assertEquals((int)0, (int)obj.getAllOProperties().size());
                OPropertyTestCase.assertEquals((int)0, (int)cl.getOProperties().size());
                OPropertyTestCase.assertEquals((int)0, (int)cl2.getOProperties().size());
                OProperty oProp = this.ont.createOProperty("n", null, null, null, null);
                try {
                    OPropertyTestCase.assertEquals((int)1, (int)cl.getAllOProperties().size());
                    OPropertyTestCase.assertTrue((boolean)cl.getAllOProperties().contains(oProp));
                    OPropertyTestCase.assertEquals((int)1, (int)cl2.getAllOProperties().size());
                    OPropertyTestCase.assertTrue((boolean)cl2.getAllOProperties().contains(oProp));
                    OPropertyTestCase.assertEquals((int)1, (int)obj.getAllOProperties().size());
                    OPropertyTestCase.assertTrue((boolean)obj.getAllOProperties().contains(oProp));
                    OPropertyTestCase.assertEquals((int)0, (int)cl.getOProperties().size());
                    OPropertyTestCase.assertEquals((int)0, (int)cl2.getOProperties().size());
                    OProperty OProp2 = this.ont.createOProperty("t", cl, null, null, null);
                    try {
                        OPropertyTestCase.assertEquals((int)2, (int)cl.getAllOProperties().size());
                        OPropertyTestCase.assertTrue((boolean)cl.getAllOProperties().contains(OProp2));
                        OPropertyTestCase.assertEquals((int)1, (int)cl2.getAllOProperties().size());
                        OPropertyTestCase.assertFalse((boolean)cl2.getAllOProperties().contains(OProp2));
                        OPropertyTestCase.assertEquals((int)1, (int)obj.getAllOProperties().size());
                        OPropertyTestCase.assertFalse((boolean)obj.getAllOProperties().contains(OProp2));
                        OPropertyTestCase.assertEquals((int)1, (int)cl.getOProperties().size());
                        OPropertyTestCase.assertEquals((int)0, (int)cl2.getOProperties().size());
                        cl.addSubClass(cl2);
                        OPropertyTestCase.assertEquals((int)2, (int)cl.getAllOProperties().size());
                        OPropertyTestCase.assertTrue((boolean)cl.getAllOProperties().contains(OProp2));
                        OPropertyTestCase.assertTrue((boolean)cl.getAllOProperties().contains(oProp));
                        OPropertyTestCase.assertEquals((int)2, (int)cl2.getAllOProperties().size());
                        OPropertyTestCase.assertTrue((boolean)cl2.getAllOProperties().contains(OProp2));
                        OPropertyTestCase.assertTrue((boolean)cl2.getAllOProperties().contains(oProp));
                        OPropertyTestCase.assertEquals((int)2, (int)obj.getAllOProperties().size());
                        OPropertyTestCase.assertTrue((boolean)obj.getAllOProperties().contains(OProp2));
                        OPropertyTestCase.assertTrue((boolean)obj.getAllOProperties().contains(oProp));
                        OPropertyTestCase.assertEquals((int)1, (int)cl.getOProperties().size());
                        OPropertyTestCase.assertEquals((int)0, (int)cl2.getOProperties().size());
                    }
                    finally {
                        OProp2.delete();
                    }
                }
                finally {
                    oProp.delete();
                }
            }
            finally {
                obj.delete();
            }
        }
        finally {
            cl2.delete();
            cl.delete();
        }
    }
}

