/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import org.meta2project.model.Connection;
import org.meta2project.model.Ontology;
import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.exception.NotFoundException;

public class OntologyTestCase
extends SessionTestCase {
    private Connection con;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
    }

    protected void tearDown() throws Exception {
        this.con.close();
    }

    public void testBox() {
        Ontology ont = this.con.getOntology("http://ontobox.org/");
        Ontology ont2 = this.con.getOntology("http://ontobox.org/");
        OntologyTestCase.assertEquals((Object)ont, (Object)ont2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntology() throws Exception {
        int baseSize = this.con.getOntologies().size();
        Ontology ont = this.con.createOntology("http://meta2.teacode.com/testcase");
        try {
            OntologyTestCase.assertEquals((String)"http://meta2.teacode.com/testcase", (String)ont.getURI());
            OntologyTestCase.assertTrue((boolean)this.con.getOntologies().contains(ont));
            OntologyTestCase.assertEquals((int)(baseSize + 1), (int)this.con.getOntologies().size());
            Ontology ont2 = this.con.getOntology("http://meta2.teacode.com/testcase");
            OntologyTestCase.assertEquals((String)ont.getURI(), (String)ont2.getURI());
            OntologyTestCase.assertTrue((boolean)this.con.getOntologies().contains(ont));
            OntologyTestCase.assertTrue((boolean)this.con.getOntologies().contains(ont2));
            OntologyTestCase.assertEquals((int)(baseSize + 1), (int)this.con.getOntologies().size());
        }
        finally {
            ont.delete();
        }
    }

    public void testCreateOntologyName1() throws Exception {
        try {
            this.con.createOntology("123");
            OntologyTestCase.fail((String)"should raise Exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.con.createOntology("\u043f\u0440\u0438\u0432\u0435\u0442");
            OntologyTestCase.fail((String)"should raise Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntologyDub() throws Exception {
        Ontology ont = this.con.createOntology("http://meta2.teacode.com/testcase");
        try {
            this.con.createOntology("http://meta2.teacode.com/testcase");
            OntologyTestCase.fail((String)"should raise AlreadyExistsException");
        }
        catch (AlreadyExistsException alreadyExistsException) {
        }
        finally {
            ont.delete();
        }
    }

    public void testDeleteOntology() throws Exception {
        Ontology ont = this.con.createOntology("http://meta2.teacode.com/testcase");
        ont.delete();
        try {
            this.con.getOntology("http://meta2.teacode.com/testcase");
            OntologyTestCase.fail((String)"should raise NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }
}

