/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.helper.TempHelper;

public class TempHelperTestCase
extends SessionTestCase {
    private BoxWorker worker;

    protected void setUp() {
        this.worker = this.session.openTransaction().getWorker();
    }

    protected void tearDown() {
        this.worker.commit();
        this.worker.close();
    }

    public void testTemp() {
        BoxWriter writer = this.worker.write();
        int ont = writer.newOntology("http://temp.test");
        try {
            TempHelperTestCase.assertEquals((int)0, (int)this.worker.objects(ont).length);
            TempHelper.cleanUp(this.worker);
            TempHelperTestCase.assertEquals((int)0, (int)this.worker.objects(ont).length);
            int obj = writer.newObject(writer.newName(ont));
            TempHelperTestCase.assertFalse((boolean)TempHelper.isTemporary(this.worker, obj));
            TempHelper.makeTemporary(this.worker, obj);
            TempHelperTestCase.assertTrue((boolean)TempHelper.isTemporary(this.worker, obj));
            TempHelper.makeTemporary(this.worker, obj);
            TempHelperTestCase.assertTrue((boolean)TempHelper.isTemporary(this.worker, obj));
            for (int t = 0; t < 1000; ++t) {
                int m = writer.newObject(this.worker.name(ont, "name" + t));
                TempHelperTestCase.assertFalse((boolean)TempHelper.isTemporary(this.worker, m));
                TempHelper.makeTemporary(this.worker, m);
                TempHelperTestCase.assertTrue((boolean)TempHelper.isTemporary(this.worker, m));
            }
            TempHelper.cleanUp(this.worker);
            TempHelperTestCase.assertEquals((int)0, (int)this.worker.objects(ont).length);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            writer.delete(ont);
        }
    }
}

