/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.module.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.meta2project.module.ModuleLoader;

public abstract class AbstractModuleLoader
implements ModuleLoader {
    final Class[] moduleClasses;
    private final Map<Class, List<Object>> modules = new HashMap<Class, List<Object>>();

    AbstractModuleLoader(Class[] moduleClasses) {
        this.moduleClasses = moduleClasses;
        for (Class moduleClass : moduleClasses) {
            this.modules.put(moduleClass, new ArrayList());
        }
    }

    void addModule(Class cl, Object module) {
        List<Object> list = this.modules.get(cl);
        list.add(module);
    }

    @Override
    public <T> List<T> getModules(Class<T> moduleClass) {
        List<Object> m = this.modules.get(moduleClass);
        if (m == null) {
            throw new RuntimeException("Unknown module class " + moduleClass);
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (Object o : m) {
            ret.add(moduleClass.cast(o));
        }
        return ret;
    }

    @Override
    public boolean remove(Object moduleObject) {
        boolean ret = false;
        for (List<Object> objects : this.modules.values()) {
            if (!objects.remove(moduleObject)) continue;
            ret = true;
        }
        return ret;
    }

    String getAddModuleInfo(Object mod) {
        return null;
    }

    private static Element createNode(String title) {
        Element node = new Element("node");
        node.setAttribute("title", title);
        return node;
    }

    @Override
    public String getInfo() {
        Element root = AbstractModuleLoader.createNode("\u0417\u0430\u0433\u0440\u0443\u0437\u0447\u0438\u043a " + this.getClass().getName());
        for (Class moduleClass : this.moduleClasses) {
            List<Object> m = this.modules.get(moduleClass);
            Element modules = AbstractModuleLoader.createNode("\u041c\u043e\u0434\u0443\u043b\u0438 \u043a\u043b\u0430\u0441\u0441\u0430 " + moduleClass.getName());
            root.addContent((Content)modules);
            if (m.isEmpty()) continue;
            for (Object mod : m) {
                Element mEl = AbstractModuleLoader.createNode(mod.getClass().getName());
                String addInfo = this.getAddModuleInfo(mod);
                modules.addContent((Content)mEl);
                if (addInfo == null) continue;
                mEl.addContent((Content)AbstractModuleLoader.createNode(addInfo));
            }
        }
        return new XMLOutputter().outputString(root);
    }
}

