/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.module.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meta2project.module.impl.AbstractModuleLoader;

class ExternalModuleLoader
extends AbstractModuleLoader {
    private static final Logger logger = Logger.getLogger(ExternalModuleLoader.class.getName());

    public ExternalModuleLoader(File baseDir, Class[] moduleClasses) throws MalformedURLException {
        super(moduleClasses);
        File[] dirs;
        logger.info("baseDir=" + baseDir.getAbsoluteFile());
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            logger.warning("directory is not found or not directory");
            return;
        }
        for (File dir : dirs = baseDir.listFiles()) {
            if (!dir.isDirectory()) continue;
            logger.info("Found module: " + dir);
            this.loadFromDir(dir);
        }
    }

    void loadFromDir(File dir) throws MalformedURLException {
        List<String> classNames = ExternalModuleLoader.analizeProperties(dir);
        for (String className : classNames) {
            logger.info("Java entry point:" + className);
            this.loadModule(dir, className, this.moduleClasses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> analizeProperties(File moduleDir) {
        File propFile = new File(moduleDir, "module.properties");
        if (propFile.exists() && propFile.isFile()) {
            Properties prop = new Properties();
            try {
                FileInputStream in = new FileInputStream(propFile);
                try {
                    prop.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
                ArrayList<String> ret = new ArrayList<String>();
                String str = prop.getProperty("java");
                if (str != null) {
                    ret.add(str);
                }
                ArrayList<Integer> tempList = new ArrayList<Integer>();
                HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
                String PREFIX = "java.";
                for (Object o : prop.keySet()) {
                    String key = (String)o;
                    if (!key.startsWith(PREFIX)) continue;
                    String num = key.substring(PREFIX.length());
                    try {
                        Integer i = Integer.valueOf(num);
                        tempList.add(i);
                        tempMap.put(i, prop.getProperty(key));
                    }
                    catch (Exception e) {}
                }
                Collections.sort(tempList);
                for (Integer num : tempList) {
                    ret.add((String)tempMap.get(num));
                }
                return ret;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "loading properties failed", e);
            }
        }
        return Collections.emptyList();
    }

    void loadModule(File moduleDir, String className, Class[] moduleClasses) throws MalformedURLException {
        URL[] urls;
        File libDir = new File(moduleDir, "lib");
        if (libDir.exists() && libDir.isDirectory()) {
            ArrayList<URL> jarURLs = new ArrayList<URL>();
            for (File jarFile : libDir.listFiles()) {
                if (!jarFile.isFile() || !jarFile.getName().toLowerCase().endsWith(".jar")) continue;
                logger.info("\tfound jar: " + jarFile);
                URL jarURL = jarFile.toURI().toURL();
                logger.info("\tURL: " + jarURL);
                jarURLs.add(jarURL);
            }
            urls = new URL[jarURLs.size()];
            jarURLs.toArray(urls);
        } else {
            urls = new URL[]{};
        }
        ModuleClassLoader loader = new ModuleClassLoader(urls, this.getClass().getClassLoader(), moduleDir);
        try {
            Class<?> cl = loader.loadClass(className);
            this.addModule(moduleClasses, cl.newInstance());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "newInstance: ", e);
        }
    }

    void addModule(Class[] moduleClasses, Object obj) {
        for (Class cl : moduleClasses) {
            if (!cl.isInstance(obj)) continue;
            logger.info(obj + " added as " + cl.getName());
            this.addModule(cl, obj);
        }
    }

    @Override
    protected String getAddModuleInfo(Object mod) {
        ClassLoader cl = mod.getClass().getClassLoader();
        if (cl instanceof ModuleClassLoader) {
            ModuleClassLoader mcl = (ModuleClassLoader)cl;
            try {
                return "\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0438\u0437 " + mcl.getBaseDir().getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    static class ModuleClassLoader
    extends URLClassLoader {
        final File baseDir;

        public ModuleClassLoader(URL[] urls, ClassLoader parent, File baseDir) {
            super(urls, parent);
            this.baseDir = baseDir;
        }

        public File getBaseDir() {
            return this.baseDir;
        }
    }
}

