/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.server;

import com.teacode.util.Base64;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.meta2project.ontobox.server.HttpErrorException;
import org.meta2project.ontobox.server.ServerManager;
import org.meta2project.ontobox.server.UserContext;

public class OntoboxServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(OntoboxServlet.class.getName());

    public void destroy() {
        logger.info("Closing servlet");
        super.destroy();
        try {
            ServerManager.close(this.getServletContext());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "closing error", e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            int t;
            byte[] decoded;
            String BASIC;
            request.setCharacterEncoding("UTF-8");
            String s = request.getHeader("Authorization");
            if (s != null && s.startsWith(BASIC = "Basic ") && (decoded = Base64.decode((String)(s = s.substring(BASIC.length())))) != null && (t = (s = new String(decoded, "ASCII")).indexOf(58)) != -1) {
                String login = s.substring(0, t);
                String password = s.substring(t + 1);
                String name = request.getPathInfo();
                if (name == null || name.length() == 1 || name.charAt(0) != '/') {
                    throw new HttpErrorException(404);
                }
                name = name.substring(1);
                ServerManager manager = ServerManager.getInstance(this.getServletContext());
                UserContext context = manager.getUserContext(login, password, name);
                if (context != null) {
                    Object out;
                    boolean gzip = OntoboxServlet.isGZipAccepted(request);
                    response.setContentType("application/x-bml");
                    if (gzip) {
                        response.setHeader("Content-Encoding", "gzip");
                        out = new GZIPOutputStream((OutputStream)response.getOutputStream());
                    } else {
                        out = response.getOutputStream();
                    }
                    context.executeQuery(request.getParameter("query"), (OutputStream)out);
                    ((OutputStream)out).close();
                    return;
                }
            }
            throw new HttpErrorException(401);
        }
        catch (HttpErrorException e) {
            int code = e.getCode();
            if (code == 401 || code == 403) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"ontobox server\"");
            }
            response.sendError(code);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "ontobox server error", e);
            response.setHeader("X-Error", e.toString());
            response.sendError(500, e.toString());
        }
    }

    private static boolean isGZipAccepted(HttpServletRequest request) {
        String a = request.getHeader("Accept-Encoding");
        if (a == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(a, ",", false);
        while (st.hasMoreElements()) {
            String s = (String)st.nextElement();
            if (!s.equalsIgnoreCase("gzip")) continue;
            return true;
        }
        return true;
    }
}

