/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.owlapi.test;

import java.io.File;
import org.meta2project.fast.adapter.FastSession;
import org.meta2project.model.Connection;
import org.meta2project.model.OntClass;
import org.meta2project.model.Ontology;
import org.meta2project.owlapi.OWLAPI;
import org.ontobox.exchange.MVX;

public class OWLAPITest {
    private static void createStructure(Connection connection) {
        Ontology ont1 = connection.createOntology("http://ont1");
        Ontology ont2 = connection.createOntology("http://ont2");
        OntClass cl1 = ont1.createOntClass("cl1", new OntClass[0]);
        cl1.putAnnotation("http://meta2project.org/model#title", "\u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a");
        cl1.putAnnotation("http://meta2project.org/model#comment", "\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
        OntClass cl2 = ont2.createOntClass("cl2", cl1);
        ont1.createOntClass("cl3", cl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        FastSession ses = new FastSession();
        try {
            Connection connection = ses.openConnection();
            OWLAPITest.createStructure(connection);
            MVX.importFile(new File("persons.m2v1"), connection.getWorker());
            int t = 0;
            for (Ontology ont : connection.getOntologies()) {
                if (ont.getURI().equals("http://ontobox.org/")) continue;
                String baseName = "owl" + t++;
                OWLAPI.createRDFOWL(ont, new File(baseName + ".owl"));
                OWLAPI.createFSyntax(ont, new File(baseName + ".ofn"));
            }
        }
        finally {
            ses.close();
        }
    }
}

