/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.box2model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.meta2project.model.FindOption;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.box2model.BoxConnection;
import org.ontobox.box.box2model.BoxTProperty;
import org.ontobox.box.helper.Searcher;

public class BoxOntology
implements Ontology {
    protected final BoxConnection con;
    protected final int id;

    public BoxOntology(BoxConnection con, int id) {
        this.con = con;
        this.id = id;
    }

    @Override
    public String getURI() {
        return this.con.worker.name(this.id);
    }

    @Override
    public Type getType(String name) {
        String fn = this.con.worker.name(this.id, name);
        return this.con.getTypeByFullName(fn);
    }

    @Override
    public Collection<Type> getAllTypes() {
        return this.con.wrapTypes(this.con.worker.types(this.id));
    }

    @Override
    public OntClass getOntClass(String name) {
        String fn = this.con.worker.name(this.id, name);
        return this.con.getOntClassByFullName(fn);
    }

    @Override
    public Collection<OntClass> getOntClasses() {
        return this.con.wrapOntClasses(this.con.worker.classes(this.id));
    }

    @Override
    public Collection<OntClass> getBasicOntClasses() {
        return this.con.wrapOntClasses(this.con.worker.classesDirect(this.id));
    }

    @Override
    public OProperty getOProperty(String name) {
        String fn = this.con.worker.name(this.id, name);
        return this.con.getOPropertyByFullName(fn);
    }

    @Override
    public Collection<OProperty> getAllOProperties() {
        return this.con.wrapOProperties(this.con.worker.oprops(this.id));
    }

    @Override
    public TProperty getTProperty(String name) {
        String fn = this.con.worker.name(this.id, name);
        return this.con.getTPropertyByFullName(fn);
    }

    @Override
    public Collection<TProperty> getAllTProperties() {
        return this.con.wrapTProperties(this.con.worker.tprops(this.id));
    }

    @Override
    public OntObject getOntObject(String name) {
        String fn = this.con.worker.name(this.id, name);
        return this.con.getOntObjectByFullName(fn);
    }

    @Override
    public Collection<OntObject> getAllOntObjects() {
        return this.con.wrapOntObjects(this.con.worker.objects(this.id));
    }

    @Override
    public Type createType(String name) {
        String fn = this.con.worker.name(this.id, name);
        return this.con.wrapType(this.con.worker.write().newType(fn));
    }

    @Override
    public OntClass createOntClass(String name, OntClass ... parentClasses) {
        String fn = this.con.worker.name(this.id, name);
        OntClass ret = this.con.wrapOntClass(this.con.worker.write().newClass(fn));
        for (OntClass parentClass : parentClasses) {
            parentClass.addSubClass(ret);
        }
        return ret;
    }

    protected OntObject createObjectByFullName(String fullName, Object ... initParams) {
        OntObject ret = this.con.wrapOntObject(this.con.worker.write().newObject(fullName));
        for (Object initParam : initParams) {
            if (!(initParam instanceof OntClass)) {
                throw new IllegalArgumentException(initParam + " (" + initParam.getClass() + ')');
            }
            ret.addOntClass((OntClass)initParam);
        }
        return ret;
    }

    @Override
    public OntObject createOntObject(String name, Object ... initParams) {
        return this.createObjectByFullName(this.con.worker.name(this.id, name), initParams);
    }

    @Override
    public OntObject createOntObject(Object ... initParams) {
        String fn = this.con.worker.write().newName(this.id);
        return this.createObjectByFullName(fn, initParams);
    }

    @Override
    public OProperty createOProperty(String name, OntClass domain, OntClass range, Integer minCard, Integer maxCard) {
        String fn = this.con.worker.name(this.id, name);
        BoxWriter writer = this.con.worker.write();
        OProperty ret = this.con.wrapOProperty(writer.newOProperty(fn));
        if (domain != null) {
            ret.setDomain(domain);
        }
        if (range != null) {
            ret.setRange(range);
        }
        if (minCard != null) {
            ret.putAnnotation("http://ontobox.org/#mincard", minCard.toString());
        }
        if (maxCard != null) {
            ret.putAnnotation("http://ontobox.org/#maxcard", maxCard.toString());
        }
        return ret;
    }

    @Override
    public TProperty createTProperty(String name, OntClass domain, Type range, Integer minCard, Integer maxCard) {
        String fn = this.con.worker.name(this.id, name);
        BoxWriter writer = this.con.worker.write();
        BoxTProperty ret = this.con.wrapTProperty(writer.newTProperty(fn));
        if (domain != null) {
            ret.setDomain(domain);
        }
        if (range != null) {
            ret.setRange(range);
        }
        if (minCard != null) {
            ret.putAnnotation("http://ontobox.org/#mincard", minCard.toString());
        }
        if (maxCard != null) {
            ret.putAnnotation("http://ontobox.org/#maxcard", maxCard.toString());
        }
        return ret;
    }

    @Override
    public TProperty createTProperty(String name, OntClass domain, String rangeTypeURI, int minCard, int maxCard) {
        return this.createTProperty(name, domain, rangeTypeURI, minCard, (Integer)maxCard);
    }

    @Override
    public TProperty createTProperty(String name, OntClass domain, String rangeTypeURI, int minCard, Integer maxCard) {
        Type range = null;
        if (rangeTypeURI != null) {
            range = this.con.getTypeByFullName(rangeTypeURI);
        }
        return this.createTProperty(name, domain, range, (Integer)minCard, maxCard);
    }

    @Override
    public void setURI(String newuri) {
        this.con.worker.write().rename(this.id, newuri);
    }

    @Override
    public void delete() {
        this.con.worker.write().delete(this.id);
    }

    @Override
    public Collection<OntObject> find(FindOption option, String ... text) {
        if (text.length == 0) {
            return Collections.emptyList();
        }
        Searcher.SearchContext search = Searcher.findBySubstring(this.con.worker, text[0]);
        int size = text.length;
        for (int t = 1; t < size; ++t) {
            if (option == FindOption.AND) {
                search = search.andBySubstring(text[t]);
                continue;
            }
            if (option == FindOption.OR) {
                search = search.orBySubstring(text[t]);
                continue;
            }
            throw new IllegalArgumentException("Unknown option: " + (Object)((Object)option));
        }
        ArrayList<OntObject> ret = new ArrayList<OntObject>();
        for (int objectId : search.all()) {
            if (this.con.worker.ontology(objectId) != this.id) continue;
            ret.add(this.con.wrapOntObject(objectId));
        }
        return ret;
    }

    @Override
    public List<String> getAnnotationNames() {
        return Arrays.asList(this.con.worker.annames(this.id));
    }

    @Override
    public String getAnnotation(String name) {
        return this.con.worker.anno(this.id, name);
    }

    @Override
    public void putAnnotation(String name, String value) {
        this.con.worker.write().annotate(this.id, name, value);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj instanceof BoxOntology && this.id == ((BoxOntology)obj).id;
    }
}

