/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;

public class MapHelper {
    public static final String MAP_URI = "http://ontobox.org/map";
    public static final String MAP_CLASS = "http://ontobox.org/map#Map";
    public static final String TPROP_PREFIX = "tprop-";
    public static final String OPROP_PREFIX = "oprop-";
    public static final String TCL_PREFIX = "tcl-";
    public static final String OCL_PREFIX = "ocl-";

    public static void initIfNeed(BoxWorker worker) {
        if (worker.entity(MAP_CLASS) != Entity.ONTCLASS) {
            BoxWriter writer = worker.write();
            if (worker.entity(MAP_URI) != Entity.ONTOLOGY) {
                writer.newOntology(MAP_URI);
            }
            writer.newClass(MAP_CLASS);
        }
    }

    public static int create(BoxWorker worker) {
        MapHelper.initIfNeed(worker);
        BoxWriter writer = worker.write();
        return writer.newObject(writer.newName(worker.id(MAP_URI)));
    }

    public static int create(BoxWorker worker, int ontology) {
        BoxWriter writer = worker.write();
        String n = writer.newName(ontology);
        return writer.newObject(n);
    }

    public static int makeMap(BoxWorker worker, int object) {
        return object;
    }

    public static void removeKey(BoxWorker worker, int map, String key) {
        String clPrefix;
        String propPrefix;
        BoxWriter writer = worker.write();
        if (MapHelper.isTkey(worker, map, key)) {
            propPrefix = TPROP_PREFIX;
            clPrefix = TCL_PREFIX;
        } else if (MapHelper.isOkey(worker, map, key)) {
            propPrefix = OPROP_PREFIX;
            clPrefix = OCL_PREFIX;
        } else {
            throw new IllegalArgumentException(key + " is not key for the " + worker.name(map) + " object");
        }
        int prop = worker.resolve(worker.name(worker.id(MAP_URI), propPrefix + key));
        int cl = worker.resolve(worker.name(worker.id(MAP_URI), clPrefix + key));
        writer.removeValues(map, prop);
        writer.removeObjectClass(map, cl);
        if (worker.objects(cl).length == 0) {
            writer.delete(prop);
            writer.delete(cl);
        }
    }

    public static boolean isMap(BoxWorker worker, int object) {
        Integer cl = worker.id(MAP_CLASS);
        return cl != null && RHelper.contains(worker.classes(object), cl);
    }

    public static String name(BoxWorker worker, int prop) {
        String name = worker.name(prop);
        String localName = worker.local(prop);
        Entity entity = worker.entity(name);
        if (worker.name(worker.ontology(prop)).equals(MAP_URI)) {
            if (entity == Entity.TPROPERTY && localName.startsWith(TPROP_PREFIX)) {
                return localName.substring(TPROP_PREFIX.length());
            }
            if (entity == Entity.OPROPERTY && localName.startsWith(OPROP_PREFIX)) {
                return localName.substring(OPROP_PREFIX.length());
            }
        }
        return null;
    }

    public static boolean isTkey(BoxWorker worker, int map, String key) {
        int[] classes = worker.classes(map);
        Integer tcl = worker.id("http://ontobox.org/map#tcl-" + key);
        return tcl != null && RHelper.contains(classes, tcl);
    }

    public static boolean isOkey(BoxWorker worker, int map, String key) {
        int[] classes = worker.classes(map);
        Integer ocl = worker.id("http://ontobox.org/map#ocl-" + key);
        return ocl != null && RHelper.contains(classes, ocl);
    }

    public static String[] getTKeys(BoxWorker worker, int map) {
        if (!MapHelper.isMap(worker, map)) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int tprop : worker.tprops(map)) {
            String name = MapHelper.name(worker, tprop);
            if (name == null) continue;
            ret.add(name);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static String[] getOKeys(BoxWorker worker, int map) {
        if (!MapHelper.isMap(worker, map)) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int oprop : worker.oprops(map)) {
            String name = MapHelper.name(worker, oprop);
            if (name == null) continue;
            ret.add(name);
        }
        return ret.toArray(new String[ret.size()]);
    }

    public static int tkey(BoxWorker worker, int map, String key) {
        int tcl;
        int tprop;
        MapHelper.initIfNeed(worker);
        if (MapHelper.isOkey(worker, map, key)) {
            throw new IllegalStateException("Key " + key + " is defined already as o-key for the " + worker.name(map) + " object");
        }
        BoxWriter writer = worker.write();
        String propfn = worker.name(worker.id(MAP_URI), TPROP_PREFIX + key);
        String clfn = worker.name(worker.id(MAP_URI), TCL_PREFIX + key);
        if (worker.entity(propfn) == Entity.TPROPERTY) {
            tprop = worker.id(propfn);
            tcl = worker.id(clfn);
        } else {
            tprop = writer.newTProperty(propfn);
            tcl = writer.newClass(clfn);
            writer.addSubclass(worker.resolve(MAP_CLASS), tcl);
            writer.setDomain(tprop, tcl);
        }
        if (!RHelper.contains(worker.classes(map), tcl)) {
            writer.addObjectClass(map, tcl);
        }
        return tprop;
    }

    public static int okey(BoxWorker worker, int map, String key) {
        int ocl;
        int oprop;
        MapHelper.initIfNeed(worker);
        if (MapHelper.isTkey(worker, map, key)) {
            throw new IllegalStateException("Key " + key + " is defined already as t-key for the " + worker.name(map) + " object");
        }
        BoxWriter writer = worker.write();
        String propfn = worker.name(worker.id(MAP_URI), OPROP_PREFIX + key);
        String clfn = worker.name(worker.id(MAP_URI), OCL_PREFIX + key);
        if (worker.entity(propfn) == Entity.OPROPERTY) {
            oprop = worker.id(propfn);
            ocl = worker.id(clfn);
        } else {
            oprop = writer.newOProperty(propfn);
            ocl = writer.newClass(clfn);
            writer.addSubclass(worker.resolve(MAP_CLASS), ocl);
            writer.setDomain(oprop, ocl);
        }
        if (!RHelper.contains(worker.classes(map), ocl)) {
            writer.addObjectClass(map, ocl);
        }
        return oprop;
    }

    public static Map<String, String> toTMap(BoxWorker worker, int map) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String name : MapHelper.getTKeys(worker, map)) {
            int prop = MapHelper.tkey(worker, map, name);
            String value = RHelper.stringValue(worker, map, prop);
            if (value == null) continue;
            ret.put(name, value);
        }
        return ret;
    }

    public static Map<String, List<String>> toTMaps(BoxWorker worker, int map) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (String name : MapHelper.getTKeys(worker, map)) {
            int prop = MapHelper.tkey(worker, map, name);
            String[] values = worker.strings(map, prop);
            if (values.length == 0) continue;
            ret.put(name, Arrays.asList(values));
        }
        return ret;
    }

    public static Map<String, Object> toTMaps2(BoxWorker worker, int map) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String name : MapHelper.getTKeys(worker, map)) {
            int prop = MapHelper.tkey(worker, map, name);
            String[] values = worker.strings(map, prop);
            if (values.length == 0) continue;
            ret.put(name, Arrays.asList(values));
        }
        return ret;
    }
}

