/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.query;

import java.util.ArrayList;
import java.util.List;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.SplittedName;
import org.ontobox.box.query.FunctionParam;
import org.ontobox.libretto.T;
import org.ontobox.libretto.function.FunctionDef;
import org.ontobox.libretto.function.FunctionType;

public class FunctionInfo {
    private final String uri;
    private final String local;
    private final List<List<FunctionParam>> signatures = new ArrayList<List<FunctionParam>>();
    private final boolean collectionWise;

    public FunctionInfo(BoxWorker worker, FunctionDef def) {
        SplittedName sn = NameHelper.splitName(def.getName());
        this.uri = sn.ontology();
        this.local = sn.local();
        this.collectionWise = def.isCollectionWise();
        for (FunctionType type : def.getTypes()) {
            int arity = type.getArity();
            ArrayList<FunctionParam> params = new ArrayList<FunctionParam>(arity);
            for (int t = 0; t < arity; ++t) {
                int type2 = type.getType(worker, t);
                params.add(new FunctionParam(type.getName(t), type.getCard(t) == T.COLLECTION_WISE, worker.name(type2)));
            }
            this.signatures.add(params);
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getLocal() {
        return this.local;
    }

    public List<List<FunctionParam>> getSignatures() {
        return this.signatures;
    }

    public boolean isCollectionWise() {
        return this.collectionWise;
    }
}

