/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.box.query.QContext;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;

public class Query {
    private final QContext ctx;
    private final String query;
    private final Map<Integer, V> vals = new HashMap<Integer, V>();

    protected Query(QContext ctx, String query) {
        this.ctx = ctx;
        this.query = query;
    }

    protected String generate(LocalContext lc) {
        BoxWorker worker = lc.getWorker();
        for (Map.Entry<Integer, V> entry : this.vals.entrySet()) {
            Object value = entry.getValue().wrap(worker);
            if (value == null) {
                throw new IllegalStateException("Unknown value for " + entry.getKey());
            }
            lc.setVar("_" + String.valueOf(entry.getKey()), value);
        }
        return this.query;
    }

    public void setString(int index, String str) {
        this.vals.put(index, new StringV(str));
    }

    public void setInt(int index, int v) {
        this.setString(index, String.valueOf(v));
    }

    public void setObject(int index, String name) {
        this.vals.put(index, new ObjectNameV(name));
    }

    public void setObj(int index, String prefixedName) {
        this.vals.put(index, new ObjectNameV(this.ctx.unshortenName(prefixedName)));
    }

    public void setObject(int index, int id) {
        this.vals.put(index, new ObjectIdV(id));
    }

    public void setDateTime(int index, Date d) {
        this.vals.put(index, new DateTimeV(d));
    }

    public void setStrings(int index, List<String> strings) {
        this.vals.put(index, new StringsV(strings));
    }

    public void setObjects(int index, List<?> objects) {
        V v;
        if (objects.isEmpty()) {
            v = new ObjectIdsV(new int[0]);
        } else {
            Object first = objects.get(0);
            if (first instanceof String) {
                ObjectNamesV names = new ObjectNamesV();
                v = names;
                for (Object o : objects) {
                    names.names.add((String)o);
                }
            } else if (first instanceof Integer) {
                int[] m = new int[objects.size()];
                int t = 0;
                for (Object o : objects) {
                    m[t++] = (Integer)o;
                }
                v = new ObjectIdsV(m);
            } else {
                throw new IllegalArgumentException("List of " + first.getClass() + " is not supported (must be List of String or List of Integer)");
            }
        }
        this.vals.put(index, v);
    }

    public void setEntity(int index, int entity) {
        this.vals.put(index, new EntityV(entity));
    }

    public void setEntities(int index, Collection<Integer> entities) {
        this.vals.put(index, new EntitiesV(entities));
    }

    protected static Object wrapId(BoxWorker worker, int id) {
        Entity entity = worker.entity(id);
        if (entity == null) {
            return new IllegalArgumentException("Entity " + id + " not found");
        }
        switch (entity) {
            case ONTOLOGY: {
                return OntologyId.newId(id);
            }
            case TYPE: {
                return TypeId.newId(id);
            }
            case ONTCLASS: {
                return ClassId.newId(id);
            }
            case OPROPERTY: {
                return OPropertyId.newId(id);
            }
            case TPROPERTY: {
                return TPropertyId.newId(id);
            }
            case ONTOBJECT: {
                return ObjectId.newId(worker, id);
            }
        }
        throw new IllegalStateException(entity.toString());
    }

    private static class EntitiesV
    implements V {
        final Collection<Integer> entities;

        private EntitiesV(Collection<Integer> entities) {
            this.entities = entities;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            OntCollection col = OntCC.newCol();
            for (Integer entity : this.entities) {
                col.add(Query.wrapId(worker, entity));
            }
            return col;
        }
    }

    private static class EntityV
    implements V {
        final int entity;

        private EntityV(int entity) {
            this.entity = entity;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            return Query.wrapId(worker, this.entity);
        }
    }

    private static class DateTimeV
    implements V {
        final Date v;

        private DateTimeV(Date v) {
            this.v = v;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            return DateHelper.format(this.v);
        }
    }

    private static class ObjectIdV
    implements V {
        final int v;

        private ObjectIdV(int v) {
            this.v = v;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            return ObjectId.newId(worker, this.v);
        }
    }

    private static class ObjectNameV
    implements V {
        final String v;

        private ObjectNameV(String v) {
            this.v = v;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            return ObjectId.newId(worker, worker.resolve(this.v, Entity.ONTOBJECT));
        }
    }

    private static class StringV
    implements V {
        final String v;

        private StringV(String v) {
            this.v = v;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            return this.v;
        }
    }

    private static class ObjectIdsV
    implements V {
        final int[] ids;

        private ObjectIdsV(int[] ids) {
            this.ids = ids;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            OntCollection col = OntCC.newCol();
            col.addObjects(worker, this.ids);
            return col;
        }
    }

    private static class ObjectNamesV
    implements V {
        final List<String> names = new ArrayList<String>();

        private ObjectNamesV() {
        }

        @Override
        public Object wrap(BoxWorker worker) {
            OntCollection col = OntCC.newCol();
            for (String name : this.names) {
                col.addObject(worker, worker.resolve(name, Entity.ONTOBJECT));
            }
            return col;
        }
    }

    private static class StringsV
    implements V {
        final List<String> v;

        private StringsV(List<String> v) {
            this.v = v;
        }

        @Override
        public Object wrap(BoxWorker worker) {
            OntCollection col = OntCC.newCol();
            for (String string : this.v) {
                col.add(string);
            }
            return col;
        }
    }

    private static interface V {
        public Object wrap(BoxWorker var1);
    }
}

