/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.exchange.mvx;

import java.io.InputStream;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.ProgressListener;
import org.ontobox.exchange.mvx.MVXLoader;
import org.ontobox.exchange.mvx.OntologyProcessor;
import org.ontobox.exchange.mvx.XmlLoader;

public class ImportMVX
implements XmlLoader.XmlProcessor,
OntologyProcessor {
    private final BoxWorker worker;
    private final Map<String, String> annotations;
    private final ProgressListener listener;
    private final OntologyProcessor processor;

    public ImportMVX(BoxWorker worker, Map<String, String> annotations, ProgressListener listener, OntologyProcessor processor) {
        this.worker = worker;
        this.annotations = annotations;
        this.listener = listener;
        this.processor = processor == null ? this : processor;
    }

    public ImportMVX(BoxWorker worker, Map<String, String> annotations, ProgressListener listener) {
        this(worker, annotations, listener, null);
    }

    @Override
    public boolean processXml(int step, InputStream in) {
        switch (step) {
            case 0: {
                MVXLoader.loadBackupStep1(in, this.worker, this.annotations, this.listener, this.processor);
                return true;
            }
            case 1: {
                MVXLoader.loadBackupStep2(in, this.worker, this.listener);
                return true;
            }
            case 2: {
                MVXLoader.loadBackupStep3(in, this.worker, this.listener);
                return false;
            }
        }
        throw new IllegalStateException("step == " + step);
    }

    @Override
    public void loadRequired(BoxWorker worker, String uri) {
        worker.write().require(uri);
    }

    @Override
    public void preloadOntology(BoxWorker worker, String uri) {
    }
}

