/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.exchange.mvx.xml;

import com.teacode.web.HTMLHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class XMLWriter {
    private final Writer writer;

    public XMLWriter(OutputStream out) throws IOException {
        this.writer = new OutputStreamWriter(out, "UTF-8");
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void writeTag(boolean close, String indent, String name, Attr ... attrs) throws IOException {
        this.writer.write(indent);
        this.writer.write("<");
        this.writer.write(name);
        for (Attr attr : attrs) {
            if (attr.value == null) continue;
            this.writer.write(" ");
            this.writer.write(attr.name);
            this.writer.write("=\"");
            this.writer.write(HTMLHelper.escape((String)attr.value.toString()));
            this.writer.write("\"");
        }
        this.writer.write(close ? "/>" : ">");
        this.writer.write("\n");
    }

    public void openTag(String indent, String name, Attr ... attrs) throws IOException {
        this.writeTag(false, indent, name, attrs);
    }

    public void openCloseTag(String indent, String name, Attr ... attrs) throws IOException {
        this.writeTag(true, indent, name, attrs);
    }

    public void closeTag(String indent, String name) throws IOException {
        this.writer.write(indent);
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(">\n");
    }

    public static class Attr {
        final String name;
        final Object value;

        public Attr(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

