/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast;

import com.teacode.collection.primitive.process.IntProcessor;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.ontobox.fast.TransactionRO;
import org.ontobox.fast.TransactionRW;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.dmap.onefile.OFileDMap;
import org.ontobox.fast.event.ActionListener;
import org.ontobox.fast.storage.DiskWorker;
import org.ontobox.fast.storage.Initer;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.storage.Verifier;
import org.ontobox.fast.util.mapmany.BMapIntStringLazy;

public class Engine {
    private static final Logger logger = Logger.getLogger(Engine.class.getName());
    Storage storage;
    private final DiskWorker diskWorker;
    private ActionListener listener;
    private final Set<TransactionRO> readTransactions = new HashSet<TransactionRO>();
    private TransactionRW writeTransaction = null;

    public Engine(File dir, boolean useCard) {
        try {
            OFileDMap dmap = new OFileDMap();
            this.storage = new Storage(dmap, useCard);
            this.diskWorker = new DiskWorker(dir, this.storage, this);
            dmap.start(dir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Engine() {
        this.storage = new Storage(null, true);
        this.diskWorker = null;
        Initer.init(this.storage);
    }

    public final synchronized void setListener(ActionListener listener) {
        this.listener = listener;
    }

    void putTransactionActions(List<WriteAction> actions) {
        if (this.diskWorker != null) {
            this.diskWorker.putTransactionActions(actions);
        }
        if (this.listener != null) {
            this.listener.actionsExecuted(actions);
        }
    }

    public final TransactionRW openTransactionRW() {
        return new TransactionRW(this);
    }

    public final TransactionRO openTransactionRO() {
        return new TransactionRO(this);
    }

    synchronized void waitForRead(TransactionRO transaction) {
        while (this.writeTransaction != null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!transaction.started) {
            if (!this.readTransactions.add(transaction)) {
                throw new IllegalStateException("This transaction is already in the read-transaction list");
            }
            transaction.started = true;
        }
    }

    synchronized void waitForWrite(TransactionRW transaction) {
        while (this.writeTransaction != null && this.writeTransaction != transaction || !this.readTransactions.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.writeTransaction = transaction;
    }

    synchronized void free(TransactionRW transaction) {
        if (this.writeTransaction == transaction) {
            this.writeTransaction = null;
            this.notifyAll();
        }
    }

    synchronized void free(TransactionRO transaction) {
        if (transaction.started) {
            if (!this.readTransactions.remove(transaction)) {
                throw new IllegalStateException("This transaction is missing in the read-transaction list");
            }
            this.notifyAll();
        }
    }

    public final synchronized void close() {
        if (this.writeTransaction != null) {
            throw new IllegalStateException("There is an unclosed write-transaction: " + this.writeTransaction);
        }
        for (TransactionRO transaction : this.readTransactions) {
            logger.severe("There is an unclosed read-transaction: " + transaction);
        }
        Verifier.verify(this.storage);
        if (this.diskWorker != null && this.diskWorker.close(this.storage) && this.storage.dmap != null) {
            final HashSet<String> keys = new HashSet<String>();
            this.storage.getDMapStringTProps().forEach(new IntProcessor(){

                public boolean process(int tpropId) {
                    BMapIntStringLazy tv = (BMapIntStringLazy)Engine.this.storage.tstrings.get(tpropId);
                    if (tv != null) {
                        for (String key : tv.reverseKeySet()) {
                            if (key.charAt(0) == Engine.this.storage.dMapKeyPrefix) continue;
                            keys.add(key);
                        }
                    }
                    return true;
                }
            });
            this.storage.getDMapBinaryTProps().forEach(new IntProcessor(){

                public boolean process(int tpropId) {
                    BMapIntStringLazy tv = (BMapIntStringLazy)Engine.this.storage.tstrings.get(tpropId);
                    if (tv != null) {
                        for (String key : tv.reverseKeySet()) {
                            if (key.charAt(0) == Engine.this.storage.dMapKeyPrefix) continue;
                            keys.add(key);
                        }
                    }
                    return true;
                }
            });
            logger.info("cleaning up dmap keys, actual keys number: " + keys.size());
            this.storage.dmap.close(keys);
        }
        this.storage = null;
    }
}

