/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.IntObjectMap;
import org.ontobox.box.event.AddTValueEvent;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.fast.action.AddValue;
import org.ontobox.fast.action.RemoveTValue;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapInt;
import org.ontobox.fast.util.mapmany.BMapIntBooleanLazy;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;
import org.ontobox.fast.util.mapmany.BMapIntLongLazy;
import org.ontobox.fast.util.mapmany.BMapIntStringLazy;

public class AddTValue
extends AddValue
implements AddTValueEvent {
    private final String value;
    private final int index;
    private int realIndex;

    public AddTValue(String[] data) {
        super(data[0], data[1]);
        this.value = data[2];
        this.index = Integer.parseInt(data[3]);
    }

    public AddTValue(String name, String propertyName, String value, int index) {
        super(name, propertyName);
        this.value = value;
        this.index = index;
    }

    @Override
    public final void preverify(Storage storage) {
        int size;
        if (this.value == null) {
            throw new IllegalArgumentException("value cannot be null (" + this.propertyName + ')');
        }
        storage.verifyExistentObject(this.name);
        storage.verifyExistentTProperty(this.propertyName);
        int propId = storage.id(this.propertyName);
        Integer card = storage.propMaxCard.get(propId);
        BMapInt v = storage.getValueMap(propId);
        int n = size = v == null ? 0 : v.getDirectSize(storage.id(this.name));
        if (storage.useCard && card != null && size == card) {
            throw new IllegalArgumentException("too many integer values (" + card + " already) for " + this.propertyName);
        }
        if (this.index < -1 || this.index > size) {
            throw new IllegalArgumentException("index: " + this.index + " (must be 0;" + size + " inclusive) for " + this.propertyName);
        }
        if (storage.isIntTProp(propId)) {
            Integer.parseInt(this.value);
        } else if (storage.isLongTProp(propId)) {
            Long.parseLong(this.value);
        } else if (storage.isDateTProp(propId)) {
            DateHelper.parse(this.value);
        } else if (storage.isBooleanTProp(propId)) {
            Boolean.parseBoolean(this.value);
        } else if (storage.isDoubleTProp(propId)) {
            Double.parseDouble(this.value);
        }
        this.verifyDomain(storage, storage.tpropDomain);
    }

    @Override
    public final void doAction(Storage storage) {
        int propId = storage.id(this.propertyName);
        if (storage.isIntTProp(propId)) {
            IntObjectMap<BMapIntIntLazy> tvalues = storage.tintegers;
            BMapIntIntLazy v = (BMapIntIntLazy)tvalues.get(propId);
            if (v == null) {
                v = new BMapIntIntLazy();
                tvalues.put(propId, (Object)v);
            }
            Integer id = storage.id(this.name);
            this.realIndex = this.index == -1 ? v.getDirect(id).size() : this.index;
            v.add(id, this.index, Integer.parseInt(this.value));
        } else if (storage.isLongTProp(propId)) {
            IntObjectMap<BMapIntLongLazy> tvalues = storage.tlongs;
            BMapIntLongLazy v = (BMapIntLongLazy)tvalues.get(propId);
            if (v == null) {
                v = new BMapIntLongLazy();
                tvalues.put(propId, (Object)v);
            }
            Integer id = storage.id(this.name);
            this.realIndex = this.index == -1 ? v.getDirect(id).size() : this.index;
            v.add(id, this.index, Long.parseLong(this.value));
        } else if (storage.isBooleanTProp(propId)) {
            IntObjectMap<BMapIntBooleanLazy> tvalues = storage.tbooleans;
            BMapIntBooleanLazy v = (BMapIntBooleanLazy)tvalues.get(propId);
            if (v == null) {
                v = new BMapIntBooleanLazy();
                tvalues.put(propId, (Object)v);
            }
            Integer id = storage.id(this.name);
            this.realIndex = this.index == -1 ? v.getDirect(id).size() : this.index;
            v.add(id, this.index, Boolean.parseBoolean(this.value));
        } else if (storage.isDateTProp(propId)) {
            IntObjectMap<BMapIntLongLazy> tvalues = storage.tlongs;
            BMapIntLongLazy v = (BMapIntLongLazy)tvalues.get(propId);
            if (v == null) {
                v = new BMapIntLongLazy();
                tvalues.put(propId, (Object)v);
            }
            Integer id = storage.id(this.name);
            this.realIndex = this.index == -1 ? v.getDirect(id).size() : this.index;
            v.add(id, this.index, DateHelper.parse(this.value).getTime());
        } else {
            IntObjectMap<BMapIntStringLazy> tvalues = storage.tstrings;
            BMapIntStringLazy v = (BMapIntStringLazy)tvalues.get(propId);
            if (v == null) {
                v = new BMapIntStringLazy();
                tvalues.put(propId, (Object)v);
            }
            Integer id = storage.id(this.name);
            this.realIndex = this.index == -1 ? v.getDirect(id).size() : this.index;
            v.add(id, this.index, this.value);
        }
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.propertyName, this.value, String.valueOf(this.index)};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new RemoveTValue(this.name, this.propertyName, this.realIndex);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public final int getIndex() {
        return this.realIndex;
    }
}

