/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.IntSet;
import org.ontobox.box.event.DeleteOntologyEvent;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.fast.action.CreateOntology;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class DeleteOntology
implements WriteAction,
DeleteOntologyEvent {
    private final String uri;

    public DeleteOntology(String[] data) {
        this(data[0]);
    }

    public DeleteOntology(String uri) {
        this.uri = uri;
    }

    @Override
    public final String getURI() {
        return this.uri;
    }

    private void assertEmpty(Storage storage, IntSet entities, String reason) {
        if (!entities.isEmpty()) {
            throw new DeleteException("Ontology", this.uri, "it has " + reason + " (" + storage.name(entities.getAny()));
        }
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExcistentOntology(this.uri);
        int ontId = storage.id(this.uri);
        this.assertEmpty(storage, storage.types.getReverse(ontId), "a type");
        this.assertEmpty(storage, storage.classes.getReverse(ontId), "a class");
        this.assertEmpty(storage, storage.objects.getReverse(ontId), "an object");
        this.assertEmpty(storage, storage.tProperties.getReverse(ontId), "a tproperty");
        this.assertEmpty(storage, storage.oProperties.getReverse(ontId), "an oproperty");
    }

    @Override
    public final void doAction(Storage storage) {
        storage.ontologies.removeValue(storage.id(this.uri).intValue());
        storage.deleteNameAndAnno(this.uri);
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.uri};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new CreateOntology(this.uri);
    }
}

