/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.RemoveOValueEvent;
import org.ontobox.fast.action.AddOValue;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;

public class RemoveOValue
implements WriteAction,
RemoveOValueEvent {
    private final String name;
    private final String opropertyName;
    private final int index;
    private String oldValue;

    public RemoveOValue(String[] data) {
        this(data[0], data[1], Integer.parseInt(data[2]));
    }

    public RemoveOValue(String name, String opropertyName, int index) {
        this.name = name;
        this.opropertyName = opropertyName;
        this.index = index;
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExistentObject(this.name);
        storage.verifyExistentOProperty(this.opropertyName);
        BMapIntIntLazy v = (BMapIntIntLazy)storage.ovalues.get(storage.id(this.opropertyName).intValue());
        if (v == null) {
            throw new IllegalArgumentException("index: " + this.index + " (there are no values at all)");
        }
        int size = v.getDirect(storage.id(this.name)).size();
        if (size == 0) {
            throw new IllegalArgumentException("index: " + this.index + " (there are no values at all)");
        }
        if (this.index < 0 || this.index >= size) {
            throw new IllegalArgumentException("index: " + this.index + " (must be 0;" + (size - 1) + " inclusive)");
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        BMapIntIntLazy map = (BMapIntIntLazy)storage.ovalues.get(storage.id(this.opropertyName).intValue());
        this.oldValue = storage.name(map.getDirect(id).get(this.index));
        map.removeDirect(id, this.index);
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.opropertyName, String.valueOf(this.index)};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new AddOValue(this.name, this.opropertyName, this.oldValue, this.index);
    }

    @Override
    public final String getObjectName() {
        return this.name;
    }

    @Override
    public final String getPropertyName() {
        return this.opropertyName;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final String getOldValue() {
        return this.oldValue;
    }
}

