/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.RemoveTValueEvent;
import org.ontobox.fast.action.AddTValue;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapInt;

public class RemoveTValue
implements WriteAction,
RemoveTValueEvent {
    private final String name;
    private final String tpropertyName;
    private final int index;
    private String oldValue;

    public RemoveTValue(String[] data) {
        this(data[0], data[1], Integer.parseInt(data[2]));
    }

    public RemoveTValue(String name, String tpropertyName, int index) {
        this.name = name;
        this.tpropertyName = tpropertyName;
        this.index = index;
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExistentObject(this.name);
        storage.verifyExistentTProperty(this.tpropertyName);
        int tpropId = storage.id(this.tpropertyName);
        BMapInt v = storage.getValueMap(tpropId);
        if (v == null) {
            throw new IllegalArgumentException("index: " + this.index + " (there are no values at all) for " + this.tpropertyName);
        }
        int size = v.getDirectSize(storage.id(this.name));
        if (size == 0) {
            throw new IllegalArgumentException("index: " + this.index + " (there are no values at all) for " + this.tpropertyName);
        }
        if (this.index < 0 || this.index >= size) {
            throw new IllegalArgumentException("index: " + this.index + " (must be 0;" + (size - 1) + " inclusive) for " + this.tpropertyName);
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        int tpropId = storage.id(this.tpropertyName);
        BMapInt map = storage.getValueMap(tpropId);
        this.oldValue = map.getDirectAsString(id, this.index);
        map.removeDirect(id, this.index);
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.tpropertyName, String.valueOf(this.index)};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new AddTValue(this.name, this.tpropertyName, this.oldValue, this.index);
    }

    @Override
    public final String getObjectName() {
        return this.name;
    }

    @Override
    public final String getPropertyName() {
        return this.tpropertyName;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final String getOldValue() {
        return this.oldValue;
    }
}

