/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.SetNameEvent;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class SetName
implements WriteAction,
SetNameEvent {
    private final String name;
    private final String newName;

    public SetName(String[] data) {
        this(data[0], data[1]);
    }

    public SetName(String name, String newName) {
        this.name = name;
        this.newName = newName;
    }

    @Override
    public String getOldName() {
        return this.name;
    }

    @Override
    public String getNewName() {
        return this.newName;
    }

    @Override
    public void preverify(Storage storage) {
        storage.verifyExistentEntity(this.name);
        storage.verifyNewEntity(this.newName, "entity");
        if (!storage.ontology(this.name).equals(storage.ontology(this.newName))) {
            throw new IllegalArgumentException("Ontology cannot be changed");
        }
    }

    @Override
    public void doAction(Storage storage) {
        storage.changeName(this.name, this.newName);
    }

    @Override
    public String[] saveData() {
        return new String[]{this.name, this.newName};
    }

    @Override
    public WriteAction getUndoAction() {
        return new SetName(this.newName, this.name);
    }
}

