/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.SetTPropertyDomainEvent;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapInt;
import org.ontobox.fast.util.mapone.BMapOneIntInt;

public class SetTPropertyDomain
implements WriteAction,
SetTPropertyDomainEvent {
    private final String name;
    private final String domain;
    private String oldDomain;

    public SetTPropertyDomain(String[] data) {
        this(data[0], data[1]);
    }

    public SetTPropertyDomain(String name, String domain) {
        this.name = name;
        this.domain = domain;
    }

    @Override
    public final void preverify(Storage storage) {
        BMapInt ts;
        storage.verifyExistentTProperty(this.name);
        if (this.domain != null) {
            storage.verifyExistentClass(this.domain);
        }
        if ((ts = storage.getValueMap(storage.id(this.name))) != null && ts.keys().length != 0) {
            throw new IllegalStateException("There are values, so domain cannot be changed");
        }
    }

    @Override
    public final void doAction(Storage storage) {
        BMapOneIntInt propDomain = storage.tpropDomain;
        int id = storage.id(this.name);
        Integer oldDomainId = propDomain.getDirect(id);
        if (oldDomainId != null) {
            this.oldDomain = storage.name(oldDomainId);
        }
        if (this.domain == null) {
            propDomain.put(id, null);
        } else {
            propDomain.put(id, storage.id(this.domain));
        }
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.domain};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new SetTPropertyDomain(this.name, this.oldDomain);
    }

    @Override
    public final String getPropertyName() {
        return this.name;
    }

    @Override
    public final String getDomain() {
        return this.domain;
    }

    @Override
    public final String getOldDomain() {
        return this.oldDomain;
    }
}

