/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.box;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ontobox.box.BoxDirectClient;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.base.BaseBoxWorker;
import org.ontobox.box.helper.ArrayHelper;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.fast.Transaction;
import org.ontobox.fast.action.ReadAction;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.box.FastBox;
import org.ontobox.fast.box.FastBoxWriter;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntBooleanLazy;
import org.ontobox.fast.util.mapmany.BMapIntInt;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;
import org.ontobox.fast.util.mapmany.BMapIntLongLazy;
import org.ontobox.fast.util.mapmany.BMapIntStringLazy;

public class FastBoxWorker
extends BaseBoxWorker {
    private static Logger logger = Logger.getLogger(FastBoxWorker.class.getName());
    private final FastBox box;
    private Transaction transaction;
    private final boolean ro;
    private final boolean autocommit;
    private boolean closed = false;

    public FastBoxWorker(FastBox box, boolean ro, boolean autocommit) {
        super(box);
        this.box = box;
        this.transaction = box.openTransaction(ro);
        this.ro = ro;
        this.autocommit = autocommit;
    }

    @Override
    public BoxWriter write() {
        return new FastBoxWriter(this);
    }

    @Override
    public String name(final int id) {
        return this.read(new ReadAction<String>(){

            @Override
            public String read(Storage storage) {
                return storage.name(id);
            }
        });
    }

    @Override
    public Integer id(final String name) {
        return this.read(new ReadAction<Integer>(){

            @Override
            public Integer read(Storage storage) {
                return storage.id(name);
            }
        });
    }

    @Override
    public Entity entity(final int id) {
        return this.read(new ReadAction<Entity>(){

            @Override
            public final Entity read(Storage storage) {
                return storage.getType(id);
            }
        });
    }

    @Override
    public int[] ontologies() {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(final Storage storage) {
                final IntList list = CCreator.newIntList((int)100);
                storage.ontologies.forEach(new IntProcessor(){

                    public boolean process(int i) {
                        if (!storage.name(i).equals("|")) {
                            list.add(i);
                        }
                        return true;
                    }
                });
                return list.toArray();
            }
        });
    }

    @Override
    protected int[] objectsForOntology(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.objects.getReverse(id).toArray();
            }
        });
    }

    @Override
    protected int[] objectsForClass(int id) {
        IntSet ret = CCreator.newIntSet((int)16);
        ret.addAll(this.objectsDirect(id));
        for (int cl : this.subclasses(id)) {
            ret.addAll(this.objectsDirect(cl));
        }
        return ret.toArray();
    }

    @Override
    protected int[] objectsDirectForClass(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(final Storage storage) {
                IntSet reverse = storage.objectClasses.getReverse(id);
                final IntSet set = CCreator.newIntSet((int)reverse.size());
                reverse.forEach(new IntProcessor(){

                    public boolean process(int i) {
                        if (storage.name(i).charAt(0) != '|') {
                            set.add(i);
                        }
                        return true;
                    }
                });
                return set.toArray();
            }
        });
    }

    @Override
    protected int[] classesForClass(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.getAllSuperclasses(id).toArray();
            }
        });
    }

    @Override
    protected int[] classesForObject(int id) {
        int[] a = this.classesDirect(id);
        IntSet ret = CCreator.newIntSet((int)16);
        ret.addAll(a);
        for (int ontClass : a) {
            ret.addAll(this.classes(ontClass));
        }
        return ret.toArray();
    }

    @Override
    protected int[] classesForOntology(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.classes.getReverse(id).toArray();
            }
        });
    }

    @Override
    protected int[] classesDirectForClass(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.subclasses.getReverse(id).toArray();
            }
        });
    }

    @Override
    protected int[] classesDirectForObject(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.objectClasses.getDirect(id).toArray();
            }
        });
    }

    @Override
    protected int[] classesDirectForOntology(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                final IntList ret = CCreator.newIntList((int)16);
                final BMapIntInt subclasses = storage.subclasses;
                storage.classes.getReverse(id).forEach(new IntProcessor(){

                    public boolean process(int classId) {
                        if (subclasses.getReverse(classId).isEmpty()) {
                            ret.add(classId);
                        }
                        return true;
                    }
                });
                return ret.toArray();
            }
        });
    }

    @Override
    protected int[] subclassesForClass(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.getAllSubclasses(id).toArray();
            }
        });
    }

    @Override
    protected int[] subclassesDirectForClass(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.subclasses.getDirect(id).toArray();
            }
        });
    }

    @Override
    protected int[] typesForOntology(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.types.getReverse(id).toArray();
            }
        });
    }

    @Override
    protected int[] tpropsForClass(int id) {
        IntSet ret = CCreator.newIntSet((int)16);
        ret.addAll(this.tpropsDirectFast(id));
        for (int cl : this.classes(id)) {
            ret.addAll(this.tpropsDirectFast(cl));
        }
        ret.addAll(this.tpropsDirectFast(null));
        return ret.toArray();
    }

    @Override
    protected int[] tpropsForObject(int id) {
        IntSet ret = CCreator.newIntSet((int)16);
        for (int cl : this.classes(id)) {
            ret.addAll(this.tpropsDirectFast(cl));
        }
        ret.addAll(this.tpropsDirectFast(null));
        return ret.toArray();
    }

    @Override
    protected int[] tpropsForOntology(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.tProperties.getReverse(id).toArray();
            }
        });
    }

    private int[] tpropsDirectFast(final Integer fn) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.tpropDomain.getReverse(fn).toArray();
            }
        });
    }

    @Override
    protected int[] tpropsDirectForClass(int fn) {
        return this.tpropsDirectFast(fn);
    }

    @Override
    protected int[] opropsForClass(int id) {
        IntSet ret = CCreator.newIntSet((int)16);
        ret.addAll(this.opropsDirectFast(id));
        for (int cl : this.classes(id)) {
            ret.addAll(this.opropsDirectFast(cl));
        }
        ret.addAll(this.opropsDirectFast(null));
        return ret.toArray();
    }

    @Override
    protected int[] opropsForObject(int id) {
        IntSet ret = CCreator.newIntSet((int)16);
        for (int cl : this.classes(id)) {
            ret.addAll(this.opropsDirectFast(cl));
        }
        ret.addAll(this.opropsDirectFast(null));
        return ret.toArray();
    }

    @Override
    protected int[] opropsForOntology(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.oProperties.getReverse(id).toArray();
            }
        });
    }

    private int[] opropsDirectFast(final Integer fn) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                return storage.opropDomain.getReverse(fn).toArray();
            }
        });
    }

    @Override
    protected int[] opropsDirectForClass(int id) {
        return this.opropsDirectFast(id);
    }

    @Override
    protected String[] stringsForTProperty(final int id) {
        return this.read(new ReadAction<String[]>(){

            @Override
            public final String[] read(Storage storage) {
                if (storage.isIntTProp(id)) {
                    BMapIntIntLazy map = (BMapIntIntLazy)storage.tintegers.get(id);
                    if (map == null) {
                        return EMPTY_STRING;
                    }
                    int[] values = map.reverseKeySet();
                    Arrays.sort(values);
                    return ArrayHelper.intsToStrings(values);
                }
                if (storage.isLongTProp(id)) {
                    BMapIntLongLazy map = (BMapIntLongLazy)storage.tlongs.get(id);
                    if (map == null) {
                        return EMPTY_STRING;
                    }
                    long[] values = map.reverseKeySet();
                    Arrays.sort(values);
                    return ArrayHelper.longsToStrings(values);
                }
                if (storage.isBooleanTProp(id)) {
                    BMapIntBooleanLazy map = (BMapIntBooleanLazy)storage.tbooleans.get(id);
                    if (map == null) {
                        return EMPTY_STRING;
                    }
                    Set<Boolean> values = map.reverseKeySet();
                    return ArrayHelper.objectsToStrings(values);
                }
                if (storage.isDateTProp(id)) {
                    BMapIntLongLazy map = (BMapIntLongLazy)storage.tlongs.get(id);
                    if (map == null) {
                        return EMPTY_STRING;
                    }
                    long[] values = map.reverseKeySet();
                    Arrays.sort(values);
                    return ArrayHelper.datesToStrings(values);
                }
                BMapIntStringLazy map = (BMapIntStringLazy)storage.tstrings.get(id);
                if (map == null) {
                    return EMPTY_STRING;
                }
                Set<String> values = map.reverseKeySet();
                ArrayList<String> ret = new ArrayList<String>(values.size());
                if (storage.isDMapTProp(id)) {
                    for (String s : values) {
                        ret.add(storage.getDMap(s, null, id));
                    }
                } else {
                    ret.addAll(values);
                }
                Collections.sort(ret);
                return ret.toArray(new String[ret.size()]);
            }
        });
    }

    @Override
    protected int[] intsForTProperty(final int id) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                if (storage.isIntTProp(id)) {
                    BMapIntIntLazy map = (BMapIntIntLazy)storage.tintegers.get(id);
                    if (map == null) {
                        return EMPTY_INT;
                    }
                    int[] values = map.reverseKeySet();
                    Arrays.sort(values);
                    return values;
                }
                return ArrayHelper.stringsToInts(FastBoxWorker.this.stringsForTProperty(id));
            }
        });
    }

    @Override
    protected long[] longsForTProperty(final int id) {
        return this.read(new ReadAction<long[]>(){

            @Override
            public final long[] read(Storage storage) {
                if (storage.isLongTProp(id)) {
                    BMapIntLongLazy map = (BMapIntLongLazy)storage.tlongs.get(id);
                    if (map == null) {
                        return EMPTY_LONG;
                    }
                    long[] values = map.reverseKeySet();
                    Arrays.sort(values);
                    return values;
                }
                return ArrayHelper.stringsToLongs(FastBoxWorker.this.stringsForTProperty(id));
            }
        });
    }

    @Override
    protected String[] stringsForObject(final int id, final int prop) {
        return this.read(new ReadAction<String[]>(){

            @Override
            public final String[] read(Storage storage) {
                String[] ret;
                if (storage.isIntTProp(prop)) {
                    BMapIntIntLazy tv = (BMapIntIntLazy)storage.tintegers.get(prop);
                    if (tv == null || tv.isEmpty()) {
                        return EMPTY_STRING;
                    }
                    return ArrayHelper.intsToStrings(tv.getDirect(id));
                }
                if (storage.isLongTProp(prop)) {
                    BMapIntLongLazy tv = (BMapIntLongLazy)storage.tlongs.get(prop);
                    if (tv == null || tv.isEmpty()) {
                        return EMPTY_STRING;
                    }
                    return ArrayHelper.longsToStrings(tv.getDirect(id));
                }
                if (storage.isBooleanTProp(prop)) {
                    BMapIntBooleanLazy tv = (BMapIntBooleanLazy)storage.tbooleans.get(prop);
                    if (tv == null || tv.isEmpty()) {
                        return EMPTY_STRING;
                    }
                    return ArrayHelper.booleansToStrings(tv.getDirect(id));
                }
                if (storage.isDateTProp(prop)) {
                    BMapIntLongLazy tv = (BMapIntLongLazy)storage.tlongs.get(prop);
                    if (tv == null || tv.isEmpty()) {
                        return EMPTY_STRING;
                    }
                    return ArrayHelper.datesToStrings(tv.getDirect(id));
                }
                BMapIntStringLazy tv = (BMapIntStringLazy)storage.tstrings.get(prop);
                if (tv == null || tv.isEmpty()) {
                    return EMPTY_STRING;
                }
                List<String> direct = tv.getDirect(id);
                if (storage.isDMapTProp(prop)) {
                    ret = new String[direct.size()];
                    int index = 0;
                    for (String s : direct) {
                        ret[index++] = storage.getDMap(s, id, prop);
                    }
                } else {
                    ret = direct.toArray(new String[direct.size()]);
                }
                return ret;
            }
        });
    }

    @Override
    protected int[] intsForObject(final int id, final int prop) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                if (storage.isIntTProp(prop)) {
                    BMapIntIntLazy tv = (BMapIntIntLazy)storage.tintegers.get(prop);
                    if (tv == null || tv.isEmpty()) {
                        return EMPTY_INT;
                    }
                    return tv.getDirect(id).toArray();
                }
                return ArrayHelper.stringsToInts(FastBoxWorker.this.stringsForObject(id, prop));
            }
        });
    }

    @Override
    protected long[] longsForObject(final int id, final int prop) {
        return this.read(new ReadAction<long[]>(){

            @Override
            public final long[] read(Storage storage) {
                if (storage.isIntTProp(prop)) {
                    BMapIntLongLazy tv = (BMapIntLongLazy)storage.tlongs.get(prop);
                    if (tv == null || tv.isEmpty()) {
                        return EMPTY_LONG;
                    }
                    return tv.getDirect(id).toArray();
                }
                return ArrayHelper.stringsToLongs(FastBoxWorker.this.stringsForObject(id, prop));
            }
        });
    }

    @Override
    protected int[] ovaluesForObject(final int id, final int prop) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                BMapIntIntLazy ov = (BMapIntIntLazy)storage.ovalues.get(prop);
                if (ov == null) {
                    return EMPTY_INT;
                }
                return ov.getDirect(id).toArray();
            }
        });
    }

    @Override
    protected int[] ownersForOProperty(final int prop, final int value) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public final int[] read(Storage storage) {
                BMapIntIntLazy ov = (BMapIntIntLazy)storage.ovalues.get(prop);
                if (ov == null) {
                    return EMPTY_INT;
                }
                return ov.getReverse(value).toArray();
            }
        });
    }

    @Override
    protected int[] ownersForTProperty(final int prop, final String value) {
        return this.read(new ReadAction<int[]>(){

            @Override
            public int[] read(Storage storage) {
                if (storage.isIntTProp(prop)) {
                    int intvalue = Integer.parseInt(value);
                    BMapIntIntLazy tvalues = (BMapIntIntLazy)storage.tintegers.get(prop);
                    if (tvalues == null || tvalues.isEmpty()) {
                        return EMPTY_INT;
                    }
                    return tvalues.getReverse(intvalue).toArray();
                }
                if (storage.isLongTProp(prop)) {
                    long longvalue = Integer.parseInt(value);
                    BMapIntLongLazy tvalues = (BMapIntLongLazy)storage.tlongs.get(prop);
                    if (tvalues == null || tvalues.isEmpty()) {
                        return EMPTY_INT;
                    }
                    return tvalues.getReverse(longvalue).toArray();
                }
                if (storage.isDateTProp(prop)) {
                    long longvalue = DateHelper.parse(value).getTime();
                    BMapIntLongLazy tvalues = (BMapIntLongLazy)storage.tlongs.get(prop);
                    if (tvalues == null || tvalues.isEmpty()) {
                        return EMPTY_INT;
                    }
                    return tvalues.getReverse(longvalue).toArray();
                }
                if (storage.isBooleanTProp(prop)) {
                    boolean booleanvalue = Boolean.parseBoolean(value);
                    BMapIntBooleanLazy tvalues = (BMapIntBooleanLazy)storage.tbooleans.get(prop);
                    if (tvalues == null || tvalues.isEmpty()) {
                        return EMPTY_INT;
                    }
                    return tvalues.getReverse(booleanvalue).toArray();
                }
                BMapIntStringLazy tvalues = (BMapIntStringLazy)storage.tstrings.get(prop);
                if (tvalues == null || tvalues.isEmpty()) {
                    return EMPTY_INT;
                }
                if (storage.isDMapTProp(prop)) {
                    if (storage.isDMapBinaryTProp(prop)) {
                        throw new UnsupportedOperationException("not supported yet");
                    }
                    final IntList owners = CCreator.newIntList((int)16);
                    IntProcessor addAll = new IntProcessor(){

                        public boolean process(int i) {
                            owners.add(i);
                            return true;
                        }
                    };
                    for (String s : storage.findDMap(value)) {
                        tvalues.getReverse(s).forEach(addAll);
                    }
                    return owners.toArray();
                }
                return tvalues.getReverse(value).toArray();
            }
        });
    }

    @Override
    protected Integer rangeForTProperty(final int id) {
        return this.read(new ReadAction<Integer>(){

            @Override
            public final Integer read(Storage storage) {
                return storage.tpropRange.getDirect(id);
            }
        });
    }

    @Override
    protected Integer rangeForOProperty(final int id) {
        return this.read(new ReadAction<Integer>(){

            @Override
            public final Integer read(Storage storage) {
                return storage.opropRange.getDirect(id);
            }
        });
    }

    @Override
    protected Integer domainForTProperty(final int id) {
        return this.read(new ReadAction<Integer>(){

            @Override
            public final Integer read(Storage storage) {
                return storage.tpropDomain.getDirect(id);
            }
        });
    }

    @Override
    protected Integer domainForOProperty(final int id) {
        return this.read(new ReadAction<Integer>(){

            @Override
            public final Integer read(Storage storage) {
                return storage.opropDomain.getDirect(id);
            }
        });
    }

    @Override
    protected String annoForEntity(final int id, final String name) {
        return this.read(new ReadAction<String>(){

            @Override
            public final String read(Storage storage) {
                Map anno = (Map)storage.annotations.get(id);
                if (anno != null) {
                    return (String)anno.get(name);
                }
                return null;
            }
        });
    }

    @Override
    protected String[] annamesForEntity(final int id) {
        return this.read(new ReadAction<String[]>(){

            @Override
            public final String[] read(Storage storage) {
                Map anno = (Map)storage.annotations.get(id);
                if (anno != null) {
                    ArrayList ret = new ArrayList(anno.keySet());
                    Collections.sort(ret);
                    return ret.toArray(new String[ret.size()]);
                }
                return EMPTY_STRING;
            }
        });
    }

    @Override
    public <T> T clientDirect(final BoxDirectClient<T> client) {
        return this.read(new ReadAction<T>(){

            @Override
            public T read(Storage storage) {
                try {
                    return client.process(storage);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    final void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Already closed worker");
        }
    }

    final void execute(WriteAction action) {
        this.assertOpen();
        if (this.transaction == null) {
            this.transaction = this.box.openTransaction(this.ro);
        }
        this.transaction.write(action);
        if (this.autocommit) {
            this.commit();
        }
    }

    final <T> T read(ReadAction<T> action) {
        this.assertOpen();
        if (this.transaction == null) {
            this.transaction = this.box.openTransaction(this.ro);
        }
        return this.transaction.read(action);
    }

    @Override
    public int getTransactionId() {
        this.assertOpen();
        if (this.transaction == null) {
            this.transaction = this.box.openTransaction(this.ro);
        }
        return System.identityHashCode(this.transaction);
    }

    @Override
    public boolean commit() {
        this.assertOpen();
        if (this.transaction != null) {
            Integer ont = this.id("|");
            if (ont != null) {
                int deleted = 0;
                long t1 = System.currentTimeMillis();
                StringBuilder sb = new StringBuilder();
                while (true) {
                    int[] objects = this.objects(ont);
                    int counter = 0;
                    sb.append("/").append(String.valueOf(objects.length));
                    for (int object : objects) {
                        if (this.owners(object).length != 0 || this.anno(object, "http://ontobox.org/#Lock") != null) continue;
                        this.write().delete(object);
                        ++counter;
                    }
                    if (counter == 0) break;
                    deleted += counter;
                }
                long t2 = System.currentTimeMillis();
                logger.info("GC: " + deleted + " deleted (" + sb + "), " + (t2 - t1) + " ms");
            }
            boolean ret = this.transaction.close(false);
            this.transaction = null;
            return ret;
        }
        return false;
    }

    @Override
    public void rollback() {
        this.assertOpen();
        if (this.transaction != null) {
            this.transaction.close(true);
            this.transaction = null;
        }
    }

    @Override
    public final void close() {
        this.assertOpen();
        try {
            if (this.transaction != null) {
                this.transaction.close(true);
                this.transaction = null;
            }
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Closing transaction", e);
            throw e;
        }
        this.closed = true;
    }
}

