/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.dmap.onefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ontobox.fast.dmap.BaseDMap;

public class OFileDMap
extends BaseDMap {
    private static final Logger logger = Logger.getLogger(OFileDMap.class.getName());
    private static final int MAX_VALUES_SIZE = 0x2800000;
    private static final int MAX_BUFFER_LEN = 0x100000;
    private final Map<String, String> values = new HashMap<String, String>();
    private final Size valuesSize = new Size();
    private boolean valuesStop = false;
    private File dmap;
    private Thread dropper;

    public void start(File dir) {
        this.dmap = new File(dir, "ofiledmap");
        this.dmap.mkdirs();
        this.dropper = new Thread("dmap-saver"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                int files = 0;
                Buffer buf = null;
                try {
                    while (true) {
                        String value;
                        String key;
                        Map map = OFileDMap.this.values;
                        synchronized (map) {
                            while (true) {
                                Iterator itr;
                                if ((itr = OFileDMap.this.values.entrySet().iterator()).hasNext()) {
                                    Map.Entry next = itr.next();
                                    key = (String)next.getKey();
                                    value = (String)next.getValue();
                                    // MONITOREXIT @DISABLED, blocks:[0, 20, 6, 14, 15] lbl12 : MonitorExitStatement: MONITOREXIT : var5_6
                                    try {
                                        FileOutputStream out = new FileOutputStream(OFileDMap.this.getFile(key));
                                        try {
                                            FileChannel ch = out.getChannel();
                                            try {
                                                int len = value.length();
                                                int dlen = len * 2;
                                                if (buf == null || buf.capacity() < dlen) {
                                                    buf = ByteBuffer.allocate(dlen);
                                                }
                                                ((ByteBuffer)buf).clear();
                                                for (int t = 0; t < len; ++t) {
                                                    ((ByteBuffer)buf).putChar(value.charAt(t));
                                                }
                                                ((ByteBuffer)buf).flip();
                                                ch.write((ByteBuffer)buf);
                                                if (dlen > 0x100000) {
                                                    buf = null;
                                                }
                                                ++files;
                                                break;
                                            }
                                            finally {
                                                ch.close();
                                            }
                                        }
                                        finally {
                                            out.close();
                                        }
                                    }
                                    catch (IOException e) {
                                        logger.log(Level.SEVERE, key, e);
                                        throw new RuntimeException(e);
                                    }
                                }
                                if (OFileDMap.this.valuesStop) {
                                    logger.info("Stopping dmap write-thread. " + files + " files.");
                                    return;
                                }
                                OFileDMap.this.values.wait();
                            }
                        }
                        map = OFileDMap.this.values;
                        synchronized (map) {
                            OFileDMap.this.values.remove(key);
                            OFileDMap.this.valuesSize.subSize(value);
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "thread", e);
                    return;
                }
            }
        };
        this.dropper.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String addValue(String value) {
        String key = OFileDMap.getKey(value);
        this.valuesSize.assertSize();
        Map<String, String> map = this.values;
        synchronized (map) {
            this.values.put(key, value);
            this.valuesSize.addSize(value);
            this.values.notify();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String get(String key) {
        Map<String, String> map = this.values;
        synchronized (map) {
            String v = this.values.get(key);
            if (v != null) {
                return v;
            }
        }
        File file = this.getFile(key);
        if (file.exists()) {
            return OFileDMap.get(file);
        }
        return null;
    }

    private File getFile(String keyBase) {
        File subDir = new File(this.dmap, keyBase.substring(0, 3));
        subDir.mkdirs();
        return new File(subDir, keyBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String get(File file) {
        String string;
        FileInputStream in = new FileInputStream(file);
        try {
            FileChannel ch = in.getChannel();
            int len = (int)ch.size() / 2;
            ByteBuffer bf = ByteBuffer.allocate(len * 2);
            ch.read(bf);
            bf.flip();
            StringBuilder sb = new StringBuilder(len);
            for (int t = 0; t < len; ++t) {
                sb.append(bf.getChar());
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> find(String value) {
        Map<String, String> map = this.values;
        synchronized (map) {
            File[] files;
            HashSet<String> ret = new HashSet<String>();
            for (Map.Entry<String, String> entry : this.values.entrySet()) {
                if (!value.equals(entry.getValue())) continue;
                ret.add(entry.getKey());
            }
            final String keyPrefix = OFileDMap.getKeyPrefix(value);
            File subDir = this.getFile(keyPrefix).getParentFile();
            for (File file : files = subDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(keyPrefix);
                }
            })) {
                if (!file.isFile()) continue;
                String name = file.getName();
                if (!value.equals(OFileDMap.get(file))) continue;
                ret.add(name);
            }
            return ret;
        }
    }

    private static void cleanupSubDir(File subDir, final Set<String> keys) {
        File[] files;
        for (File file : files = subDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !keys.contains(name);
            }
        })) {
            if (!file.isFile() || file.delete()) continue;
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Set<String> keys) {
        Map<String, String> map = this.values;
        synchronized (map) {
            if (keys != null) {
                HashSet<String> k = new HashSet<String>(this.values.keySet());
                for (String s : k) {
                    if (keys.contains(s)) continue;
                    this.values.remove(s);
                }
            }
            this.valuesStop = true;
            this.values.notify();
        }
        try {
            this.dropper.join();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, "close", e);
        }
        if (keys != null) {
            for (File subDir : this.dmap.listFiles()) {
                if (!subDir.isDirectory()) continue;
                OFileDMap.cleanupSubDir(subDir, keys);
            }
        }
    }

    private static class Size {
        private int size = 0;

        private Size() {
        }

        public synchronized void addSize(String str) {
            this.size += str.length();
        }

        public synchronized void subSize(String str) {
            this.size -= str.length();
            this.notify();
        }

        public synchronized void assertSize() {
            while (this.size > 0x2800000) {
                try {
                    logger.info("dmap memory buffer size too big, waiting");
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

