/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.queue;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ontobox.fast.action.Check;
import org.ontobox.fast.action.CloseAction;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.queue.QueueProcessor;

public class ActionsQueue {
    private static Logger logger = Logger.getLogger(ActionsQueue.class.getName());
    private final BlockingQueue<WriteAction> actions = new LinkedBlockingQueue<WriteAction>();
    private final Thread thread;
    private int totalActions = 0;

    public ActionsQueue(final QueueProcessor processor, final String name) {
        this.thread = new Thread(name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        try {
                            WriteAction action = ActionsQueue.this.getBlocking();
                            do {
                                processor.process(action);
                                ActionsQueue.this.totalActions++;
                            } while ((action = ActionsQueue.this.getNonBlocking()) != null);
                            continue;
                        }
                        catch (InterruptedException e) {
                        }
                        finally {
                            processor.flush();
                            continue;
                        }
                        break;
                    }
                    processor.close();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, name, e);
                }
            }
        };
        this.thread.start();
    }

    public int getTotalActions() {
        return this.totalActions;
    }

    public final void putActions(Collection<WriteAction> acts) {
        this.actions.addAll(acts);
    }

    public void putCheckActions() {
        this.actions.add(new Check());
    }

    final void putAction(WriteAction action) throws InterruptedException {
        this.actions.put(action);
    }

    final WriteAction getAction(boolean blocking) throws InterruptedException {
        WriteAction action = blocking ? this.actions.take() : (WriteAction)this.actions.poll();
        if (action instanceof CloseAction) {
            throw new InterruptedException();
        }
        return action;
    }

    final WriteAction getBlocking() throws InterruptedException {
        return this.getAction(true);
    }

    final WriteAction getNonBlocking() throws InterruptedException {
        return this.getAction(false);
    }

    public final void close() {
        try {
            this.putAction(new CloseAction());
            this.thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

