/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import com.teacode.collection.primitive.BooleanList;
import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntByteMap;
import com.teacode.collection.primitive.IntIntMap;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.LongList;
import com.teacode.collection.primitive.process.BooleanProcessor;
import com.teacode.collection.primitive.process.IntObjectProcessor;
import com.teacode.collection.primitive.process.IntProcessor;
import com.teacode.collection.primitive.process.LongProcessor;
import com.teacode.file.buffer.ReadBuffer;
import com.teacode.file.buffer.WriteBuffer;
import com.teacode.util.StringCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.fast.id.IdSupport;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.AnnoNameVerifier;
import org.ontobox.fast.util.mapmany.BMapInt;
import org.ontobox.fast.util.mapmany.BMapIntBooleanLazy;
import org.ontobox.fast.util.mapmany.BMapIntInt;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;
import org.ontobox.fast.util.mapmany.BMapIntLongLazy;
import org.ontobox.fast.util.mapmany.BMapIntStringLazy;
import org.ontobox.fast.util.mapone.BMapOneIntInt;

public class BinaryDumper {
    private static final Logger logger = Logger.getLogger(BinaryDumper.class.getName());
    private static final String ONTO_TAG = "Onto";
    private static final String TYPE_TAG = "Type";
    private static final String CLASS_TAG = "Clas";
    private static final String SUBCLASS_TAG = "SubC";
    private static final String OPROPERTY_TAG = "OPrp";
    private static final String ODOMAIN_TAG = "ODmn";
    private static final String ORANGE_TAG = "ORng";
    private static final String TPROPERTY_TAG = "TPrp";
    private static final String TDOMAIN_TAG = "TDmn";
    private static final String TRANGE_TAG = "TRng";
    private static final String OBJECT_TAG = "Obje";
    private static final String OBJECT_CLASS_TAG = "OCla";
    private static final String OVALUE_TAG = "OVlu";
    private static final String TSTRINGS_TAG = "TStr";
    private static final String TINTEGER_TAG = "TInt";
    private static final String TLONG_TAG = "TLon";
    private static final String TBOOLEAN_TAG = "TBol";
    private static final String NAME_TAG = "Name";
    private static final String ANNOTATION_TAG = "Anno";
    private static final String END_TAG = "End ";
    private final Storage storage;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;

    public BinaryDumper(Storage storage) {
        this.storage = storage;
    }

    private static void putMap(WriteBuffer buf, String sign, IntIntMap newId, BMapOneIntInt maps) throws IOException {
        buf.putRAWASCII(sign);
        int[] ids = maps.directKeySet();
        buf.putInt(ids.length);
        for (int oldId : ids) {
            buf.putInt(newId.get(oldId).intValue());
            Integer vId = maps.getDirect(oldId);
            if (vId != null) {
                buf.putInt(newId.get(vId.intValue()).intValue());
                continue;
            }
            buf.putNullInt();
        }
    }

    private static void getMap(ReadBuffer buf, BMapOneIntInt maps, IntByteMap types, Entity entity) throws IOException {
        int len = buf.getInt();
        if (entity == null) {
            for (int t = 0; t < len; ++t) {
                maps.put(buf.getInt(), buf.getInt());
            }
        } else {
            byte typeByte = (byte)entity.ordinal();
            for (int t = 0; t < len; ++t) {
                int id = buf.getInt();
                maps.put(id, buf.getInt());
                types.put(id, typeByte);
            }
        }
    }

    private static void putMap(final WriteBuffer buf, String sign, final IntIntMap newId, BMapIntInt maps) throws IOException {
        buf.putRAWASCII(sign);
        int[] ids = maps.keys();
        buf.putInt(ids.length);
        IntProcessor putAll = new IntProcessor(){

            public boolean process(int i) {
                buf.putInt(newId.get(i).intValue());
                return true;
            }
        };
        for (int oldId : ids) {
            buf.putInt(newId.get(oldId).intValue());
            IntList values = maps.getDirect(oldId);
            buf.putInt(values.size());
            values.forEach(putAll);
        }
    }

    private static void getMap(ReadBuffer buf, BMapIntInt maps) throws IOException {
        int len = buf.getInt();
        for (int t = 0; t < len; ++t) {
            int id = buf.getInt();
            int len2 = buf.getInt();
            for (int t2 = 0; t2 < len2; ++t2) {
                maps.add(id, buf.getInt());
            }
        }
    }

    private void dumpPart1(final WriteBuffer buf, final IntIntMap newId) throws IOException {
        IntSet ids = this.storage.ontologies;
        buf.putRAWASCII(ONTO_TAG);
        buf.putInt(ids.size());
        ids.forEach(new IntProcessor(){

            public boolean process(int i) {
                buf.putInt(newId.get(i).intValue());
                return true;
            }
        });
        BinaryDumper.putMap(buf, TYPE_TAG, newId, this.storage.types);
        BinaryDumper.putMap(buf, CLASS_TAG, newId, this.storage.classes);
        BinaryDumper.putMap(buf, SUBCLASS_TAG, newId, this.storage.subclasses);
        BinaryDumper.putMap(buf, OPROPERTY_TAG, newId, this.storage.oProperties);
        BinaryDumper.putMap(buf, ODOMAIN_TAG, newId, this.storage.opropDomain);
        BinaryDumper.putMap(buf, ORANGE_TAG, newId, this.storage.opropRange);
        BinaryDumper.putMap(buf, TPROPERTY_TAG, newId, this.storage.tProperties);
        BinaryDumper.putMap(buf, TDOMAIN_TAG, newId, this.storage.tpropDomain);
        BinaryDumper.putMap(buf, TRANGE_TAG, newId, this.storage.tpropRange);
        BinaryDumper.putMap(buf, OBJECT_TAG, newId, this.storage.objects);
        BinaryDumper.putMap(buf, OBJECT_CLASS_TAG, newId, this.storage.objectClasses);
    }

    private void dumpPart2(final WriteBuffer buf, final IntIntMap newId) throws IOException {
        buf.putRAWASCII(OVALUE_TAG);
        IntObjectMap<BMapIntIntLazy> ovals = this.storage.ovalues;
        buf.putInt(ovals.size());
        final IntProcessor putAll = new IntProcessor(){

            public boolean process(int i) {
                buf.putInt(newId.get(i).intValue());
                return true;
            }
        };
        ovals.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntIntLazy>(){

            public boolean process(int id, BMapIntIntLazy values) {
                buf.putInt(newId.get(id).intValue());
                int[] objs = values.keys();
                buf.putInt(objs.length);
                for (int objId : objs) {
                    buf.putInt(newId.get(objId).intValue());
                    IntList vals = values.getDirect(objId);
                    buf.putInt(vals.size());
                    vals.forEach(putAll);
                }
                return true;
            }
        });
        buf.putRAWASCII(TSTRINGS_TAG);
        Object tvals = this.storage.tstrings;
        buf.putInt(tvals.size());
        tvals.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntStringLazy>(){

            public boolean process(int id, BMapIntStringLazy values) {
                buf.putInt(newId.get(id).intValue());
                int[] objs = values.keys();
                buf.putInt(objs.length);
                for (int objId : objs) {
                    buf.putInt(newId.get(objId).intValue());
                    List<String> vals = values.getDirect(objId);
                    buf.putInt(vals.size());
                    for (String val : vals) {
                        buf.putString(val);
                    }
                }
                return true;
            }
        });
        buf.putRAWASCII(TINTEGER_TAG);
        tvals = this.storage.tintegers;
        buf.putInt(tvals.size());
        final IntProcessor saveAsInt = new IntProcessor(){

            public boolean process(int i) {
                buf.putInt(i);
                return true;
            }
        };
        tvals.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntIntLazy>(){

            public boolean process(int id, BMapIntIntLazy values) {
                buf.putInt(newId.get(id).intValue());
                int[] objs = values.keys();
                buf.putInt(objs.length);
                for (int objId : objs) {
                    buf.putInt(newId.get(objId).intValue());
                    IntList vals = values.getDirect(objId);
                    buf.putInt(vals.size());
                    vals.forEach(saveAsInt);
                }
                return true;
            }
        });
        buf.putRAWASCII(TLONG_TAG);
        tvals = this.storage.tlongs;
        buf.putInt(tvals.size());
        final LongProcessor saveAsLong = new LongProcessor(){

            public boolean process(long i) {
                buf.putLong(i);
                return true;
            }
        };
        tvals.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntLongLazy>(){

            public boolean process(int id, BMapIntLongLazy values) {
                buf.putInt(newId.get(id).intValue());
                int[] objs = values.keys();
                buf.putInt(objs.length);
                for (int objId : objs) {
                    buf.putInt(newId.get(objId).intValue());
                    LongList vals = values.getDirect(objId);
                    buf.putInt(vals.size());
                    vals.forEach(saveAsLong);
                }
                return true;
            }
        });
        buf.putRAWASCII(TBOOLEAN_TAG);
        tvals = this.storage.tbooleans;
        buf.putInt(tvals.size());
        final BooleanProcessor saveAsBoolean = new BooleanProcessor(){

            public boolean process(boolean i) {
                buf.putByte(i ? (byte)1 : 0);
                return true;
            }
        };
        tvals.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntBooleanLazy>(){

            public boolean process(int id, BMapIntBooleanLazy values) {
                buf.putInt(newId.get(id).intValue());
                int[] objs = values.keys();
                buf.putInt(objs.length);
                for (int objId : objs) {
                    buf.putInt(newId.get(objId).intValue());
                    BooleanList vals = values.getDirect(objId);
                    buf.putInt(vals.size());
                    vals.forEach(saveAsBoolean);
                }
                return true;
            }
        });
        buf.putRAWASCII(ANNOTATION_TAG);
        IntObjectMap<Map<String, String>> annos = this.storage.annotations;
        buf.putInt(annos.size());
        annos.forEachEntry((IntObjectProcessor)new IntObjectProcessor<Map<String, String>>(){

            public boolean process(int key, Map<String, String> map) {
                buf.putInt(newId.get(key).intValue());
                Set<String> names = map.keySet();
                buf.putInt(names.size());
                for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
                    buf.putString(stringStringEntry.getKey());
                    buf.putString(stringStringEntry.getValue());
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBinary(File file) throws IOException {
        long t1 = System.nanoTime();
        IdSupport ids = this.storage.ids;
        final IntIntMap newId = CCreator.newIntIntMap((int)1000);
        FileOutputStream out = new FileOutputStream(file);
        try {
            FileChannel ch = out.getChannel();
            try {
                final WriteBuffer buf = new WriteBuffer(ch);
                buf.putRAWASCII(NAME_TAG);
                buf.putInt(ids.size());
                ids.forEachIdName(new IntObjectProcessor<String>(){
                    int idCounter = 0;

                    public boolean process(int i, String s) {
                        newId.put(i, this.idCounter);
                        buf.putString(s);
                        ++this.idCounter;
                        return true;
                    }
                });
                this.dumpPart1(buf, newId);
                this.dumpPart2(buf, newId);
                buf.putRAWASCII(END_TAG);
                buf.flush();
            }
            finally {
                ch.close();
            }
        }
        finally {
            out.close();
        }
        long t2 = System.nanoTime();
        logger.info("Saving " + file + ": " + (t2 - t1) / 1000L / 1000L + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBinary(File file) throws IOException, InterruptedException {
        long t1 = System.nanoTime();
        FileInputStream in = new FileInputStream(file);
        try {
            FileChannel ch = in.getChannel();
            try {
                ReadBuffer buf = new ReadBuffer(ch);
                this.load(file, buf);
            }
            finally {
                ch.close();
            }
        }
        finally {
            in.close();
        }
        long t2 = System.nanoTime();
        logger.info("Loading " + file + ": " + (t2 - t1) / 1000L / 1000L + " ms");
    }

    private void load(File file, ReadBuffer buf) throws IOException {
        String tag;
        HashMap<String, BMapOneIntInt> mapOnes = new HashMap<String, BMapOneIntInt>();
        HashMap<String, Entity> mapOnesType = new HashMap<String, Entity>();
        HashMap<String, BMapIntInt> maps = new HashMap<String, BMapIntInt>();
        mapOnes.put(TYPE_TAG, this.storage.types);
        mapOnesType.put(TYPE_TAG, Entity.TYPE);
        mapOnes.put(CLASS_TAG, this.storage.classes);
        mapOnesType.put(CLASS_TAG, Entity.ONTCLASS);
        mapOnes.put(OBJECT_TAG, this.storage.objects);
        mapOnes.put(OPROPERTY_TAG, this.storage.oProperties);
        mapOnesType.put(OPROPERTY_TAG, Entity.OPROPERTY);
        mapOnes.put(TPROPERTY_TAG, this.storage.tProperties);
        mapOnesType.put(TPROPERTY_TAG, Entity.TPROPERTY);
        maps.put(SUBCLASS_TAG, this.storage.subclasses);
        mapOnes.put(ODOMAIN_TAG, this.storage.opropDomain);
        mapOnes.put(ORANGE_TAG, this.storage.opropRange);
        mapOnes.put(TDOMAIN_TAG, this.storage.tpropDomain);
        mapOnes.put(TRANGE_TAG, this.storage.tpropRange);
        maps.put(OBJECT_CLASS_TAG, this.storage.objectClasses);
        StringCompressor strcomp = new StringCompressor();
        while (!(tag = buf.getRAWASCII(4)).equals(END_TAG)) {
            Object tvals;
            int t;
            if (tag.equals(NAME_TAG)) {
                int len = buf.getInt();
                IdSupport ids = this.storage.ids;
                for (int t2 = 0; t2 < len; ++t2) {
                    String name = buf.getString();
                    if (name.startsWith("http://www.w3.org/2001/XMLSchema")) {
                        throw new IllegalStateException("Unsupported dump format (schema types are not allowed: " + name + ")");
                    }
                    ids.addName(t2, name);
                }
                this.storage.refreshCounter();
                continue;
            }
            if (tag.equals(ONTO_TAG)) {
                int len = buf.getInt();
                IntSet onts = this.storage.ontologies;
                IntByteMap idType = this.storage.idType;
                for (t = 0; t < len; ++t) {
                    Integer ontId = buf.getInt();
                    onts.add(ontId.intValue());
                    idType.put(ontId.intValue(), (byte)Entity.ONTOLOGY.ordinal());
                    String uri = this.storage.name(ontId);
                    if (!"http://xml.ontobox.org/".equals(uri)) continue;
                    logger.info("Marking " + uri + " as required");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("http://ontobox.org/#required", "http://ontobox.org/#required");
                    this.storage.annotations.put(ontId.intValue(), map);
                }
                continue;
            }
            if (tag.equals(OVALUE_TAG)) {
                int len = buf.getInt();
                IntObjectMap<BMapIntIntLazy> ovals = this.storage.ovalues;
                for (int t3 = 0; t3 < len; ++t3) {
                    Integer propId = buf.getInt();
                    BMapIntIntLazy values = (BMapIntIntLazy)ovals.get(propId.intValue());
                    int len2 = buf.getInt();
                    if (values == null) {
                        values = new BMapIntIntLazy();
                        ovals.put(propId.intValue(), (Object)values);
                    }
                    for (int t2 = 0; t2 < len2; ++t2) {
                        Integer objId = buf.getInt();
                        int len3 = buf.getInt();
                        for (int t32 = 0; t32 < len3; ++t32) {
                            values.add(objId, buf.getInt());
                        }
                    }
                }
                continue;
            }
            if (tag.equals(TSTRINGS_TAG)) {
                int len = buf.getInt();
                tvals = this.storage.tstrings;
                IntObjectMap<BMapIntLongLazy> tlongs = this.storage.tlongs;
                for (t = 0; t < len; ++t) {
                    int t3;
                    int len3;
                    Integer objId;
                    int t2;
                    int len2;
                    BMapInt values;
                    int propId = buf.getInt();
                    if (this.storage.isDateTProp(propId)) {
                        values = (BMapIntLongLazy)tlongs.get(propId);
                        len2 = buf.getInt();
                        if (values == null) {
                            values = new BMapIntLongLazy();
                            tlongs.put(propId, (Object)values);
                        }
                        for (t2 = 0; t2 < len2; ++t2) {
                            objId = buf.getInt();
                            len3 = buf.getInt();
                            for (t3 = 0; t3 < len3; ++t3) {
                                ((BMapIntLongLazy)values).add(objId, DateHelper.parse(buf.getString()).getTime());
                            }
                        }
                        continue;
                    }
                    values = (BMapIntStringLazy)tvals.get(propId);
                    len2 = buf.getInt();
                    if (values == null) {
                        values = new BMapIntStringLazy();
                        tvals.put(propId, (Object)values);
                    }
                    for (t2 = 0; t2 < len2; ++t2) {
                        objId = buf.getInt();
                        len3 = buf.getInt();
                        for (t3 = 0; t3 < len3; ++t3) {
                            ((BMapIntStringLazy)values).add(objId, strcomp.string(buf.getString()));
                        }
                    }
                }
                continue;
            }
            if (tag.equals(TINTEGER_TAG)) {
                int len = buf.getInt();
                tvals = this.storage.tintegers;
                for (int t4 = 0; t4 < len; ++t4) {
                    int propId = buf.getInt();
                    BMapIntIntLazy values = (BMapIntIntLazy)tvals.get(propId);
                    int len2 = buf.getInt();
                    if (values == null) {
                        values = new BMapIntIntLazy();
                        tvals.put(propId, (Object)values);
                    }
                    for (int t2 = 0; t2 < len2; ++t2) {
                        Integer objId = buf.getInt();
                        int len3 = buf.getInt();
                        for (int t3 = 0; t3 < len3; ++t3) {
                            values.add(objId, buf.getInt());
                        }
                    }
                }
                continue;
            }
            if (tag.equals(TLONG_TAG)) {
                int len = buf.getInt();
                tvals = this.storage.tlongs;
                for (int t5 = 0; t5 < len; ++t5) {
                    int propId = buf.getInt();
                    BMapIntLongLazy values = (BMapIntLongLazy)tvals.get(propId);
                    int len2 = buf.getInt();
                    if (values == null) {
                        values = new BMapIntLongLazy();
                        tvals.put(propId, (Object)values);
                    }
                    for (int t2 = 0; t2 < len2; ++t2) {
                        Integer objId = buf.getInt();
                        int len3 = buf.getInt();
                        for (int t3 = 0; t3 < len3; ++t3) {
                            values.add(objId, buf.getLong());
                        }
                    }
                }
                continue;
            }
            if (tag.equals(TBOOLEAN_TAG)) {
                int len = buf.getInt();
                tvals = this.storage.tbooleans;
                for (int t6 = 0; t6 < len; ++t6) {
                    int propId = buf.getInt();
                    BMapIntBooleanLazy values = (BMapIntBooleanLazy)tvals.get(propId);
                    int len2 = buf.getInt();
                    if (values == null) {
                        values = new BMapIntBooleanLazy();
                        tvals.put(propId, (Object)values);
                    }
                    for (int t2 = 0; t2 < len2; ++t2) {
                        Integer objId = buf.getInt();
                        int len3 = buf.getInt();
                        for (int t3 = 0; t3 < len3; ++t3) {
                            values.add(objId, buf.getByte() == 1);
                        }
                    }
                }
                continue;
            }
            if (tag.equals(ANNOTATION_TAG)) {
                int len = buf.getInt();
                IntObjectMap<Map<String, String>> annos = this.storage.annotations;
                for (int t7 = 0; t7 < len; ++t7) {
                    Integer entId = buf.getInt();
                    Entity entity = this.storage.getType(entId);
                    boolean prop = entity == Entity.TPROPERTY || entity == Entity.OPROPERTY;
                    HashMap<String, String> values = (HashMap<String, String>)annos.get(entId.intValue());
                    if (values == null) {
                        values = new HashMap<String, String>();
                        annos.put(entId.intValue(), values);
                    }
                    int len2 = buf.getInt();
                    for (int t2 = 0; t2 < len2; ++t2) {
                        String name = strcomp.string(AnnoNameVerifier.getNewName(buf.getString()));
                        String value = strcomp.string(buf.getString());
                        values.put(name, value);
                        if (!prop || !name.equals("http://ontobox.org/#maxcard")) continue;
                        this.storage.propMaxCard.put(entId.intValue(), Integer.parseInt(value));
                    }
                }
                continue;
            }
            BMapOneIntInt m = (BMapOneIntInt)mapOnes.get(tag);
            BMapIntInt m2 = (BMapIntInt)maps.get(tag);
            if (m != null) {
                BinaryDumper.getMap(buf, m, this.storage.idType, (Entity)((Object)mapOnesType.get(tag)));
                continue;
            }
            if (m2 != null) {
                BinaryDumper.getMap(buf, m2);
                continue;
            }
            throw new RuntimeException("Unsupported/unknown tag (" + tag + ')');
        }
    }
}

