/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntObjectProcessor;
import com.teacode.collection.primitive.process.IntProcessor;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntInt;

public class Hierarchy {
    private Storage storage;
    private boolean reset = true;
    private final IntObjectMap<IntSet> subclassCache = CCreator.newIntObjectMap((int)100);
    private final IntObjectMap<IntSet> superclassCache = CCreator.newIntObjectMap((int)100);
    private final IntSet EMPTY = CCreator.newIntSet((int)1);

    public Hierarchy(Storage storage) {
        this.storage = storage;
    }

    public synchronized void reset() {
        this.reset = true;
    }

    private void copyListToSets(IntList list, final IntSet set1, final IntSet set2) {
        list.forEach(new IntProcessor(){

            public boolean process(int i) {
                set1.add(i);
                set2.add(i);
                return true;
            }
        });
    }

    private int[] initDirect() {
        IntSet ret = CCreator.newIntSet((int)16);
        BMapIntInt subclasses = this.storage.subclasses;
        for (int superCl : subclasses.keys()) {
            ret.add(superCl);
            IntList subclassesDirect = subclasses.getDirect(superCl);
            this.copyListToSets(subclassesDirect, this.get(superCl), ret);
        }
        return ret.toArray();
    }

    private IntSet get(int supCl) {
        IntSet set = (IntSet)this.subclassCache.get(supCl);
        if (set == null) {
            set = CCreator.newIntSet((int)16);
            this.subclassCache.put(supCl, (Object)set);
        }
        return set;
    }

    private boolean isSubclass(int supCl, int subCl) {
        IntSet subclasses = (IntSet)this.subclassCache.get(supCl);
        return subclasses != null && subclasses.contains(subCl);
    }

    private void init() {
        if (this.reset) {
            this.subclassCache.clear();
            this.superclassCache.clear();
            int[] classes = this.initDirect();
            int len = classes.length;
            for (int k = 0; k < len; ++k) {
                for (int i = 0; i < len; ++i) {
                    for (int j = 0; j < len; ++j) {
                        int iCl = classes[i];
                        int jCl = classes[j];
                        int kCl = classes[k];
                        if (this.isSubclass(iCl, jCl) || !this.isSubclass(iCl, kCl) || !this.isSubclass(kCl, jCl)) continue;
                        this.get(iCl).add(jCl);
                    }
                }
            }
            this.subclassCache.forEachEntry((IntObjectProcessor)new IntObjectProcessor<IntSet>(){

                public boolean process(final int superCl, IntSet subCls) {
                    subCls.forEach(new IntProcessor(){

                        public boolean process(int subCl) {
                            IntSet set = (IntSet)Hierarchy.this.superclassCache.get(subCl);
                            if (set == null) {
                                set = CCreator.newIntSet((int)16);
                                Hierarchy.this.superclassCache.put(subCl, (Object)set);
                            }
                            set.add(superCl);
                            return true;
                        }
                    });
                    return true;
                }
            });
            this.reset = false;
        }
    }

    private IntSet notNull(IntSet set) {
        return set != null ? set : this.EMPTY;
    }

    public synchronized IntSet getAllSubclasses(Integer classId) {
        this.init();
        return this.notNull((IntSet)this.subclassCache.get(classId.intValue()));
    }

    public synchronized IntSet getAllSuperclassed(Integer classId) {
        this.init();
        return this.notNull((IntSet)this.superclassCache.get(classId.intValue()));
    }

    public synchronized IntSet getAllSuperclasses(IntList classIds) {
        this.init();
        final IntSet ret = CCreator.newIntSet((int)16);
        final IntProcessor addAll = new IntProcessor(){

            public boolean process(int i) {
                ret.add(i);
                return true;
            }
        };
        classIds.forEach(new IntProcessor(){

            public boolean process(int cl) {
                Hierarchy.this.getAllSuperclassed(cl).forEach(addAll);
                return true;
            }
        });
        return ret;
    }
}

