/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntByteMap;
import com.teacode.collection.primitive.IntCollection;
import com.teacode.collection.primitive.IntIntMap;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntProcessor;
import com.teacode.collection.primitive.process.ObjectProcessor;
import com.teacode.util.StringCompressor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.ontobox.box.Entity;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.exception.IllegalNameException;
import org.ontobox.box.exception.NotFoundException;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.SplittedName;
import org.ontobox.fast.dmap.DMap;
import org.ontobox.fast.id.IdSimpleSupport;
import org.ontobox.fast.id.IdSupport;
import org.ontobox.fast.storage.Hierarchy;
import org.ontobox.fast.util.Memory;
import org.ontobox.fast.util.mapmany.BMapInt;
import org.ontobox.fast.util.mapmany.BMapIntBooleanLazy;
import org.ontobox.fast.util.mapmany.BMapIntInt;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;
import org.ontobox.fast.util.mapmany.BMapIntLongLazy;
import org.ontobox.fast.util.mapmany.BMapIntStringLazy;
import org.ontobox.fast.util.mapone.BMapOneIntInt;

public class Storage {
    private static Logger logger = Logger.getLogger(Storage.class.getName());
    public IdSupport ids = new IdSimpleSupport();
    public IntByteMap idType = CCreator.newIntByteMap((int)10000);
    public IntSet ontologies = CCreator.newIntSet((int)100);
    public final BMapOneIntInt types = new BMapOneIntInt();
    public final BMapOneIntInt classes = new BMapOneIntInt();
    public final BMapIntInt subclasses = new BMapIntInt();
    public final BMapOneIntInt oProperties = new BMapOneIntInt();
    public final BMapOneIntInt opropDomain = new BMapOneIntInt();
    public final BMapOneIntInt opropRange = new BMapOneIntInt();
    public final BMapOneIntInt tProperties = new BMapOneIntInt();
    public final BMapOneIntInt tpropDomain = new BMapOneIntInt();
    public final BMapOneIntInt tpropRange = new BMapOneIntInt();
    public final IntIntMap propMaxCard = CCreator.newIntIntMap((int)100);
    public BMapOneIntInt objects = new BMapOneIntInt(100000);
    public BMapIntInt objectClasses = new BMapIntInt(100000);
    public IntObjectMap<BMapIntIntLazy> ovalues = CCreator.newIntObjectMap((int)100);
    public IntObjectMap<BMapIntStringLazy> tstrings = CCreator.newIntObjectMap((int)100);
    public IntObjectMap<BMapIntIntLazy> tintegers = CCreator.newIntObjectMap((int)100);
    public IntObjectMap<BMapIntLongLazy> tlongs = CCreator.newIntObjectMap((int)100);
    public IntObjectMap<BMapIntBooleanLazy> tbooleans = CCreator.newIntObjectMap((int)100);
    public final IntObjectMap<Map<String, String>> annotations = CCreator.newIntObjectMap((int)100);
    private final Hierarchy hierarchy = new Hierarchy(this);
    public final DMap dmap;
    public int maxDMapValueAsKey = 0;
    public char dMapKeyPrefix = (char)63;
    public final boolean useCard;

    public Storage(DMap dmap, boolean useCard) {
        this.dmap = dmap;
        if (dmap != null) {
            this.maxDMapValueAsKey = dmap.getMinKeySize() - 1;
            this.dMapKeyPrefix = dmap.getReservedKeyPrefix();
        }
        this.useCard = useCard;
    }

    public final void freeMemory() {
        Memory.getUsedMemory();
        long m1 = Memory.getUsedMemory();
        this.ids = null;
        Memory.getUsedMemory();
        long m3 = Memory.getUsedMemory();
        this.idType = null;
        Memory.getUsedMemory();
        long m4 = Memory.getUsedMemory();
        this.objects = null;
        Memory.getUsedMemory();
        long m5 = Memory.getUsedMemory();
        this.objectClasses = null;
        Memory.getUsedMemory();
        long m6 = Memory.getUsedMemory();
        this.ovalues = null;
        Memory.getUsedMemory();
        long m7 = Memory.getUsedMemory();
        this.tstrings = null;
        Memory.getUsedMemory();
        long m8 = Memory.getUsedMemory();
        this.tintegers = null;
        Memory.getUsedMemory();
        long m9 = Memory.getUsedMemory();
        System.out.println("before " + m1 / 1024L / 1024L + "MB");
        System.out.println("ids " + (m3 - m1) / 1024L / 1024L + "MB");
        System.out.println("idType " + (m4 - m3) / 1024L / 1024L + "MB");
        System.out.println("objects " + (m5 - m4) / 1024L / 1024L + "MB");
        System.out.println("objectsClasses " + (m6 - m5) / 1024L / 1024L + "MB");
        System.out.println("ovalues " + (m7 - m6) / 1024L / 1024L + "MB");
        System.out.println("tstrings " + (m8 - m7) / 1024L / 1024L + "MB");
        System.out.println("tintegers " + (m9 - m8) / 1024L / 1024L + "MB");
        System.out.println("after " + m9 / 1024L / 1024L + "MB");
        System.exit(2);
    }

    public final void refreshCounter() {
        this.ids.refreshCounter();
    }

    public final synchronized void dropStructureCache() {
        this.hierarchy.reset();
    }

    public final synchronized IntSet getAllSubclasses(Integer classId) {
        return this.hierarchy.getAllSubclasses(classId);
    }

    public final synchronized IntSet getAllSuperclasses(Integer classId) {
        return this.hierarchy.getAllSuperclassed(classId);
    }

    public final synchronized IntSet getAllSuperclasses(IntList classIds) {
        return this.hierarchy.getAllSuperclasses(classIds);
    }

    public final int createName(String name, Entity type) {
        int id = this.ids.createName(name);
        if (type != Entity.ONTOBJECT) {
            this.idType.put(id, (byte)type.ordinal());
        }
        return id;
    }

    public final Entity getType(int id) {
        Byte b = this.idType.get(id);
        if (b == null) {
            if (this.objects.containsDirectKey(id)) {
                return Entity.ONTOBJECT;
            }
            return null;
        }
        return Entity.values()[b];
    }

    public final void changeName(String name, String newName) {
        this.ids.changeName(name, newName);
    }

    public final void deleteNameAndAnno(String name) {
        Integer id = this.ids.deleteName(name);
        this.idType.removeKey(id.intValue());
        this.annotations.removeKey(id.intValue());
    }

    public final Integer ontology(String fullName) {
        return this.id(NameHelper.splitName(fullName).ontology());
    }

    private static void verifyURI(String uri) {
        if (uri.contains("#")) {
            throw new IllegalNameException(uri);
        }
    }

    final void verifyEntityName(String name) {
        SplittedName data = NameHelper.splitName(name);
        if (data == null) {
            throw new IllegalNameException(name);
        }
        this.verifyExcistentOntology(data.ontology());
    }

    public static void verifyAnnoName(String name) {
        SplittedName data = NameHelper.splitName(name);
        if (data == null) {
            throw new IllegalNameException(name);
        }
        Storage.verifyURI(data.ontology());
    }

    public final void verifyNewEntity(String name, String entityType) {
        this.verifyEntityName(name);
        if (this.id(name) != null) {
            throw new AlreadyExistsException(entityType, name);
        }
    }

    private void verifyExistentEntity(String name, String type, Entity ... types) {
        this.verifyEntityName(name);
        Integer id = this.id(name);
        if (id == null) {
            throw new NotFoundException(type, name);
        }
        Entity entity = this.getType(id);
        for (Entity t : types) {
            if (t != entity) continue;
            return;
        }
        if (entity == null) {
            throw new NotFoundException(type, name);
        }
        throw new NotFoundException(type, entity.toString(), name);
    }

    private void verifyExistentEntity(String name, String type, Entity entity) {
        this.verifyEntityName(name);
        Integer id = this.id(name);
        if (id == null) {
            throw new NotFoundException(type, name);
        }
        Entity e = this.getType(id);
        if (e == entity) {
            return;
        }
        if (e == null) {
            throw new NotFoundException(type, name);
        }
        throw new NotFoundException(type, e.toString(), name);
    }

    public final void verifyExistentEntity(String name) {
        this.verifyExistentEntity(name, "Entity", Entity.TYPE, Entity.ONTOBJECT, Entity.ONTCLASS, Entity.TPROPERTY, Entity.OPROPERTY);
    }

    public final void verifyExistentObject(String name) {
        this.verifyExistentEntity(name, "Object", Entity.ONTOBJECT);
    }

    public final void verifyExistentClass(String name) {
        this.verifyExistentEntity(name, "Class", Entity.ONTCLASS);
    }

    public final void verifyExistentType(String name) {
        this.verifyExistentEntity(name, "Type", Entity.TYPE);
    }

    public final void verifyExistentOProperty(String name) {
        this.verifyExistentEntity(name, "OProperty", Entity.OPROPERTY);
    }

    public final void verifyExistentTProperty(String name) {
        this.verifyExistentEntity(name, "TProperty", Entity.TPROPERTY);
    }

    public final void verifyNewOntology(String uri) {
        Storage.verifyURI(uri);
        if (this.id(uri) != null) {
            throw new AlreadyExistsException("Ontology", uri);
        }
    }

    public final void verifyExcistentOntology(String uri) {
        Integer ontId = this.id(uri);
        if (ontId == null || !this.ontologies.contains(ontId.intValue())) {
            throw new NotFoundException("ontology", uri);
        }
    }

    public final Integer id(String name) {
        return this.ids.id(name);
    }

    public final String name(Integer id) {
        return this.ids.name(id);
    }

    public final String getDMap(String key, Integer ontObjectId, Integer tPropertyId) {
        if (key.charAt(0) == this.dMapKeyPrefix) {
            return key.substring(1);
        }
        String v = this.dmap.get(key);
        if (v == null) {
            String name = "unknown";
            if (ontObjectId != null) {
                name = this.name(ontObjectId);
            }
            throw new IllegalStateException("Unknown dmap key \"" + key + "\" (object " + name + ", t-property " + this.name(tPropertyId) + ')');
        }
        return v;
    }

    public final Collection<String> findDMap(String value) {
        if (value.length() <= this.maxDMapValueAsKey) {
            return Collections.singletonList(this.dMapKeyPrefix + value);
        }
        return this.dmap.find(value);
    }

    public final void compressStrings() {
        final StringCompressor strcomp = new StringCompressor();
        long t1 = System.nanoTime();
        this.tstrings.forEachValue((ObjectProcessor)new ObjectProcessor<BMapIntStringLazy>(){

            public boolean process(BMapIntStringLazy map) {
                map.compressStrings(strcomp);
                return true;
            }
        });
        long t2 = System.nanoTime();
    }

    public final boolean isDMapStringTProp(int tpropId) {
        if (this.dmap == null) {
            return false;
        }
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#dmapString");
    }

    public final boolean isDMapBinaryTProp(int tpropId) {
        if (this.dmap == null) {
            return false;
        }
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#dmapBinary");
    }

    public final boolean isDeclaredDMapBinaryTProp(int tpropId) {
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#dmapBinary");
    }

    public final boolean isDMapTProp(int tpropId) {
        return this.isDMapStringTProp(tpropId) || this.isDMapBinaryTProp(tpropId);
    }

    public final boolean isIntTProp(int tpropId) {
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#int");
    }

    public final boolean isLongTProp(int tpropId) {
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#long");
    }

    public final boolean isDateTProp(int tpropId) {
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#date");
    }

    public final boolean isBooleanTProp(int tpropId) {
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#boolean");
    }

    public final boolean isDoubleTProp(int tpropId) {
        Integer type = this.tpropRange.getDirect(tpropId);
        return type != null && this.name(type).equals("http://ontobox.org/#double");
    }

    public BMapInt getValueMap(int tpropId) {
        if (this.isIntTProp(tpropId)) {
            return (BMapInt)this.tintegers.get(tpropId);
        }
        if (this.isLongTProp(tpropId) || this.isDateTProp(tpropId)) {
            return (BMapInt)this.tlongs.get(tpropId);
        }
        if (this.isBooleanTProp(tpropId)) {
            return (BMapInt)this.tbooleans.get(tpropId);
        }
        return (BMapInt)this.tstrings.get(tpropId);
    }

    public final IntSet getDMapStringTProps() {
        Integer id = this.id("http://ontobox.org/#dmapString");
        if (id == null) {
            return CCreator.newIntSet((int)1);
        }
        return this.tpropRange.getReverse(id);
    }

    public final IntSet getDMapBinaryTProps() {
        Integer id = this.id("http://ontobox.org/#dmapBinary");
        if (id == null) {
            return CCreator.newIntSet((int)1);
        }
        return this.tpropRange.getReverse(id);
    }

    public final String names(IntCollection col) {
        if (col.isEmpty()) {
            return "empty/none";
        }
        final int[] holder = new int[1];
        col.forEach(new IntProcessor(){

            public boolean process(int i) {
                holder[0] = i;
                return false;
            }
        });
        String ret = this.name(holder[0]);
        int size = col.size();
        if (size > 1) {
            ret = ret + " and more (" + size + " total)";
        }
        return ret;
    }
}

