/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SimpleEscaper {
    private static final char SEPARATOR = ' ';
    private static final char NULL = '?';
    private static final char EMPTY = '\u001f';
    private static final Map<Character, String> toEscape = new HashMap<Character, String>();
    private static final Map<Integer, Character> fromEscape = new HashMap<Integer, Character>();
    private static final Logger logger = Logger.getLogger(SimpleEscaper.class.getName());

    private static void add(char ch, String t) {
        toEscape.put(Character.valueOf(ch), '^' + t);
        fromEscape.put(t.charAt(0) << 16 + t.charAt(1), Character.valueOf(ch));
    }

    private static String code(short c) {
        String s = Integer.toHexString(c & 0xFF);
        if (s.length() == 1) {
            s = '0' + s;
        }
        return s;
    }

    public static void writeLine(Writer writer, String name, String[] data) throws IOException {
        writer.write(name);
        for (String s : data) {
            writer.write(32);
            if (s == null) {
                writer.write(63);
                continue;
            }
            if (s.isEmpty()) {
                writer.write(31);
                continue;
            }
            for (char ch : s.toCharArray()) {
                String sym = toEscape.get(Character.valueOf(ch));
                if (sym != null) {
                    writer.write(sym);
                    continue;
                }
                writer.write(ch);
            }
        }
        writer.write(10);
    }

    public static ParsedLine parseLine(Reader reader) throws IOException {
        String[] acc = new String[5];
        StringBuilder sb = new StringBuilder(200);
        int accPos = 0;
        block6: while (true) {
            int i;
            if ((i = reader.read()) == -1) {
                if (sb.length() != 0) {
                    acc[accPos++] = sb.toString();
                }
                if (accPos != 0) {
                    StringBuilder sb2 = new StringBuilder();
                    for (int t = 0; t < accPos; ++t) {
                        sb2.append(acc[t]).append(" | ");
                    }
                    logger.warning("Skipped last line: " + sb2);
                }
                return null;
            }
            char ch = (char)i;
            if (ch == '\r' || ch == '\n') {
                if (accPos != 0 || sb.length() != 0) break;
                continue;
            }
            switch (ch) {
                case '?': {
                    acc[accPos++] = null;
                    sb.setLength(0);
                    continue block6;
                }
                case '\u001f': {
                    acc[accPos++] = "";
                    sb.setLength(0);
                    continue block6;
                }
                case ' ': {
                    if (sb.length() == 0) continue block6;
                    acc[accPos++] = sb.toString();
                    sb.setLength(0);
                    continue block6;
                }
                case '^': {
                    char ch2 = (char)reader.read();
                    char ch3 = (char)reader.read();
                    sb.append(fromEscape.get(ch2 << 16 + ch3));
                    continue block6;
                }
            }
            sb.append(ch);
        }
        if (sb.length() != 0) {
            acc[accPos++] = sb.toString();
        }
        if (accPos == 0) {
            return null;
        }
        int dataLen = accPos - 1;
        String[] data = new String[dataLen];
        System.arraycopy(acc, 1, data, 0, dataLen);
        return new ParsedLine(acc[0], data);
    }

    static {
        for (short c = 0; c <= 32; c = (short)(c + 1)) {
            SimpleEscaper.add((char)c, SimpleEscaper.code(c));
        }
        SimpleEscaper.add(' ', SimpleEscaper.code((short)32));
        SimpleEscaper.add('?', SimpleEscaper.code((short)63));
        SimpleEscaper.add('^', SimpleEscaper.code((short)94));
    }

    public static final class ParsedLine {
        public final String name;
        public final String[] data;

        public ParsedLine(String name, String[] data) {
            this.name = name;
            this.data = data;
        }
    }
}

