/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.map;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntSet;
import java.util.HashSet;
import java.util.Set;

public class MapBooleanIntSet {
    private final IntSet falseSet;
    private final IntSet trueSet;

    public MapBooleanIntSet() {
        this.falseSet = CCreator.newIntSet((int)16);
        this.trueSet = CCreator.newIntSet((int)16);
    }

    public MapBooleanIntSet(int size) {
        this.falseSet = CCreator.newIntSet((int)size);
        this.trueSet = CCreator.newIntSet((int)size);
    }

    public final void put(boolean key, int value) {
        if (key) {
            this.trueSet.add(value);
        } else {
            this.falseSet.add(value);
        }
    }

    public final IntSet get(boolean key) {
        return key ? this.trueSet : this.falseSet;
    }

    public final Set<Boolean> keySet() {
        HashSet<Boolean> ret = new HashSet<Boolean>(2);
        if (!this.falseSet.isEmpty()) {
            ret.add(false);
        }
        if (!this.trueSet.isEmpty()) {
            ret.add(true);
        }
        return ret;
    }

    public final boolean containsKey(boolean key) {
        if (key) {
            return !this.trueSet.isEmpty();
        }
        return !this.falseSet.isEmpty();
    }

    public final void removeKey(boolean key) {
        if (key) {
            this.trueSet.clear();
        } else {
            this.falseSet.clear();
        }
    }

    public final void removeValues(boolean key, int value) {
        IntSet set = this.get(key);
        set.removeValue(value);
    }
}

