/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.mapmany;

import com.teacode.collection.primitive.BooleanList;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.BooleanProcessor;
import java.util.Set;
import java.util.logging.Logger;
import org.ontobox.fast.util.map.MapBooleanIntSet;
import org.ontobox.fast.util.map.MapIntBooleanList;
import org.ontobox.fast.util.mapmany.BMapInt;

public class BMapIntBooleanLazy
implements BMapInt {
    private static final Logger logger = Logger.getLogger(BMapIntBooleanLazy.class.getName());
    private final MapIntBooleanList direct;
    private MapBooleanIntSet reverse = null;

    public BMapIntBooleanLazy() {
        this.direct = new MapIntBooleanList();
    }

    public BMapIntBooleanLazy(int size) {
        this.direct = new MapIntBooleanList(size);
    }

    public final void add(int key, boolean value) {
        this.direct.add(key, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final void add(int key, int index, boolean value) {
        this.direct.add(key, index, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final boolean isEmpty() {
        return this.direct.isEmpty();
    }

    public final BooleanList getDirect(int key) {
        return this.direct.get(key);
    }

    @Override
    public String getDirectAsString(int key, int index) {
        return String.valueOf(this.getDirect(key).get(index));
    }

    @Override
    public int getDirectSize(int key) {
        return this.getDirect(key).size();
    }

    private synchronized void initReverse() {
        if (this.reverse == null) {
            int[] keys = this.direct.keys();
            this.reverse = new MapBooleanIntSet(keys.length);
            for (final int key : keys) {
                this.direct.get(key).forEach(new BooleanProcessor(){

                    public boolean process(boolean i) {
                        BMapIntBooleanLazy.this.reverse.put(i, key);
                        return true;
                    }
                });
            }
        }
    }

    public final IntSet getReverse(boolean value) {
        this.initReverse();
        return this.reverse.get(value);
    }

    @Override
    public final int[] keys() {
        return this.direct.keys();
    }

    public final Set<Boolean> reverseKeySet() {
        this.initReverse();
        return this.reverse.keySet();
    }

    final void removeDirectKey(final int key) {
        if (this.reverse != null) {
            this.getDirect(key).forEach(new BooleanProcessor(){

                public boolean process(boolean value) {
                    BMapIntBooleanLazy.this.reverse.removeValues(value, key);
                    return true;
                }
            });
        }
        this.direct.removeKey(key);
    }

    @Override
    public final void removeDirect(int key, int index) {
        BooleanList vList = this.direct.get(key);
        boolean value = vList.get(index);
        if (this.reverse != null) {
            this.reverse.removeValues(value, key);
        }
        vList.removeIndex(index);
        if (vList.isEmpty()) {
            this.removeDirectKey(key);
        }
    }
}

