/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.mapmany;

import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.LongList;
import com.teacode.collection.primitive.process.LongProcessor;
import java.util.logging.Logger;
import org.ontobox.fast.util.map.MapIntLongList;
import org.ontobox.fast.util.map.MapLongIntSet;
import org.ontobox.fast.util.mapmany.BMapInt;

public class BMapIntLongLazy
implements BMapInt {
    private static final Logger logger = Logger.getLogger(BMapIntLongLazy.class.getName());
    private final MapIntLongList direct;
    private MapLongIntSet reverse = null;

    public BMapIntLongLazy() {
        this.direct = new MapIntLongList();
    }

    public BMapIntLongLazy(int size) {
        this.direct = new MapIntLongList(size);
    }

    public final void add(int key, long value) {
        this.direct.add(key, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final void add(int key, int index, long value) {
        this.direct.add(key, index, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final boolean isEmpty() {
        return this.direct.isEmpty();
    }

    public final LongList getDirect(int key) {
        return this.direct.get(key);
    }

    @Override
    public String getDirectAsString(int key, int index) {
        return String.valueOf(this.getDirect(key).get(index));
    }

    @Override
    public int getDirectSize(int key) {
        return this.getDirect(key).size();
    }

    private synchronized void initReverse() {
        if (this.reverse == null) {
            int[] keys = this.direct.keys();
            this.reverse = new MapLongIntSet(keys.length);
            for (final int key : keys) {
                this.direct.get(key).forEach(new LongProcessor(){

                    public boolean process(long i) {
                        BMapIntLongLazy.this.reverse.put(i, key);
                        return true;
                    }
                });
            }
        }
    }

    public final IntSet getReverse(long value) {
        this.initReverse();
        return this.reverse.get(value);
    }

    @Override
    public final int[] keys() {
        return this.direct.keys();
    }

    public final long[] reverseKeySet() {
        this.initReverse();
        return this.reverse.keys();
    }

    final void removeDirectKey(final int key) {
        if (this.reverse != null) {
            this.getDirect(key).forEach(new LongProcessor(){

                public boolean process(long value) {
                    BMapIntLongLazy.this.reverse.removeValues(value, key);
                    return true;
                }
            });
        }
        this.direct.removeKey(key);
    }

    @Override
    public final void removeDirect(int key, int index) {
        LongList vList = this.direct.get(key);
        long value = vList.get(index);
        if (this.reverse != null) {
            this.reverse.removeValues(value, key);
        }
        vList.removeIndex(index);
        if (vList.isEmpty()) {
            this.removeDirectKey(key);
        }
    }
}

