/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.mapmany;

import com.teacode.collection.primitive.IntSet;
import com.teacode.util.StringCompressor;
import java.util.List;
import java.util.Set;
import org.ontobox.fast.util.map.MapIntStringList;
import org.ontobox.fast.util.map.MapStringIntSet;
import org.ontobox.fast.util.mapmany.BMapInt;

public class BMapIntStringLazy
implements BMapInt {
    private final MapIntStringList direct = new MapIntStringList();
    private MapStringIntSet reverse = null;

    public final void add(int key, String value) {
        this.direct.add(key, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final void add(int key, int index, String value) {
        this.direct.add(key, index, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final synchronized void compressStrings(StringCompressor strcomp) {
        for (int key : this.direct.keys()) {
            List<String> list = this.direct.get(key);
            if (list.isEmpty()) continue;
            int size = list.size();
            for (int t = 0; t < size; ++t) {
                String str = list.get(t);
                String newStr = strcomp.string(str);
                if (newStr == str) continue;
                list.set(t, newStr);
            }
        }
        if (this.reverse != null) {
            for (String s : this.reverse.keySet()) {
                String key = strcomp.string(s);
                if (key == s) continue;
                IntSet set = this.reverse.get(s);
                this.reverse.removeKey(s);
                if (set.isEmpty()) continue;
                this.reverse.put(key, set);
            }
        }
    }

    public final boolean isEmpty() {
        return this.direct.isEmpty();
    }

    public final List<String> getDirect(int key) {
        return this.direct.get(key);
    }

    @Override
    public String getDirectAsString(int key, int index) {
        return this.getDirect(key).get(index);
    }

    @Override
    public int getDirectSize(int key) {
        return this.getDirect(key).size();
    }

    private synchronized void initReverse() {
        if (this.reverse == null) {
            int[] keys = this.direct.keys();
            this.reverse = new MapStringIntSet(keys.length);
            for (int key : keys) {
                for (String s : this.direct.get(key)) {
                    this.reverse.put(s, key);
                }
            }
        }
    }

    public final IntSet getReverse(String value) {
        this.initReverse();
        return this.reverse.get(value);
    }

    @Override
    public final int[] keys() {
        return this.direct.keys();
    }

    public final Set<String> reverseKeySet() {
        this.initReverse();
        return this.reverse.keySet();
    }

    final void removeDirectKey(int key) {
        if (this.reverse != null) {
            for (String s : this.getDirect(key)) {
                this.reverse.removeValues(s, key);
            }
        }
        this.direct.removeKey(key);
    }

    @Override
    public final void removeDirect(int key, int index) {
        List<String> vList = this.direct.get(key);
        String value = vList.get(index);
        if (this.reverse != null) {
            this.reverse.removeValues(value, key);
        }
        vList.remove(index);
        if (vList.isEmpty()) {
            this.removeDirectKey(key);
        }
    }
}

