/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.test;

import com.teacode.collection.primitive.BooleanList;
import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntByteMap;
import com.teacode.collection.primitive.IntIntMap;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.ObjectIntMap;
import com.teacode.collection.primitive.process.IntObjectProcessor;
import com.teacode.collection.primitive.process.IntProcessor;
import com.teacode.collection.primitive.process.ObjectProcessor;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ontobox.fast.util.mapone.BMapOneIntInt;

public class CollectionsTest
extends TestCase {
    protected static boolean contains(int[] array, int v) {
        for (int i : array) {
            if (i != v) continue;
            return true;
        }
        return false;
    }

    public static void testBMapOne(BMapOneIntInt test) {
        test.put(1, 7);
        test.put(3, 2);
        test.put(1, 2);
        test.put(1, 2);
        CollectionsTest.assertEquals((int)2, (int)test.getDirect(1));
        CollectionsTest.assertEquals((int)2, (int)test.getDirect(3));
        IntSet reverse2 = test.getReverse(2);
        CollectionsTest.assertEquals((int)2, (int)reverse2.size());
        CollectionsTest.assertTrue((boolean)reverse2.contains(1));
        CollectionsTest.assertTrue((boolean)reverse2.contains(3));
        IntSet reverse7 = test.getReverse(7);
        CollectionsTest.assertTrue((boolean)reverse7.isEmpty());
        CollectionsTest.assertTrue((boolean)test.containsDirectKey(1));
        CollectionsTest.assertTrue((boolean)test.containsDirectKey(3));
        CollectionsTest.assertEquals((int)2, (int)test.directKeySet().length);
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(test.directKeySet(), 1));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(test.directKeySet(), 3));
        CollectionsTest.assertFalse((boolean)CollectionsTest.contains(test.directKeySet(), 2));
        CollectionsTest.assertFalse((boolean)CollectionsTest.contains(test.directKeySet(), 7));
        test.removeDirectKey(1);
        CollectionsTest.assertEquals(null, (Object)test.getDirect(1));
        reverse2 = test.getReverse(2);
        CollectionsTest.assertEquals((int)1, (int)reverse2.size());
        CollectionsTest.assertEquals((int)3, (int)reverse2.toArray()[0]);
        test.removeDirectKey(3);
        CollectionsTest.assertEquals(null, (Object)test.getDirect(3));
        reverse2 = test.getReverse(2);
        CollectionsTest.assertTrue((boolean)reverse2.isEmpty());
    }

    public static void testBMapOneRemoveReverse(BMapOneIntInt test) {
        test.put(1, 7);
        test.put(3, 2);
        test.put(3, 2);
        test.put(1, 2);
        CollectionsTest.assertEquals((int)2, (int)test.getDirect(1));
        CollectionsTest.assertEquals((int)2, (int)test.getDirect(3));
        IntSet reverse2 = test.getReverse(2);
        CollectionsTest.assertEquals((int)2, (int)reverse2.size());
        CollectionsTest.assertTrue((boolean)reverse2.contains(1));
        CollectionsTest.assertTrue((boolean)reverse2.contains(3));
        IntSet reverse7 = test.getReverse(7);
        CollectionsTest.assertTrue((boolean)reverse7.isEmpty());
        test.removeReverseKey(2);
        CollectionsTest.assertEquals(null, (Object)test.getDirect(1));
        CollectionsTest.assertEquals(null, (Object)test.getDirect(3));
        reverse2 = test.getReverse(2);
        CollectionsTest.assertTrue((boolean)reverse2.isEmpty());
    }

    public static void testManyPut(BMapOneIntInt test) {
        int COUNT = 10000;
        Random rnd = new Random();
        for (int t = 0; t < 10000; ++t) {
            int v2 = rnd.nextInt(500);
            int v7 = rnd.nextInt(500);
            test.put(2, v2);
            test.put(7, v7);
            CollectionsTest.assertEquals((int)v2, (int)test.getDirect(2));
            CollectionsTest.assertEquals((int)v7, (int)test.getDirect(7));
        }
    }

    public static void testNULL(BMapOneIntInt test) {
        test.put(1, 3);
        test.put(2, null);
        test.put(3, null);
        CollectionsTest.assertEquals((Object)3, (Object)test.getDirect(1));
        CollectionsTest.assertEquals(null, (Object)test.getDirect(2));
        CollectionsTest.assertEquals(null, (Object)test.getDirect(3));
        IntSet k = test.getReverse(3);
        CollectionsTest.assertEquals((int)1, (int)k.size());
        CollectionsTest.assertTrue((boolean)k.contains(1));
        k = test.getReverse(null);
        CollectionsTest.assertEquals((int)2, (int)k.size());
        CollectionsTest.assertTrue((boolean)k.contains(2));
        CollectionsTest.assertTrue((boolean)k.contains(3));
        CollectionsTest.assertTrue((boolean)test.containsDirectKey(1));
        CollectionsTest.assertTrue((boolean)test.containsDirectKey(2));
        CollectionsTest.assertTrue((boolean)test.containsDirectKey(3));
        CollectionsTest.assertFalse((boolean)test.containsDirectKey(4));
        int[] keys = test.directKeySet();
        CollectionsTest.assertEquals((int)3, (int)keys.length);
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(keys, 1));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(keys, 2));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(keys, 3));
        CollectionsTest.assertFalse((boolean)CollectionsTest.contains(keys, 4));
        test.removeDirectKey(2);
        CollectionsTest.assertEquals((Object)3, (Object)test.getDirect(1));
        CollectionsTest.assertEquals(null, (Object)test.getDirect(2));
        CollectionsTest.assertEquals(null, (Object)test.getDirect(3));
        k = test.getReverse(3);
        CollectionsTest.assertEquals((int)1, (int)k.size());
        CollectionsTest.assertTrue((boolean)k.contains(1));
        k = test.getReverse(null);
        CollectionsTest.assertEquals((int)1, (int)k.size());
        CollectionsTest.assertTrue((boolean)k.contains(3));
        CollectionsTest.assertTrue((boolean)test.containsDirectKey(1));
        CollectionsTest.assertTrue((boolean)test.containsDirectKey(3));
        CollectionsTest.assertFalse((boolean)test.containsDirectKey(2));
        keys = test.directKeySet();
        CollectionsTest.assertEquals((int)2, (int)keys.length);
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(keys, 1));
        CollectionsTest.assertFalse((boolean)CollectionsTest.contains(keys, 2));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(keys, 3));
    }

    public void testGeneral() {
        CollectionsTest.testBMapOne(new BMapOneIntInt());
        CollectionsTest.testBMapOneRemoveReverse(new BMapOneIntInt());
        CollectionsTest.testManyPut(new BMapOneIntInt());
        CollectionsTest.testNULL(new BMapOneIntInt());
    }

    public void testIntList() {
        IntList list = CCreator.newIntList((int)16);
        CollectionsTest.assertTrue((boolean)list.isEmpty());
        CollectionsTest.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        list.add(100);
        CollectionsTest.assertFalse((boolean)list.isEmpty());
        CollectionsTest.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        CollectionsTest.assertEquals((int)100, (int)list.get(0));
        list.insert(0, 200);
        CollectionsTest.assertFalse((boolean)list.isEmpty());
        CollectionsTest.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        CollectionsTest.assertEquals((int)100, (int)list.get(1));
        CollectionsTest.assertEquals((int)200, (int)list.get(0));
        CollectionsTest.assertEquals((int)1, (int)list.indexOf(0, 100));
        CollectionsTest.assertEquals((int)0, (int)list.indexOf(0, 200));
        CollectionsTest.assertEquals((int)-1, (int)list.indexOf(1, 200));
        list.addAll(new int[]{300, 400});
        CollectionsTest.assertFalse((boolean)list.isEmpty());
        CollectionsTest.assertTrue((list.size() == 4 ? 1 : 0) != 0);
        CollectionsTest.assertEquals((int)400, (int)list.get(3));
        CollectionsTest.assertEquals((int)300, (int)list.get(2));
        CollectionsTest.assertEquals((int)100, (int)list.get(1));
        CollectionsTest.assertEquals((int)200, (int)list.get(0));
        CollectionsTest.assertEquals((int)1, (int)list.indexOf(0, 100));
        CollectionsTest.assertEquals((int)0, (int)list.indexOf(0, 200));
        CollectionsTest.assertEquals((int)-1, (int)list.indexOf(1, 200));
        CollectionsTest.assertEquals((int)2, (int)list.indexOf(0, 300));
        CollectionsTest.assertEquals((int)3, (int)list.indexOf(0, 400));
        int[] array = list.toArray();
        CollectionsTest.assertEquals((int)4, (int)array.length);
        CollectionsTest.assertEquals((int)200, (int)array[0]);
        CollectionsTest.assertEquals((int)100, (int)array[1]);
        list.add(500);
        list.removeIndex(1);
        list.insert(0, 100);
        CollectionsTest.assertEquals((int)4, (int)array.length);
        CollectionsTest.assertEquals((int)200, (int)array[0]);
        CollectionsTest.assertEquals((int)100, (int)array[1]);
        CollectionsTest.assertEquals((int)100, (int)list.get(0));
        CollectionsTest.assertEquals((int)200, (int)list.get(1));
        CollectionsTest.assertEquals((int)300, (int)list.get(2));
        CollectionsTest.assertEquals((int)400, (int)list.get(3));
        CollectionsTest.assertEquals((int)500, (int)list.get(4));
        CollectionsTest.assertTrue((boolean)list.forEach(new IntProcessor(){
            int index = 0;

            public boolean process(int i) {
                Assert.assertEquals((int)(this.index * 100 + 100), (int)i);
                ++this.index;
                return true;
            }
        }));
        CollectionsTest.assertFalse((boolean)list.forEach(new IntProcessor(){

            public boolean process(int i) {
                return false;
            }
        }));
        CollectionsTest.assertFalse((boolean)list.forEach(new IntProcessor(){
            boolean f = true;

            public boolean process(int i) {
                if (this.f) {
                    this.f = false;
                    return false;
                }
                Assert.fail((String)"invalid call");
                return false;
            }
        }));
        CollectionsTest.assertEquals((int)100, (int)list.get(0));
        CollectionsTest.assertEquals((int)200, (int)list.get(1));
        CollectionsTest.assertEquals((int)300, (int)list.get(2));
        CollectionsTest.assertEquals((int)400, (int)list.get(3));
        CollectionsTest.assertEquals((int)500, (int)list.get(4));
        list.removeIndex(list.indexOf(0, 300));
        CollectionsTest.assertEquals((int)100, (int)list.get(0));
        CollectionsTest.assertEquals((int)200, (int)list.get(1));
        CollectionsTest.assertEquals((int)400, (int)list.get(2));
        CollectionsTest.assertEquals((int)500, (int)list.get(3));
        CollectionsTest.assertEquals((int)4, (int)list.size());
        int size = list.size();
        for (int t = 0; t < size; ++t) {
            CollectionsTest.assertEquals((int)(4 - t), (int)list.size());
            list.removeIndex(0);
            CollectionsTest.assertEquals((int)(4 - t - 1), (int)list.size());
        }
        CollectionsTest.assertEquals((int)0, (int)list.size());
        CollectionsTest.assertTrue((boolean)list.isEmpty());
        CollectionsTest.assertTrue((boolean)list.forEach(new IntProcessor(){

            public boolean process(int i) {
                Assert.fail((String)"");
                return true;
            }
        }));
        list.add(123);
        CollectionsTest.assertEquals((int)1, (int)list.size());
        CollectionsTest.assertFalse((boolean)list.isEmpty());
        list.clear();
        CollectionsTest.assertEquals((int)0, (int)list.size());
        CollectionsTest.assertTrue((boolean)list.isEmpty());
        CollectionsTest.assertTrue((boolean)list.forEach(new IntProcessor(){

            public boolean process(int i) {
                Assert.fail((String)"");
                return true;
            }
        }));
    }

    public void testIntSet() {
        IntSet set = CCreator.newIntSet((int)16);
        CollectionsTest.assertTrue((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)0, (int)set.size());
        set.add(1);
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)1, (int)set.size());
        int v = set.getAny();
        CollectionsTest.assertTrue((1 == v ? 1 : 0) != 0);
        set.add(2);
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)2, (int)set.size());
        v = set.getAny();
        CollectionsTest.assertTrue((1 == v || 2 == v ? 1 : 0) != 0);
        set.add(3);
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)3, (int)set.size());
        set.add(3);
        set.add(2);
        set.add(1);
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)3, (int)set.size());
        set.addAll(new int[0]);
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)3, (int)set.size());
        set.addAll(new int[]{4, 5});
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)5, (int)set.size());
        CollectionsTest.assertTrue((boolean)set.forEach(new IntProcessor(){

            public boolean process(int i) {
                Assert.assertTrue((i == 1 || i == 2 || i == 3 || i == 4 || i == 5 ? 1 : 0) != 0);
                return true;
            }
        }));
        CollectionsTest.assertFalse((boolean)set.forEach(new IntProcessor(){

            public boolean process(int i) {
                return false;
            }
        }));
        CollectionsTest.assertFalse((boolean)set.forEach(new IntProcessor(){
            boolean f = true;

            public boolean process(int i) {
                if (this.f) {
                    this.f = false;
                    return false;
                }
                Assert.fail((String)"invalid call");
                return false;
            }
        }));
        int[] arr = set.toArray();
        CollectionsTest.assertEquals((int)5, (int)arr.length);
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 1));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 2));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 3));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 4));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 5));
        set.add(100);
        set.removeValue(3);
        set.removeValue(100);
        CollectionsTest.assertEquals((int)5, (int)arr.length);
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 1));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 2));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 3));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 4));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(arr, 5));
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)4, (int)set.size());
        CollectionsTest.assertTrue((boolean)set.forEach(new IntProcessor(){

            public boolean process(int i) {
                Assert.assertTrue((i == 1 || i == 2 || i == 4 || i == 5 ? 1 : 0) != 0);
                return true;
            }
        }));
        set.retainAll(new int[]{2, 4, 7, 7, 0});
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)2, (int)set.size());
        CollectionsTest.assertTrue((boolean)set.forEach(new IntProcessor(){

            public boolean process(int i) {
                Assert.assertTrue((i == 2 || i == 4 ? 1 : 0) != 0);
                return true;
            }
        }));
        set.retainAll(new int[]{2, 2});
        CollectionsTest.assertFalse((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)1, (int)set.size());
        CollectionsTest.assertTrue((boolean)set.forEach(new IntProcessor(){

            public boolean process(int i) {
                Assert.assertTrue((i == 2 ? 1 : 0) != 0);
                return true;
            }
        }));
        set.retainAll(new int[0]);
        CollectionsTest.assertTrue((boolean)set.isEmpty());
        CollectionsTest.assertEquals((int)0, (int)set.size());
        CollectionsTest.assertTrue((boolean)set.forEach(new IntProcessor(){

            public boolean process(int i) {
                Assert.fail((String)"");
                return true;
            }
        }));
    }

    public void testIntIntMap() {
        IntIntMap map = CCreator.newIntIntMap((int)10);
        CollectionsTest.assertNull((Object)map.get(100));
        CollectionsTest.assertFalse((boolean)map.containsKey(100));
        map.put(100, 0);
        CollectionsTest.assertEquals((int)0, (int)map.get(100));
        CollectionsTest.assertTrue((boolean)map.containsKey(100));
        map.put(100, 3);
        CollectionsTest.assertEquals((int)3, (int)map.get(100));
        map.removeKey(100);
        CollectionsTest.assertNull((Object)map.get(100));
        CollectionsTest.assertEquals((int)0, (int)map.keys().length);
        map.put(1, 100);
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(map.keys(), 1));
        map.put(2, 200);
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(map.keys(), 1));
        CollectionsTest.assertTrue((boolean)CollectionsTest.contains(map.keys(), 2));
        for (int t = 100; t < 1000; ++t) {
            CollectionsTest.assertNull((Object)map.get(t));
            CollectionsTest.assertFalse((boolean)map.containsKey(t));
            map.put(t, t);
            CollectionsTest.assertEquals((int)t, (int)map.get(t));
        }
    }

    public void testIntByteMap() {
        IntByteMap map = CCreator.newIntByteMap((int)10);
        CollectionsTest.assertNull((Object)map.get(100));
        map.put(100, (byte)0);
        CollectionsTest.assertEquals((int)0, (int)map.get(100).byteValue());
        map.put(100, (byte)3);
        CollectionsTest.assertEquals((int)3, (int)map.get(100).byteValue());
        map.removeKey(100);
        CollectionsTest.assertNull((Object)map.get(100));
        map.put(1, (byte)100);
        map.put(2, (byte)7);
        for (int t = 3; t < 120; ++t) {
            CollectionsTest.assertNull((Object)map.get(t));
            map.put(t, (byte)t);
            CollectionsTest.assertEquals((int)t, (int)map.get(t).intValue());
        }
    }

    public void testObjectIntMap() {
        int t;
        ObjectIntMap map = CCreator.newObjectIntMap((int)10);
        CollectionsTest.assertNull((Object)map.get((Object)"a"));
        CollectionsTest.assertFalse((boolean)map.containsKey((Object)"a"));
        map.put((Object)"a", 0);
        CollectionsTest.assertEquals((int)0, (int)map.get((Object)"a"));
        CollectionsTest.assertTrue((boolean)map.containsKey((Object)"a"));
        map.put((Object)"a", 3);
        CollectionsTest.assertEquals((int)3, (int)map.get((Object)"a"));
        map.removeKey((Object)"a");
        CollectionsTest.assertNull((Object)map.get((Object)"a"));
        map.put((Object)"1", 100);
        map.put((Object)"2", 200);
        for (t = 3; t < 10; ++t) {
            CollectionsTest.assertNull((Object)map.get((Object)String.valueOf(t)));
            CollectionsTest.assertFalse((boolean)map.containsKey((Object)String.valueOf(t)));
            map.put((Object)String.valueOf(t), t);
            CollectionsTest.assertEquals((int)t, (int)map.get((Object)String.valueOf(t)));
        }
        CollectionsTest.assertTrue((boolean)map.forEachKey((ObjectProcessor)new ObjectProcessor<String>(){
            int index = 0;

            public boolean process(String value) {
                Assert.assertTrue((this.index < 9 ? 1 : 0) != 0);
                int v = Integer.parseInt(value);
                Assert.assertTrue((v >= 1 && v < 10 ? 1 : 0) != 0);
                ++this.index;
                return true;
            }
        }));
        CollectionsTest.assertFalse((boolean)map.forEachKey((ObjectProcessor)new ObjectProcessor<String>(){

            public boolean process(String value) {
                return false;
            }
        }));
        for (t = 1; t < 10; ++t) {
            map.removeKey((Object)String.valueOf(t));
        }
        CollectionsTest.assertTrue((boolean)map.forEachKey((ObjectProcessor)new ObjectProcessor<String>(){

            public boolean process(String value) {
                Assert.fail((String)"");
                return true;
            }
        }));
    }

    public void testIntObjectMap() {
        int t;
        int t2;
        IntObjectMap map = CCreator.newIntObjectMap((int)10);
        CollectionsTest.assertNull((Object)map.get(1));
        CollectionsTest.assertEquals((int)0, (int)map.size());
        CollectionsTest.assertTrue((boolean)map.isEmpty());
        map.put(1, (Object)"0");
        CollectionsTest.assertEquals((String)"0", (String)((String)map.get(1)));
        CollectionsTest.assertEquals((int)1, (int)map.size());
        CollectionsTest.assertFalse((boolean)map.isEmpty());
        map.put(1, (Object)"1");
        CollectionsTest.assertEquals((String)"1", (String)((String)map.get(1)));
        CollectionsTest.assertEquals((int)1, (int)map.size());
        CollectionsTest.assertFalse((boolean)map.isEmpty());
        for (t2 = 2; t2 < 10; ++t2) {
            CollectionsTest.assertNull((Object)map.get(t2));
            map.put(t2, (Object)String.valueOf(t2));
            CollectionsTest.assertEquals((String)String.valueOf(t2), (String)((String)map.get(t2)));
        }
        CollectionsTest.assertEquals((int)9, (int)map.size());
        map.clear();
        CollectionsTest.assertNull((Object)map.get(1));
        CollectionsTest.assertEquals((int)0, (int)map.size());
        CollectionsTest.assertTrue((boolean)map.isEmpty());
        for (t2 = 1; t2 < 10; ++t2) {
            CollectionsTest.assertNull((Object)map.get(t2));
            map.put(t2, (Object)String.valueOf(t2));
            CollectionsTest.assertEquals((String)String.valueOf(t2), (String)((String)map.get(t2)));
        }
        CollectionsTest.assertEquals((int)9, (int)map.size());
        CollectionsTest.assertFalse((boolean)map.forEachEntry((IntObjectProcessor)new IntObjectProcessor<String>(){

            public boolean process(int key, String value) {
                return false;
            }
        }));
        CollectionsTest.assertFalse((boolean)map.forEachValue((ObjectProcessor)new ObjectProcessor<String>(){

            public boolean process(String value) {
                return false;
            }
        }));
        CollectionsTest.assertTrue((boolean)map.forEachEntry((IntObjectProcessor)new IntObjectProcessor<String>(){

            public boolean process(int key, String value) {
                Assert.assertTrue((key >= 1 && key <= 9 ? 1 : 0) != 0);
                Assert.assertEquals((String)String.valueOf(key), (String)value);
                return true;
            }
        }));
        CollectionsTest.assertTrue((boolean)map.forEachValue((ObjectProcessor)new ObjectProcessor<String>(){

            public boolean process(String value) {
                int key = Integer.parseInt(value);
                Assert.assertTrue((key >= 1 && key <= 9 ? 1 : 0) != 0);
                return true;
            }
        }));
        int[] keys = map.keys();
        CollectionsTest.assertEquals((int)9, (int)keys.length);
        for (t = 1; t <= 9; ++t) {
            CollectionsTest.assertTrue((boolean)CollectionsTest.contains(keys, t));
        }
        for (t = 1; t <= 9; ++t) {
            map.removeKey(t);
            CollectionsTest.assertEquals((int)(9 - t), (int)map.size());
        }
        CollectionsTest.assertNull((Object)map.get(1));
        CollectionsTest.assertEquals((int)0, (int)map.size());
        CollectionsTest.assertTrue((boolean)map.isEmpty());
        CollectionsTest.assertEquals((int)9, (int)keys.length);
        for (t = 1; t <= 9; ++t) {
            CollectionsTest.assertTrue((boolean)CollectionsTest.contains(keys, t));
        }
    }

    public void testBooleanList() {
        BooleanList list = CCreator.newBooleanList((int)100);
        CollectionsTest.assertTrue((boolean)list.isEmpty());
        CollectionsTest.assertEquals((int)0, (int)list.size());
        list.add(false);
        CollectionsTest.assertFalse((boolean)list.isEmpty());
        CollectionsTest.assertEquals((int)1, (int)list.size());
        list.insert(0, true);
        CollectionsTest.assertFalse((boolean)list.isEmpty());
        CollectionsTest.assertEquals((int)2, (int)list.size());
    }
}

