/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto;

import com.teacode.exception.ExUtil;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.exception.RangeException;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.TempHelper;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.LibrettoEnv;
import org.ontobox.libretto.Modifier;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.EntityId;
import org.ontobox.libretto.adapter.NamedEntityId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.PropertyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.parser.KeyWord;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.VarTable;

public class LocalContext {
    private final Handler handler;
    private final BoxWorker worker;
    private final VarTable vars;
    private final Parser parser;
    private final Interp interp;
    private final Modifier modifier;
    public final int INT_ID;
    public final int STRING_ID;
    public final int LONG_ID;
    public final int DOUBLE_ID;
    public final int BOOLEAN_ID;
    public final int DATE_ID;
    public final int ONTOLOGY_ID;
    public final int TPROPERTY_ID;
    public final int OPROPERTY_ID;
    public final int CLASS_ID;
    public final int TYPE_ID;
    public final int FUNCTION_ID;
    public final int EXPR_ID;
    protected boolean xmlInited = false;
    protected int XmlEl;
    protected int XmlAttr;
    protected int XmlCData;
    protected int XmlComm;
    protected int XmlDoc;
    protected int XmlText;
    protected int XmlAttrProp;
    protected int XmlValProp;
    protected int XmlRootProp;
    protected int XmlNameProp;
    protected int XmlContentProp;
    protected int XmlTextProp;
    public static String LOCAL_VAR = "_var";
    public List<Token> embeddedExp;
    private static final int FORNUM = 20;
    private static final String[] formats = new String[20];
    private static final DateFormat[] dateformats = new DateFormat[20];
    private static final TimeZone utc = new SimpleTimeZone(0, "utc");
    private static final TimeZone vartz = new SimpleTimeZone(0, "utc");

    public LocalContext(Handler handler, BoxWorker worker) {
        this(handler, worker, new VarTable());
    }

    public LocalContext(Handler handler, BoxWorker worker, VarTable vrs) {
        this.handler = handler;
        this.worker = worker;
        this.vars = vrs;
        if (vrs.checkVar("_0") == -1) {
            handler.specialVarsBase = this.vars.putNewVar("_0");
            this.vars.putNewVar("_1");
            this.vars.putNewVar("_2");
            this.vars.putNewVar("_3");
            this.vars.putNewVar("_4");
            this.vars.putNewVar("_5");
            this.vars.putNewVar("_6");
            this.vars.putNewVar("_7");
            this.vars.putNewVar("_8");
            this.vars.putNewVar("_9");
            handler.matchVarNumber = this.vars.putNewVar("_m0");
            this.vars.putNewVar("_m1");
            this.vars.putNewVar("_m2");
            this.vars.putNewVar("_m3");
            this.vars.putNewVar("_m4");
            this.vars.putNewVar("_m5");
            this.vars.putNewVar("_m6");
            this.vars.putNewVar("_m7");
            this.vars.putNewVar("_m8");
            this.vars.putNewVar("_m9");
            handler.indexVarNumber = this.vars.putNewVar("_i");
            handler.thisVarNumber = this.vars.putNewVar("_this");
            handler.prevVarNumber = this.vars.putNewVar("_prev");
            handler.localVar = this.vars.putNewVar(LOCAL_VAR);
            handler.specialVarsNumber = 24;
        }
        this.parser = new Parser(this);
        this.interp = new Interp(this, this.vars, handler.getFunctions(), this.parser);
        this.modifier = new Modifier(this, this.interp);
        this.interp.setModifier(this.modifier);
        handler.timeZones.put(handler.defaultTZ.getID().toLowerCase(), handler.defaultTZ);
        BoxWorker w = this.getWorker();
        this.INT_ID = w.id("http://ontobox.org/#int");
        this.STRING_ID = w.id("http://ontobox.org/#string");
        this.LONG_ID = w.id("http://ontobox.org/#long");
        this.DOUBLE_ID = w.id("http://ontobox.org/#double");
        this.BOOLEAN_ID = w.id("http://ontobox.org/#boolean");
        this.DATE_ID = w.id("http://ontobox.org/#date");
        this.ONTOLOGY_ID = w.id("http://ontobox.org/#ontology");
        this.TPROPERTY_ID = w.id("http://ontobox.org/#tproperty");
        this.OPROPERTY_ID = w.id("http://ontobox.org/#oproperty");
        this.CLASS_ID = w.id("http://ontobox.org/#class");
        this.TYPE_ID = w.id("http://ontobox.org/#type");
        this.FUNCTION_ID = w.id("http://ontobox.org/#function");
        this.EXPR_ID = w.id("http://ontobox.org/#expr");
    }

    public void initXML() {
        if (!this.xmlInited) {
            BoxWorker w = this.worker;
            this.XmlEl = w.resolve("http://xml.ontobox.org/#Element", Entity.ONTCLASS);
            this.XmlAttr = w.resolve("http://xml.ontobox.org/#Attribute", Entity.ONTCLASS);
            this.XmlCData = w.resolve("http://xml.ontobox.org/#CDATA", Entity.ONTCLASS);
            this.XmlComm = w.resolve("http://xml.ontobox.org/#Comment", Entity.ONTCLASS);
            this.XmlDoc = w.resolve("http://xml.ontobox.org/#Document", Entity.ONTCLASS);
            this.XmlText = w.resolve("http://xml.ontobox.org/#Text", Entity.ONTCLASS);
            this.XmlAttrProp = w.resolve("http://xml.ontobox.org/#attributes");
            this.XmlValProp = w.resolve("http://xml.ontobox.org/#value");
            this.XmlRootProp = w.resolve("http://xml.ontobox.org/#root");
            this.XmlNameProp = w.resolve("http://xml.ontobox.org/#name");
            this.XmlContentProp = w.resolve("http://xml.ontobox.org/#content");
            this.XmlTextProp = w.resolve("http://xml.ontobox.org/#text");
            this.xmlInited = true;
        }
    }

    public int getXmlEl() {
        this.initXML();
        return this.XmlEl;
    }

    public int getXmlAttr() {
        this.initXML();
        return this.XmlAttr;
    }

    public int getXmlCData() {
        this.initXML();
        return this.XmlCData;
    }

    public int getXmlComm() {
        this.initXML();
        return this.XmlComm;
    }

    public int getXmlDoc() {
        this.initXML();
        return this.XmlDoc;
    }

    public int getXmlText() {
        this.initXML();
        return this.XmlText;
    }

    public int getXmlAttrProp() {
        this.initXML();
        return this.XmlAttrProp;
    }

    public int getXmlValProp() {
        this.initXML();
        return this.XmlValProp;
    }

    public int getXmlRootProp() {
        this.initXML();
        return this.XmlRootProp;
    }

    public int getXmlNameProp() {
        this.initXML();
        return this.XmlNameProp;
    }

    public int getXmlContentProp() {
        this.initXML();
        return this.XmlContentProp;
    }

    public int getXmlTextProp() {
        this.initXML();
        return this.XmlTextProp;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public final BoxWorker getWorker() {
        return this.worker;
    }

    public VarTable getVars() {
        return this.vars;
    }

    public Interp getInterp() {
        return this.interp;
    }

    public Parser getParser() {
        return this.parser;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public final void setVar(String var, Object val) {
        int varnum = this.vars.putVar(var);
        this.vars.putVarValue(varnum, val);
    }

    public final void setVar(int n, Object val) {
        int varnum = this.vars.checkVar(String.valueOf(n));
        this.vars.putVarValue(varnum, val);
    }

    public OntologyId getOntologyFromMap(String pr) {
        return this.getOntology(this.handler.getUriByPrefix(pr));
    }

    public void putOntologyInMap(String pr, OntologyId ont) {
        this.handler.getMapping().put(pr, this.worker.name(ont.id()));
    }

    public String checkMapURI(String uri) {
        Map<String, String> mapping = this.getHandler().getMapping();
        Set<String> kk = mapping.keySet();
        for (String k : kk) {
            if (!mapping.get(k).equals(uri)) continue;
            return k;
        }
        return null;
    }

    public OntologyId getOntology(String uri) {
        if (uri == null) {
            return null;
        }
        BoxWorker worker = this.worker;
        if (uri.equals("http://ontobox.org/map")) {
            MapHelper.initIfNeed(worker);
        }
        if (worker.entity(uri) == Entity.ONTOLOGY) {
            return OntologyId.newId(worker.id(uri));
        }
        return OntologyId.newId(worker.write().newOntology(uri));
    }

    public final String getTokenURI(Token tok) {
        if (tok.getUri() != null) {
            return tok.getUri();
        }
        String prefix = tok.getPrefix();
        String uri = prefix == null || prefix.isEmpty() ? this.handler.getMapping().get("") : this.handler.getMapping().get(prefix);
        return uri;
    }

    public final String getFullName(Token dt) {
        return this.getTokenURI(dt) + '#' + dt.getName();
    }

    public TypeId getDatatype(String uri) {
        BoxWorker worker = this.worker;
        if (worker.entity(uri) == Entity.TYPE) {
            return TypeId.newId(worker.id(uri));
        }
        return null;
    }

    public Integer getEntity(String uri) {
        return this.worker.id(uri);
    }

    public Collection<ObjectId> getAllOntObjects(String ontouri) {
        if (ontouri == null) {
            throw new RuntimeException("Ontology not found (null)");
        }
        BoxWorker worker = this.worker;
        int[] objects = worker.objects(worker.resolve(ontouri));
        ArrayList<ObjectId> ret = new ArrayList<ObjectId>(objects.length);
        for (int obj : objects) {
            ret.add(ObjectId.newId(worker, obj));
        }
        return ret;
    }

    public ObjectId getOntObject(Token obj) {
        try {
            int ontId = this.worker.resolve(this.getTokenURI(obj), Entity.ONTOLOGY);
            int id = this.worker.resolve(this.worker.name(ontId, obj.getName()), Entity.ONTOBJECT);
            return ObjectId.newId(this.worker, id);
        }
        catch (Exception e) {
            if (obj.getName().equals("_")) {
                ObjectId o = this.getObject(obj, KeyWord.CREATE_OR_UPDATE);
                if (obj.isTemporaryObj()) {
                    TempHelper.makeTemporary(this.worker, o.id());
                }
                return o;
            }
            throw new RuntimeException("OntoBox reports: " + e.getMessage());
        }
    }

    public ClassId getOntClass(String fullName) {
        return ClassId.newId(this.worker.resolve(fullName, Entity.ONTCLASS));
    }

    public boolean belongsTo(NamedEntityId ne, OntologyId ont) {
        return this.worker.ontology(ne.id()) == ont.id();
    }

    public boolean belongsTo(String entity, String onto) {
        OntologyId ont = this.getOntology(onto);
        if (ont == null) {
            throw new RuntimeException("Ontology " + onto + " does not exist");
        }
        Integer ne = this.getEntity(entity);
        if (ne == null) {
            throw new RuntimeException("Entity " + entity + " does not exist");
        }
        return this.worker.ontology(ne) == ont.id();
    }

    public ClassId getClass(String name, String uri, KeyWord modifier) {
        OntologyId ont = this.getOntology(uri);
        String fn = this.worker.name(ont.id(), name);
        if (this.worker.entity(fn) == Entity.ONTCLASS) {
            if (modifier == KeyWord.CREATE) {
                throw new RuntimeException("Created class " + uri + '#' + name + " already exists");
            }
            return ClassId.newId(this.worker.id(fn));
        }
        if (modifier == KeyWord.UPDATE) {
            throw new RuntimeException("Class '" + name + "' not found in ontology '" + uri + '\'');
        }
        return ClassId.newId(this.worker.write().newClass(fn));
    }

    public int[] getClassObjects(Token tok) {
        int ont = this.worker.resolve(this.getTokenURI(tok), Entity.ONTOLOGY);
        int cl = this.worker.resolve(this.worker.name(ont, tok.getName()), Entity.ONTCLASS);
        return this.worker.objects(cl);
    }

    public ClassId getOntClass(Token tok) {
        int ont = this.worker.resolve(this.getTokenURI(tok), Entity.ONTOLOGY);
        return ClassId.newId(this.worker.resolve(this.worker.name(ont, tok.getName()), Entity.ONTCLASS));
    }

    public OntCollection getAllObjects() {
        OntCollection all = OntCC.newCol(CollectionType.OBJECT_COL);
        for (int ont : this.worker.ontologies()) {
            all.addObjects(this.worker, this.worker.objects(ont));
        }
        return all;
    }

    public PropertyId getProperty(Token cur) {
        if (cur.isKey()) {
            return null;
        }
        String full_name = this.getFullName(cur);
        Entity entity = this.worker.entity(full_name);
        if (entity == Entity.TPROPERTY) {
            return TPropertyId.newId(this.worker.id(full_name));
        }
        if (entity == Entity.OPROPERTY) {
            return OPropertyId.newId(this.worker.id(full_name));
        }
        return null;
    }

    public void removePropValue(ObjectId obj, PropertyId prop, int index) {
        this.worker.write().removeValue(obj.id(), prop.id(), index);
    }

    public void removePropValues(ObjectId obj, PropertyId prop) {
        this.worker.write().removeValues(obj.id(), prop.id());
    }

    public OntCollection getAllTPropValues(ObjectId obj) {
        OntCollection result = OntCC.newCol();
        for (int tprop : this.worker.tprops(obj.id())) {
            result.addAllTyped(Arrays.asList(this.worker.strings(obj.id(), tprop)));
        }
        return result;
    }

    public OntCollection getAllOPropValues(ObjectId obj) {
        OntCollection result = OntCC.newCol();
        for (int oprop : this.worker.oprops(obj.id())) {
            result.addObjects(this.worker, this.worker.objects(obj.id(), oprop));
        }
        return result;
    }

    public boolean isEntityType(Integer t) {
        if (t == null) {
            return false;
        }
        return t == this.CLASS_ID || t == this.ONTOLOGY_ID || t == this.TPROPERTY_ID || t == this.TYPE_ID || t == this.OPROPERTY_ID;
    }

    public Integer entityType(int ent) {
        Entity e = this.worker.entity(ent);
        switch (e) {
            case ONTOLOGY: {
                return this.ONTOLOGY_ID;
            }
            case ONTCLASS: {
                return this.CLASS_ID;
            }
            case TPROPERTY: {
                return this.TPROPERTY_ID;
            }
            case OPROPERTY: {
                return this.OPROPERTY_ID;
            }
            case TYPE: {
                return this.TYPE_ID;
            }
        }
        return null;
    }

    public void addPropValues(ObjectId obj, PropertyId prop, Object val, int index) {
        block25: {
            if (Interp.isFalse(val)) {
                return;
            }
            OntCollection col = val instanceof OntCollection ? (OntCollection)val : OntCC.singleton(val);
            try {
                String propname = this.worker.name(prop.id());
                LibrettoEnv le = this.getHandler().librettoEnv;
                if (prop instanceof TPropertyId) {
                    TPropertyId tp = (TPropertyId)prop;
                    boolean isDate = false;
                    Integer t = this.worker.range(tp.id());
                    if (t != null && this.worker.name(t).equals("http://ontobox.org/#date")) {
                        isDate = true;
                    }
                    if (index < 0) {
                        index = this.worker.strings(obj.id(), tp.id()).length;
                    }
                    String[] dummyStr = new String[1];
                    for (Object o : col) {
                        if (o instanceof ObjectContainer) {
                            o = ((ObjectContainer)o).getObject();
                        }
                        if (o instanceof ObjectId) {
                            throw new InvalidPropValueException("The attempt to assign object " + this.worker.name(((ObjectId)o).id()) + " to t-property " + this.worker.name(prop.id()));
                        }
                        if (this.isEntityType(t)) {
                            if (!(o instanceof EntityId)) {
                                throw new RuntimeException("Can not cast value " + Helper.shortenString(o.toString()) + " to EntityType property " + this.worker.name(tp.id()));
                            }
                            int vid = ((EntityId)o).id();
                            o = this.worker.name(vid);
                            int vtype = this.entityType(vid);
                            if (vtype != t) {
                                throw new InvalidPropValueException("Can not cast entity value " + o + "(" + (Object)((Object)this.worker.entity(vid)) + ")" + " to EntityType property " + this.worker.name(tp.id()) + o + "(" + this.worker.name(t) + ")");
                            }
                        }
                        String s = o.toString();
                        if (isDate) {
                            Date d = this.getNormalizedDate(s, dummyStr);
                            if (d == null) {
                                throw new InvalidDateException(s);
                            }
                            s = DateHelper.format(d);
                        }
                        this.worker.write().addString(obj.id(), tp.id(), index, s);
                        ++index;
                    }
                } else {
                    OPropertyId op = (OPropertyId)prop;
                    if (index < 0) {
                        index = this.worker.objects(obj.id(), op.id()).length + index;
                    }
                    for (Object o : col) {
                        if (o instanceof ObjectContainer) {
                            o = ((ObjectContainer)o).getObject();
                        }
                        if (!(o instanceof ObjectId)) {
                            throw new InvalidPropValueException("The attempt to assign non-object " + o.toString() + " to o-property " + this.worker.name(prop.id()));
                        }
                        this.worker.write().addObject(obj.id(), op.id(), index, ((ObjectId)o).id());
                        ++index;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException("Wrong type or too many property's values in " + this.worker.name(prop.id())), (Throwable)e);
            }
            catch (InvalidDateException e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException("Invalid date format '" + e.getMessage() + '\''), (Throwable)e);
            }
            catch (InvalidPropValueException e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage()), (Throwable)e);
            }
            catch (RangeException e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException("Invalid class of assigned object in property " + this.worker.name(prop.id())), (Throwable)e);
            }
            catch (Exception e) {
                if (!this.isMap(obj)) break block25;
                String name = this.getKeyName(prop);
                if (col.isDataCol()) {
                    prop = this.setTkey(name, obj);
                    for (Object o : col) {
                        if (!(o instanceof ObjectContainer)) continue;
                        o = ((ObjectContainer)o).getObject();
                    }
                }
                prop = this.setOkey(name, obj);
            }
        }
    }

    public int getPropValNumber(ObjectId oo, PropertyId p) {
        BoxWorker worker = this.worker;
        if (p instanceof OPropertyId) {
            return worker.objects(oo.id(), p.id()).length;
        }
        return worker.strings(oo.id(), p.id()).length;
    }

    public boolean doesKeyExist(Token cur) {
        if (cur.getPrefix() != null) {
            return false;
        }
        String key = cur.getName();
        String tcl = "http://ontobox.org/map#tcl-" + key;
        String ocl = "http://ontobox.org/map#ocl-" + key;
        return this.worker.entity(tcl) == Entity.ONTCLASS && this.worker.objects(this.worker.id(tcl)).length != 0 || this.worker.entity(ocl) == Entity.ONTCLASS && this.worker.objects(this.worker.id(ocl)).length != 0;
    }

    public OntCollection typedCollection(Collection col, TPropertyId tp) {
        OntCollection rcol;
        block25: {
            String tptype;
            try {
                tptype = this.worker.name(this.worker.range(tp.id()));
            }
            catch (Exception e) {
                tptype = "";
            }
            try {
                if (tptype.equals("http://ontobox.org/#int")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        rcol.add(Integer.valueOf((String)s));
                    }
                    break block25;
                }
                if (tptype.equals("http://ontobox.org/#long")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        rcol.add(Long.valueOf((String)s));
                    }
                    break block25;
                }
                if (tptype.equals("http://ontobox.org/#double")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        rcol.add(Double.valueOf((String)s));
                    }
                    break block25;
                }
                if (tptype.equals("http://ontobox.org/#class")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        Integer id = Helper.getEntityByURI(this, (String)s, this.CLASS_ID);
                        if (id == null) {
                            throw new RuntimeException("Type mismatch for entity " + s + " in t-property " + this.worker.name(tp.id()) + " (class entity expected)");
                        }
                        rcol.add(ClassId.newId(id));
                    }
                    break block25;
                }
                if (tptype.equals("http://ontobox.org/#tproperty")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        Integer id = Helper.getEntityByURI(this, (String)s, this.TPROPERTY_ID);
                        if (id == null) {
                            throw new RuntimeException("Type mismatch for entity " + s + " in t-property " + this.worker.name(tp.id()) + " (tproperty entity expected)");
                        }
                        rcol.add(TPropertyId.newId(id));
                    }
                    break block25;
                }
                if (tptype.equals("http://ontobox.org/#oproperty")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        Integer id = Helper.getEntityByURI(this, (String)s, this.OPROPERTY_ID);
                        if (id == null) {
                            throw new RuntimeException("Type mismatch for entity " + s + " in t-property " + this.worker.name(tp.id()) + " (oproperty entity expected)");
                        }
                        rcol.add(OPropertyId.newId(id));
                    }
                    break block25;
                }
                if (tptype.equals("http://ontobox.org/#type")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        Integer id = Helper.getEntityByURI(this, (String)s, this.TYPE_ID);
                        if (id == null) {
                            throw new RuntimeException("Type mismatch for entity " + s + " in t-property " + this.worker.name(tp.id()) + " (type entity expected)");
                        }
                        rcol.add(TypeId.newId(id));
                    }
                    break block25;
                }
                if (tptype.equals("http://ontobox.org/#ontology")) {
                    rcol = OntCC.newCol(CollectionType.DATA_COL, col.size());
                    for (Object s : col) {
                        Integer id = Helper.getEntityByURI(this, (String)s, this.ONTOLOGY_ID);
                        if (id == null) {
                            throw new RuntimeException("Type mismatch for entity " + s + " in t-property " + this.worker.name(tp.id()) + " (ontology entity expected)");
                        }
                        rcol.add(OntologyId.newId(id));
                    }
                    break block25;
                }
                return OntCC.newCol(col);
            }
            catch (Exception e) {
                throw new RuntimeException("The problems with values casting in property " + this.worker.name(tp.id()));
            }
        }
        return rcol;
    }

    ObjectId getObject(Token objectToken, KeyWord modifier) {
        String fullName;
        OntologyId ont = this.getOntology(this.getTokenURI(objectToken));
        BoxWorker worker = this.worker;
        String shortname = objectToken.getName();
        String string = fullName = shortname.equals("_") && modifier != KeyWord.UPDATE ? worker.write().newName(ont.id()) : worker.name(ont.id(), shortname);
        if (worker.entity(fullName) == Entity.ONTOBJECT) {
            if (modifier == KeyWord.CREATE) {
                throw new RuntimeException("Created object " + objectToken.toString() + " already exists");
            }
            return ObjectId.newId(worker, worker.id(fullName));
        }
        if (modifier == KeyWord.UPDATE) {
            throw new RuntimeException("Object " + objectToken.toString() + " not found");
        }
        return ObjectId.newId(worker, worker.write().newObject(fullName));
    }

    ObjectId createMap() {
        int o;
        try {
            o = this.getOntologyFromMap("").id();
        }
        catch (Exception e) {
            o = this.getOntologyFromMap("map").id();
        }
        return ObjectId.newId(this.worker, MapHelper.create(this.worker, o));
    }

    public ObjectId createTempMap() {
        ObjectId tm = this.createMap();
        TempHelper.makeTemporary(this.worker, tm.id());
        return tm;
    }

    public ObjectId createKeyMap(Object value, String valuename) {
        ObjectId map = this.createTempMap();
        this.setMapValue(map, valuename, value);
        return map;
    }

    public ObjectId createKeyValueMap(Object key, Object value, String keyname, String valuename) {
        ObjectId map = this.createTempMap();
        this.setMapValue(map, keyname, key);
        this.setMapValue(map, valuename, value);
        return map;
    }

    public int addMap(BoxWorker worker, int map, String name, String value) {
        worker.write().addString(map, MapHelper.tkey(worker, map, name), value);
        return map;
    }

    OPropertyId setOkey(String name, ObjectId map) {
        return OPropertyId.newId(MapHelper.okey(this.worker, map.id(), name));
    }

    TPropertyId setTkey(String name, ObjectId map) {
        return TPropertyId.newId(MapHelper.tkey(this.worker, map.id(), name));
    }

    OPropertyId createOkey(String name) {
        return this.setOkey(name, this.createMap());
    }

    public final boolean isMap(Object map) {
        return map instanceof ObjectId && MapHelper.isMap(this.worker, ((ObjectId)map).id());
    }

    public final boolean isTemporary(Object obj) {
        return obj instanceof ObjectId && TempHelper.isTemporary(this.worker, ((ObjectId)obj).id());
    }

    public String getKeyName(PropertyId key) {
        return MapHelper.name(this.worker, key.id());
    }

    public final PropertyId getMapKey(ObjectId map, String name) {
        BoxWorker worker = this.worker;
        int id = map.id();
        if (MapHelper.isTkey(worker, id, name)) {
            return TPropertyId.newId(MapHelper.tkey(worker, id, name));
        }
        if (MapHelper.isOkey(worker, id, name)) {
            return OPropertyId.newId(MapHelper.okey(worker, id, name));
        }
        return null;
    }

    public OntCollection getMapKeyValues(ObjectId map, String name) {
        BoxWorker worker = this.worker;
        int mapId = map.id();
        Collection<Object> c = null;
        if (MapHelper.isTkey(worker, mapId, name)) {
            c = Arrays.asList(worker.strings(mapId, MapHelper.tkey(worker, mapId, name)));
        } else if (MapHelper.isOkey(worker, mapId, name)) {
            c = ObjectId.convert(worker, worker.objects(mapId, MapHelper.okey(worker, mapId, name)));
        } else {
            String fn = "http://ontobox.org/map#" + name;
            Entity entity = worker.entity(fn);
            try {
                if (entity == Entity.TPROPERTY) {
                    c = Arrays.asList(worker.strings(mapId, worker.id(fn)));
                }
                if (entity == Entity.OPROPERTY) {
                    c = ObjectId.convert(worker, worker.objects(mapId, worker.id(fn)));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return null;
        }
        if (c.iterator().next().equals(Boolean.FALSE)) {
            return null;
        }
        if (c.isEmpty()) {
            return null;
        }
        return OntCC.newCol(c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMapValue(ObjectId map, String key, Object value) {
        BoxWorker worker = this.worker;
        BoxWriter writer = worker.write();
        int mapId = map.id();
        if (value instanceof OntCollection) {
            if (((OntCollection)value).isDataCol()) {
                TPropertyId tp = this.setTkey(key, map);
                int propId = tp.id();
                for (Object d : (OntCollection)value) {
                    writer.addString(mapId, propId, d.toString());
                }
                return;
            } else {
                if (!((OntCollection)value).isObjCol()) return;
                OPropertyId op = this.setOkey(key, map);
                int propId = op.id();
                for (Object d : (OntCollection)value) {
                    writer.addObject(mapId, propId, ((ObjectId)d).id());
                }
            }
            return;
        } else {
            if (value == null) return;
            if (value instanceof ObjectId) {
                writer.addObject(mapId, this.setOkey(key, map).id(), ((ObjectId)value).id());
                return;
            } else {
                writer.addString(mapId, this.setTkey(key, map).id(), value.toString());
            }
        }
    }

    public void removeMapKey(ObjectId map, String key) {
        if (!this.isMap(map)) {
            throw new RuntimeException("OntObject is not map in 'removeMapValues'");
        }
        MapHelper.removeKey(this.worker, map.id(), key);
    }

    public Collection<String> getAllMapTKeys(ObjectId map) {
        BoxWorker worker = this.worker;
        if (!MapHelper.isMap(worker, map.id())) {
            throw new RuntimeException("Trying to get keys in non-map");
        }
        return Arrays.asList(MapHelper.getTKeys(worker, map.id()));
    }

    ClassId createMapSubClass(String uri, String name) {
        BoxWorker worker = this.worker;
        int map = worker.resolve("http://ontobox.org/map#Map");
        int cl = worker.write().newClass(worker.name(this.getOntology(uri).id(), name));
        worker.write().addSubclass(map, cl);
        return ClassId.newId(cl);
    }

    private boolean belongsTo(int elem, int[] array) {
        for (int i : array) {
            if (i != elem) continue;
            return true;
        }
        return false;
    }

    public void objectForceDelete(int dd) {
        this.objectForceDelink(dd);
        this.worker.write().delete(dd);
    }

    void objectForceDelink(int dd) {
        int[] owners;
        for (int oi : owners = this.worker.owners(dd)) {
            int[] props;
            for (int pi : props = this.worker.oprops(oi)) {
                Integer ri = this.worker.range(pi);
                int[] values = this.worker.objects(oi, pi);
                for (int i = values.length - 1; i >= 0; --i) {
                    int vi = values[i];
                    if (vi != dd) continue;
                    this.worker.write().removeValue(oi, pi, i);
                }
            }
        }
    }

    public List<Integer> getOwners(Object dd) {
        int[] owners;
        boolean isobject = false;
        if (dd instanceof String) {
            owners = this.worker.owners((String)dd);
        } else {
            isobject = true;
            owners = this.worker.owners((Integer)dd);
        }
        ArrayList<Integer> triples = new ArrayList<Integer>();
        for (int oi : owners) {
            int[] props = isobject ? this.worker.oprops(oi) : this.worker.tprops(oi);
            for (int pi : props) {
                Object[] values;
                Object[] vals;
                if (isobject) {
                    vals = this.worker.objects(oi, pi);
                    values = new Object[vals.length];
                    for (int i = 0; i < vals.length; ++i) {
                        values[i] = vals[i];
                    }
                } else {
                    vals = this.worker.strings(oi, pi);
                    values = new Object[vals.length];
                    System.arraycopy(vals, 0, values, 0, vals.length);
                }
                for (int i = values.length - 1; i >= 0; --i) {
                    Object vi = values[i];
                    if (!vi.equals(dd)) continue;
                    triples.add(oi);
                    triples.add(pi);
                    triples.add(i);
                }
            }
        }
        return triples;
    }

    public void objectRemoveFromClass(int cl, int rm) {
        int[] props;
        for (int p : props = this.worker.oprops(cl)) {
            this.worker.write().removeValues(rm, p);
        }
        for (int p : props = this.worker.tprops(cl)) {
            this.worker.write().removeValues(rm, p);
        }
        this.worker.write().removeObjectClass(rm, cl);
    }

    public TimeZone getDefaultTZ() {
        return this.handler.defaultTZ;
    }

    public void setDefaultTZ(TimeZone tz) {
        this.handler.defaultTZ = tz;
    }

    public Map<String, TimeZone> getTimeZones() {
        return this.handler.timeZones;
    }

    private static int parseNumber(CharStream in) {
        int num = 0;
        if (!Character.isDigit(in.ch)) {
            throw new RuntimeException("");
        }
        while (Character.isDigit(in.ch)) {
            num = num * 10 + in.ch - 48;
            in.next();
        }
        return num;
    }

    private static int getDigit(CharStream in) {
        if (!in.isDigit()) {
            throw new RuntimeException("");
        }
        int n = in.ch - 48;
        in.next();
        return n;
    }

    static Date parseDate(String str, TimeZone tz, String[] frm) {
        GregorianCalendar c;
        CharStream in = CharStream.createCharStream();
        in.rewindCharStream(new StringReader(str));
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        int abshour = 0;
        int absminute = 0;
        boolean isAbsolute = false;
        boolean isAbsMinus = false;
        int shiftz = 16;
        int shiftt = 0;
        int shifts = 0;
        int year = LocalContext.parseNumber(in);
        if (in.ch != '/' && in.ch != '-') {
            throw new RuntimeException("");
        }
        in.nextChk();
        int month = LocalContext.parseNumber(in);
        if (in.ch == '/' || in.ch == '-') {
            if (in.ch == '/') {
                shifts = 1;
            }
        } else {
            throw new RuntimeException("");
        }
        in.nextChk();
        int day = LocalContext.parseNumber(in);
        if (in.ch == ' ' || in.ch == 'T') {
            if (in.ch == 'T') {
                shiftt = 2;
            }
            in.next();
            if (Character.isDigit(in.ch)) {
                hour = LocalContext.parseNumber(in);
                if (hour > 23) {
                    throw new RuntimeException("");
                }
                if (in.ch != ':') {
                    throw new RuntimeException("");
                }
                in.nextChk();
                minute = LocalContext.parseNumber(in);
                shiftz = 12;
                if (in.ch == ':') {
                    in.nextChk();
                    second = LocalContext.parseNumber(in);
                    shiftz = 8;
                    if (in.ch == '.') {
                        in.nextChk();
                        millisecond = LocalContext.parseNumber(in);
                        shiftz = 4;
                    }
                }
                if (in.ch == '+' || in.ch == '-') {
                    if (in.ch == '-') {
                        isAbsMinus = true;
                    }
                    isAbsolute = true;
                    in.nextChk();
                    abshour = LocalContext.getDigit(in) * 10;
                    if ((abshour += LocalContext.getDigit(in)) > 12) {
                        throw new RuntimeException("");
                    }
                    absminute = LocalContext.getDigit(in) * 10;
                    if ((absminute += LocalContext.getDigit(in)) > 59) {
                        throw new RuntimeException("");
                    }
                    shiftz = 0;
                } else if (in.ch == 'Z') {
                    shiftz = 0;
                    isAbsolute = true;
                }
            }
        }
        if (isAbsolute) {
            c = new GregorianCalendar(year, month - 1, day, hour, minute, second);
            int shift = abshour * 3600000 + absminute * 60000;
            if (isAbsMinus) {
                shift = -shift;
            }
            vartz.setRawOffset(shift);
            ((Calendar)c).setTimeZone(vartz);
        } else {
            c = new GregorianCalendar(year, month - 1, day, hour, minute, second);
            ((Calendar)c).setTimeZone(tz);
        }
        Date date = new Date(c.getTimeInMillis() + (long)millisecond);
        String d = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(date);
        frm[0] = formats[shiftz + shifts + shiftt];
        return date;
    }

    public static Date getNormalizedDate(String date, TimeZone tz, String[] frm) {
        try {
            return LocalContext.parseDate(date, tz, frm);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getNormalizedDate(String date, String[] format) {
        return LocalContext.getNormalizedDate(date, this.getDefaultTZ(), format);
    }

    public Date getNormalizedDate(String date) {
        return LocalContext.getNormalizedDate(date, this.getDefaultTZ(), new String[1]);
    }

    String convertDate(String date, TimeZone tz1, TimeZone tz2) {
        if (tz1 == null) {
            tz1 = this.getDefaultTZ();
        }
        if (tz2 == null) {
            tz2 = this.getDefaultTZ();
        }
        String[] format = new String[1];
        Date d = LocalContext.getNormalizedDate(date, tz1, format);
        SimpleDateFormat df = new SimpleDateFormat(format[0]);
        df.setTimeZone(tz2);
        return df.format(d);
    }

    public Token getPathTerm(Reader reader) {
        CharStream inin = CharStream.createCharStream();
        inin.rewindCharStream(reader);
        this.parser.pushIn(inin);
        Token tok = this.parser.getPathTerm(null);
        this.parser.popIn();
        return tok;
    }

    public void pushIn0(CharStream inin) {
        this.parser.pushIn1(inin, false);
    }

    public void pushIn1(CharStream inin) {
        this.parser.pushIn1(inin, true);
    }

    public void popIn1() {
        this.parser.popIn1();
    }

    public Object eval(Object o, Object quoted) {
        return this.interp.eval(o, quoted, null, null);
    }

    public void addToEmbeddedExp(Token tok) {
        this.embeddedExp.add(tok);
    }

    public void stop() {
        this.handler.stop = true;
    }

    public static boolean checkSyntax(String str, String ptrn) {
        Pattern pattern = Pattern.compile(ptrn, 0);
        Matcher m = pattern.matcher(str);
        return Pattern.compile(ptrn, 0).matcher(str).matches();
    }

    public String checkLocalInOntologies(String local) {
        int[] ontos = this.worker.ontologies();
        if (!Handler.ALL_DEFAULT) {
            return null;
        }
        String uri = null;
        for (int onto : ontos) {
            String ur = this.worker.name(onto);
            String nm = ur + '#' + local;
            Integer n = this.worker.id(nm);
            if (n == null) continue;
            if (uri != null) {
                throw new RuntimeException("Ambiguous local name " + local + " can be interpreted as " + uri + '#' + local + " and " + nm + ". Use explicit ontology prefixes.");
            }
            uri = ur;
        }
        return uri;
    }

    public LibrettoEnv getLE() {
        return this.handler.librettoEnv;
    }

    static {
        LocalContext.formats[0] = "yyyy-MM-dd HH:mm:ss.SSSZ";
        LocalContext.formats[1] = "yyyy/MM/dd HH:mm:ss.SSSZ";
        LocalContext.formats[2] = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
        LocalContext.formats[3] = "yyyy/MM/dd'T'HH:mm:ss.SSSZ";
        LocalContext.formats[4] = "yyyy-MM-dd HH:mm:ss.SSS";
        LocalContext.formats[5] = "yyyy/MM/dd HH:mm:ss.SSS";
        LocalContext.formats[6] = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        LocalContext.formats[7] = "yyyy/MM/dd'T'HH:mm:ss.SSS";
        LocalContext.formats[8] = "yyyy-MM-dd HH:mm:ss";
        LocalContext.formats[9] = "yyyy/MM/dd HH:mm:ss";
        LocalContext.formats[10] = "yyyy-MM-dd'T'HH:mm:ss";
        LocalContext.formats[11] = "yyyy/MM/dd'T'HH:mm:ss";
        LocalContext.formats[12] = "yyyy-MM-dd HH:mm";
        LocalContext.formats[13] = "yyyy/MM/dd HH:mm";
        LocalContext.formats[14] = "yyyy-MM-dd'T'HH:mm";
        LocalContext.formats[15] = "yyyy/MM/dd'T'HH:mm";
        LocalContext.formats[16] = "yyyy-MM-dd";
        LocalContext.formats[17] = "yyyy/MM/dd";
        LocalContext.formats[18] = "yyyy-MM-dd";
        LocalContext.formats[19] = "yyyy/MM/dd";
        for (int i = 0; i < 20; ++i) {
            LocalContext.dateformats[i] = new SimpleDateFormat(formats[i]);
        }
    }

    public static class InvalidDateException
    extends RuntimeException {
        public InvalidDateException(String message) {
            super(message);
        }
    }

    private class InvalidPropValueException
    extends Exception {
        InvalidPropValueException(String e) {
            super(e);
        }
    }
}

