/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.debug;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.meta2project.fast.adapter.FastSession;
import org.meta2project.model.Connection;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.TempHelper;
import org.ontobox.exchange.MVX;
import org.ontobox.libretto.FieldContainer;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.debug.Example;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.parser.LQuery;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Tokens;
import org.ontobox.libretto.parser.VarTable;

public class Debug {
    public static Sequence progseq;

    public static void main(String[] args) {
        Handler pathHandler = null;
        Handler.DEBUG = true;
        try {
            FastSession ses = new FastSession();
            Connection con = ses.openConnection();
            pathHandler = new Handler();
            Example example = Example.EXECUTE_PROG;
            BoxWorker worker = con.getWorker();
            LocalContext konto = new LocalContext(pathHandler, worker, new VarTable());
            switch (example) {
                case SINGLE_QUERY: {
                    Collection singleResult = pathHandler.query(konto, "(1+2)");
                    System.out.println(singleResult);
                    break;
                }
                case EXECUTE_PROG: {
                    Collection<Collection> allresults = pathHandler.execute(konto, Debug.chr("qtie.ltt"));
                    boolean count = false;
                    int n = 0;
                    for (Collection col : allresults) {
                        System.out.print(progseq.get(n));
                        if (++n > progseq.size() - 35) {
                            // empty if block
                        }
                        if (col != null) {
                            System.out.print("  #" + n + " = ");
                            System.out.print('(');
                            int i = 0;
                            for (Object obj : col) {
                                if (i > 0) {
                                    System.out.print(", ");
                                }
                                ++i;
                                if (obj instanceof ObjectId) {
                                    BoxWorker w = con.getWorker();
                                    String nm = "";
                                    try {
                                        int id = ((ObjectId)obj).id();
                                        if (TempHelper.isTemporary(w, id)) {
                                            nm = "&";
                                        }
                                        nm = nm + "&";
                                        int ont = con.getWorker().ontology(id);
                                        String prefix = worker.name(ont);
                                        prefix = konto.getHandler().getPrefixByURI(prefix);
                                        if (prefix != null && !prefix.equals("")) {
                                            nm = nm + prefix + ":";
                                        }
                                        nm = nm + w.local(id);
                                    }
                                    catch (Exception e) {
                                        nm = "-------" + obj.toString();
                                    }
                                    System.out.print(nm);
                                    continue;
                                }
                                System.out.print(obj);
                            }
                            System.out.println(')');
                            continue;
                        }
                        System.out.println();
                    }
                    MVX.exportFile(new File("out.m2v1"), con.getWorker());
                    break;
                }
                case PATH_FIELDS: {
                    Collection singleResult = pathHandler.query(konto, "(1+2)^number/(^^number+1)");
                    System.out.println(singleResult);
                    Object firstValue = singleResult.iterator().next();
                    if (!(firstValue instanceof FieldContainer)) break;
                    FieldContainer fc = (FieldContainer)firstValue;
                    Collection<String> fields = fc.getFields();
                    for (String field : fields) {
                        System.out.println(field + " = " + fc.getValue(field));
                    }
                    break;
                }
                case QUERY_AND_QUESTIONS: {
                    pathHandler.load(konto, new FileReader("people.bxq"));
                    Collection tr = pathHandler.query(konto, "`*;");
                    LQuery q = pathHandler.createQuery(konto, "fn:get-all-classes();");
                    OntCollection co = q.execute(tr);
                    q = pathHandler.createQuery(konto, "tr*");
                    co = q.execute(co);
                    OntCollection oc = OntCC.newCol();
                    oc.addAllTyped("aabbcc");
                    oc.addAllTyped("ddaaee");
                    oc.addAllTyped("123");
                    OntCollection res = q.execute("hjkhaajlk");
                    OntObject john = con.getOntObjectByFullName("http://teacode.com/people#john");
                    OntObject paul = con.getOntObjectByFullName("http://teacode.com/people#tom");
                    res = q.execute(john);
                    System.out.println(res);
                    OntCollection two = OntCC.singleton(john);
                    two.addAllTyped(paul);
                    res = q.execute(two);
                    System.out.println(res);
                    break;
                }
                case SQL2PATH: {
                    StringReader rd = new StringReader(" CREATE TABLE `ZONE` (`ZONEID` INTEGER); INSERT INTO `ZONE` (ZONEID) VALUES (100);");
                    StringWriter w = new StringWriter();
                    Handler.sql2path(rd, w, "http://sql2path");
                    System.out.print(((Object)w).toString());
                    break;
                }
                case ONTOLOGY_MAPPING: {
                    try {
                        Ontology defaultontology = con.createOntology("http://default");
                        Ontology prefixedontology = con.createOntology("http://prefixed");
                        pathHandler.getMapping().put("", defaultontology.getURI());
                        pathHandler.getMapping().put("p", prefixedontology.getURI());
                        Collection singleResult = pathHandler.query(konto, "(if (*) then */count() else 0)");
                        System.out.println(singleResult);
                    }
                    catch (Exception e) {}
                    break;
                }
                case SQL2ONTOBOX: {
                    InputStreamReader rd = new InputStreamReader((InputStream)new FileInputStream("p1.txt"), "UTF-8");
                    StringWriter sw = new StringWriter();
                    String sqlontname = "http://sql";
                    pathHandler.sql2ontobox(con.getWorker(), rd, sqlontname);
                    pathHandler.getMapping().put("", "http://sql");
                    System.out.println("Stored!");
                    MVX.exportFile(new File("control.m2v1"), con.getWorker());
                    break;
                }
                case GETONTOBOX: {
                    FastSession ses1 = new FastSession(new File("fb2"));
                    Connection con1 = ses1.openConnection();
                    Collection<Collection> allresults = pathHandler.execute(new LocalContext(pathHandler, con1.getWorker()), Debug.chr("book.bxq"));
                    boolean count = false;
                    for (Collection col : allresults) {
                        System.out.println(col);
                    }
                    con1.close();
                    ses1.close();
                    break;
                }
                case BOX2LIBRETTO: {
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream("out.bxq"), "UTF-8");
                    MVX.importFile(new File("j.m2v1"), con.getWorker());
                    pathHandler.box2libretto(con.getWorker(), w);
                    ((Writer)w).close();
                    break;
                }
                case EXECUTE_MANY: {
                    ArrayList<Collection> manyresults = new ArrayList<Collection>();
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("p0.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pa.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pb.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pc.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pd.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pe.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pf.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pg.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("ph.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pi.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pj.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pk.txt")));
                    manyresults.addAll(pathHandler.execute(konto, Debug.chr("pl.txt")));
                    for (Collection col : manyresults) {
                        System.out.println(col);
                    }
                    MVX.exportFile(new File("manyout.m2v1"), con.getWorker());
                }
            }
            con.close();
            ses.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR!!!!!!!!! " + e.getMessage());
        }
    }

    static Reader chr(String filename) throws Exception {
        System.out.println(filename);
        char[] ca = new char[70000000];
        FileReader fr = new FileReader(filename);
        fr.read(ca);
        CharArrayReader car = new CharArrayReader(ca);
        return car;
    }

    static void showTokens(String file) {
        HashMap p2u = new HashMap();
        CharStream in = CharStream.createCharStream();
        in.rewindFile(file);
        Tokens tokens = new Tokens(null);
        tokens.display.tokenize();
    }
}

