/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import com.teacode.exception.ExUtil;
import com.teacode.file.FileUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.meta2project.exchange.OWLXImport;
import org.meta2project.model.Connection;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.box2model.BoxConnection;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.OntologyHelper;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.XMLHelper;
import org.ontobox.exchange.MVX;
import org.ontobox.libretto.ChoicePoint;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.IterContainer;
import org.ontobox.libretto.LabelException;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.M;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.FunctionId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.PropertyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.BuiltInFunction;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.function.XMLFuncs;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.helper.JsonHelper;
import org.ontobox.libretto.parser.Box2Libretto;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public class BaseFuncs {
    private static final Logger logger = Logger.getLogger(BaseFuncs.class.getName());
    private final Map<String, Map<Object, Set>> indexes = new HashMap<String, Map<Object, Set>>();
    private final Random rnd = new Random();
    public static String PLUS_FUN = "http://ontobox.org/#plus";
    public static String MINUS_FUN = "http://ontobox.org/#minus";
    public static String MULT_FUN = "http://ontobox.org/#mult";
    public static String DIV_FUN = "http://ontobox.org/#div";
    public static String MOD_FUN = "http://ontobox.org/#mod";

    public void init(FunctionTable funs) {
        funs.pushFunction(new FunIn1());
        funs.pushFunction(new FunIn2());
        funs.pushFunction(new FunLast0());
        funs.pushFunction(new FunHead0());
        funs.pushFunction(new FunTail0());
        funs.pushFunction(new FunPartition1());
        funs.pushFunction(new FunContains1());
        funs.pushFunction(new FunDistinct0());
        funs.pushFunction(new FunUnion1());
        funs.pushFunction(new FunIntersection1());
        funs.pushFunction(new FunSubtraction1());
        funs.pushFunction(new FunComplement1());
        funs.pushFunction(new FunDifference1());
        funs.pushFunction(new FunUnion2());
        funs.pushFunction(new FunIntersection2());
        funs.pushFunction(new FunSubtraction2());
        funs.pushFunction(new FunComplement2());
        funs.pushFunction(new FunDifference2());
        funs.pushFunction(new FunCount0());
        funs.pushFunction(new FunSize0());
        funs.pushFunction(new FunI1());
        funs.pushFunction(new FunCollect1());
        funs.pushFunction(new FunReverse0());
        funs.pushFunction(new FunNext1());
        funs.pushFunction(new FunIter1());
        funs.pushFunction(new FunSlice2());
        funs.pushFunction(new FunSplitSequence1());
        funs.pushFunction(new FunSplitSequence3());
        funs.pushFunction(new FunSplitSequence5());
        funs.pushFunction(new FunReduceLeft1());
        funs.pushFunction(new FunIndex1(this.indexes));
        funs.pushFunction(new FunIndex3(this.indexes));
        funs.pushFunction(new FunIndex4(this.indexes));
        funs.pushFunction(new FunIndexValues2(this.indexes));
        funs.pushFunction(new FunIndexKeys1(this.indexes));
        funs.pushFunction(new FunIndexDelete1(this.indexes));
        funs.pushFunction(new FunIndexRemoveKey1(this.indexes));
        funs.pushFunction(new FunSplitSequence2());
        funs.pushFunction(new FunTKeys0());
        funs.pushFunction(new FunOKeys0());
        funs.pushFunction(new FunGetKeyValue1());
        funs.pushFunction(new FunRead1());
        funs.pushFunction(new FunRead2());
        funs.pushFunction(new FunReadXML1());
        funs.pushFunction(new FunReadXML0());
        funs.pushFunction(new FunReadHTML2());
        funs.pushFunction(new FunReadHTML0());
        funs.pushFunction(new FunWrite2());
        funs.pushFunction(new FunWrite3());
        funs.pushFunction(new FunWriteXML2());
        funs.pushFunction(new FunPrint0());
        funs.pushFunction(new FunPrintln0());
        funs.pushFunction(new FunVoid1());
        funs.pushFunction(new FunExit1());
        funs.pushFunction(new FunEvall1());
        funs.pushFunction(new FunEval0());
        funs.pushFunction(new FunExecute0());
        funs.pushFunction(new FunLoad1());
        funs.pushFunction(new FunBoxToMvx1());
        funs.pushFunction(new FunMvxToBox1());
        funs.pushFunction(new FunOwlxToBox1());
        funs.pushFunction(new FunOwlxToBox2());
        funs.pushFunction(new FunBoxToLibretto0());
        funs.pushFunction(new FunTboxToLibretto0());
        funs.pushFunction(new FunBoxToRepo1());
        funs.pushFunction(new FunEnum2());
        funs.pushFunction(new FunEnum3());
        funs.pushFunction(new FunReadChars0());
        funs.pushFunction(new FunReadLines0());
        funs.pushFunction(new FunReadLines1());
        funs.pushFunction(new FunReadLines2());
        funs.pushFunction(new FunStop0());
        funs.pushFunction(new FunLabel3());
        funs.pushFunction(new FunRollback1());
        funs.pushFunction(new FunError1());
        funs.pushFunction(new FunSha1());
        funs.pushFunction(new FunPlus2());
        funs.pushFunction(new FunMinus2());
        funs.pushFunction(new FunMult2());
        funs.pushFunction(new FunDiv2());
        funs.pushFunction(new FunMod2());
        funs.pushFunction(new FunSleep1());
        funs.pushFunction(new Rnd());
        funs.pushFunction(new LogInfo());
        funs.addFuncs(new BuiltInFunction("toJson", 0, T.COLLECTION_WISE){

            @Override
            public Object call(LocalContext lc) {
                return JsonHelper.toJsonString(lc.getWorker(), this.contextCollection());
            }
        }, new BuiltInFunction("copyFile", 2, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                File from = new File(this.getStringM(1));
                File to = new File(this.getStringM(2));
                if (!from.exists()) {
                    throw new RuntimeException(from + " is not found");
                }
                if (!from.isFile()) {
                    throw new RuntimeException(from + " is not a file");
                }
                if (to.exists() && to.isDirectory()) {
                    throw new RuntimeException(to + " is a directory, add a file name to the path");
                }
                try {
                    FileUtil.copyFile((File)from, (File)to);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return to.getAbsolutePath();
            }
        });
    }

    static OntCollection splitCol(OntCollection col, Object chkpath, Object keypath, String typestr, Interp interp, String keyname, String valuename) {
        SPLITTER type;
        OntCollection result = OntCC.newCol(CollectionType.UNDEF_COL);
        LocalContext konto = interp.konto;
        if (typestr.equals("different")) {
            type = SPLITTER.DIFFERENT;
        } else if (typestr.equals("starts")) {
            type = SPLITTER.STARTS;
        } else if (typestr.equals("ends")) {
            type = SPLITTER.ENDS;
        } else if (typestr.equals("between")) {
            type = SPLITTER.BETWEEN;
        } else {
            throw new RuntimeException("Invalid type (" + typestr + ")");
        }
        OntCollection oc = OntCC.newCol(CollectionType.UNDEF_COL);
        Object key = "";
        int i = 0;
        Object previous = null;
        switch (type) {
            case DIFFERENT: {
                break;
            }
            case STARTS: {
                for (Object ooo : col) {
                    Object res = interp.eval(ooo = ObjectContainer.getObject(ooo), chkpath, i, previous);
                    if (Interp.isTrue(res)) {
                        if (!oc.isEmpty()) {
                            result.addAllTyped(konto.createKeyValueMap(key, oc, keyname, valuename));
                        }
                        oc.clear();
                        key = interp.eval(ooo, keypath, i, previous);
                    }
                    oc.addAllTyped(ooo);
                    previous = ooo;
                    ++i;
                }
                result.addAllTyped(konto.createKeyValueMap(key, oc, keyname, valuename));
                break;
            }
        }
        return result;
    }

    static OntCollection splitColRdd(OntCollection col, Object chkpath, String typestr, Interp interp, String keyname, Integer indx, Object previous) {
        SPLITTER type;
        if (Interp.isFalse(col)) {
            return null;
        }
        OntCollection result = OntCC.newCol(CollectionType.UNDEF_COL);
        LocalContext konto = interp.konto;
        if (typestr.equals("different")) {
            type = SPLITTER.DIFFERENT;
        } else if (typestr.equals("starts")) {
            type = SPLITTER.STARTS;
        } else if (typestr.equals("ends")) {
            type = SPLITTER.ENDS;
        } else {
            throw new RuntimeException("The invalid type (" + typestr + ") in the 3rd argument");
        }
        OntCollection oc = OntCC.newCol(CollectionType.UNDEF_COL);
        switch (type) {
            case DIFFERENT: {
                break;
            }
            case STARTS: {
                for (Object ooo : col) {
                    Object res = interp.eval(ooo = ObjectContainer.getObject(ooo), chkpath, indx, previous);
                    if (Interp.isTrue(res)) {
                        if (!oc.isEmpty()) {
                            result.addAllTyped(konto.createKeyMap(oc, keyname));
                        }
                        oc.clear();
                    }
                    oc.addAllTyped(ooo);
                }
                result.addAllTyped(konto.createKeyMap(oc, keyname));
                break;
            }
        }
        return result;
    }

    static OntCollection conduct(LocalContext lc, OntCollection input, IterProg prog) {
        Interp interp = lc.getInterp();
        Map<String, List<Instruction>> program = prog.code;
        Integer collectvarnum = prog.collectvarnum;
        Object initval = prog.initval;
        lc.getVars().putVarValue(collectvarnum, interp.eval(null, initval, null, null));
        Boolean previous = Boolean.FALSE;
        Integer indx = -1;
        String curstate = "start";
        OntCollection result = OntCC.newCol();
        boolean thesame = false;
        HashSet<Instruction> sameset = new HashSet<Instruction>();
        Iterator elit = input.iterator();
        Object ooo = null;
        if (elit.hasNext()) {
            ooo = elit.next();
        }
        block5: while (ooo != null) {
            Integer n = indx;
            Integer n2 = indx = Integer.valueOf(indx + 1);
            List<Instruction> curinstr = program.get(curstate);
            boolean success = false;
            block6: for (Instruction instr : curinstr) {
                if (!Interp.isTrue(interp.eval(ooo, instr.condition, indx, previous))) continue;
                success = true;
                thesame = instr.thesame;
                Object newval = Helper.getNormalized(interp.eval(ooo, instr.newvalue, indx, previous));
                if (instr.step == Transitions.ERROR) {
                    throw new RuntimeException("Composer reports error at value " + Helper.shortenString(ooo) + ": " + newval);
                }
                if (thesame) {
                    if (sameset.contains(instr)) {
                        throw new RuntimeException("Loop for value " + Helper.shortenString(ooo) + " in state " + curstate + " (through continue-s/break-s instructions)");
                    }
                    sameset.add(instr);
                }
                switch (instr.step) {
                    case BREAK: {
                        if (!thesame) {
                            sameset.clear();
                        }
                        result.addAllTyped(newval);
                        Object init = Helper.getNormalized(interp.eval(ooo, instr.init, indx, previous));
                        lc.getVars().putVarValue(collectvarnum, init);
                        curstate = instr.newstate;
                        break block6;
                    }
                    case CONTINUE: {
                        if (!thesame) {
                            sameset.clear();
                        }
                        lc.getVars().putVarValue(collectvarnum, newval);
                        curstate = instr.newstate;
                        break block6;
                    }
                    case STOP: {
                        result.addAllTyped(newval);
                        break block5;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            if (!success) {
                throw new RuntimeException("Failed to handle value " + Helper.shortenString(ooo) + " at state " + curstate);
            }
            if (thesame) continue;
            previous = ooo;
            if (!elit.hasNext()) break;
            ooo = elit.next();
        }
        result.addAllTyped(lc.getVars().getVarValue(collectvarnum));
        return result;
    }

    class LogInfo
    extends BuiltInFunction {
        LogInfo() {
            super("logInfo", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object oo = this.context();
            logger.info(String.valueOf(oo));
            return oo;
        }
    }

    class Rnd
    extends BuiltInFunction {
        Rnd() {
            super("rnd", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            return BaseFuncs.this.rnd.nextInt(this.getIntegerM(1));
        }
    }

    static class FunSleep1
    extends BuiltInFunction {
        FunSleep1() {
            super("sleep", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            try {
                Thread.sleep(this.getLongM(1));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this.getCurrentValue();
        }
    }

    static class FunMod2
    extends BuiltInFunction {
        FunMod2() {
            super("mod", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            return this.getIntegerM(1) % this.getIntegerM(2);
        }
    }

    static class FunDiv2
    extends BuiltInFunction {
        FunDiv2() {
            super("div", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object arg1 = this.getSingleArg(1);
            Object arg2 = this.getSingleArg(2);
            if (arg1 instanceof Integer) {
                if (arg2 instanceof Integer) {
                    return (Integer)arg1 / (Integer)arg2;
                }
                if (arg2 instanceof Double) {
                    return (double)((Integer)arg1).intValue() / (Double)arg2;
                }
                throw new RuntimeException("Invalid 2nd argument of minus/2");
            }
            if (arg1 instanceof Double) {
                if (arg2 instanceof Integer) {
                    return (Double)arg1 / (double)((Integer)arg2).intValue();
                }
                if (arg2 instanceof Double) {
                    return (Double)arg1 / (Double)arg2;
                }
                throw new RuntimeException("Invalid 2nd argument of minus/2");
            }
            throw new RuntimeException("Invalid 1st argument of minus/2");
        }
    }

    static class FunMult2
    extends BuiltInFunction {
        FunMult2() {
            super("mult", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object arg1 = this.getSingleArg(1);
            Object arg2 = this.getSingleArg(2);
            if (arg1 instanceof Integer) {
                if (arg2 instanceof Integer) {
                    return (Integer)arg1 * (Integer)arg2;
                }
                if (arg2 instanceof Double) {
                    return (double)((Integer)arg1).intValue() * (Double)arg2;
                }
                throw new RuntimeException("Invalid 2nd argument of minus/2");
            }
            if (arg1 instanceof Double) {
                if (arg2 instanceof Integer) {
                    return (Double)arg1 * (double)((Integer)arg2).intValue();
                }
                if (arg2 instanceof Double) {
                    return (Double)arg1 * (Double)arg2;
                }
                throw new RuntimeException("Invalid 2nd argument of minus/2");
            }
            throw new RuntimeException("Invalid 1st argument of minus/2");
        }
    }

    static class FunMinus2
    extends BuiltInFunction {
        FunMinus2() {
            super("minus", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object arg1 = this.getSingleArg(1);
            Object arg2 = this.getSingleArg(2);
            if (arg1 instanceof Integer) {
                if (arg2 instanceof Integer) {
                    return (Integer)arg1 - (Integer)arg2;
                }
                if (arg2 instanceof Double) {
                    return (double)((Integer)arg1).intValue() - (Double)arg2;
                }
                throw new RuntimeException("Invalid 2nd argument of minus/2");
            }
            if (arg1 instanceof Double) {
                if (arg2 instanceof Integer) {
                    return (Double)arg1 - (double)((Integer)arg2).intValue();
                }
                if (arg2 instanceof Double) {
                    return (Double)arg1 - (Double)arg2;
                }
                throw new RuntimeException("Invalid 2nd argument of minus/2");
            }
            throw new RuntimeException("Invalid 1st argument of minus/2");
        }
    }

    static class FunPlus2
    extends BuiltInFunction {
        FunPlus2() {
            super("plus", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object arg1 = this.getSingleArg(1);
            Object arg2 = this.getSingleArg(2);
            if (arg1 instanceof Integer) {
                if (arg2 instanceof Integer) {
                    return (Integer)arg1 + (Integer)arg2;
                }
                if (arg2 instanceof Double) {
                    return (double)((Integer)arg1).intValue() + (Double)arg2;
                }
                if (arg2 instanceof String) {
                    return arg1.toString() + arg2.toString();
                }
                throw new RuntimeException("Invalid 2nd argument of plus/2");
            }
            if (arg1 instanceof Double) {
                if (arg2 instanceof Integer) {
                    return (Double)arg1 + (double)((Integer)arg2).intValue();
                }
                if (arg2 instanceof Double) {
                    return (Double)arg1 + (Double)arg2;
                }
                if (arg2 instanceof String) {
                    return arg1.toString() + arg2.toString();
                }
                throw new RuntimeException("Invalid 2nd argument of plus/2");
            }
            if (arg1 instanceof String) {
                if (arg2 instanceof Integer) {
                    return arg1.toString() + arg2.toString();
                }
                if (arg2 instanceof Double) {
                    return arg1.toString() + arg2.toString();
                }
                if (arg2 instanceof String) {
                    return arg1.toString() + arg2.toString();
                }
                throw new RuntimeException("Invalid 2nd argument of plus/2");
            }
            throw new RuntimeException("Invalid 1st argument of plus/2");
        }
    }

    static class FunSha1
    extends BuiltInFunction {
        FunSha1() {
            super("sha", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String ss = this.getStringArg(1);
            if (ss == null) {
                throw new RuntimeException("The argument of sha/1 must be a string");
            }
            return Helper.sha(ss);
        }
    }

    static class FunStop0
    extends BuiltInFunction {
        FunStop0() {
            super("stop", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            konto.stop();
            return Boolean.TRUE;
        }
    }

    private static class ReadChar
    implements ChoicePoint {
        String string;
        Character current;
        Character next;
        int counter;
        int pointer;

        ReadChar(String str) {
            this.string = str;
            this.counter = 0;
            this.next = this.string.length() == 0 ? null : Character.valueOf(this.string.charAt(this.counter));
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Object next() {
            this.current = this.next;
            ++this.counter;
            this.next = this.counter == this.string.length() ? null : Character.valueOf(this.string.charAt(this.counter));
            return (int)this.current.charValue();
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public int getPointer() {
            return this.pointer;
        }

        @Override
        public Object getCurrent() {
            return (int)this.current.charValue();
        }

        @Override
        public void setPointer(int pt) {
            this.pointer = pt;
        }

        @Override
        public OntCollection getCollection() {
            return null;
        }
    }

    static class FunReadChars0
    extends BuiltInFunction {
        FunReadChars0() {
            super("readChars", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String string = this.getCurrentString();
            ReadChar cp = new ReadChar(string);
            return cp;
        }
    }

    private static class ReadLine
    implements ChoicePoint {
        BufferedReader rd;
        String current;
        String next;
        int counter;
        int pointer;

        ReadLine(BufferedReader r) {
            this.rd = r;
            this.counter = -1;
            try {
                this.next = this.rd.readLine();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Object next() {
            try {
                this.current = this.next;
                this.next = this.rd.readLine();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            ++this.counter;
            return this.current;
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public int getPointer() {
            return this.pointer;
        }

        @Override
        public Object getCurrent() {
            return this.current;
        }

        @Override
        public void setPointer(int pt) {
            this.pointer = pt;
        }

        @Override
        public OntCollection getCollection() {
            return null;
        }
    }

    static class FunReadLines2
    extends BuiltInFunction {
        FunReadLines2() {
            super("readLines", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            BufferedReader rd;
            String filename = this.getStringArg(1);
            String enc = this.getStringArg(2);
            try {
                InputStream is = Helper.getProtocolStream(filename);
                rd = new BufferedReader(new InputStreamReader(is, enc));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            ReadLine cp = new ReadLine(rd);
            return cp;
        }
    }

    static class FunReadLines1
    extends BuiltInFunction {
        FunReadLines1() {
            super("readLines", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            BufferedReader rd;
            String filename = this.getStringArg(1);
            try {
                InputStream is = Helper.getProtocolStream(filename);
                rd = new BufferedReader(new InputStreamReader(is, "utf-8"));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            ReadLine cp = new ReadLine(rd);
            return cp;
        }
    }

    static class FunReadLines0
    extends BuiltInFunction {
        FunReadLines0() {
            super("readLines", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            BufferedReader rd;
            String string = this.getCurrentString();
            try {
                rd = new BufferedReader(new StringReader(string));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            ReadLine cp = new ReadLine(rd);
            return cp;
        }
    }

    private static class SimpleRange
    implements ChoicePoint {
        final int start;
        final int end;
        final int step;
        int current;
        int pointer;
        boolean up;
        int counter;
        OntCollection collection = null;

        SimpleRange(int s, int e, int st) {
            this.start = s;
            this.end = e;
            this.counter = 0;
            if (s < e) {
                this.step = Math.abs(st);
                this.up = true;
            } else {
                this.step = -Math.abs(st);
                this.up = false;
            }
            this.current = this.start;
        }

        @Override
        public boolean hasNext() {
            return this.up && this.current <= this.end || !this.up && this.current >= this.end;
        }

        @Override
        public Object next() {
            int cur = this.current;
            this.current += this.step;
            ++this.counter;
            return cur;
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public int getPointer() {
            return this.pointer;
        }

        @Override
        public Object getCurrent() {
            return this.current - this.step;
        }

        @Override
        public void setPointer(int pt) {
            this.pointer = pt;
        }

        @Override
        public OntCollection getCollection() {
            if (this.collection == null) {
                this.collection = OntCC.newCol();
                for (int crnt = this.start; this.up && crnt <= this.end || !this.up && crnt >= this.end; crnt += this.step) {
                    this.collection.addAllTyped(crnt);
                }
            }
            return this.collection;
        }
    }

    static class FunEnum3
    extends BuiltInFunction {
        FunEnum3() {
            super("enum", 3, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            int start = this.getIntegerArg(1);
            int end = this.getIntegerArg(2);
            int step = this.getIntegerArg(3);
            SimpleRange cp = new SimpleRange(start, end, step);
            return cp;
        }
    }

    static class FunEnum2
    extends BuiltInFunction {
        FunEnum2() {
            super("enum", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            int start = this.getIntegerArg(1);
            int end = this.getIntegerArg(2);
            SimpleRange cp = new SimpleRange(start, end, 1);
            return cp;
        }
    }

    static class FunError1
    extends BuiltInFunction {
        FunError1() {
            super("error", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String key = this.getStringArg(1);
            throw new RuntimeException(key);
        }
    }

    static class FunRollback1
    extends BuiltInFunction {
        FunRollback1() {
            super("rollback", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String key = this.getStringArg(1);
            throw new LabelException(key);
        }
    }

    static class FunLabel3
    extends BuiltInFunction {
        FunLabel3() {
            super("label", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object result;
            String key = this.getStringArg(1);
            Object tryexp = this.getSingleArg(2);
            if (!(tryexp instanceof Token)) {
                throw new RuntimeException("The second argument must be an anonymous function or quoted expression in label/3");
            }
            Object catchexp = this.getSingleArg(3);
            try {
                result = lc.getInterp().eval(this.getCurrentValue(), tryexp, this.getIndex(), this.getPrevious());
            }
            catch (LabelException e) {
                if (e.getKey().equals(key)) {
                    result = lc.getInterp().eval(this.getCurrentValue(), catchexp, this.getIndex(), this.getPrevious());
                }
                throw new LabelException(e.getKey());
            }
            return result;
        }
    }

    static class FunBoxToRepo1
    extends BuiltInFunction {
        FunBoxToRepo1() {
            super("box2repo", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String oname;
            Integer oid;
            BoxWorker worker = lc.getWorker();
            Object onto = this.getSingleArg(1);
            if (onto instanceof OntologyId) {
                oid = ((OntologyId)onto).id();
                oname = worker.name(oid);
            } else if (onto instanceof String) {
                oname = (String)onto;
                oid = worker.id(oname);
                if (oid == null) {
                    oname = lc.getHandler().getMapping().get(oname);
                }
                if ((oid = worker.id(oname)) == null) {
                    throw new RuntimeException("Ontology not found ");
                }
            } else {
                throw new RuntimeException("Argument of box2repo/1 must be an ontology entity or a string");
            }
            MVX.exportOntology(worker, new File(OntologyHelper.sha(oname) + ".mvx"), oid, true);
            return OntologyId.newId(oid);
        }
    }

    static class FunTboxToLibretto0
    extends BuiltInFunction {
        FunTboxToLibretto0() {
            super("tbox2libretto", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            StringWriter w;
            try {
                w = new StringWriter();
                new Box2Libretto(lc.getWorker()).generate(w, true);
                ((Writer)w).close();
            }
            catch (Exception e) {
                throw new RuntimeException("Function tbox2libretto: " + e.getMessage());
            }
            return ((Object)w).toString();
        }
    }

    static class FunBoxToLibretto0
    extends BuiltInFunction {
        FunBoxToLibretto0() {
            super("box2libretto", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            StringWriter w;
            try {
                w = new StringWriter();
                new Box2Libretto(lc.getWorker()).generate(w, false);
                ((Writer)w).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return ((Object)w).toString();
        }
    }

    static class FunOwlxToBox2
    extends BuiltInFunction {
        FunOwlxToBox2() {
            super("owlx2box", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            File file = new File(this.stringM(1));
            String ont = this.stringM(2);
            try {
                BoxWorker worker = lc.getInterp().konto.getWorker();
                new OWLXImport().load((Connection)new BoxConnection(worker), file, ont);
            }
            catch (Exception e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage() + " (" + file + ")"), (Throwable)e);
            }
            return Boolean.TRUE;
        }
    }

    static class FunOwlxToBox1
    extends BuiltInFunction {
        FunOwlxToBox1() {
            super("owlx2box", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            File file = new File(this.stringM(1));
            try {
                BoxWorker worker = lc.getInterp().konto.getWorker();
                new OWLXImport().load((Connection)new BoxConnection(worker), file);
            }
            catch (Exception e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage() + " (" + file + ")"), (Throwable)e);
            }
            return Boolean.TRUE;
        }
    }

    static class FunMvxToBox1
    extends BuiltInFunction {
        FunMvxToBox1() {
            super("mvx2box", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String filename = this.getStringArg(1);
            try {
                File file = new File(filename);
                BoxWorker worker = lc.getInterp().konto.getWorker();
                MVX.importFile(file, worker);
            }
            catch (Exception e) {
                throw new RuntimeException("MVX reports: " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunBoxToMvx1
    extends BuiltInFunction {
        FunBoxToMvx1() {
            super("box2mvx", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String filename = this.getStringArg(1);
            MVX.exportFile(new File(filename), lc.getInterp().konto.getWorker());
            return Boolean.TRUE;
        }
    }

    static class FunLoad1
    extends BuiltInFunction {
        FunLoad1() {
            super("load", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Iterator<Collection> chain;
            boolean setwasempty;
            if (lc.getParser().loadnameset == null) {
                lc.getParser().loadnameset = new HashSet<String>();
                setwasempty = true;
            } else {
                setwasempty = false;
            }
            String progname = this.getStringArg(1);
            if (lc.getParser().loadnameset.contains(progname)) {
                throw new RuntimeException("load/1 reports: loop in loading " + progname);
            }
            lc.getParser().loadnameset.add(progname);
            Token prog = new Token(TokenType.PROGRAM, 0, null);
            CharStream in = CharStream.createCharStream();
            lc.pushIn1(in);
            try {
                InputStream is = Helper.getProtocolStream(progname);
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "utf-8"));
                in.rewindCharStream(rd);
            }
            catch (Exception e) {
                throw new RuntimeException("load/1(" + progname + ") reports:" + e.getMessage());
            }
            try {
                chain = lc.getHandler().execute(prog, lc, in).iterator();
            }
            catch (Exception e) {
                in.close();
                lc.popIn1();
                throw new RuntimeException("load/1(" + progname + ") reports: " + e.getMessage());
            }
            lc.getParser().loadnameset.remove(progname);
            Iterator<Token> seq = prog.getSeq().iterator();
            OntCollection result = OntCC.newCol();
            int i = 0;
            while (chain.hasNext()) {
                ObjectId obj;
                if (++i == 69) {
                    // empty if block
                }
                Object res = chain.next();
                Token curtok = seq.next().quote();
                if (Interp.isFalse(res)) {
                    res = "";
                }
                try {
                    obj = lc.createKeyValueMap(curtok, res, "query", "answer");
                }
                catch (Exception e) {
                    obj = lc.createKeyValueMap(curtok, "", "query", "answer");
                }
                result.addAllTyped(obj);
            }
            lc.popIn1();
            if (setwasempty) {
                lc.getParser().loadnameset = null;
            }
            return result;
        }
    }

    static class FunExecute0
    extends BuiltInFunction {
        FunExecute0() {
            super("execute", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Iterator<Collection> chain;
            String program = this.getCurrentString();
            Token prog = new Token(TokenType.PROGRAM, 0, null);
            CharStream in = CharStream.createCharStream();
            lc.pushIn1(in);
            in.rewindCharStream(new StringReader(program));
            try {
                chain = lc.getHandler().execute(prog, lc, in).iterator();
            }
            catch (RuntimeException e) {
                in.close();
                lc.popIn1();
                throw new RuntimeException("execute/0 reports: " + e.getMessage());
            }
            Iterator<Token> seq = prog.getSeq().iterator();
            OntCollection result = OntCC.newCol();
            int i = 0;
            while (chain.hasNext()) {
                ObjectId obj;
                if (++i == 69) {
                    // empty if block
                }
                Object res = chain.next();
                Token curtok = seq.next().quote();
                if (Interp.isFalse(res)) {
                    res = "";
                }
                try {
                    obj = lc.createKeyValueMap(curtok, res, "query", "answer");
                }
                catch (Exception e) {
                    obj = lc.createKeyValueMap(curtok, "", "query", "answer");
                }
                result.addAllTyped(obj);
            }
            lc.popIn1();
            return result;
        }
    }

    static class FunEval0
    extends BuiltInFunction {
        FunEval0() {
            super("eval", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object quoted = this.getCurrentValue();
            if (quoted instanceof String) {
                CharStream in = CharStream.createCharStream();
                lc.pushIn1(in);
                quoted = lc.getHandler().createQuery(lc, (String)quoted).getQuery();
                lc.popIn1();
            }
            return lc.getInterp().eval(null, quoted, this.getIndex(), this.getPrevious());
        }
    }

    static class FunEvall1
    extends BuiltInFunction {
        FunEvall1() {
            super("evall", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object quoted = this.getSingleArg(1);
            if (quoted instanceof String) {
                CharStream in = CharStream.createCharStream();
                lc.pushIn1(in);
                quoted = lc.getHandler().createQuery(lc, (String)quoted).getQuery();
                lc.popIn1();
            }
            return lc.getInterp().eval(this.getCurrentValue(), quoted, this.getIndex(), this.getPrevious());
        }
    }

    static class FunExit1
    extends BuiltInFunction {
        FunExit1() {
            super("exit", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            int n = this.getIntegerArg(1);
            System.exit(n);
            return null;
        }
    }

    static class FunVoid1
    extends BuiltInFunction {
        FunVoid1() {
            super("void", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            return this.getSingleArg(1);
        }
    }

    static class FunPrintln0
    extends BuiltInFunction {
        FunPrintln0() {
            super("println", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            PrintWriter pw = lc.getHandler().getPrintWriter();
            pw.println(oo);
            result.addAllTyped(oo);
            return oo;
        }
    }

    static class FunPrint0
    extends BuiltInFunction {
        FunPrint0() {
            super("print", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object oo = this.getCurrentValue();
            PrintWriter pw = lc.getHandler().getPrintWriter();
            pw.print(oo);
            result.addAllTyped(oo);
            return oo;
        }
    }

    static class FunWriteXML2
    extends LibrettoFunction {
        FunWriteXML2() {
            super("writeXML", 2, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String name = this.getStringArg(1);
            Object root = this.getSingleArg(2);
            if (!(root instanceof ObjectId)) {
                throw new RuntimeException("The 2nd argument must be an XML object");
            }
            int xid = ((ObjectId)root).id();
            Integer did = null;
            BoxWorker w = lc.getWorker();
            if (RHelper.isInstanceOf(w, xid, lc.getXmlEl())) {
                int onto = w.ontology(xid);
                did = XMLFuncs.newDoc(lc, xid, onto);
                xid = did;
            }
            try {
                File xml = new File(name);
                XMLHelper.exportXML(lc.getWorker(), xml, xid);
                if (did != null) {
                    w.write().delete(did);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in writing to XML file (" + name + "): " + e.getMessage(), e);
            }
            return Boolean.TRUE;
        }
    }

    static class FunWrite3
    extends BuiltInFunction {
        FunWrite3() {
            super("write", 3, T.STATIC);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call(LocalContext lc) {
            OntCollection oc;
            String name = this.getStringArg(1);
            Object contents = this.getArg(2);
            String enc = this.getStringArg(3);
            if (contents instanceof OntCollection && (oc = (OntCollection)contents).size() == 1) {
                contents = oc.get(0);
            }
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(name), enc);
                try {
                    ((Writer)writer).append(contents.toString());
                    ((Writer)writer).flush();
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in writing to file (" + name + "): " + e.getMessage(), e);
            }
            return Boolean.TRUE;
        }
    }

    static class FunWrite2
    extends BuiltInFunction {
        FunWrite2() {
            super("write", 2, T.STATIC);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call(LocalContext lc) {
            OntCollection oc;
            String name = this.getStringArg(1);
            Object contents = this.getArg(2);
            if (contents instanceof OntCollection && (oc = (OntCollection)contents).size() == 1) {
                contents = oc.get(0);
            }
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(name), "utf-8");
                try {
                    ((Writer)writer).append(contents.toString());
                    ((Writer)writer).flush();
                }
                finally {
                    ((Writer)writer).close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error in writing to file (" + name + "): " + e.getMessage(), e);
            }
            return Boolean.TRUE;
        }
    }

    static class FunReadHTML2
    extends LibrettoFunction {
        FunReadHTML2() {
            super("readHTML", 2, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int xmlid;
            String filename = this.getStringArg(1);
            String encoding = this.getStringArg(2);
            BoxWorker worker = lc.getWorker();
            int ontid = lc.getLE().getXMLHeap(lc);
            InputStream is = null;
            try {
                is = Helper.getProtocolStream(filename);
                xmlid = XMLHelper.importHTML(lc.getWorker(), ontid, is, encoding);
            }
            catch (Exception e) {
                throw new RuntimeException("HTML file " + filename + " read error: " + e.getMessage(), e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
            return ObjectId.newId(worker, xmlid);
        }
    }

    static class FunReadHTML0
    extends LibrettoFunction {
        FunReadHTML0() {
            super("readHTML", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int xmlid;
            String html = this.stringM();
            int ontid = lc.getLE().getXMLHeap(lc);
            BoxWorker worker = lc.getWorker();
            try {
                xmlid = XMLHelper.importHTML(worker, ontid, new ByteArrayInputStream(html.getBytes("UTF-8")), "UTF-8");
            }
            catch (Exception e) {
                throw new RuntimeException("HTML string read error: " + e.getMessage(), e);
            }
            return ObjectId.newId(worker, xmlid);
        }
    }

    static class FunReadXML1
    extends LibrettoFunction {
        FunReadXML1() {
            super("readXML", 1, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int xmlid;
            String filename = this.getStringArg(1);
            BoxWorker worker = lc.getWorker();
            int ontid = lc.getLE().getXMLHeap(lc);
            InputStream is = null;
            try {
                is = Helper.getProtocolStream(filename);
                xmlid = XMLHelper.importXML(lc.getWorker(), ontid, is);
            }
            catch (Exception e) {
                throw new RuntimeException("XML file read error: " + e.getMessage(), e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
            }
            return ObjectId.newId(worker, xmlid);
        }
    }

    static class FunReadXML0
    extends LibrettoFunction {
        FunReadXML0() {
            super("readXML", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int xmlid;
            String xml = this.getCurrentString();
            BoxWorker worker = lc.getWorker();
            int ontid = lc.getLE().getXMLHeap(lc);
            try {
                xmlid = XMLHelper.importXML(worker, ontid, new ByteArrayInputStream(xml.getBytes("UTF-8")));
            }
            catch (Exception e) {
                throw new RuntimeException("XML string read error: " + e.getMessage(), e);
            }
            return ObjectId.newId(worker, xmlid);
        }
    }

    static class FunRead2
    extends BuiltInFunction {
        FunRead2() {
            super("read", 2, T.STATIC);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String name = this.getStringArg(1);
            String enc = this.getStringArg(2);
            try {
                InputStream is = Helper.getProtocolStream(name);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, enc));
                try {
                    int i;
                    char[] buf = new char[1000];
                    StringBuilder sb = new StringBuilder();
                    while ((i = reader.read(buf)) != -1) {
                        sb.append(buf, 0, i);
                    }
                    result.addAllTyped(sb.toString());
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("File read error (" + name + "): " + e.getMessage(), e);
            }
            return result;
        }
    }

    static class FunRead1
    extends BuiltInFunction {
        FunRead1() {
            super("read", 1, T.STATIC, "0-1s");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String name = this.getStringArg(1);
            try {
                InputStream is = Helper.getProtocolStream(name);
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                try {
                    int i;
                    char[] buf = new char[1000];
                    StringBuilder sb = new StringBuilder();
                    while ((i = reader.read(buf)) != -1) {
                        sb.append(buf, 0, i);
                    }
                    result.addAllTyped(sb.toString());
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("File read error (" + name + "): " + e.getMessage(), e);
            }
            return result;
        }
    }

    static class FunGetKeyValue1
    extends BuiltInFunction {
        FunGetKeyValue1() {
            super("getKeyValue", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol();
            String key = this.getStringArg(1);
            Object oo = this.getCurrentValue();
            if ((oo = ObjectContainer.getObject(oo)) instanceof ObjectId && lc.isMap(oo)) {
                ObjectId map = (ObjectId)oo;
                Object[] res = null;
                PropertyId prop = lc.getMapKey(map, key);
                if (prop instanceof TPropertyId) {
                    TPropertyId tprop = (TPropertyId)prop;
                    res = lc.getWorker().strings(map.id(), tprop.id());
                } else if (prop instanceof OPropertyId) {
                    OPropertyId oprop = (OPropertyId)prop;
                    res = lc.getWorker().objects(map.id(), oprop.id());
                }
                if (res != null) {
                    result.addAllTyped(res);
                }
            }
            return result;
        }
    }

    static class FunOKeys0
    extends BuiltInFunction {
        FunOKeys0() {
            super("okeys", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if ((oo = ObjectContainer.getObject(oo)) instanceof ObjectId && lc.isMap(oo)) {
                result.addAllTyped(MapHelper.getOKeys(lc.getWorker(), ((ObjectId)oo).id()));
            }
            return result;
        }
    }

    static class FunTKeys0
    extends BuiltInFunction {
        FunTKeys0() {
            super("tkeys", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol();
            Object oo = ObjectContainer.getObject(this.getCurrentValue());
            if (oo instanceof ObjectId && lc.isMap(oo)) {
                result.addAllTyped(MapHelper.getTKeys(lc.getWorker(), ((ObjectId)oo).id()));
            }
            return result;
        }
    }

    static class FunContains1
    extends BuiltInFunction {
        FunContains1() {
            super("contains", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            int idx;
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object oo = this.getSingleArg(1);
            if ((oo = ObjectContainer.getObject(oo)) instanceof OntCollection) {
                oo = ((OntCollection)oo).get(0);
            }
            if (!(oo instanceof String)) {
                return null;
            }
            String s = (String)oo;
            Object str = this.getCurrentValue();
            str = ObjectContainer.getObject(str);
            if (str instanceof String && (idx = ((String)str).indexOf(s)) >= 0) {
                result.add(str);
            }
            return result;
        }
    }

    static class FunIndex1
    extends BuiltInFunction {
        final Map<String, Map<Object, Set>> indexes;

        FunIndex1(Map<String, Map<Object, Set>> ixs) {
            super("index", 1, T.STATIC);
            this.indexes = ixs;
        }

        @Override
        public Object call(LocalContext lc) {
            String indexname = this.getStringArg(1);
            if (indexname == null) {
                throw new RuntimeException("The 1st argument (index name) must be a string");
            }
            Map<Object, Set> index = this.indexes.get(indexname);
            if (index == null) {
                index = new HashMap<Object, Set>();
            }
            this.indexes.put(indexname, index);
            return Boolean.TRUE;
        }
    }

    static class FunIndex3
    extends BuiltInFunction {
        final Map<String, Map<Object, Set>> indexes;

        FunIndex3(Map<String, Map<Object, Set>> ixs) {
            super("index", 3, T.STATIC);
            this.indexes = ixs;
        }

        @Override
        public Object call(LocalContext lc) {
            String indexname = this.getStringArg(1);
            Object key = this.getArg(2);
            Object value = this.getArg(3);
            if (indexname == null) {
                throw new RuntimeException("The 1st argument (index name) must be a string in index/3");
            }
            if (Interp.isFalse(key)) {
                throw new RuntimeException("The key in 2nd argument is empty in index/3");
            }
            if (Interp.isFalse(value)) {
                throw new RuntimeException("The value in 3rd argument is empty in index/3");
            }
            Map<Object, Set> index = this.indexes.get(indexname);
            if (index == null) {
                index = new HashMap<Object, Set>();
            }
            Interp interp = lc.getInterp();
            OntCollection oc = key instanceof OntCollection ? (OntCollection)key : OntCC.singleton(key);
            OntCollection ioc = value instanceof OntCollection ? (OntCollection)value : OntCC.singleton(value);
            for (Object val : oc) {
                Set s;
                if (index.containsKey(val)) {
                    s = index.get(val);
                } else {
                    s = new HashSet();
                    index.put(val, s);
                }
                for (Object el : ioc) {
                    s.add(el);
                }
            }
            this.indexes.put(indexname, index);
            return Boolean.TRUE;
        }
    }

    static class FunIndex4
    extends BuiltInFunction {
        final Map<String, Map<Object, Set>> indexes;

        FunIndex4(Map<String, Map<Object, Set>> ixs) {
            super("index", 4, T.STATIC);
            this.indexes = ixs;
        }

        @Override
        public Object call(LocalContext lc) {
            String indexname = this.getStringArg(1);
            Object domobj = this.getArg(2);
            Token key = this.getQuotedArg(3);
            Token indexed = this.getQuotedArg(4);
            if (indexname == null) {
                throw new RuntimeException("The 1st argument (index name) must be a string");
            }
            if (indexed == null) {
                throw new RuntimeException("The 3rd argument (key) must be a quoted expression");
            }
            if (key == null) {
                throw new RuntimeException("The 4the argument (value) must be a quoted expression");
            }
            Map<Object, Set> index = this.indexes.get(indexname);
            if (index == null) {
                index = new HashMap<Object, Set>();
            }
            Interp interp = lc.getInterp();
            if (!(domobj instanceof OntCollection)) {
                throw new RuntimeException("The domain of index must be a collection");
            }
            int indx = 0;
            for (Object oo : (OntCollection)domobj) {
                Object indexingVal = interp.eval(oo, key, indx, null);
                OntCollection oc = Helper.wrapInCol(indexingVal);
                Object indexedElem = interp.eval(oo, indexed, indx, null);
                OntCollection ioc = Helper.wrapInCol(indexedElem);
                ++indx;
                for (Object val : oc) {
                    Set s;
                    if (index.containsKey(val)) {
                        s = index.get(val);
                    } else {
                        s = new HashSet();
                        index.put(val, s);
                    }
                    for (Object el : ioc) {
                        s.add(el);
                    }
                }
            }
            this.indexes.put(indexname, index);
            return Boolean.TRUE;
        }
    }

    static class FunIndexRemoveKey1
    extends BuiltInFunction {
        final Map<String, Map<Object, Set>> indexes;

        FunIndexRemoveKey1(Map<String, Map<Object, Set>> ixs) {
            super("indexRemoveKey", 1, T.ELEMENT_WISE);
            this.indexes = ixs;
        }

        @Override
        public Object call(LocalContext lc) {
            String indexname = this.getStringArg(1);
            Object key = this.getCurrentValue();
            Map<Object, Set> index = this.indexes.get(indexname);
            if (index == null) {
                throw new RuntimeException("Index with name \"" + indexname + "\" not found");
            }
            if (key instanceof String && index.containsKey(key)) {
                index.remove(key);
                return true;
            }
            return false;
        }
    }

    static class FunIndexDelete1
    extends BuiltInFunction {
        final Map<String, Map<Object, Set>> indexes;

        FunIndexDelete1(Map<String, Map<Object, Set>> ixs) {
            super("indexDelete", 1, T.STATIC);
            this.indexes = ixs;
        }

        @Override
        public Object call(LocalContext lc) {
            String indexname = this.getStringArg(1);
            Map<Object, Set> index = this.indexes.get(indexname);
            if (index == null) {
                throw new RuntimeException("Index with name \"" + indexname + "\" not found");
            }
            this.indexes.remove(indexname);
            return true;
        }
    }

    static class FunIndexKeys1
    extends BuiltInFunction {
        final Map<String, Map<Object, Set>> indexes;

        FunIndexKeys1(Map<String, Map<Object, Set>> ixs) {
            super("indexKeys", 1, T.STATIC);
            this.indexes = ixs;
        }

        @Override
        public Object call(LocalContext lc) {
            String indexname = this.getStringArg(1);
            Map<Object, Set> index = this.indexes.get(indexname);
            if (index == null) {
                throw new RuntimeException("Index '" + indexname + "\" does not exist in indexKeys/1");
            }
            OntCollection result = OntCC.newCol();
            result.addAllTyped(index.keySet());
            return result;
        }
    }

    static class FunIndexValues2
    extends BuiltInFunction {
        final Map<String, Map<Object, Set>> indexes;

        FunIndexValues2(Map<String, Map<Object, Set>> ixs) {
            super("indexValues", 1, T.ELEMENT_WISE);
            this.indexes = ixs;
        }

        @Override
        public Object call(LocalContext lc) {
            String indexname = this.getStringArg(1);
            Map<Object, Set> index = this.indexes.get(indexname);
            if (index == null) {
                throw new RuntimeException("Index '" + indexname + "\" does not exist in indexValues/1");
            }
            Object e = this.getCurrentValue();
            Object o = ObjectContainer.getObject(e);
            OntCollection result = OntCC.newCol();
            if (o instanceof OntCollection) {
                for (Object oo : (OntCollection)o) {
                    if (!index.containsKey(oo)) continue;
                    result.addAllTyped(index.get(oo));
                }
            } else if (index.containsKey(o)) {
                result.addAllTyped(index.get(o));
            }
            return result;
        }
    }

    private static class IterProg {
        Integer collectvarnum;
        Object initval;
        Map<String, List<Instruction>> code;

        private IterProg() {
        }
    }

    private static class Instruction {
        String state;
        Object condition;
        Object newvalue;
        Transitions step;
        String newstate;
        Object init;
        boolean thesame;

        private Instruction() {
        }
    }

    private static enum Transitions {
        BREAK,
        CONTINUE,
        STOP,
        ERROR;

    }

    static class FunReduceLeft1
    extends BuiltInFunction {
        FunReduceLeft1() {
            super("reduceLeft", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object fun = this.getSingleArg(1);
            if (!(fun instanceof Token) && !(fun instanceof FunctionId)) {
                throw new RuntimeException("The 1st argument must be a function entity or an anonymous function");
            }
            int size = o.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                return o.get(0);
            }
            Object result = o.get(0);
            Object[] rargs = new Object[3];
            rargs[0] = null;
            for (int i = 1; i < size; ++i) {
                rargs[1] = result;
                rargs[2] = o.get(i);
                result = Helper.applyFunction(lc, null, null, null, fun, rargs);
            }
            return result;
        }
    }

    static class FunSplitSequence5
    extends BuiltInFunction {
        FunSplitSequence5() {
            super("splitSequence", 5, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object chkpath = this.getSingleArg(1);
            Object keypath = this.getSingleArg(2);
            String typestr = this.getStringArg(3);
            String keyname = this.getStringArg(4);
            String valuenm = this.getStringArg(5);
            return BaseFuncs.splitCol(o, chkpath, keypath, typestr, lc.getInterp(), keyname, valuenm);
        }
    }

    static class FunSplitSequence3
    extends BuiltInFunction {
        FunSplitSequence3() {
            super("splitSequence", 3, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object chkpath = this.getSingleArg(1);
            Object keypath = this.getSingleArg(2);
            String typestr = this.getStringArg(3);
            return BaseFuncs.splitCol(o, chkpath, keypath, typestr, lc.getInterp(), "key", "value");
        }
    }

    static class FunSplitSequence2
    extends BuiltInFunction {
        FunSplitSequence2() {
            super("splitSequence", 2, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            if (Interp.isFalse(o)) {
                throw new RuntimeException("Empty context");
            }
            Object chkpath = this.getSingleArg(1);
            String keyname = this.getStringArg(2);
            return BaseFuncs.splitColRdd(o, chkpath, "starts", lc.getInterp(), keyname, this.getIndex(), this.getPrevious());
        }
    }

    public static enum SPLITTER {
        DIFFERENT,
        STARTS,
        ENDS,
        BETWEEN;

    }

    static class FunSplitSequence1
    extends BuiltInFunction {
        FunSplitSequence1() {
            super("splitSequence", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            OntCollection result = OntCC.newCol(CollectionType.UNDEF_COL);
            Integer length = this.getIntegerArg(1);
            if (length == null) {
                throw new RuntimeException("The arguments must be integer");
            }
            int count = 0;
            int size = o.size();
            do {
                result.addAllTyped(lc.createKeyValueMap(count, OntCC.newCol(o.range(count, length)), "key", "value"));
            } while ((count += length.intValue()) < size);
            return result;
        }
    }

    static class FunSlice2
    extends BuiltInFunction {
        FunSlice2() {
            super("slice", 2, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Integer start = this.getIntegerArg(1);
            Integer length = this.getIntegerArg(2);
            int size = o.size();
            if (start < 0) {
                int s = start;
                if (length < 0) {
                    start = 0;
                    length = size + s + 1;
                } else {
                    int ss = size + s - length + 1;
                    start = Math.max(0, ss);
                    if (ss < 0) {
                        length = length + ss;
                    }
                }
            } else if (length < 0) {
                length = size;
            }
            if (start == null || length == null) {
                throw new RuntimeException("The arguments must be integer");
            }
            return o.range(start, length);
        }
    }

    static class FunIter1
    extends BuiltInFunction {
        FunIter1() {
            super("iter", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object col = this.getArg(1);
            if (col == null) {
                col = OntCC.newCol(CollectionType.UNDEF_COL);
            } else if (col.equals(Boolean.FALSE)) {
                col = OntCC.newCol(CollectionType.UNDEF_COL);
            }
            if (!(col instanceof OntCollection)) {
                throw new RuntimeException("The argument of iter/1 must be a sequence");
            }
            result.addAllTyped(new IterContainer((OntCollection)col));
            return result;
        }
    }

    static class FunNext1
    extends BuiltInFunction {
        FunNext1() {
            super("next", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object obj = this.getArg(1);
            if (obj instanceof OntCollection) {
                OntCollection oc = (OntCollection)obj;
                if (oc.size() != 1) {
                    throw new RuntimeException("The wrong argument");
                }
                obj = oc.get(0);
            }
            if (!(obj instanceof IterContainer)) {
                throw new RuntimeException("Function next/1 can not be applied to non-iterator");
            }
            obj = ((IterContainer)obj).next();
            result.addAllTyped(obj);
            return result;
        }
    }

    static class FunDifference2
    extends BuiltInFunction {
        FunDifference2() {
            super("difference", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object o1 = this.getArg(1);
            Object o2 = this.getArg(2);
            OntCollection o = o1 instanceof OntCollection ? (OntCollection)o1 : OntCC.singleton(o1);
            int size = o.size();
            HashSet<Object> hm = new HashSet<Object>(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            if (o2 instanceof OntCollection) {
                for (Object e : (OntCollection)o2) {
                    Object object = ObjectContainer.getObject(e);
                    hm.add(object);
                }
            } else {
                hm.add(ObjectContainer.getObject(o2));
            }
            for (Object e : o) {
                Object object = ObjectContainer.getObject(e);
                if (hm.contains(object)) {
                    hm.remove(object);
                    continue;
                }
                hm.add(object);
            }
            for (Object e : hm) {
                res.add(e);
            }
            return res;
        }
    }

    static class FunDifference1
    extends BuiltInFunction {
        FunDifference1() {
            super("difference", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object o1 = this.getArg(1);
            int size = o.size();
            HashSet<Object> hm = new HashSet<Object>(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            if (o1 instanceof OntCollection) {
                for (Object e : (OntCollection)o1) {
                    Object object = ObjectContainer.getObject(e);
                    hm.add(object);
                }
            } else {
                hm.add(ObjectContainer.getObject(o1));
            }
            for (Object e : o) {
                Object object = ObjectContainer.getObject(e);
                if (hm.contains(object)) {
                    hm.remove(object);
                    continue;
                }
                hm.add(object);
            }
            for (Object e : hm) {
                res.add(e);
            }
            return res;
        }
    }

    static class FunComplement2
    extends BuiltInFunction {
        FunComplement2() {
            super("complement", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object o1 = this.getArg(1);
            Object o2 = this.getArg(2);
            OntCollection o = o1 instanceof OntCollection ? (OntCollection)o1 : OntCC.singleton(o1);
            int size = o.size();
            HashSet<Object> hm = new HashSet<Object>(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            if (o2 instanceof OntCollection) {
                for (Object e : (OntCollection)o2) {
                    Object object = ObjectContainer.getObject(e);
                    hm.add(object);
                }
            } else {
                hm.add(ObjectContainer.getObject(o2));
            }
            for (Object e : o) {
                Object object = ObjectContainer.getObject(e);
                if (!hm.contains(object)) continue;
                hm.remove(object);
            }
            for (Object e : hm) {
                res.add(e);
            }
            return res;
        }
    }

    static class FunComplement1
    extends BuiltInFunction {
        FunComplement1() {
            super("complement", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object o1 = this.getArg(1);
            int size = o.size();
            HashSet<Object> hm = new HashSet<Object>(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            if (o1 instanceof OntCollection) {
                for (Object e : (OntCollection)o1) {
                    Object object = ObjectContainer.getObject(e);
                    hm.add(object);
                }
            } else {
                hm.add(ObjectContainer.getObject(o1));
            }
            for (Object e : o) {
                Object object = ObjectContainer.getObject(e);
                if (!hm.contains(object)) continue;
                hm.remove(object);
            }
            for (Object e : hm) {
                res.add(e);
            }
            return res;
        }
    }

    static class FunSubtraction2
    extends BuiltInFunction {
        FunSubtraction2() {
            super("subtraction", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object o1 = this.getArg(1);
            Object o2 = this.getArg(2);
            OntCollection o = o1 instanceof OntCollection ? (OntCollection)o1 : OntCC.singleton(o1);
            int size = o.size();
            HashSet hm = new HashSet(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            for (Object e : o) {
                e = ObjectContainer.getObject(e);
                hm.add(e);
            }
            if (o2 instanceof OntCollection) {
                for (Object e : (OntCollection)o2) {
                    if (!hm.contains(e = ObjectContainer.getObject(e))) continue;
                    hm.remove(e);
                }
            } else if (hm.contains(ObjectContainer.getObject(o2))) {
                res.add(ObjectContainer.getObject(o2));
            }
            for (Object e : hm) {
                res.add(e);
            }
            return res;
        }
    }

    static class FunSubtraction1
    extends BuiltInFunction {
        FunSubtraction1() {
            super("subtraction", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object o1 = this.getArg(1);
            int size = o.size();
            HashSet hm = new HashSet(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            for (Object e : o) {
                e = ObjectContainer.getObject(e);
                hm.add(e);
            }
            if (o1 instanceof OntCollection) {
                for (Object e : (OntCollection)o1) {
                    if (!hm.contains(e = ObjectContainer.getObject(e))) continue;
                    hm.remove(e);
                }
            } else if (hm.contains(ObjectContainer.getObject(o1))) {
                res.add(ObjectContainer.getObject(o1));
            }
            for (Object e : hm) {
                res.add(e);
            }
            return res;
        }
    }

    static class FunIntersection2
    extends BuiltInFunction {
        FunIntersection2() {
            super("intersection", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object o1 = this.getArg(1);
            Object o2 = this.getArg(2);
            OntCollection o = o1 instanceof OntCollection ? (OntCollection)o1 : OntCC.singleton(o1);
            int size = o.size();
            HashSet hm = new HashSet(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            for (Object e : o) {
                e = ObjectContainer.getObject(e);
                hm.add(e);
            }
            if (o2 instanceof OntCollection) {
                for (Object e : (OntCollection)o2) {
                    if (!hm.contains(e = ObjectContainer.getObject(e))) continue;
                    res.add(e);
                }
            } else if (hm.contains(ObjectContainer.getObject(o2))) {
                res.add(ObjectContainer.getObject(o2));
            }
            return res;
        }
    }

    static class FunIntersection1
    extends BuiltInFunction {
        FunIntersection1() {
            super("intersection", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object o1 = this.getArg(1);
            int size = o.size();
            HashSet hm = new HashSet(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            for (Object e : o) {
                e = ObjectContainer.getObject(e);
                hm.add(e);
            }
            if (o1 instanceof OntCollection) {
                for (Object e : (OntCollection)o1) {
                    if (!hm.contains(e = ObjectContainer.getObject(e))) continue;
                    res.add(e);
                }
            } else if (hm.contains(ObjectContainer.getObject(o1))) {
                res.add(ObjectContainer.getObject(o1));
            }
            return res;
        }
    }

    static class FunUnion2
    extends BuiltInFunction {
        FunUnion2() {
            super("union", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object o1 = this.getArg(1);
            OntCollection o = o1 instanceof OntCollection ? (OntCollection)o1 : OntCC.singleton(o1);
            Object o2 = this.getArg(2);
            int size = o.size();
            HashSet hm = new HashSet(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            for (Object e : o) {
                if (!hm.add(e = ObjectContainer.getObject(e))) continue;
                res.add(e);
            }
            if (o2 instanceof OntCollection) {
                for (Object e : (OntCollection)o2) {
                    if (!hm.add(e = ObjectContainer.getObject(e))) continue;
                    res.add(e);
                }
            } else {
                res.add(ObjectContainer.getObject(o2));
            }
            return res;
        }
    }

    static class FunUnion1
    extends BuiltInFunction {
        FunUnion1() {
            super("union", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object o1 = this.getArg(1);
            int size = o.size();
            HashSet hm = new HashSet(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            for (Object e : o) {
                if (!hm.add(e = ObjectContainer.getObject(e))) continue;
                res.add(e);
            }
            if (o1 instanceof OntCollection) {
                for (Object e : (OntCollection)o1) {
                    if (!hm.add(e = ObjectContainer.getObject(e))) continue;
                    res.add(e);
                }
            } else {
                res.add(ObjectContainer.getObject(o1));
            }
            return res;
        }
    }

    static class FunDistinct0
    extends BuiltInFunction {
        FunDistinct0() {
            super("distinct", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            int size = o.size();
            HashSet hm = new HashSet(size);
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, size);
            for (Object e : o) {
                if (!hm.add(e = ObjectContainer.getObject(e))) continue;
                res.add(e);
            }
            return res;
        }
    }

    static class FunSize0
    extends BuiltInFunction {
        FunSize0() {
            super("size", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            return this.getContext().size();
        }
    }

    static class FunCount0
    extends BuiltInFunction {
        FunCount0() {
            super("count", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            return this.getContext().size();
        }
    }

    static class FunReverse0
    extends BuiltInFunction {
        FunReverse0() {
            super("reverse", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            OntCollection res = OntCC.newCol();
            for (int i = o.size() - 1; i >= 0; --i) {
                res.addAllTyped(o.get(i));
            }
            return res;
        }
    }

    static class FunPartition1
    extends BuiltInFunction {
        FunPartition1() {
            super("partition", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = Helper.wrapInCol(this.getContext());
            Interp interp = lc.getInterp();
            Object cond = this.getSingleArg(1);
            if (!(cond instanceof Token)) {
                throw new RuntimeException("The 1st argument must be an anonymous function");
            }
            Object prev = null;
            OntCollection f = OntCC.newCol();
            OntCollection t = OntCC.newCol();
            for (int i = 0; i < o.size(); ++i) {
                Object oo = o.get(i);
                Object res = interp.calcPredicate(oo, (Token)cond, M.P_COMPUTE, o, i, prev);
                prev = oo;
                if (Interp.isFalse(res)) {
                    f.addAllTyped(oo);
                    continue;
                }
                t.addAllTyped(oo);
            }
            ObjectId oi = lc.createTempMap();
            lc.setMapValue(oi, "true", t);
            lc.setMapValue(oi, "false", f);
            return oi;
        }
    }

    static class FunTail0
    extends BuiltInFunction {
        FunTail0() {
            super("tail", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = Helper.wrapInCol(this.getContext());
            if (o.isEmpty()) {
                return null;
            }
            OntCollection oc = OntCC.newCol();
            for (int i = 1; i < o.size(); ++i) {
                oc.addAllTyped(o.get(i));
            }
            return oc;
        }
    }

    static class FunHead0
    extends BuiltInFunction {
        FunHead0() {
            super("head", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = Helper.wrapInCol(this.getContext());
            if (o.isEmpty()) {
                return null;
            }
            return o.get(0);
        }
    }

    static class FunLast0
    extends BuiltInFunction {
        FunLast0() {
            super("last", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            if (o.isEmpty()) {
                return null;
            }
            return o.get(o.size() - 1);
        }
    }

    static class FunI1
    extends BuiltInFunction {
        FunI1() {
            super("i", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            int i = this.getIntegerArg(1);
            OntCollection o = this.getContext();
            if (i < 0) {
                int size = o.size();
                i = size + i;
            }
            if (i < 0 || i >= o.size()) {
                return null;
            }
            return o.get(i);
        }
    }

    static class FunCollect1
    extends BuiltInFunction {
        FunCollect1() {
            super("collect", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object obj = this.getSingleArg(1);
            OntCollection oc = this.getContext();
            if (!(obj instanceof Token)) {
                throw new RuntimeException("The first argument must be an anonymous function with a variable, e.g. _{$x}");
            }
            Token tok = (Token)obj;
            if (tok.getType() != TokenType.CLOSURE) {
                throw new RuntimeException("The first argument must be an anonymous function with a variable, e.g. _{$x}");
            }
            while (tok.getType() != TokenType.VAR_REF) {
                if (tok.getSeq().size() != 1) {
                    throw new RuntimeException("The first argument must be an anonymous function with a variable, e.g. _{$x}");
                }
                tok = tok.getSub(0);
            }
            lc.getVars().putVarValue((Integer)tok.getObj(), (Object)oc);
            return oc;
        }
    }

    static class FunIn2
    extends BuiltInFunction {
        FunIn2() {
            super("in", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object elem = this.getArg(1);
            Object col = this.getArg(2);
            if (elem instanceof OntCollection) {
                if (((OntCollection)elem).size() != 1) {
                    throw new RuntimeException("The 1st argument of in/2 must be a single value");
                }
                elem = ((OntCollection)elem).get(0);
            }
            if (col instanceof OntCollection) {
                OntCollection colcol = (OntCollection)col;
                if (elem instanceof ObjectId && colcol.isDataCol()) {
                    return null;
                }
                if (!(elem instanceof ObjectId) && colcol.isObjCol()) {
                    return null;
                }
                for (Object o : colcol) {
                    if (!o.equals(elem)) continue;
                    return elem;
                }
            } else if (elem.equals(col)) {
                return elem;
            }
            return null;
        }
    }

    static class FunIn1
    extends BuiltInFunction {
        FunIn1() {
            super("in", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object col = this.getArg(1);
            Object elem = this.getCurrentValue();
            if (col instanceof OntCollection) {
                OntCollection colcol = (OntCollection)col;
                if (elem instanceof ObjectId && colcol.isDataCol()) {
                    return null;
                }
                if (!(elem instanceof ObjectId) && colcol.isObjCol()) {
                    return null;
                }
                for (Object o : colcol) {
                    if (!o.equals(elem)) continue;
                    return elem;
                }
            } else if (elem.equals(col)) {
                return elem;
            }
            return null;
        }
    }
}

