/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.T;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.BuiltInFunction;
import org.ontobox.libretto.parser.FunctionTable;

public class DateFuncs {
    private static final Map<String, Integer> days = new HashMap<String, Integer>();
    private static final Map<String, Integer> months = new HashMap<String, Integer>();
    private static final Set timeZoneIDs = new HashSet();

    public static void init(FunctionTable funs) {
        funs.pushFunction(new FunDateFormat1());
        funs.pushFunction(new FunDateYear0());
        funs.pushFunction(new FunDateDayMonth0());
        funs.pushFunction(new FunDateDayWeek0());
        funs.pushFunction(new FunDateDayYear0());
        funs.pushFunction(new FunDateMonth0());
        funs.pushFunction(new FunDateHours0());
        funs.pushFunction(new FunDateMinutes0());
        funs.pushFunction(new FunDateSeconds0());
        funs.pushFunction(new FunDateConvert2());
        funs.pushFunction(new FunAfter1());
        funs.pushFunction(new FunBefore1());
        funs.pushFunction(new FunDateTimezones0());
        funs.pushFunction(new FunDateDefinedTimezones0());
        funs.pushFunction(new FunDateSetDefaultTimezone1());
        funs.pushFunction(new FunDateAddTimezone11());
        funs.pushFunction(new FunDateAddTimezone2());
        funs.pushFunction(new FunDate0());
    }

    static {
        for (String s : TimeZone.getAvailableIDs()) {
            timeZoneIDs.add(s.toLowerCase());
        }
        days.put("sun", 1);
        days.put("mon", 2);
        days.put("tue", 3);
        days.put("wed", 4);
        days.put("thu", 5);
        days.put("fri", 6);
        days.put("sat", 7);
        days.put("none", 0);
        months.put("jan", 0);
        months.put("feb", 1);
        months.put("mar", 2);
        months.put("apr", 3);
        months.put("may", 4);
        months.put("jun", 5);
        months.put("jul", 6);
        months.put("aug", 7);
        months.put("sep", 8);
        months.put("oct", 9);
        months.put("nov", 10);
        months.put("dec", 11);
    }

    static class FunDate0
    extends BuiltInFunction {
        FunDate0() {
            super("date", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            return new Date();
        }
    }

    static class FunDateDefinedTimezones0
    extends BuiltInFunction {
        FunDateDefinedTimezones0() {
            super("dateDefinedTimezones", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection sc = OntCC.newCol();
            for (String z : konto.getTimeZones().keySet()) {
                sc.addAllTyped(z);
            }
            return sc;
        }
    }

    static class FunDateTimezones0
    extends BuiltInFunction {
        FunDateTimezones0() {
            super("dateTimezones", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection sc = OntCC.newCol();
            for (String z : TimeZone.getAvailableIDs()) {
                sc.addAllTyped(z);
            }
            return sc;
        }
    }

    static class FunDateSetDefaultTimezone1
    extends BuiltInFunction {
        FunDateSetDefaultTimezone1() {
            super("dateSetDefaultTimezone", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String tzstr = this.getStringArg(1);
            TimeZone tz = konto.getTimeZones().get(tzstr);
            if (tz == null) {
                throw new RuntimeException("Time zone with ID \"" + tzstr + "\" not defined");
            }
            konto.setDefaultTZ(tz);
            return tzstr;
        }
    }

    static class FunBefore1
    extends BuiltInFunction {
        FunBefore1() {
            super("dateBefore", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Date snd = this.getDateArg(1);
            Object oo = this.getCurrentValue();
            if (!((oo = ObjectContainer.getObject(oo)) instanceof Date)) {
                throw new RuntimeException("The 1st argument must be a date");
            }
            Date fst = (Date)oo;
            if (snd == null) {
                throw new RuntimeException("The argument must be a date");
            }
            if (fst.before(snd)) {
                result.addAllTyped(oo);
            }
            return result;
        }
    }

    static class FunAfter1
    extends BuiltInFunction {
        FunAfter1() {
            super("dateAfter", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Date snd = this.getDateArg(1);
            Object oo = this.getCurrentValue();
            if (!((oo = ObjectContainer.getObject(oo)) instanceof Date)) {
                throw new RuntimeException("The 1st argument must be a date");
            }
            Date fst = (Date)oo;
            if (snd == null) {
                throw new RuntimeException("The argument must be a date");
            }
            if (fst.after(snd)) {
                result.addAllTyped(oo);
            }
            return result;
        }
    }

    static class FunDateSeconds0
    extends BuiltInFunction {
        FunDateSeconds0() {
            super("dateSeconds", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("A date not found as the context value");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            result.addAllTyped(cal.get(13));
            return result;
        }
    }

    static class FunDateMinutes0
    extends BuiltInFunction {
        FunDateMinutes0() {
            super("dateMinutes", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("A date not found in the context value");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            result.addAllTyped(cal.get(12));
            return result;
        }
    }

    static class FunDateHours0
    extends BuiltInFunction {
        FunDateHours0() {
            super("dateHours", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("A date not found in the context value");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).setTimeZone(konto.getDefaultTZ());
            cal.setTime(date);
            result.addAllTyped(cal.get(11));
            return result;
        }
    }

    static class FunDateYear0
    extends BuiltInFunction {
        FunDateYear0() {
            super("dateYear", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("A date not found in the context value");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            result.addAllTyped(cal.get(1));
            return result;
        }
    }

    static class FunDateMonth0
    extends BuiltInFunction {
        FunDateMonth0() {
            super("dateMonth", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("A date not found in the context value");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            result.addAllTyped(cal.get(2) + 1);
            return result;
        }
    }

    static class FunDateDayYear0
    extends BuiltInFunction {
        FunDateDayYear0() {
            super("dateDayYear", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("A date not found in the context value");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            result.addAllTyped(cal.get(6));
            return result;
        }
    }

    static class FunDateDayWeek0
    extends BuiltInFunction {
        FunDateDayWeek0() {
            super("dateDayWeek", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("A date not found in the context value");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            result.addAllTyped(cal.get(7));
            return result;
        }
    }

    static class FunDateDayMonth0
    extends BuiltInFunction {
        FunDateDayMonth0() {
            super("dateDayMonth", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object oo = this.getCurrentValue();
            if (!(oo instanceof Date)) {
                throw new RuntimeException("The context must be a date");
            }
            Date date = (Date)oo;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return cal.get(5);
        }
    }

    static class FunDateFormat1
    extends BuiltInFunction {
        FunDateFormat1() {
            super("dateFormat", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol();
            String form = this.getStringArg(1);
            Object oo = this.getCurrentValue();
            if (!((oo = ObjectContainer.getObject(oo)) instanceof Date)) {
                throw new RuntimeException("The context must be in a date value");
            }
            Date date = (Date)oo;
            SimpleDateFormat df = new SimpleDateFormat(form);
            result.addAllTyped(df.format(date));
            return result;
        }
    }

    static class FunDateConvert2
    extends BuiltInFunction {
        FunDateConvert2() {
            super("dateConvert", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            String fsts = this.getStringArg(1);
            String snds = this.getStringArg(2);
            TimeZone tz1 = fsts.equals("default") ? konto.getDefaultTZ() : konto.getTimeZones().get(fsts);
            TimeZone tz2 = snds.equals("default") ? konto.getDefaultTZ() : konto.getTimeZones().get(snds);
            if (tz1 == null) {
                throw new RuntimeException("Time zone \"" + fsts + "\" not found");
            }
            if (tz2 == null) {
                throw new RuntimeException("Time zone \"" + snds + "\" not found");
            }
            Object oo = this.getCurrentValue();
            oo = ObjectContainer.getObject(oo);
            String[] format = new String[1];
            Date date = LocalContext.getNormalizedDate(oo.toString(), tz1, format);
            SimpleDateFormat df = new SimpleDateFormat(format[0]);
            df.setTimeZone(tz2);
            return df.format(date);
        }
    }

    static class FunDateAddTimezone11
    extends BuiltInFunction {
        FunDateAddTimezone11() {
            super("dateAddTimezone", 11, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String id = this.getStringArg(1);
            if (!timeZoneIDs.contains(id)) {
                throw new RuntimeException("Invalid time zone \"" + id + '\"');
            }
            int offset = this.getIntegerArg(2);
            int[] startdate = this.getDaylight(3);
            int[] enddate = this.getDaylight(7);
            int summeroffset = this.getIntegerArg(11);
            SimpleTimeZone tz = new SimpleTimeZone(offset, id, startdate[0], startdate[1], startdate[2], startdate[3], enddate[0], enddate[1], enddate[2], enddate[3], summeroffset);
            konto.getTimeZones().put(id, tz);
            return id;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int[] getDaylight(int argoffset) {
            int day1num;
            int date1num;
            int month1num;
            int[] values = new int[4];
            String month1 = this.getStringArg(0 + argoffset);
            try {
                month1num = (Integer)months.get(month1);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid daylight time starting month \"" + month1 + '\"');
            }
            boolean isLast = false;
            Object date1 = this.getSingleArg(1 + argoffset);
            if (date1 instanceof String) {
                if (!date1.equals("last")) throw new RuntimeException("Invalid daylight time starting date \"" + date1 + '\"');
                date1num = -1;
                isLast = true;
            } else {
                if (!(date1 instanceof Integer)) throw new RuntimeException("Invalid daylight time starting date \"" + date1 + '\"');
                date1num = (Integer)date1;
            }
            String day = this.getStringArg(2 + argoffset);
            if (day.equals("none") && date1num < 0) {
                throw new RuntimeException("Day of month must be positive if day of week is  \"none\"");
            }
            try {
                day1num = (Integer)days.get(day);
                if (!isLast) {
                    day1num = -day1num;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid daylight time starting month \"" + month1 + '\"');
            }
            int time1num = this.getIntegerArg(3 + argoffset);
            values[0] = month1num;
            values[1] = date1num;
            values[2] = day1num;
            values[3] = time1num;
            return values;
        }
    }

    static class FunDateAddTimezone2
    extends BuiltInFunction {
        FunDateAddTimezone2() {
            super("dateAddTimezone", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String id = this.getStringArg(1);
            if (!timeZoneIDs.contains(id)) {
                throw new RuntimeException("Invalid time zone \"" + id + '\"');
            }
            int offset = this.getIntegerArg(2);
            SimpleTimeZone tz = new SimpleTimeZone(offset, id);
            konto.getTimeZones().put(id, tz);
            return id;
        }
    }
}

