/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.datatype.DValue;

public class FunctionType {
    public static int THING_CLASS = -1;
    public static int NO_TYPE = -2;
    private int[] argType = null;
    private T[] argCard;
    private String[] clsName;

    private FunctionType(int arity) {
        this.argCard = new T[arity];
        this.clsName = new String[arity];
    }

    public FunctionType(List<String> argtypeName, List<T> argcard) {
        this(argtypeName.size());
        for (int i = 0; i < argtypeName.size(); ++i) {
            this.setType(i, argtypeName.get(i), argcard.get(i));
        }
    }

    public static FunctionType createUntyped(int arity) {
        FunctionType ft = new FunctionType(arity + 1);
        T[] ac = ft.argCard;
        String[] cn = ft.clsName;
        for (int i = 0; i < ac.length; ++i) {
            ac[i] = T.COLLECTION_WISE;
            cn[i] = null;
        }
        return ft;
    }

    public void setCollectionwise() {
        this.argCard[0] = T.COLLECTION_WISE;
    }

    public void setElementwise() {
        this.argCard[0] = T.ELEMENT_WISE;
    }

    public int getArity() {
        return this.argCard.length - 1;
    }

    public int getType(BoxWorker w, int idx) {
        if (this.argType == null) {
            this.setIds(w);
        }
        return this.argType[idx];
    }

    public T getCard(int idx) {
        return this.argCard[idx];
    }

    public String getName(int idx) {
        return this.clsName[idx];
    }

    public void setType(int idx, String clstype, T card) {
        this.argCard[idx] = card;
        this.clsName[idx] = clstype;
    }

    public void setIds(BoxWorker w) {
        if (this.argType == null) {
            this.argType = new int[this.clsName.length];
        }
        for (int i = 0; i < this.clsName.length; ++i) {
            this.argType[i] = this.clsName[i] == null ? THING_CLASS : w.id(this.clsName[i]);
        }
    }

    public boolean isEquiv(FunctionType ft) {
        if (ft.getArity() != this.getArity()) {
            return false;
        }
        for (int i = 0; i < this.clsName.length; ++i) {
            if (!(this.clsName[i] == null ? ft.clsName[i] != null : !this.clsName[i].equals(ft.clsName[i]))) continue;
            return false;
        }
        return true;
    }

    static boolean checkDT(LocalContext lc, int tid, Object obj) {
        if (obj instanceof Integer && tid == lc.INT_ID) {
            return true;
        }
        if (obj instanceof String && tid == lc.STRING_ID) {
            return true;
        }
        if (obj instanceof Double && tid == lc.DOUBLE_ID) {
            return true;
        }
        if (obj instanceof Date && tid == lc.DATE_ID) {
            return true;
        }
        if (obj instanceof Boolean && tid == lc.BOOLEAN_ID) {
            return true;
        }
        if (obj instanceof Long && tid == lc.LONG_ID) {
            return true;
        }
        if (obj instanceof OntologyId && tid == lc.ONTOLOGY_ID) {
            return true;
        }
        if (obj instanceof TPropertyId && tid == lc.TPROPERTY_ID) {
            return true;
        }
        if (obj instanceof OPropertyId && tid == lc.OPROPERTY_ID) {
            return true;
        }
        if (obj instanceof ClassId && tid == lc.CLASS_ID) {
            return true;
        }
        return obj instanceof TypeId && tid == lc.TYPE_ID;
    }

    public boolean matches(LocalContext lc, Object[] rargs) {
        BoxWorker w = lc.getWorker();
        if (this.argType == null) {
            this.setIds(w);
        }
        block0: for (int i = 0; i < this.argType.length; ++i) {
            int ctype = this.argType[i];
            Object obj = rargs[i];
            if ((obj = OntCC.normalize(obj)) instanceof OntCollection) {
                if (ctype == THING_CLASS) continue;
                OntCollection ont = (OntCollection)obj;
                if (this.argCard[i] != T.COLLECTION_WISE && ont.size() != 1) {
                    return false;
                }
                if (ont.size() == 0) {
                    return true;
                }
                if (ont.isDataCol()) {
                    if (w.entity(ctype) != Entity.TYPE) {
                        return false;
                    }
                    for (Object d : ont) {
                        if (FunctionType.checkDT(lc, ctype, d = ObjectContainer.getObject(d))) continue;
                        return false;
                    }
                    continue;
                }
                if (w.entity(ctype) == Entity.TYPE) {
                    return false;
                }
                block2: for (Object o : ont) {
                    o = ObjectContainer.getObject(o);
                    int id = ((ObjectId)o).id();
                    int[] cls = w.classes(id);
                    for (int j = 0; j < cls.length; ++j) {
                        if (cls[j] == ctype) continue block2;
                    }
                    return false;
                }
                continue;
            }
            if (obj instanceof ObjectId) {
                obj = ObjectContainer.getObject(obj);
                if (ctype == THING_CLASS) continue;
                if (w.entity(ctype) != Entity.ONTCLASS) {
                    return false;
                }
                int id = ((ObjectId)obj).id();
                int[] cls = w.classes(id);
                for (int j = 0; j < cls.length; ++j) {
                    if (cls[j] == ctype) continue block0;
                }
                return false;
            }
            obj = ObjectContainer.getObject(obj);
            if (ctype == THING_CLASS) continue;
            if (w.entity(ctype) != Entity.TYPE) {
                return false;
            }
            if (FunctionType.checkDT(lc, ctype, obj)) continue;
            return false;
        }
        return true;
    }

    public int compare(LocalContext lc, FunctionType ft) {
        BoxWorker w = lc.getWorker();
        if (this.isEquiv(ft)) {
            return 0;
        }
        if (this.argType == null) {
            this.setIds(w);
        }
        if (ft.argType == null) {
            ft.setIds(w);
        }
        int res = 0;
        for (int i = 0; i < this.argType.length; ++i) {
            int t1 = this.argType[i];
            int t2 = ft.argType[i];
            if (t1 == t2) continue;
            if (t1 == THING_CLASS) {
                if (res == 0) {
                    res = 2;
                    continue;
                }
                if (res != 1) continue;
                return -1;
            }
            if (t2 == THING_CLASS) {
                if (res == 0) {
                    res = 1;
                    continue;
                }
                if (res != 2) continue;
                return -1;
            }
            if (w.entity(t1) == Entity.TYPE || w.entity(t2) == Entity.TYPE) {
                return -1;
            }
            if (RHelper.isSubclassOf(w, t1, t2)) {
                if (res == 0) {
                    res = 1;
                    continue;
                }
                if (res != 2) continue;
                return -1;
            }
            if (RHelper.isSubclassOf(w, t2, t1)) {
                if (res == 0) {
                    res = 2;
                    continue;
                }
                if (res != 1) continue;
                return -1;
            }
            return -1;
        }
        return res;
    }

    public static List<Integer> lub(BoxWorker w, int t1, int t2) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (t1 == NO_TYPE) {
            res.add(t2);
            return res;
        }
        if (t2 == NO_TYPE) {
            res.add(t1);
            return res;
        }
        if (w.entity(t1) == Entity.TYPE) {
            if (t1 == t2) {
                res.add(t1);
                return res;
            }
            res.add(THING_CLASS);
            return res;
        }
        if (w.entity(t2) == Entity.TYPE) {
            res.add(THING_CLASS);
            return res;
        }
        int[] sc1 = w.classes(t1);
        int[] sc2 = w.classes(t2);
        return null;
    }

    public static FunctionType readType(int arity, String types) {
        State state = State.CRD;
        int param = -1;
        FunctionType ft = new FunctionType(arity + 1);
        block10: for (int i = 0; i < types.length(); ++i) {
            char ch = types.charAt(i);
            if (ch >= '0' && ch <= '9') {
                state = State.NUM;
                int p = ch - 48;
                if (p != param + 1) {
                    throw new RuntimeException("Erroneous argument number '" + ch + "' in \"" + types + "\"");
                }
                if (p > arity) {
                    throw new RuntimeException("Arity of function (" + arity + ") is esceeded in \"" + types + "\"");
                }
                param = p;
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                state = State.NUM;
                int p = ch - 65 + 10;
                if (p != param + 1) {
                    throw new RuntimeException("Erroneous argument number '" + ch + "' in \"" + types + "\"");
                }
                if (p > arity) {
                    throw new RuntimeException("Arity of function (" + arity + ") is esceeded in \"" + types + "\"");
                }
                param = p;
                continue;
            }
            if (state != State.NUM) {
                switch (ch) {
                    case '-': {
                        if (param > 0) {
                            throw new RuntimeException("Static symbol is allowed only in the context argument  in \"" + types + "\"");
                        }
                        if (state == State.CRD) {
                            throw new RuntimeException("Double cardinality definition at position " + i + " in \"" + types + "\"");
                        }
                        ft.argCard[param] = T.STATIC;
                        state = State.CRD;
                        break;
                    }
                    case '*': {
                        if (state == State.CRD) {
                            throw new RuntimeException("Double cardinality definition at position " + i + " in \"" + types + "\"");
                        }
                        if (param == 0) {
                            ft.setCollectionwise();
                        } else {
                            ft.argCard[param] = T.COLLECTION_WISE;
                        }
                        state = State.CRD;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid char at position " + i + " in \"" + types + "\"");
                    }
                }
            }
            switch (ch) {
                case 'b': 
                case 'c': 
                case 'd': 
                case 'f': 
                case 'i': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 's': 
                case 't': 
                case 'y': {
                    String typename;
                    ft.clsName[param] = typename = DValue.typenames.get(Character.valueOf(ch));
                    state = State.TP;
                    continue block10;
                }
                case '|': {
                    ft.argType[param] = -1;
                    ft.clsName[param] = null;
                    continue block10;
                }
                case '-': {
                    if (param > 0) {
                        throw new RuntimeException("Static symbol is allowed only in the context argument  in \"" + types + "\"");
                    }
                    ft.argCard[param] = T.STATIC;
                    state = State.CRD;
                    continue block10;
                }
                case '*': {
                    ft.argCard[param] = T.COLLECTION_WISE;
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Invalid char at position " + i + " in \"" + types + "\"");
                }
            }
        }
        if (param != arity) {
            throw new RuntimeException("Function arity (" + arity + ") contradicts with \"" + types + "\"");
        }
        return ft;
    }

    private static enum State {
        NUM,
        TP,
        CRD;

    }
}

