/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import com.teacode.exception.ExUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.EntityId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.parser.FunctionTable;

public class JavaFuncs {
    public static final String JAVA_ONTOLOGY = "org.ontobox.java";
    public static final String JAVA_PREFIX = "javaobject:";
    private static Map<String, Class> primitives = new HashMap<String, Class>();

    private static Class unprimitive(Class cl) {
        if (cl.isPrimitive()) {
            Class ret = primitives.get(cl.getName());
            if (ret == null) {
                throw new IllegalStateException("Unknown primitive type " + cl);
            }
            return ret;
        }
        return cl;
    }

    public static void init(FunctionTable funcs) {
        funcs.addFuncs(new JavaF("new", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                return JavaFuncs.newObj(lc, this.stringM(), new Object[0]);
            }
        }, new JavaF("new", 1, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                return JavaFuncs.newObj(lc, this.stringM(), JavaFuncs.unwrapCol(lc, this.arg(1)));
            }
        }, new JavaF("call", 1, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                Object obj = JavaFuncs.unwrap(lc, this.context());
                if (obj == null) {
                    throw new IllegalArgumentException("Context cannot be converted to Java object (" + this.context() + ")");
                }
                return JavaFuncs.callObject(lc, obj, this.stringM(1), new Object[0]);
            }
        }, new JavaF("call", 2, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                Object obj = JavaFuncs.unwrap(lc, this.context());
                if (obj == null) {
                    throw new IllegalArgumentException("Context cannot be converted to Java object (" + this.context() + ")");
                }
                return JavaFuncs.callObject(lc, obj, this.stringM(1), JavaFuncs.unwrapCol(lc, this.arg(2)));
            }
        }, new JavaF("map", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                Object obj = JavaFuncs.unwrap(lc, this.context());
                if (obj == null) {
                    throw new IllegalArgumentException("Context cannot be converted to Java object (" + this.context() + ")");
                }
                return JavaFuncs.toMap(lc, obj);
            }
        }, new JavaF("worker", 0, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                return JavaFuncs.wrap(lc, lc.getWorker());
            }
        }, new JavaF("toString", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                Object obj = JavaFuncs.unwrap(lc, this.context());
                if (obj == null) {
                    throw new IllegalArgumentException("Context cannot be converted to Java object (" + this.context() + ")");
                }
                return String.valueOf(obj);
            }
        });
    }

    private static Class getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + name + " not found");
        }
    }

    private static boolean isClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void error(String entity, String entities, int found, Object[] signature) {
        if (found == 1) {
            throw new RuntimeException(entity + " found, but signature doesn't match " + JavaFuncs.signature(signature));
        }
        if (found > 0) {
            throw new RuntimeException(entities + " found, but signatures don't match " + JavaFuncs.signature(signature));
        }
        throw new RuntimeException(entity + " not found");
    }

    private static void errorConstructor(String clName, int found, Object[] signature) {
        JavaFuncs.error("Constructor " + clName, "Constructors " + clName, found, signature);
    }

    private static void errorMethod(String clName, String methodName, int found, Object[] signature) {
        JavaFuncs.error("Method " + clName + "." + methodName, "Methods " + clName + "." + methodName, found, signature);
    }

    private static String signature(Object[] args) {
        int len = args.length;
        StringBuilder sb = new StringBuilder("(");
        for (int t = 0; t < len; ++t) {
            if (t != 0) {
                sb.append(", ");
            }
            sb.append(args[t].getClass().getName());
        }
        sb.append(")");
        return sb.toString();
    }

    private static Object newObj(LocalContext lc, String clName, Object[] args) {
        Class cl = JavaFuncs.getClass(clName);
        int found = 0;
        for (Constructor<?> constr : cl.getConstructors()) {
            ++found;
            Object[] params = JavaFuncs.args(lc, constr.getParameterTypes(), args);
            if (params == null) continue;
            try {
                return JavaFuncs.wrap(lc, constr.newInstance(params));
            }
            catch (Throwable e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage()), (Throwable)e);
            }
        }
        JavaFuncs.errorConstructor(clName, found, args);
        return null;
    }

    private static Object[] call(LocalContext lc, Object obj, Method method, Object[] args) {
        Object[] params = JavaFuncs.args(lc, method.getParameterTypes(), args);
        System.out.println("params: " + Arrays.toString(params));
        if (params != null) {
            try {
                return new Object[]{JavaFuncs.wrap(lc, method.invoke(obj, params))};
            }
            catch (Throwable e) {
                throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    private static Object callObject(LocalContext lc, Object obj, String methodName, Object[] args) {
        String str;
        Object[] call;
        Class cl = obj.getClass();
        int found = 0;
        for (Method method : cl.getMethods()) {
            if ((method.getModifiers() & 8) != 0 || (method.getModifiers() & 1) != 1 || !method.getName().equals(methodName)) continue;
            ++found;
            call = JavaFuncs.call(lc, obj, method, args);
            if (call == null) continue;
            return call[0];
        }
        if (found > 0) {
            String clName = cl.getName();
            JavaFuncs.errorMethod(clName, methodName, found, args);
        }
        if (obj instanceof String && JavaFuncs.isClass(str = (String)obj)) {
            cl = JavaFuncs.getClass(str);
        }
        found = 0;
        for (Method method : cl.getMethods()) {
            if ((method.getModifiers() & 8) != 8 || (method.getModifiers() & 1) != 1 || !method.getName().equals(methodName)) continue;
            ++found;
            call = JavaFuncs.call(lc, null, method, args);
            if (call == null) continue;
            return call[0];
        }
        JavaFuncs.errorMethod(cl.getName(), methodName, found, args);
        return null;
    }

    private static Object[] args(LocalContext lc, Class[] types, Object[] args) {
        System.out.println("Trying to apply arguments " + Arrays.toString(args) + " to signature " + Arrays.toString(types));
        ArrayList<Object> ret = new ArrayList<Object>();
        int argI = 0;
        for (Class type : types) {
            Object r;
            if ((type = JavaFuncs.unprimitive(type)).equals(BoxWorker.class)) {
                ret.add(lc.getWorker());
                continue;
            }
            if (argI == args.length) {
                return null;
            }
            if (!type.isInstance(r = args[argI++])) {
                return null;
            }
            ret.add(r);
        }
        if (argI != args.length) {
            return null;
        }
        return ret.toArray();
    }

    private static void copyLibrettoToBox(BoxWorker worker, Object value, int id, int tprop) {
        if (value instanceof OntCollection) {
            for (Object v : (Collection)value) {
                worker.write().addString(id, tprop, v.toString());
            }
        } else {
            worker.write().addString(id, tprop, value.toString());
        }
    }

    private static Object toMap(LocalContext lc, Object obj) {
        BoxWorker worker = lc.getWorker();
        int id = worker.write().newLWObject();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Object o : map.keySet()) {
                int tprop = MapHelper.tkey(worker, id, o.toString());
                JavaFuncs.copyLibrettoToBox(worker, JavaFuncs.wrap(lc, map.get(o)), id, tprop);
            }
        } else {
            Class<?> cl = obj.getClass();
            for (Field field : cl.getFields()) {
                if ((field.getModifiers() & 1) != 1) continue;
                try {
                    int tprop = MapHelper.tkey(worker, id, field.getName());
                    JavaFuncs.copyLibrettoToBox(worker, JavaFuncs.wrap(lc, field.get(obj)), id, tprop);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            for (AccessibleObject accessibleObject : cl.getMethods()) {
                if (((Method)accessibleObject).getDeclaringClass().equals(Object.class) || (((Method)accessibleObject).getModifiers() & 1) != 1 || (((Method)accessibleObject).getModifiers() & 8) != 0 || ((Method)accessibleObject).getParameterTypes().length != 0) continue;
                String name = ((Method)accessibleObject).getName();
                if (name.startsWith("get") && name.length() > 3) {
                    name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                }
                try {
                    int tprop = MapHelper.tkey(worker, id, name);
                    JavaFuncs.copyLibrettoToBox(worker, JavaFuncs.wrap(lc, ((Method)accessibleObject).invoke(obj, new Object[0])), id, tprop);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ObjectId.newId(worker, id);
    }

    protected static Object wrap(LocalContext lc, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            OntCollection col = OntCC.newCol();
            for (Object o : (Collection)value) {
                col.addAllTyped(JavaFuncs.wrap(lc, o));
            }
            return col;
        }
        if (value instanceof int[]) {
            OntCollection col = OntCC.newCol();
            for (int i : (int[])value) {
                col.addAllTyped(i);
            }
            return col;
        }
        if (value instanceof String[]) {
            OntCollection col = OntCC.newCol();
            for (String s : (String[])value) {
                col.addAllTyped(s);
            }
            return col;
        }
        if (value instanceof String || value instanceof Long || value instanceof Integer || value instanceof Double || value instanceof EntityId) {
            return value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        return JavaObjects.getInstance(lc).newObject(value);
    }

    protected static Object unwrap(LocalContext lc, Object value) {
        if (value instanceof String) {
            Object obj = JavaObjects.getInstance(lc).get((String)value);
            if (obj != null) {
                return obj;
            }
            return value;
        }
        if (value instanceof Integer || value instanceof Double || value instanceof Long || value instanceof Float) {
            return value;
        }
        if (value instanceof EntityId) {
            return ((EntityId)value).id();
        }
        return null;
    }

    protected static Object[] unwrapCol(LocalContext lc, Object obj) {
        if (obj instanceof OntCollection) {
            OntCollection col = (OntCollection)obj;
            int size = col.size();
            Object[] ret = new Object[size];
            for (int t = 0; t < size; ++t) {
                ret[t] = JavaFuncs.unwrap(lc, col.get(t));
            }
            return ret;
        }
        return new Object[]{JavaFuncs.unwrap(lc, obj)};
    }

    static {
        primitives.put("char", Character.class);
        primitives.put("byte", Byte.class);
        primitives.put("short", Short.class);
        primitives.put("int", Integer.class);
        primitives.put("long", Long.class);
        primitives.put("float", Float.class);
        primitives.put("double", Double.class);
        primitives.put("boolean", Boolean.class);
    }

    protected static abstract class JavaF
    extends LibrettoFunction {
        protected JavaF(String name, int arity, T ctxtype) {
            super(name, arity, ctxtype, JavaFuncs.JAVA_ONTOLOGY, null);
        }
    }

    protected static class JavaObjects {
        protected final Map<String, Object> objects = new HashMap<String, Object>();

        protected JavaObjects() {
        }

        public String newObject(Object obj) {
            String key = JavaFuncs.JAVA_PREFIX + System.identityHashCode(obj);
            Object f = this.objects.get(key);
            if (f != null) {
                if (f != obj) {
                    throw new IllegalStateException("Object clash for " + key);
                }
            } else {
                this.objects.put(key, obj);
            }
            return key;
        }

        public Object get(String key) {
            if (key.startsWith(JavaFuncs.JAVA_PREFIX)) {
                return this.objects.get(key);
            }
            return null;
        }

        public static JavaObjects getInstance(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            JavaObjects ret = (JavaObjects)worker.getAttribute(JavaFuncs.JAVA_ONTOLOGY);
            if (ret == null) {
                ret = new JavaObjects();
                worker.setAttribute(JavaFuncs.JAVA_ONTOLOGY, ret);
            }
            return ret;
        }
    }
}

