/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.RHelper;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.LibrettoEnv;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.EntityId;
import org.ontobox.libretto.adapter.NamedEntityId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.PropertyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.datatype.Bool;
import org.ontobox.libretto.function.BuiltInFunction;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.parser.Asterisk;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public class ModelFuncs {
    public static void init(FunctionTable funs) {
        funs.pushFunction(new FunEntity1());
        funs.pushFunction(new FunEntity0());
        funs.pushFunction(new FunInstanceof1());
        funs.pushFunction(new FunClone1());
        funs.pushFunction(new FunMove1());
        funs.pushFunction(new FunMoveAll1());
        funs.pushFunction(new FunGetObject0());
        funs.pushFunction(new FunGetObject1());
        funs.pushFunction(new FunRename1());
        funs.pushFunction(new FunName0());
        funs.pushFunction(new FunLocal0());
        funs.pushFunction(new FunShort0());
        funs.pushFunction(new FunOntology0());
        funs.addFuncs(new BuiltInFunction("id", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                return this.entityM();
            }
        }, new BuiltInFunction("byId", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                Object context = this.context();
                Integer id = null;
                if (context instanceof Integer) {
                    id = (Integer)context;
                } else {
                    try {
                        id = Integer.parseInt(context.toString());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return Helper.getEntityById(lc, id, null);
            }
        });
        funs.pushFunction(new FunOntologies0());
        funs.pushFunction(new FunPrefixes0());
        funs.pushFunction(new FunPrefix0());
        funs.pushFunction(new FunGeneratePrefixes0());
        funs.pushFunction(new FunNewOntology2());
        funs.pushFunction(new FunPrefix2());
        funs.pushFunction(new FunNewClass1());
        funs.pushFunction(new NewObject1());
        funs.pushFunction(new Obj0());
        funs.pushFunction(new FunNewOprop3());
        funs.pushFunction(new FunNewTprop3());
        funs.pushFunction(new FunAddObjectClass1());
        funs.pushFunction(new FunAddValues2());
        funs.pushFunction(new FunSetValues2());
        funs.pushFunction(new FunAddValues3());
        funs.pushFunction(new FunRemoveValues2());
        funs.pushFunction(new FunRemoveValues1());
        funs.pushFunction(new FunRemoveValues0());
        funs.pushFunction(new FunReplaceValues3());
        funs.pushFunction(new FunRemoveObjectClass1());
        funs.pushFunction(new FunAddSubclass1());
        funs.pushFunction(new FunRemoveSubclass1());
        funs.pushFunction(new FunOProps0());
        funs.pushFunction(new FunTProps0());
        funs.pushFunction(new FunClasses0());
        funs.pushFunction(new FunGetDirectSubClasses0());
        funs.pushFunction(new FunSubClasses0());
        funs.pushFunction(new FunObjectsDirect0());
        funs.pushFunction(new FunClassesDirect0());
        funs.pushFunction(new FunOpropsDirect0());
        funs.pushFunction(new FunTpropsDirect0());
        funs.pushFunction(new FunSubclassOf1());
        funs.pushFunction(new FunDelete0());
        funs.pushFunction(new FunDomain0());
        funs.pushFunction(new FunRange0());
        funs.pushFunction(new FunMaxCard0());
        funs.pushFunction(new FunMinCard0());
        funs.pushFunction(new FunKeys0());
        funs.pushFunction(new FunGet1());
        funs.pushFunction(new FunRemoveKey1());
        funs.pushFunction(new FunPut2());
        funs.pushFunction(new FunType0());
        funs.pushFunction(new FunToString1());
        funs.pushFunction(new FunToInt1());
        funs.pushFunction(new FunToLong1());
        funs.pushFunction(new FunToDouble1());
        funs.pushFunction(new FunToDate1());
        funs.pushFunction(new FunToBool1());
        funs.pushFunction(new FunToOntology1());
        funs.pushFunction(new FunToType1());
        funs.pushFunction(new FunToClass1());
        funs.pushFunction(new FunToObject1());
        funs.pushFunction(new FunToTProperty1());
        funs.pushFunction(new FunToOProperty1());
        funs.pushFunction(new FunToEntity1());
        funs.pushFunction(new FunToString0());
        funs.pushFunction(new FunToInt0());
        funs.pushFunction(new FunToLong0());
        funs.pushFunction(new FunToDouble0());
        funs.pushFunction(new FunToDate0());
        funs.pushFunction(new FunToBool0());
        funs.pushFunction(new FunToOntology0());
        funs.pushFunction(new FunToType0());
        funs.pushFunction(new FunToClass0());
        funs.pushFunction(new FunToObject0());
        funs.pushFunction(new FunToTProperty0());
        funs.pushFunction(new FunToOProperty0());
        funs.pushFunction(new FunToEntity0());
        funs.pushFunction(new FunProps0());
        funs.pushFunction(new FunValues0());
        funs.pushFunction(new FunValues1());
        funs.pushFunction(new FunObjects0());
        funs.pushFunction(new FunObjects1());
        funs.pushFunction(new FunOwners0());
        funs.pushFunction(new FunOwnersProps0());
        funs.pushFunction(new FunDeleteForced0());
    }

    @Deprecated
    public static Token getQuotedEntity(Object obj) {
        Token ot;
        try {
            ot = (Token)obj;
        }
        catch (Exception e) {
            throw new RuntimeException("The context value must be a quoted entity");
        }
        if (ot.getType() != TokenType.QUOTED_EXP) {
            throw new RuntimeException("The context value must be a quoted entity");
        }
        Sequence seq = ot.getSeq();
        if (seq.size() != 1) {
            throw new RuntimeException("Invalid quoted entity");
        }
        return seq.get(0);
    }

    @Deprecated
    private static Token createQuotedEntity(Token entity) {
        Token qu = new Token(TokenType.QUOTED_EXP, 0, null);
        qu.getSeq().addToken(entity);
        return qu;
    }

    @Deprecated
    public static Token createQuotedClass(LocalContext konto, int id) {
        BoxWorker worker = konto.getWorker();
        String fullName = worker.name(id);
        if (worker.entity(id) != Entity.ONTCLASS) {
            throw new RuntimeException("Name \"" + fullName + "\" is not a class URI");
        }
        String uri = worker.name(worker.ontology(id));
        String prefix = konto.getHandler().getPrefixByURI(uri);
        if (prefix == null) {
            throw new RuntimeException("Ontology with prefix \"" + prefix + "\"  not created or declared");
        }
        Token cls = new Token(TokenType.CLASS_NAME, worker.local(id), null);
        cls.setPrefix(prefix.isEmpty() ? null : prefix);
        return ModelFuncs.createQuotedEntity(cls);
    }

    @Deprecated
    public static Token createQuotedProperty(LocalContext konto, int id) {
        BoxWorker worker = konto.getWorker();
        Entity entity = worker.entity(id);
        if (entity != Entity.OPROPERTY && entity != Entity.TPROPERTY) {
            throw new RuntimeException('\"' + worker.name(id) + "\" is not a valid property URI");
        }
        String uri = worker.name(worker.ontology(id));
        String prefix = konto.getHandler().getPrefixByURI(uri);
        if (uri == null) {
            throw new RuntimeException("Ontology with prefix \"" + prefix + "\" is not defined");
        }
        Token prp = new Token(TokenType.PROP_NAME, worker.local(id), null);
        prp.setPrefix(prefix.isEmpty() ? null : prefix);
        return ModelFuncs.createQuotedEntity(prp);
    }

    @Deprecated
    public static Token createQuotedOntology(LocalContext konto, OntologyId ont) {
        String uri = konto.getWorker().name(ont.id());
        String prefix = konto.getHandler().getPrefixByURI(uri);
        if (prefix == null) {
            throw new RuntimeException("Ontology with URI \"" + uri + "\" is not declared");
        }
        Token on = new Token(TokenType.ASTERISK, Asterisk.AST_NS.ordinal(), null);
        on.setPrefix(prefix.equals("") ? null : prefix);
        return ModelFuncs.createQuotedEntity(on);
    }

    static class FunDeleteForced0
    extends BuiltInFunction {
        FunDeleteForced0() {
            super("deleteForced", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The context value must be an object");
            }
            int oi = ((ObjectId)obj).id();
            String delname = konto.getWorker().name(oi);
            konto.objectForceDelete(oi);
            return delname;
        }
    }

    static class FunOwnersProps0
    extends BuiltInFunction {
        FunOwnersProps0() {
            super("ownersProps", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            BoxWorker worker = konto.getWorker();
            OntCollection res = OntCC.newCol();
            obj = !(obj instanceof ObjectId) ? (obj instanceof NamedEntityId ? worker.name(((NamedEntityId)obj).id()) : obj.toString()) : Integer.valueOf(((ObjectId)obj).id());
            List<Integer> owners = konto.getOwners(obj);
            for (int i = 0; i < owners.size(); ++i) {
                int ow = owners.get(i);
                int pw = owners.get(++i);
                int iw = owners.get(++i);
                ObjectId map = konto.createTempMap();
                res.addAllTyped(map);
                konto.setMapValue(map, "o", new ObjectId(ow));
                konto.setMapValue(map, "p", OPropertyId.newId(pw));
                konto.setMapValue(map, "i", iw);
            }
            return res;
        }
    }

    static class FunOwners0
    extends BuiltInFunction {
        FunOwners0() {
            super("owners", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            OntCollection res = OntCC.newCol();
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The context value must be an object");
            }
            int oi = ((ObjectId)obj).id();
            List<Integer> owners = konto.getOwners(oi);
            for (int i = 0; i < owners.size(); ++i) {
                int ow = owners.get(i);
                int pw = owners.get(++i);
                int iw = owners.get(++i);
                ObjectId map = konto.createTempMap();
                res.addAllTyped(map);
                konto.setMapValue(map, "o", ObjectId.newId(konto.getWorker(), ow));
                konto.setMapValue(map, "p", OPropertyId.newId(pw));
                konto.setMapValue(map, "i", iw);
            }
            return res;
        }
    }

    static class FunObjects1
    extends BuiltInFunction {
        FunObjects1() {
            super("objects", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            PropertyId prop;
            Object arg = this.getSingleArg(1);
            if (!(arg instanceof EntityId)) {
                throw new RuntimeException("The 1st argument must be a property entity");
            }
            Integer id = ((EntityId)arg).id();
            Entity ent = konto.getWorker().entity(id);
            if (ent != Entity.OPROPERTY && ent != Entity.TPROPERTY) {
                throw new RuntimeException("The 1st argument is not a property entity");
            }
            try {
                prop = ent == Entity.TPROPERTY ? TPropertyId.newId(id) : OPropertyId.newId(id);
            }
            catch (Exception ee) {
                return null;
            }
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            if (e instanceof ObjectId) {
                try {
                    BoxWorker worker = konto.getWorker();
                    if (prop instanceof OPropertyId) {
                        int[] co;
                        for (int oo : co = worker.objects(((ObjectId)e).id(), prop.id())) {
                            result.add(ObjectId.newId(worker, oo));
                        }
                    } else {
                        String[] strings = worker.strings(((ObjectId)e).id(), prop.id());
                        result.addAll(Arrays.asList(strings));
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    static class FunValues1
    extends BuiltInFunction {
        FunValues1() {
            super("values", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            PropertyId prop;
            Object arg = this.getSingleArg(1);
            if (!(arg instanceof EntityId)) {
                throw new RuntimeException("The 1st argument must be a property entity in values/1");
            }
            Integer id = ((EntityId)arg).id();
            Entity ent = konto.getWorker().entity(id);
            if (ent != Entity.OPROPERTY && ent != Entity.TPROPERTY) {
                throw new RuntimeException("The 1st argument is not a property entity in values/1");
            }
            try {
                prop = ent == Entity.TPROPERTY ? TPropertyId.newId(id) : OPropertyId.newId(id);
            }
            catch (Exception ee) {
                return null;
            }
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            if (e instanceof ObjectId) {
                try {
                    BoxWorker worker = konto.getWorker();
                    if (prop instanceof OPropertyId) {
                        int[] co;
                        for (int oo : co = worker.objects(((ObjectId)e).id(), prop.id())) {
                            result.add(ObjectId.newId(worker, oo));
                        }
                    } else {
                        String[] strings = worker.strings(((ObjectId)e).id(), prop.id());
                        result.addAll(Arrays.asList(strings));
                    }
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    static class FunObjects0
    extends BuiltInFunction {
        FunObjects0() {
            super("objects", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.OBJECT_COL);
            Object e = this.getCurrentValue();
            if (e instanceof ClassId) {
                BoxWorker worker = lc.getWorker();
                result.addObjects(worker, worker.objects(((ClassId)e).id()));
            } else if (e instanceof OntologyId) {
                BoxWorker worker = lc.getWorker();
                result.addObjects(worker, worker.objects(((OntologyId)e).id()));
            } else {
                if (!(e instanceof ObjectId)) {
                    return null;
                }
                e = ObjectContainer.getObject(e);
                result.addAllTyped(lc.getAllOPropValues((ObjectId)e));
            }
            return result;
        }
    }

    static class FunValues0
    extends BuiltInFunction {
        FunValues0() {
            super("values", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            if (!(e instanceof ObjectId)) {
                return null;
            }
            e = ObjectContainer.getObject(e);
            result.addAllTyped(lc.getAllTPropValues((ObjectId)e));
            return result;
        }
    }

    static class FunProps0
    extends BuiltInFunction {
        FunProps0() {
            super("props", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int eid;
            Object cx = this.getCurrentValue();
            if (cx instanceof ClassId) {
                eid = ((ClassId)cx).id();
            } else if (cx instanceof OntologyId) {
                eid = ((OntologyId)cx).id();
            } else if (cx instanceof ObjectId) {
                eid = ((ObjectId)cx).id();
            } else {
                throw new RuntimeException("The context value must be either ontology, class or object value");
            }
            BoxWorker worker = konto.getWorker();
            OntCollection result = OntCC.newCol();
            for (int op : worker.oprops(eid)) {
                result.add(OPropertyId.newId(op));
            }
            for (int tp : worker.tprops(eid)) {
                result.add(TPropertyId.newId(tp));
            }
            return result;
        }
    }

    static class FunToEntity0
    extends BuiltInFunction {
        FunToEntity0() {
            super("toEntity", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Helper.getEntityByString(konto, str, null);
        }
    }

    static class FunToType0
    extends BuiltInFunction {
        FunToType0() {
            super("toType", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Helper.getEntityByString(konto, str, Entity.TYPE);
        }
    }

    static class FunToClass0
    extends BuiltInFunction {
        FunToClass0() {
            super("toClass", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Helper.getEntityByString(konto, str, Entity.ONTCLASS);
        }
    }

    static class FunToOProperty0
    extends BuiltInFunction {
        FunToOProperty0() {
            super("toOProperty", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Helper.getEntityByString(konto, str, Entity.OPROPERTY);
        }
    }

    static class FunToTProperty0
    extends BuiltInFunction {
        FunToTProperty0() {
            super("toTProperty", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Helper.getEntityByString(konto, str, Entity.TPROPERTY);
        }
    }

    static class FunToObject0
    extends BuiltInFunction {
        FunToObject0() {
            super("toObject", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Helper.getEntityByString(konto, str, Entity.ONTOBJECT);
        }
    }

    static class FunToOntology0
    extends BuiltInFunction {
        FunToOntology0() {
            super("toOntology", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Helper.getEntityByString(konto, str, Entity.ONTOLOGY);
        }
    }

    static class FunToBool0
    extends BuiltInFunction {
        FunToBool0() {
            super("toBoolean", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Bool bl;
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = ((String)obj).toLowerCase();
            if (str.equals("true") || str.equals("t")) {
                bl = Bool.TRUE;
            } else if (str.equals("false") || str.equals("f") || str.equals("fail")) {
                bl = Bool.FALSE;
            } else {
                throw new RuntimeException("Unable to rekognize boolean value \"" + str + "\"");
            }
            return bl;
        }
    }

    static class FunToDate0
    extends BuiltInFunction {
        FunToDate0() {
            super("toDate", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return konto.getNormalizedDate(str);
        }
    }

    static class FunToDouble0
    extends BuiltInFunction {
        FunToDouble0() {
            super("toDouble", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Double.valueOf(str);
        }
    }

    static class FunToLong0
    extends BuiltInFunction {
        FunToLong0() {
            super("toLong", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Long l;
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            try {
                l = Long.parseLong(str);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return l;
        }
    }

    static class FunToInt0
    extends BuiltInFunction {
        FunToInt0() {
            super("toInt", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            if (!(obj instanceof String)) {
                throw new RuntimeException("The context value must be a string");
            }
            String str = (String)obj;
            return Integer.decode(str);
        }
    }

    static class FunToString0
    extends BuiltInFunction {
        FunToString0() {
            super("toString", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            return obj.toString();
        }
    }

    static class FunToEntity1
    extends BuiltInFunction {
        FunToEntity1() {
            super("toEntity", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            return Helper.getEntityByString(konto, str, null);
        }
    }

    static class FunToType1
    extends BuiltInFunction {
        FunToType1() {
            super("toType", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            return Helper.getEntityByString(konto, str, Entity.TYPE);
        }
    }

    static class FunToClass1
    extends BuiltInFunction {
        FunToClass1() {
            super("toClass", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            return Helper.getEntityByString(konto, str, Entity.ONTCLASS);
        }
    }

    static class FunToOProperty1
    extends BuiltInFunction {
        FunToOProperty1() {
            super("toOProperty", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            return Helper.getEntityByString(konto, str, Entity.OPROPERTY);
        }
    }

    static class FunToTProperty1
    extends BuiltInFunction {
        FunToTProperty1() {
            super("toTProperty", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            return Helper.getEntityByString(konto, str, Entity.TPROPERTY);
        }
    }

    static class FunToObject1
    extends BuiltInFunction {
        FunToObject1() {
            super("toObject", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            return Helper.getEntityByString(konto, str, Entity.ONTOBJECT);
        }
    }

    static class FunToOntology1
    extends BuiltInFunction {
        FunToOntology1() {
            super("toOntology", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            return Helper.getEntityByString(konto, str, Entity.ONTOLOGY);
        }
    }

    static class FunToBool1
    extends BuiltInFunction {
        FunToBool1() {
            super("toBoolean", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            Bool bl;
            String str = this.getStringArg(1).toLowerCase();
            if (str == null) {
                throw new RuntimeException("Unable to rekognize boolean value \"" + str + "\"");
            }
            if (str.equals("true") || str.equals("t")) {
                bl = Bool.TRUE;
            } else if (str.equals("false") || str.equals("f") || str.equals("fail")) {
                bl = Bool.FALSE;
            } else {
                throw new RuntimeException("Unable to rekognize boolean value \"" + str + "\"");
            }
            return bl;
        }
    }

    static class FunToDate1
    extends BuiltInFunction {
        FunToDate1() {
            super("toDate", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            String str = this.getStringArg(1);
            if (str == null) {
                throw new RuntimeException("1st argument must be a string");
            }
            return konto.getNormalizedDate(str);
        }
    }

    static class FunToDouble1
    extends BuiltInFunction {
        FunToDouble1() {
            super("toDouble", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            Double f;
            Object obj = this.getSingleArg(1);
            if (obj instanceof String) {
                f = Double.valueOf((String)obj);
            } else if (obj instanceof Integer) {
                f = ((Integer)obj).doubleValue();
            } else if (obj instanceof Double) {
                f = (Double)obj;
            } else {
                throw new RuntimeException("1st argument must be either a string, an integer or a double");
            }
            return f;
        }
    }

    static class FunToLong1
    extends BuiltInFunction {
        FunToLong1() {
            super("toLong", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            Long l;
            Object obj = this.getSingleArg(1);
            if (obj instanceof String) {
                try {
                    l = Long.parseLong((String)obj);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else if (obj instanceof Integer) {
                l = ((Integer)obj).longValue();
            } else if (obj instanceof Long) {
                l = (Long)obj;
            } else {
                throw new RuntimeException("1st argument must be either a string, an integer or a long");
            }
            return l;
        }
    }

    static class FunToInt1
    extends BuiltInFunction {
        FunToInt1() {
            super("toInt", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            Integer i;
            Object obj = this.getSingleArg(1);
            if (obj instanceof String) {
                i = Integer.decode((String)obj);
            } else if (obj instanceof Integer) {
                i = (Integer)obj;
            } else if (obj instanceof Long) {
                i = ((Long)obj).intValue();
            } else {
                throw new RuntimeException("1st argument must be either a string, an integer or a long");
            }
            return i;
        }
    }

    static class FunToString1
    extends BuiltInFunction {
        FunToString1() {
            super("toString", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getSingleArg(1);
            return obj.toString();
        }
    }

    static class FunType0
    extends BuiltInFunction {
        FunType0() {
            super("type", 0, T.ELEMENT_WISE);
        }

        private static String decode(Object obj) {
            if (obj instanceof Integer) {
                return "Integer";
            }
            if (obj instanceof String) {
                return "String";
            }
            if (obj instanceof Double) {
                return "Double";
            }
            if (obj instanceof Token) {
                return "Expr";
            }
            return "Object";
        }

        @Override
        public Object call(LocalContext konto) {
            return FunType0.decode(this.getCurrentValue());
        }
    }

    static class FunGet1
    extends BuiltInFunction {
        FunGet1() {
            super("get", 1, T.ELEMENT_WISE, null);
        }

        @Override
        public Object call(LocalContext konto) {
            Object e = ObjectContainer.getObject(this.getCurrentValue());
            String key = this.getStringArg(1);
            if (key == null) {
                throw new RuntimeException("Key name not found in the 1st argument of get/1");
            }
            if (e instanceof ObjectId) {
                return konto.getMapKeyValues((ObjectId)e, key);
            }
            if (e instanceof EntityId) {
                Integer id = ((EntityId)e).id();
                String a = konto.getWorker().anno(id, key);
                if (a == null) {
                    String ekey = Helper.getFullByName(konto, key);
                    return konto.getWorker().anno(id, ekey);
                }
                return a;
            }
            throw new RuntimeException("Context should be an object or an annotated entity");
        }
    }

    static class FunPut2
    extends BuiltInFunction {
        FunPut2() {
            super("put", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String keyname = this.getStringArg(1);
            if (keyname == null) {
                throw new RuntimeException("Key name not found in the 1st argument");
            }
            Object obj = this.getArg(2);
            Object map = this.getCurrentValue();
            if (map instanceof ObjectId) {
                try {
                    lc.removeMapKey((ObjectId)map, keyname);
                }
                catch (Exception e) {
                    // empty catch block
                }
                lc.setMapValue((ObjectId)map, keyname, obj);
            } else if (map instanceof EntityId) {
                String key = Helper.getFullByName(lc, keyname);
                String v = "";
                if (obj instanceof OntCollection) {
                    for (Object a : (OntCollection)obj) {
                        if (!v.equals("")) {
                            v = v + " ";
                        }
                        v = v + a.toString();
                    }
                    obj = v;
                }
                lc.getWorker().write().annotate(((EntityId)map).id(), key, obj.toString());
            } else {
                throw new RuntimeException("The context value of put/2 must be an object or an entity");
            }
            return map;
        }
    }

    static class FunRemoveKey1
    extends BuiltInFunction {
        FunRemoveKey1() {
            super("removeKey", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String keyname = this.getStringArg(1);
            if (keyname == null) {
                throw new RuntimeException("Key name not found in the 1st argument");
            }
            Object map = this.getCurrentValue();
            if (map instanceof ObjectId) {
                try {
                    lc.removeMapKey((ObjectId)map, keyname);
                }
                catch (Exception e) {}
            } else if (map instanceof EntityId) {
                String key = Helper.getFullByName(lc, keyname);
                lc.getWorker().write().annotate(((EntityId)map).id(), key, null);
            } else {
                throw new RuntimeException("The context value " + map + " is neither object, nor entity");
            }
            return map;
        }
    }

    static class FunKeys0
    extends BuiltInFunction {
        FunKeys0() {
            super("keys", 0, T.ELEMENT_WISE, null);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = ObjectContainer.getObject(this.getCurrentValue());
            if (e instanceof ObjectId) {
                Integer id = ((ObjectId)e).id();
                if (konto.isMap(e)) {
                    BoxWorker worker = konto.getWorker();
                    result.addAllTyped(MapHelper.getTKeys(worker, id));
                    result.addAllTyped(MapHelper.getOKeys(worker, id));
                }
            } else if (e instanceof EntityId) {
                Integer id = ((EntityId)e).id();
                result.addAllTyped(Arrays.asList(konto.getWorker().annames(id)));
            } else {
                throw new RuntimeException("Context should be an object or an annotated entity");
            }
            return result;
        }
    }

    static class FunMinCard0
    extends BuiltInFunction {
        FunMinCard0() {
            super("minCard", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object cx = this.getCurrentValue();
            Integer prop = Helper.checkEntity(cx, Entity.TPROPERTY);
            if (prop == null) {
                prop = Helper.checkEntity(cx, Entity.OPROPERTY);
            }
            if (prop == null) {
                throw new RuntimeException("The context value must be a property entity");
            }
            String v = lc.getWorker().anno(prop, "http://ontobox.org/#mincard");
            return v == null ? 0 : Integer.valueOf(v);
        }
    }

    static class FunMaxCard0
    extends BuiltInFunction {
        FunMaxCard0() {
            super("maxCard", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object cx = this.getCurrentValue();
            Integer prop = Helper.checkEntity(cx, Entity.TPROPERTY);
            if (prop == null) {
                prop = Helper.checkEntity(cx, Entity.OPROPERTY);
            }
            if (prop == null) {
                throw new RuntimeException("The context value must be a property entity");
            }
            String v = lc.getWorker().anno(prop, "http://ontobox.org/#maxcard");
            return v == null ? -1 : Integer.valueOf(v);
        }
    }

    static class FunRange0
    extends BuiltInFunction {
        FunRange0() {
            super("range", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Integer prop = Helper.checkEntity(this.getCurrentValue(), Entity.TPROPERTY);
            if (prop == null) {
                prop = Helper.checkEntity(this.getCurrentValue(), Entity.OPROPERTY);
                if (prop == null) {
                    throw new RuntimeException("The context value must be a property entity in domain/0");
                }
                Integer range = konto.getWorker().range(prop);
                if (range != null) {
                    return ClassId.newId(range);
                }
            } else {
                Integer range = konto.getWorker().range(prop);
                if (range != null) {
                    return TypeId.newId(range);
                }
            }
            return null;
        }
    }

    static class FunDomain0
    extends BuiltInFunction {
        FunDomain0() {
            super("domain", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Integer prop = Helper.checkEntity(this.getCurrentValue(), Entity.TPROPERTY);
            if (prop == null && (prop = Helper.checkEntity(this.getCurrentValue(), Entity.OPROPERTY)) == null) {
                throw new RuntimeException("The context value must be a property entity in domain/0");
            }
            Integer dom = konto.getWorker().domain(prop);
            if (dom != null) {
                return ClassId.newId(dom);
            }
            return null;
        }
    }

    static class FunDelete0
    extends BuiltInFunction {
        FunDelete0() {
            super("delete", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object cx = this.getCurrentValue();
            if (!(cx instanceof EntityId)) {
                throw new RuntimeException("The context value of delete must be an entity");
            }
            int id = ((EntityId)cx).id();
            BoxWorker worker = konto.getWorker();
            if (worker.entity(id) == Entity.ONTOLOGY) {
                String prefix = konto.getHandler().getPrefixByURI(worker.name(id));
                if (prefix == null) {
                    prefix = "";
                }
                worker.write().delete(id);
                konto.getHandler().getMapping().remove(prefix);
            } else {
                worker.write().delete(id);
            }
            return true;
        }
    }

    static class FunSubclassOf1
    extends BuiltInFunction {
        FunSubclassOf1() {
            super("subclassof", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            if (RHelper.isSubclassOf(lc.getWorker(), this.ontclassM(), this.ontclassM(1))) {
                return this.getCurrentValue();
            }
            return null;
        }
    }

    static class FunTpropsDirect0
    extends BuiltInFunction {
        FunTpropsDirect0() {
            super("tpropsDirect", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int cls = this.ontclassM();
            OntCollection res = OntCC.newCol();
            for (int p : konto.getWorker().tpropsDirect(cls)) {
                res.addAllTyped(TPropertyId.newId(p));
            }
            return res;
        }
    }

    static class FunOpropsDirect0
    extends BuiltInFunction {
        FunOpropsDirect0() {
            super("opropsDirect", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int cls = this.ontclassM();
            OntCollection res = OntCC.newCol();
            for (int op : konto.getWorker().opropsDirect(cls)) {
                res.addAllTyped(OPropertyId.newId(op));
            }
            return res;
        }
    }

    static class FunClassesDirect0
    extends BuiltInFunction {
        FunClassesDirect0() {
            super("classesDirect", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int eid;
            Object cx = this.context();
            if (cx instanceof ClassId) {
                eid = ((ClassId)cx).id();
            } else if (cx instanceof OntologyId) {
                eid = ((OntologyId)cx).id();
            } else if (cx instanceof ObjectId) {
                eid = ((ObjectId)cx).id();
            } else {
                throw new LibrettoFunction.WrongContext("a class, ontology, or object value");
            }
            int[] classes = konto.getWorker().classesDirect(eid);
            OntCollection res = OntCC.newCol();
            for (int c : classes) {
                res.addAllTyped(ClassId.newId(c));
            }
            return res;
        }
    }

    static class FunObjectsDirect0
    extends BuiltInFunction {
        FunObjectsDirect0() {
            super("objectsDirect", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int cls = this.ontclassM();
            OntCollection res = OntCC.newCol();
            BoxWorker worker = konto.getWorker();
            res.addObjects(worker, worker.objectsDirect(cls));
            return res;
        }
    }

    static class FunSubClasses0
    extends BuiltInFunction {
        FunSubClasses0() {
            super("subclasses", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection res = OntCC.newCol();
            for (int i : konto.getWorker().subclasses(this.ontclassM())) {
                res.addAllTyped(ClassId.newId(i));
            }
            return res;
        }
    }

    static class FunGetDirectSubClasses0
    extends BuiltInFunction {
        FunGetDirectSubClasses0() {
            super("subclassesDirect", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            OntCollection res = OntCC.newCol();
            for (int c : konto.getWorker().subclassesDirect(this.ontclassM())) {
                res.addAllTyped(ClassId.newId(c));
            }
            return res;
        }
    }

    static class FunClasses0
    extends BuiltInFunction {
        FunClasses0() {
            super("classes", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int eid;
            Object cx = this.getCurrentValue();
            if (cx instanceof ClassId) {
                eid = ((ClassId)cx).id();
            } else if (cx instanceof OntologyId) {
                eid = ((OntologyId)cx).id();
            } else if (cx instanceof ObjectId) {
                eid = ((ObjectId)cx).id();
            } else {
                throw new RuntimeException("The context value of classes/0 must be either a class, ontology, or object value");
            }
            int[] classes = konto.getWorker().classes(eid);
            OntCollection res = OntCC.newCol();
            for (int c : classes) {
                res.addAllTyped(ClassId.newId(c));
            }
            return res;
        }
    }

    static class FunTProps0
    extends BuiltInFunction {
        FunTProps0() {
            super("tprops", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int eid;
            Object cx = this.getCurrentValue();
            BoxWorker worker = konto.getWorker();
            if (cx instanceof ClassId) {
                eid = ((ClassId)cx).id();
            } else if (cx instanceof OntologyId) {
                eid = ((OntologyId)cx).id();
            } else if (cx instanceof ObjectId) {
                eid = ((ObjectId)cx).id();
            } else {
                throw new RuntimeException("The context value must be either ontology, class or object value");
            }
            OntCollection res = OntCC.newCol();
            for (int p : worker.tprops(eid)) {
                res.addAllTyped(TPropertyId.newId(p));
            }
            return res;
        }
    }

    static class FunOProps0
    extends BuiltInFunction {
        FunOProps0() {
            super("oprops", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int eid;
            Object cx = this.getCurrentValue();
            BoxWorker worker = konto.getWorker();
            if (cx instanceof ClassId) {
                eid = ((ClassId)cx).id();
            } else if (cx instanceof OntologyId) {
                eid = ((OntologyId)cx).id();
            } else if (cx instanceof ObjectId) {
                eid = ((ObjectId)cx).id();
            } else {
                throw new RuntimeException("The context value must be either ontology, class or object value");
            }
            OntCollection res = OntCC.newCol();
            for (int p : worker.oprops(eid)) {
                res.addAllTyped(OPropertyId.newId(p));
            }
            return res;
        }
    }

    static class FunRemoveObjectClass1
    extends BuiltInFunction {
        FunRemoveObjectClass1() {
            super("removeObjectClass", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int obj = this.objectM();
            int cl = this.ontclassM(1);
            konto.objectRemoveFromClass(cl, obj);
            return ObjectId.newId(konto.getWorker(), obj);
        }
    }

    static class FunReplaceValues3
    extends BuiltInFunction {
        FunReplaceValues3() {
            super("replaceValues", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            Object prop = this.getSingleArg(1);
            Object cond = this.getSingleArg(2);
            Object newvl = this.getSingleArg(3);
            BoxWorker worker = konto.getWorker();
            BoxWriter w = worker.write();
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The attempt to apply to a non-object context element");
            }
            int oid = ((ObjectId)obj).id();
            if (!(cond instanceof Token)) {
                throw new RuntimeException("The condition not found in the 2nd argument ");
            }
            if (!(newvl instanceof Token)) {
                throw new RuntimeException("The new value expression not found in the 3rd argument ");
            }
            Token tcd = (Token)cond;
            if (tcd.getType() != TokenType.CLOSURE) {
                throw new RuntimeException("The closure not found in the 2nd argument ");
            }
            Token newval = (Token)newvl;
            if (newval.getType() != TokenType.CLOSURE) {
                throw new RuntimeException("The closure not found in the 3rd argument ");
            }
            Object[] condcontext = (Object[])tcd.getObj();
            condcontext[0] = this.getCurrentValue();
            HashMap varsincond = (HashMap)tcd.getSub(0).getInfo();
            Object[] newvalcontext = (Object[])newval.getObj();
            HashMap varsinnewval = (HashMap)newval.getSub(0).getInfo();
            konto.getVars().pushEnv(condcontext, varsincond);
            if (prop instanceof OPropertyId) {
                int i;
                int oprop = ((OPropertyId)prop).id();
                int[] vals = worker.objects(oid, oprop);
                OntCollection[] rslts = new OntCollection[vals.length];
                Object prev = OntCC.newCol();
                int j = 0;
                for (i = 0; i < vals.length; ++i) {
                    ObjectId o = ObjectId.newId(worker, vals[i]);
                    Object res = konto.getInterp().eval(o, tcd, i, prev);
                    if (Interp.isFalse(res)) {
                        rslts[i] = null;
                    } else {
                        konto.getVars().pushEnv(newvalcontext, varsinnewval);
                        newvalcontext[0] = o;
                        rslts[i] = Helper.wrapInCol(konto.getInterp().eval(o, newval, i, prev));
                        konto.getVars().popEnv();
                    }
                    prev = o;
                }
                for (i = vals.length - 1; i >= 0; --i) {
                    if (rslts[i] == null) continue;
                    w.removeValue(oid, oprop, i);
                    j = i;
                    if (rslts[i].isDataCol()) {
                        throw new RuntimeException("Invalid new values (data values instead of objects) ");
                    }
                    for (Object oo : rslts[i]) {
                        w.addObject(oid, oprop, j, ((ObjectId)oo).id());
                        ++j;
                    }
                }
            } else if (prop instanceof TPropertyId) {
                int i;
                int tprop = ((TPropertyId)prop).id();
                OntCollection vals = konto.typedCollection(Arrays.asList(worker.strings(oid, tprop)), (TPropertyId)prop);
                OntCollection[] rslts = new OntCollection[vals.size()];
                Object prev = OntCC.newCol();
                for (i = 0; i < vals.size(); ++i) {
                    Object s = vals.get(i);
                    Object res = konto.getInterp().eval(s, tcd, i, prev);
                    if (Interp.isFalse(res)) {
                        rslts[i] = null;
                    } else {
                        OntCollection oc;
                        konto.getVars().pushEnv(newvalcontext, varsinnewval);
                        newvalcontext[0] = s;
                        rslts[i] = oc = Helper.wrapInCol(konto.getInterp().eval(s, newval, i, prev));
                        konto.getVars().popEnv();
                    }
                    prev = s;
                }
                for (i = vals.size() - 1; i >= 0; --i) {
                    if (rslts[i] == null) continue;
                    w.removeValue(oid, tprop, i);
                    int j = i;
                    if (rslts[i].isObjCol()) {
                        throw new RuntimeException("Invalid new values (data values instead of objects) ");
                    }
                    for (Object oo : rslts[i]) {
                        w.addString(oid, tprop, j, oo.toString());
                        ++j;
                    }
                }
            } else {
                throw new RuntimeException("Property not found in the 1st argument ");
            }
            konto.getVars().popEnv();
            return obj;
        }
    }

    static class FunRemoveValues2
    extends BuiltInFunction {
        FunRemoveValues2() {
            super("removeValues", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            Object prop = this.getSingleArg(1);
            Object cond = this.getSingleArg(2);
            BoxWorker worker = konto.getWorker();
            BoxWriter w = worker.write();
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The attempt to apply to a non-object context element");
            }
            int oid = ((ObjectId)obj).id();
            if (!(cond instanceof Token)) {
                throw new RuntimeException("The condition not found in the 2nd argument ");
            }
            Token tcd = (Token)cond;
            if (tcd.getType() != TokenType.CLOSURE) {
                throw new RuntimeException("The closure not found in the 2nd argument ");
            }
            Object[] argsargs1 = (Object[])tcd.getObj();
            argsargs1[0] = this.getCurrentValue();
            HashMap varsinargs = (HashMap)tcd.getSub(0).getInfo();
            konto.getVars().pushEnv(argsargs1, varsinargs);
            if (prop instanceof OPropertyId) {
                int i;
                int oprop = ((OPropertyId)prop).id();
                int[] vals = worker.objects(oid, oprop);
                Object prev = OntCC.newCol();
                for (i = 0; i < vals.length; ++i) {
                    ObjectId o = ObjectId.newId(worker, vals[i]);
                    Object res = konto.getInterp().eval(o, tcd, i, prev);
                    vals[i] = Interp.isFalse(res) ? 0 : 1;
                    prev = o;
                }
                for (i = vals.length - 1; i >= 0; --i) {
                    if (vals[i] != 1) continue;
                    w.removeValue(oid, oprop, i);
                }
            } else if (prop instanceof TPropertyId) {
                int i;
                int tprop = ((TPropertyId)prop).id();
                String[] vals = worker.strings(oid, tprop);
                Object prev = OntCC.newCol();
                for (i = 0; i < vals.length; ++i) {
                    String s = vals[i];
                    Object res = konto.getInterp().eval(s, tcd, i, prev);
                    vals[i] = Interp.isFalse(res) ? null : "";
                    prev = s;
                }
                for (i = vals.length - 1; i >= 0; --i) {
                    if (vals[i] == null) continue;
                    w.removeValue(oid, tprop, i);
                }
            } else {
                throw new RuntimeException("Property not found in the 1st argument ");
            }
            konto.getVars().popEnv();
            return obj;
        }
    }

    static class FunRemoveValues1
    extends BuiltInFunction {
        FunRemoveValues1() {
            super("removeValues", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            Object prop = this.getSingleArg(1);
            BoxWorker worker = konto.getWorker();
            BoxWriter w = worker.write();
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The attempt to apply to a non-object context element");
            }
            int oid = ((ObjectId)obj).id();
            if (prop instanceof OPropertyId) {
                int oprop = ((OPropertyId)prop).id();
                w.removeValues(oid, oprop);
            } else if (prop instanceof TPropertyId) {
                int tprop = ((TPropertyId)prop).id();
                w.removeValues(oid, tprop);
            } else {
                throw new RuntimeException("Property not found in the 1st argument ");
            }
            return obj;
        }
    }

    static class FunRemoveValues0
    extends BuiltInFunction {
        FunRemoveValues0() {
            super("removeValues", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            BoxWorker worker = konto.getWorker();
            BoxWriter w = worker.write();
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The attempt to apply to a non-object context element");
            }
            int oid = ((ObjectId)obj).id();
            w.removeValues(oid);
            return obj;
        }
    }

    static class FunRemoveSubclass1
    extends BuiltInFunction {
        FunRemoveSubclass1() {
            super("removeSubclass", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object sup = this.getCurrentValue();
            Object sub = this.getSingleArg(1);
            if (!(sup instanceof ClassId)) {
                throw new RuntimeException("The context value must be a class");
            }
            if (!(sub instanceof ClassId)) {
                throw new RuntimeException("The 1st argument must be a class");
            }
            BoxWorker worker = konto.getWorker();
            worker.write().removeSubclass(((ClassId)sup).id(), ((ClassId)sub).id());
            return sup;
        }
    }

    static class FunAddSubclass1
    extends BuiltInFunction {
        FunAddSubclass1() {
            super("addSubclass", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object sup = this.getCurrentValue();
            Object sub = this.getSingleArg(1);
            if (!(sup instanceof ClassId)) {
                throw new RuntimeException("The context value must be a class");
            }
            if (!(sub instanceof ClassId)) {
                throw new RuntimeException("The 1st argument must be a class");
            }
            BoxWorker worker = konto.getWorker();
            worker.write().addSubclass(((ClassId)sup).id(), ((ClassId)sub).id());
            return sup;
        }
    }

    static class FunAddValues3
    extends BuiltInFunction {
        FunAddValues3() {
            super("addValues", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            Object prop = this.getSingleArg(1);
            Object vals = this.getArg(2);
            int idx = this.getIntegerArg(3);
            BoxWorker worker = konto.getWorker();
            BoxWriter w = worker.write();
            OntCollection ovals = Helper.wrapInCol(vals);
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The attempt to apply to a non-object context element");
            }
            int oid = ((ObjectId)obj).id();
            if (prop instanceof OPropertyId) {
                int oprop = ((OPropertyId)prop).id();
                if (ovals.isDataCol()) {
                    throw new RuntimeException("The attempt to assign the oproperty " + worker.name(oprop) + " a non-object value");
                }
                for (Object o : ovals) {
                    int vid = ((ObjectId)o).id();
                    w.addObject(oid, oprop, idx, vid);
                }
            } else if (prop instanceof TPropertyId) {
                int tprop = ((TPropertyId)prop).id();
                if (ovals.isObjCol()) {
                    throw new RuntimeException("The attempt to assign the tproperty " + worker.name(tprop) + " a non-object value");
                }
                boolean isDate = false;
                Integer t = worker.range(tprop);
                if (t != null && worker.name(t).equals("http://ontobox.org/#date")) {
                    isDate = true;
                }
                for (Object o : ovals) {
                    String s = o.toString();
                    String[] dummyStr = new String[1];
                    if (isDate) {
                        Date d = konto.getNormalizedDate(s, dummyStr);
                        if (d == null) {
                            throw new LocalContext.InvalidDateException(s);
                        }
                        s = DateHelper.format(d);
                    }
                    w.addString(oid, tprop, idx, s);
                    ++idx;
                }
            } else {
                throw new RuntimeException("Property not found in the 1st argument ");
            }
            return obj;
        }
    }

    static class FunSetValues2
    extends BuiltInFunction {
        FunSetValues2() {
            super("setValues", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            Object prop = this.getSingleArg(1);
            Object vals = this.getArg(2);
            BoxWorker worker = konto.getWorker();
            BoxWriter w = worker.write();
            OntCollection ovals = Helper.wrapInCol(vals);
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The attempt to apply to a non-object context element");
            }
            int oid = ((ObjectId)obj).id();
            if (prop instanceof String) {
                String name = (String)prop;
                String s = Helper.getFullByName(konto, name);
                Integer id = worker.id(s);
                if (id == null) {
                    String[] nm = Helper.getQName(name);
                    if (nm[1] == null || nm[1].equals("")) {
                        throw new RuntimeException("Wrong name");
                    }
                    String uri = konto.getHandler().getUriByPrefix(nm[0]);
                    konto.getLE();
                    int fnum = LibrettoEnv.getSetter(konto, uri, name);
                    if (fnum != -1) {
                        konto.getInterp().calcSGetter((ObjectId)obj, ovals, fnum);
                        return obj;
                    }
                } else if (worker.entity(id) == Entity.OPROPERTY) {
                    prop = OPropertyId.newId(id);
                } else if (worker.entity(id) == Entity.TPROPERTY) {
                    prop = TPropertyId.newId(id);
                } else {
                    throw new RuntimeException("Property not found in 1st argument (" + (Object)((Object)worker.entity(id)) + ")");
                }
            }
            if (prop instanceof OPropertyId) {
                int oprop = ((OPropertyId)prop).id();
                if (ovals.isDataCol()) {
                    throw new RuntimeException("The attempt to assign the oproperty " + worker.name(oprop) + " a non-object value");
                }
                w.removeValues(oid, oprop);
                for (Object o : ovals) {
                    int vid = ((ObjectId)o).id();
                    w.addObject(oid, oprop, vid);
                }
            } else if (prop instanceof TPropertyId) {
                int tprop = ((TPropertyId)prop).id();
                if (ovals.isObjCol()) {
                    throw new RuntimeException("The attempt to assign the tproperty " + worker.name(tprop) + " a non-object value");
                }
                boolean isDate = false;
                Integer t = worker.range(tprop);
                if (t != null && worker.name(t).equals("http://ontobox.org/#date")) {
                    isDate = true;
                }
                w.removeValues(oid, tprop);
                for (Object o : ovals) {
                    String s = o.toString();
                    String[] dummyStr = new String[1];
                    if (isDate) {
                        Date d = konto.getNormalizedDate(s, dummyStr);
                        if (d == null) {
                            throw new LocalContext.InvalidDateException(s);
                        }
                        s = DateHelper.format(d);
                    }
                    w.addString(oid, tprop, s);
                }
            } else {
                throw new RuntimeException("Property not found in the 1st argument ");
            }
            return obj;
        }
    }

    static class FunAddValues2
    extends BuiltInFunction {
        FunAddValues2() {
            super("addValues", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object obj = this.getCurrentValue();
            Object prop = this.getSingleArg(1);
            Object vals = this.getArg(2);
            BoxWorker worker = konto.getWorker();
            BoxWriter w = worker.write();
            OntCollection ovals = Helper.wrapInCol(vals);
            if (!(obj instanceof ObjectId)) {
                throw new RuntimeException("The attempt to apply to a non-object context element");
            }
            int oid = ((ObjectId)obj).id();
            if (prop instanceof OPropertyId) {
                int oprop = ((OPropertyId)prop).id();
                if (ovals.isDataCol()) {
                    throw new RuntimeException("The attempt to assign the oproperty " + worker.name(oprop) + " a non-object value");
                }
                for (Object o : ovals) {
                    int vid = ((ObjectId)o).id();
                    w.addObject(oid, oprop, vid);
                }
            } else if (prop instanceof TPropertyId) {
                int tprop = ((TPropertyId)prop).id();
                if (ovals.isObjCol()) {
                    throw new RuntimeException("The attempt to assign the tproperty " + worker.name(tprop) + " a non-object value");
                }
                boolean isDate = false;
                Integer t = worker.range(tprop);
                if (t != null && worker.name(t).equals("http://ontobox.org/#date")) {
                    isDate = true;
                }
                for (Object o : ovals) {
                    String s = o.toString();
                    String[] dummyStr = new String[1];
                    if (isDate) {
                        Date d = konto.getNormalizedDate(s, dummyStr);
                        if (d == null) {
                            throw new LocalContext.InvalidDateException(s);
                        }
                        s = DateHelper.format(d);
                    }
                    w.addString(oid, tprop, s);
                }
            } else {
                throw new RuntimeException("Property not found in the 1st argument ");
            }
            return obj;
        }
    }

    static class FunAddObjectClass1
    extends BuiltInFunction {
        FunAddObjectClass1() {
            super("addObjectClass", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Object oo = this.getCurrentValue();
            Object oc = this.getSingleArg(1);
            if (!(oc instanceof ClassId)) {
                throw new RuntimeException("The 1st argument must be a class value");
            }
            BoxWorker worker = konto.getWorker();
            if (!(oo instanceof ObjectId)) {
                throw new RuntimeException("Context object not found");
            }
            worker.write().addObjectClass(((ObjectId)oo).id(), ((ClassId)oc).id());
            return oo;
        }
    }

    static class FunNewTprop3
    extends BuiltInFunction {
        FunNewTprop3() {
            super("newTProp", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int ont = this.ontologyM();
            String name = this.stringM(1);
            int domain = this.ontclassM(2);
            Object rr = this.arg(3);
            if (!(rr instanceof TypeId)) {
                throw new LibrettoFunction.WrongArg(3, "a type");
            }
            int range = ((TypeId)rr).id();
            BoxWorker worker = konto.getWorker();
            BoxWriter writer = worker.write();
            int tp = writer.newTProperty(worker.name(ont, name));
            writer.setDomain(tp, domain);
            writer.setRange(tp, range);
            return TPropertyId.newId(tp);
        }
    }

    static class FunNewOprop3
    extends BuiltInFunction {
        FunNewOprop3() {
            super("newOProp", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            int ont = this.ontologyM();
            String name = this.stringM(1);
            int domain = this.ontclassM(2);
            int range = this.ontclassM(3);
            BoxWorker worker = konto.getWorker();
            BoxWriter writer = worker.write();
            int op = writer.newOProperty(worker.name(ont, name));
            writer.setDomain(op, domain);
            writer.setRange(op, range);
            return OPropertyId.newId(op);
        }
    }

    static class Obj0
    extends BuiltInFunction {
        Obj0() {
            super("obj", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            return ObjectId.newId(worker, worker.write().newLWObject());
        }
    }

    static class NewObject1
    extends BuiltInFunction {
        NewObject1() {
            super("newObject", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            Object ont = this.getSingleArg(1);
            String name = null;
            if (ont instanceof String && !ont.equals("")) {
                String qn = (String)ont;
                String[] nm = Helper.getQName(qn);
                if (nm[0] == null) {
                    ont = nm[1];
                } else {
                    ont = nm[0];
                    name = nm[1];
                }
            }
            if (ont instanceof Integer) {
                throw new RuntimeException("The 1st argument must be either string or ontology datatype value");
            }
            Integer oid = Helper.getOntologyByAll(lc, ont).id();
            BoxWorker worker = lc.getWorker();
            name = name == null ? worker.write().newName(oid) : worker.name(oid) + '#' + name;
            int id = worker.write().newObject(name);
            return ObjectId.newId(worker, id);
        }
    }

    static class FunNewClass1
    extends BuiltInFunction {
        FunNewClass1() {
            super("newClass", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            int ont = this.ontologyM();
            String name = this.stringM(1);
            BoxWorker worker = lc.getWorker();
            return ClassId.newId(worker.write().newClass(worker.name(ont, name)));
        }
    }

    static class FunOntology0
    extends BuiltInFunction {
        FunOntology0() {
            super("ontology", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object cls = this.getCurrentValue();
            BoxWorker worker = lc.getWorker();
            if (!(cls instanceof NamedEntityId)) {
                throw new IllegalArgumentException("The context value (" + cls + ") is not a named entity");
            }
            int id = ((NamedEntityId)cls).id();
            return OntologyId.newId(worker.ontology(id));
        }
    }

    static class FunPrefix2
    extends BuiltInFunction {
        FunPrefix2() {
            super("prefix", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String prefix = this.getStringArg(1);
            if (!prefix.equals("") && !LocalContext.checkSyntax(prefix, "[_\\w][_\\d\\w-]*")) {
                throw new RuntimeException("Prefix \"" + prefix + "\" has invalid syntax");
            }
            String uripref = this.getStringArg(2);
            String uri = lc.getHandler().getMapping().get(uripref);
            if (uri == null && lc.checkMapURI(uripref) != null) {
                uri = uripref;
            }
            if (uri == null) {
                throw new RuntimeException("Ontology with prefix/uri \"" + uripref + "\" not found");
            }
            lc.getHandler().getMapping().put(prefix, uri);
            return lc.getOntology(uri);
        }
    }

    static class FunNewOntology2
    extends BuiltInFunction {
        FunNewOntology2() {
            super("newOntology", 2, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            String prefix = this.getStringArg(1);
            String uri = this.getStringArg(2);
            if (!prefix.equals("") && !LocalContext.checkSyntax(prefix, "[_\\w][_\\d\\w-]*")) {
                throw new RuntimeException("Prefix \"" + prefix + "\" has invalid syntax");
            }
            OntologyId ont = lc.getOntology(uri);
            if (ont == null) {
                throw new RuntimeException("Failed to find/create ontology \"" + uri + "\"");
            }
            lc.getHandler().getMapping().put(prefix, uri);
            return ont;
        }
    }

    static class FunGeneratePrefixes0
    extends BuiltInFunction {
        FunGeneratePrefixes0() {
            super("generatePrefixes", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            Map<String, String> mapping = lc.getHandler().getMapping();
            mapping.putAll(NameHelper.generatePrefixes(worker, mapping));
            return OntCC.newCol().addAllTyped(mapping.keySet());
        }
    }

    static class FunPrefix0
    extends BuiltInFunction {
        FunPrefix0() {
            super("prefix", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object pfx = this.getCurrentValue();
            if (pfx instanceof OntologyId) {
                return lc.checkMapURI(lc.getWorker().name(((OntologyId)pfx).id()));
            }
            if (pfx instanceof String) {
                return lc.checkMapURI((String)pfx);
            }
            return null;
        }
    }

    static class FunPrefixes0
    extends BuiltInFunction {
        FunPrefixes0() {
            super("prefixes", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection oc = OntCC.newCol();
            BoxWorker worker = lc.getWorker();
            for (Map.Entry<String, String> entry : lc.getHandler().getMapping().entrySet()) {
                int obj = worker.write().newLWObject();
                lc.addMap(worker, obj, "prefix", entry.getKey());
                lc.addMap(worker, obj, "name", entry.getValue());
                oc.addObject(worker, obj);
            }
            return oc;
        }
    }

    static class FunOntologies0
    extends BuiltInFunction {
        FunOntologies0() {
            super("ontologies", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            int[] onts = worker.ontologies();
            OntCollection oc = OntCC.newCol();
            HashSet<String> hs = new HashSet<String>();
            Map<String, String> mapping = lc.getHandler().getMapping();
            hs.addAll(mapping.values());
            for (int o : onts) {
                String s = worker.name(o);
                hs.add(s);
            }
            oc.addAllTyped(hs);
            return oc;
        }
    }

    static class FunShort0
    extends BuiltInFunction {
        FunShort0() {
            super("short", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object cls = this.getCurrentValue();
            BoxWorker worker = lc.getWorker();
            if (cls instanceof NamedEntityId) {
                NamedEntityId n = (NamedEntityId)cls;
                int ont = worker.ontology(n.id());
                String uri = worker.name(ont);
                String name = worker.local(n.id());
                String prefix = lc.getHandler().getPrefixByURI(uri);
                if (prefix == null) {
                    throw new RuntimeException("The short name does not exist for entity " + worker.name(n.id()));
                }
                if (prefix.equals("")) {
                    return name;
                }
                return prefix + ":" + name;
            }
            if (cls instanceof OntologyId) {
                throw new RuntimeException("Ontologies do not have short names");
            }
            throw new RuntimeException("The context value must be a named entity");
        }
    }

    static class FunLocal0
    extends BuiltInFunction {
        FunLocal0() {
            super("local", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object cls = this.getCurrentValue();
            BoxWorker worker = lc.getWorker();
            if (cls instanceof NamedEntityId) {
                NamedEntityId n = (NamedEntityId)cls;
                return worker.local(n.id());
            }
            if (cls instanceof OntologyId) {
                throw new RuntimeException("Ontologies do not have local names");
            }
            throw new RuntimeException("The context value must be a named entity");
        }
    }

    static class FunName0
    extends BuiltInFunction {
        FunName0() {
            super("name", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            return lc.getWorker().name(this.entityM());
        }
    }

    static class FunRename1
    extends BuiltInFunction {
        FunRename1() {
            super("rename", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object cls = this.getCurrentValue();
            String name = this.getStringArg(1);
            BoxWorker worker = lc.getWorker();
            if (cls instanceof NamedEntityId) {
                int id = ((NamedEntityId)cls).id();
                worker.write().rename(id, worker.name(worker.ontology(id), name));
            } else if (cls instanceof OntologyId) {
                int id = ((OntologyId)cls).id();
                String oldName = worker.name(id);
                if (!oldName.equals(name)) {
                    worker.write().rename(id, name);
                    lc.getHandler().replaceMappedOntology(oldName, name);
                }
            } else {
                throw new IllegalArgumentException("Only named entities or ontology can be renamed");
            }
            return cls;
        }
    }

    static class FunGetObject1
    extends BuiltInFunction {
        FunGetObject1() {
            super("getObject", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            Object arg = this.getSingleArg(1);
            if (arg instanceof Integer) {
                int id = (Integer)arg;
                if (worker.entity(id) != Entity.ONTOBJECT) {
                    throw new IllegalArgumentException("Object with id " + id + " is not found");
                }
                return ObjectId.newId(worker, id);
            }
            if (arg instanceof String) {
                return ObjectId.newId(worker, worker.resolve((String)arg, Entity.ONTOBJECT));
            }
            throw new IllegalArgumentException("The argument value must be an object full name or an object integer identifier");
        }
    }

    static class FunGetObject0
    extends BuiltInFunction {
        FunGetObject0() {
            super("getObject", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String s;
            try {
                s = (String)this.getCurrentValue();
            }
            catch (Exception e) {
                throw new RuntimeException("The context value must be a string (an object full name)");
            }
            BoxWorker worker = lc.getWorker();
            return ObjectId.newId(worker, worker.resolve(s, Entity.ONTOBJECT));
        }
    }

    static class FunMoveAll1
    extends BuiltInFunction {
        FunMoveAll1() {
            super("moveAll", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            BoxWriter writer = worker.write();
            Integer onid = Helper.checkEntity(this.getSingleArg(1), Entity.ONTOLOGY);
            Integer obid = Helper.checkEntity(this.getCurrentValue(), Entity.ONTOBJECT);
            if (onid == null) {
                throw new RuntimeException("Ontology entity not found in the 1st argument");
            }
            if (obid == null) {
                throw new RuntimeException("Context object not found");
            }
            Integer oold = worker.ontology(obid);
            HashSet<Integer> cloud = new HashSet<Integer>();
            HashSet<Integer> tohandle = new HashSet<Integer>();
            tohandle.add(obid);
            while (!tohandle.isEmpty()) {
                Iterator i$ = tohandle.iterator();
                while (i$.hasNext()) {
                    int[] values;
                    int elem = (Integer)i$.next();
                    tohandle.remove(elem);
                    if (cloud.contains(elem)) continue;
                    cloud.add(elem);
                    for (int val : values = worker.objects(elem)) {
                        if (worker.ontology(val) != oold.intValue()) continue;
                        tohandle.add(val);
                    }
                }
            }
            HashMap<Integer, Integer> oldnew = new HashMap<Integer, Integer>();
            Iterator i$ = cloud.iterator();
            while (i$.hasNext()) {
                String[] annames;
                int[] oprops;
                int[] tprops;
                int[] classes;
                int elem = (Integer)i$.next();
                Integer nob = Helper.createAnonym(writer, elem);
                if (nob == null) {
                    throw new RuntimeException("Failed to create a new object in ontology " + worker.name(onid));
                }
                for (int cl : classes = worker.classesDirect(elem)) {
                    writer.addObjectClass(nob, cl);
                }
                for (int tp : tprops = worker.tprops(elem)) {
                    String[] vals;
                    for (String val : vals = worker.strings(elem, tp)) {
                        writer.addString((int)nob, tp, val);
                    }
                }
                for (int op : oprops = worker.oprops(elem)) {
                    int[] vals;
                    for (int val : vals = worker.objects(elem, op)) {
                        if (cloud.contains(val)) {
                            val = (Integer)oldnew.get(val);
                        }
                        writer.addObject(nob, op, val);
                    }
                }
                for (String key : annames = worker.annames(elem)) {
                    String val = worker.anno(elem, key);
                    writer.annotate(nob, key, val);
                }
                oldnew.put(elem, nob);
            }
            i$ = cloud.iterator();
            while (i$.hasNext()) {
                int[] owners;
                int elem = (Integer)i$.next();
                for (int owner : owners = worker.owners(elem)) {
                    int[] oprops;
                    if (cloud.contains(owner)) continue;
                    for (int oprop : oprops = worker.oprops(owner)) {
                        int[] values = worker.objects(owner, oprop);
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] != elem) continue;
                            writer.removeValue(owner, oprop, i);
                            writer.addObject(owner, oprop, i, (Integer)oldnew.get(elem));
                        }
                    }
                    writer.delete(elem);
                }
            }
            return ObjectId.newId(worker, (Integer)oldnew.get(obid));
        }
    }

    static class FunMove1
    extends BuiltInFunction {
        FunMove1() {
            super("move", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            BoxWriter writer = worker.write();
            Integer onid = Helper.checkEntity(this.getSingleArg(1), Entity.ONTOLOGY);
            Integer obid = Helper.checkEntity(this.getCurrentValue(), Entity.ONTOBJECT);
            if (onid == null) {
                throw new RuntimeException("Ontology entity not found in the 1st argument of move/1");
            }
            if (obid == null) {
                throw new RuntimeException("Context object not found in move/1");
            }
            if (onid.intValue() == worker.ontology(obid)) {
                return this.getCurrentValue();
            }
            Integer nob = Helper.createAnonym(writer, onid);
            if (nob == null) {
                throw new RuntimeException("Failed to create a new object in ontology " + worker.name(onid));
            }
            for (int cl : worker.classesDirect(obid)) {
                writer.addObjectClass(nob, cl);
            }
            for (int tp : worker.tprops(obid)) {
                for (String val : worker.strings(obid, tp)) {
                    writer.addString((int)nob, tp, val);
                }
            }
            for (int op : worker.oprops(obid)) {
                for (int val : worker.objects(obid, op)) {
                    writer.addObject(nob, op, val);
                }
            }
            for (String key : worker.annames(obid)) {
                String string = worker.anno(obid, key);
                if (string == null) continue;
                writer.annotate(nob, key, string);
            }
            for (int owner : worker.owners(obid)) {
                for (int oprop : worker.oprops(owner)) {
                    int[] values = worker.objects(owner, oprop);
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] != obid) continue;
                        writer.removeValue(owner, oprop, i);
                        writer.addObject(owner, oprop, i, nob);
                    }
                }
            }
            writer.delete(obid);
            return ObjectId.newId(worker, nob);
        }
    }

    static class FunClone1
    extends BuiltInFunction {
        FunClone1() {
            super("clone", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            BoxWriter writer = worker.write();
            Integer onid = Helper.checkEntity(this.getSingleArg(1), Entity.ONTOLOGY);
            Integer obid = Helper.checkEntity(this.getCurrentValue(), Entity.ONTOBJECT);
            if (onid == null) {
                throw new RuntimeException("Ontology entity not found in the 1st argument of move/1");
            }
            if (obid == null) {
                throw new RuntimeException("Context object not found in move/1");
            }
            Integer nob = Helper.createAnonym(writer, onid);
            if (nob == null) {
                throw new RuntimeException("Failed to create a new object in ontology " + worker.name(onid));
            }
            for (int cl : worker.classesDirect(obid)) {
                writer.addObjectClass(nob, cl);
            }
            for (int tp : worker.tprops(obid)) {
                for (String val : worker.strings(obid, tp)) {
                    writer.addString((int)nob, tp, val);
                }
            }
            for (int op : worker.oprops(obid)) {
                for (int val : worker.objects(obid, op)) {
                    writer.addObject(nob, op, val);
                }
            }
            for (String key : worker.annames(obid)) {
                String string = worker.anno(obid, key);
                if (string == null) continue;
                writer.annotate(nob, key, string);
            }
            return ObjectId.newId(worker, nob);
        }
    }

    static class FunInstanceof1
    extends BuiltInFunction {
        FunInstanceof1() {
            super("instanceof", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object obj = this.getCurrentValue();
            Integer oid = Helper.checkEntity(obj, Entity.ONTOBJECT);
            Integer cid = Helper.checkEntity(this.getSingleArg(1), Entity.ONTCLASS);
            if (cid == null) {
                throw new RuntimeException("The 1st argument must be a class entity in instanceof/1");
            }
            if (RHelper.isInstanceOf(lc.getWorker(), oid, cid)) {
                return obj;
            }
            return null;
        }
    }

    static class FunEntity0
    extends BuiltInFunction {
        FunEntity0() {
            super("entity", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            return Helper.getEntityById(lc, lc.getWorker().id(this.stringM()), null);
        }
    }

    static class FunEntity1
    extends BuiltInFunction {
        FunEntity1() {
            super("entity", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            return Helper.getEntityById(lc, worker.id(worker.name(this.ontologyM(1), this.stringM())), null);
        }
    }
}

