/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.getchar;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.ontobox.libretto.getchar.Position;
import org.ontobox.libretto.getchar.Stream;

public class CharStream {
    private final Stream stream;
    public char ch;
    private StringBuilder sbld;
    private Reader reader;
    private boolean segments;
    public String collectbuffer;

    private CharStream(Stream stream) {
        this.stream = stream;
        this.sbld = new StringBuilder();
        this.segments = false;
    }

    public static CharStream createCharStream() {
        return CharStream.createCharStream(new StringReader(""));
    }

    private static CharStream createCharStream(Reader reader) {
        return new CharStream(new Stream(reader, false));
    }

    public void rewindCharStream(Reader reader) {
        this.setReader(reader, "", true);
        this.reader = reader;
    }

    public void rewindCharStreamNoEat(Reader reader) {
        this.setReader(reader, "", false);
        this.reader = reader;
    }

    public void rewindString(String string) {
        StringReader rd = new StringReader(string);
        this.rewindCharStream(new StringReader(string));
        this.reader = rd;
    }

    public void rewindStringNoEat(String string) {
        StringReader rd = new StringReader(string);
        this.rewindCharStreamNoEat(new StringReader(string));
        this.reader = rd;
    }

    public void rewindFile(String file) {
        InputStreamReader r;
        try {
            r = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.rewindCharStream(r);
        this.reader = r;
    }

    void setReader(Reader reader, String readerName, boolean eat) {
        this.stream.setNewReader(reader, "");
        this.reader = reader;
        if (eat) {
            do {
                this.stream.ch = this.stream.next();
            } while (this.stream.ch <= ' ' || this.stream.ch == '\u00a0');
        } else {
            this.stream.ch = this.stream.next();
        }
        this.ch = this.stream.ch;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getPosition() {
        Position p = this.fixPos();
        return p.showPosition();
    }

    public void setExtbuffer(StringBuilder sb) {
        this.stream.setExtbuffer(sb);
    }

    public void close() {
        try {
            this.stream.reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close input stream: " + e.getMessage());
        }
    }

    public void next() {
        this.ch = this.stream.next();
    }

    public void nextChk() {
        this.sbld.setLength(0);
        this.ch = this.stream.next();
        if (this.isEndOfStream()) {
            throw new RuntimeException("Unexpected end of stream" + new Position(this.stream).showPosition());
        }
    }

    public void nextValid() {
        this.ch = this.stream.next();
        this.eatSpaces();
    }

    public void nextValidChk() {
        this.ch = this.stream.next();
        this.eatSpacesChk();
    }

    public void eatSpacesChk() {
        this.eatSpaces();
        if (this.isEndOfStream()) {
            throw new RuntimeException("Unexpected end of stream" + new Position(this.stream).showPosition());
        }
    }

    public void eatSpaces() {
        this.sbld.setLength(0);
        while ((this.ch <= ' ' || this.isNoBreakSpace()) && !this.isEndOfStream()) {
            this.sbld.append(this.ch);
            this.ch = this.stream.next();
        }
    }

    public StringBuilder getEaten() {
        return this.sbld;
    }

    public void skipLine() {
        while (this.ch != '\n' && !this.isEndOfStream()) {
            this.ch = this.stream.next();
        }
        this.eatSpaces();
    }

    public String collectLine() {
        StringBuilder sb = new StringBuilder();
        while (this.ch != '\n' && !this.isEndOfStream()) {
            this.ch = this.stream.next();
            sb.append(this.ch);
        }
        this.eatSpaces();
        return sb.toString();
    }

    public boolean isLeftAngle() {
        return this.ch == '<';
    }

    public boolean isNotValid() {
        return this.ch <= ' ' || this.isNoBreakSpace();
    }

    public boolean isRightAngle() {
        return this.ch == '>';
    }

    public boolean isLeftPr() {
        return this.ch == '(';
    }

    public boolean isRightPr() {
        return this.ch == ')';
    }

    public boolean isEquality() {
        return this.ch == '=';
    }

    public boolean isSlash() {
        return this.ch == '/';
    }

    boolean isDot() {
        return this.ch == '.';
    }

    public boolean isQuote() {
        return this.ch == '\'';
    }

    public boolean isDoubleQuote() {
        return this.ch == '\"';
    }

    public boolean isNewLine() {
        return this.ch == '\n';
    }

    public boolean isReturn() {
        return this.ch == '\r';
    }

    public boolean isTab() {
        return this.ch == '\t';
    }

    public boolean isEndOfStream() {
        return this.ch == '\u0000' || this.ch == '\uffff';
    }

    public static boolean isEndOfStream(int ch) {
        return ch == 0 || ch == -1;
    }

    boolean isLetter() {
        return Character.isLetter(this.ch);
    }

    public boolean isLowerCase() {
        return Character.isLowerCase(this.ch);
    }

    public boolean isUpperCase() {
        return Character.isUpperCase(this.ch);
    }

    public boolean isDigit() {
        return Character.isDigit(this.ch);
    }

    public boolean isOctDigit() {
        return Character.isDigit(this.ch) && this.ch < '8';
    }

    public boolean isHexDigit() {
        return Character.isDigit(this.ch) || Character.toLowerCase(this.ch) >= 'a' && Character.toLowerCase(this.ch) <= 'f';
    }

    public boolean isLetterOrDigitOrSub() {
        return Character.isLetterOrDigit(this.ch) || this.ch == '_';
    }

    public boolean isMinus() {
        return this.ch == '-';
    }

    boolean isLetterOrDigitOrMinus() {
        return Character.isLetterOrDigit(this.ch) || this.isMinus();
    }

    public boolean isLeftCurly() {
        return this.ch == '{';
    }

    public boolean isRightCurly() {
        return this.ch == '}';
    }

    public boolean isExclaim() {
        return this.ch == '!';
    }

    public boolean isSpace() {
        return this.ch == ' ';
    }

    boolean isNoBreakSpace() {
        return this.ch == '\u00a0';
    }

    public boolean isBackSlash() {
        return this.ch == '\\';
    }

    public boolean isStick() {
        return this.ch == '|';
    }

    public boolean isLeftSquare() {
        return this.ch == '[';
    }

    public boolean isRightSquare() {
        return this.ch == ']';
    }

    boolean isSub() {
        return this.ch == '_';
    }

    public boolean isSuper() {
        return this.ch == '^';
    }

    public boolean isAmp() {
        return this.ch == '&';
    }

    public boolean isPercent() {
        return this.ch == '%';
    }

    public boolean isSharp() {
        return this.ch == '#';
    }

    public boolean isDollar() {
        return this.ch == '$';
    }

    public boolean isComma() {
        return this.ch == ',';
    }

    public boolean isSemicolon() {
        return this.ch == ';';
    }

    public boolean isColon() {
        return this.ch == ':';
    }

    public boolean isSymbol() {
        return this.ch == '!' || this.ch == '#' || this.ch == '$' || this.ch == '&' || this.ch == '*' || this.ch == '+' || this.ch == '-' || this.ch == '/' || this.ch == '<' || this.ch == '=' || this.ch == '>' || this.ch == '?' || this.ch == '@' || this.ch == '%' || this.ch == '~' || this.ch == ':' || this.ch == '|' || this.ch == '\\';
    }

    public boolean isSingleSymbol() {
        return this.ch == ',' || this.ch == ';' || this.ch == '(' || this.ch == ')' || this.ch == '[' || this.ch == ']' || this.ch == '{' || this.ch == '}' || this.ch == '^';
    }

    public boolean isNextNameLetter() {
        return Character.isLetterOrDigit(this.ch) || this.isSub();
    }

    public boolean isXMLNextNameLetter() {
        return this.isLetterOrDigitOrMinus() || this.isSub();
    }

    public boolean isFirstNameLetter() {
        return this.isLetter() || this.isSub();
    }

    public boolean isXMLFirstNameLetter() {
        return this.isLetter() || this.isSub();
    }

    Position fixPos() {
        return new Position(this.stream);
    }

    public Object getNumber() {
        int i;
        StringBuilder identChars = new StringBuilder();
        int n = 0;
        do {
            identChars.append(this.ch);
            this.next();
            ++n;
        } while (this.isDigit());
        this.eatSpaces();
        long num = 0L;
        for (i = 0; i < n; ++i) {
            num = num * 10L + (long)Character.digit(identChars.charAt(i), 10);
        }
        identChars = new StringBuilder();
        if (this.isDot()) {
            this.next();
            n = 0;
            while (this.isDigit()) {
                identChars.append(this.ch);
                this.next();
                ++n;
            }
            long nom = num;
            long div = 1L;
            for (i = 0; i < n; ++i) {
                nom = nom * 10L + (long)Character.digit(identChars.charAt(i), 10);
                div *= 10L;
            }
            this.eatSpaces();
            return (double)nom / (double)div;
        }
        if (num < Integer.MAX_VALUE) {
            return (int)num;
        }
        return num;
    }

    public String[] getQName() {
        StringBuilder nameChars = new StringBuilder();
        nameChars.setLength(0);
        String nsprefix = null;
        do {
            nameChars.append(this.ch);
            this.next();
            if (!this.isColon() || nsprefix != null || nameChars.length() <= 0) continue;
            this.next();
            nsprefix = nameChars.toString();
            nameChars.delete(0, nameChars.length());
            if (this.isFirstNameLetter()) continue;
            throw new RuntimeException("Something wrong in id \"" + nsprefix + ":\"");
        } while (this.isNextNameLetter() || this.isColon());
        this.eatSpaces();
        String name = nameChars.toString();
        return new String[]{nsprefix, name};
    }

    public String[] getXMLQName() {
        StringBuilder nameChars = new StringBuilder();
        nameChars.setLength(0);
        String nsprefix = null;
        do {
            nameChars.append(this.ch);
            this.next();
            if (!this.isColon() || nsprefix != null || nameChars.length() <= 0) continue;
            this.next();
            nsprefix = nameChars.toString();
            nameChars.delete(0, nameChars.length());
            if (this.isXMLFirstNameLetter()) continue;
            throw new RuntimeException("Something wrong in id \"" + nsprefix + ":\"");
        } while (this.isXMLNextNameLetter() || this.isColon());
        this.eatSpaces();
        String name = nameChars.toString();
        return new String[]{nsprefix, name};
    }

    public String getName() {
        if (!this.isFirstNameLetter()) {
            throw new RuntimeException("Name not found");
        }
        StringBuilder nameChars = new StringBuilder();
        nameChars.setLength(0);
        do {
            nameChars.append(this.ch);
            this.nextChk();
        } while (this.isNextNameLetter() || this.isColon());
        this.eatSpaces();
        return nameChars.toString();
    }

    public String getString() {
        return (String)this.getString(false);
    }

    Object getString(boolean checkType) {
        char delim = '\"';
        if (this.isQuote()) {
            delim = '\'';
        }
        boolean isNumber = true;
        boolean isDotted = false;
        StringBuilder sb = new StringBuilder();
        this.nextChk();
        while (this.ch != delim) {
            sb.append(this.ch);
            if (isNumber && !this.isDigit() && !this.isMinus()) {
                if (this.isDot()) {
                    if (isDotted) {
                        isNumber = false;
                    } else {
                        isDotted = true;
                    }
                } else {
                    isNumber = false;
                }
            }
            this.nextChk();
            if (!this.isMinus()) continue;
            isNumber = false;
        }
        String s = sb.toString();
        this.nextValidChk();
        if (isNumber && checkType) {
            if (isDotted) {
                return Double.valueOf(s);
            }
            return Integer.valueOf(s);
        }
        return s;
    }

    public boolean areSegments() {
        return this.segments;
    }

    public void setSegments(boolean s) {
        this.segments = s;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StringBuilder getQuoteBrackets(char delim) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            block11: {
                if (this.ch == '\u00bb') {
                    if (delim != '\u00bb') {
                        throw new RuntimeException("Misplaced '\u00bb' in quote-bracket string");
                    }
                    return sb;
                }
                if (this.ch == '\u00ab') {
                    this.nextChk();
                    sb.append('\u00ab');
                    sb.append((CharSequence)this.getQuoteBrackets('\u00bb'));
                    sb.append('\u00bb');
                } else if (this.ch == delim) {
                    this.nextChk();
                    if (this.ch == '^') {
                        return sb;
                    }
                    sb.append(delim);
                    if (this.ch == delim) continue;
                    sb.append(this.ch);
                } else {
                    if (this.ch == '^') {
                        this.nextChk();
                        if (this.ch == delim) {
                            this.nextChk();
                            sb.append("^");
                            sb.append(delim);
                            sb.append((CharSequence)this.getQuoteBrackets(delim));
                            sb.append(delim);
                            sb.append("^");
                            break block11;
                        } else {
                            sb.append('^');
                            continue;
                        }
                    }
                    sb.append(this.ch);
                }
            }
            this.nextChk();
        }
    }

    public StringBuilder getFxStringSegment(char delim) {
        StringBuilder sb = new StringBuilder();
        int startshift = this.stream.posNum;
        int endshift = 0;
        int dcounter = 0;
        boolean multiline = false;
        if (this.segments) {
            if (this.ch == delim) {
                this.nextChk();
                return sb;
            }
            while (true) {
                if (this.ch == '\\') {
                    this.nextChk();
                    if (this.ch == '\\' || this.ch == '{' || this.ch == '\'' || this.ch == '\"' || this.ch == '!') {
                        sb.append(this.ch);
                        this.nextChk();
                        continue;
                    }
                    throw new RuntimeException("Undefined scaping sequence '\\" + this.ch + "' in the parametrized string");
                }
                if (this.ch == '{') {
                    return sb;
                }
                if (this.ch == delim) {
                    this.nextChk();
                    if (this.ch == '!') {
                        return sb;
                    }
                    sb.append(delim);
                    sb.append(this.ch);
                    this.nextChk();
                    continue;
                }
                sb.append(this.ch);
                this.nextChk();
            }
        }
        if (this.ch == delim) {
            this.nextChk();
            if (this.ch == delim) {
                this.nextChk();
                multiline = true;
            } else {
                this.eatSpaces();
                return sb;
            }
        }
        block11: while (!(dcounter >= 3 || this.ch == '{' && this.segments)) {
            block52: {
                int i;
                block51: {
                    if (this.ch != '\\') break block51;
                    this.nextChk();
                    switch (this.ch) {
                        case '\"': 
                        case '\'': 
                        case '\\': 
                        case '{': 
                        case '}': {
                            sb.append(this.ch);
                            break block52;
                        }
                        case 'b': {
                            sb.append("\b");
                            break block52;
                        }
                        case 'n': {
                            sb.append("\n");
                            break block52;
                        }
                        case 'f': {
                            sb.append("\f");
                            break block52;
                        }
                        case 'r': {
                            sb.append("\r");
                            break block52;
                        }
                        case 't': {
                            sb.append("\t");
                            break block52;
                        }
                        case 'u': {
                            int b = 0;
                            this.nextChk();
                            for (i = 0; this.isHexDigit() && i < 4; ++i) {
                                this.ch = Character.toLowerCase(this.ch);
                                if (this.ch >= 'a' && this.ch <= 'f') {
                                    this.ch = (char)(this.ch - 39);
                                }
                                b = b * 16 + (this.ch - 48);
                                this.nextChk();
                            }
                            if (b < 0 || b > 65535 || i < 4) {
                                throw new RuntimeException("An illegal hexadecimal unicode character");
                            }
                            sb.append((char)b);
                            continue block11;
                        }
                        case 'x': {
                            int b = 0;
                            this.nextChk();
                            for (i = 0; this.isHexDigit() && i < 2; ++i) {
                                this.ch = Character.toLowerCase(this.ch);
                                if (this.ch >= 'a' && this.ch <= 'f') {
                                    this.ch = (char)(this.ch - 39);
                                }
                                b = b * 16 + (this.ch - 48);
                                this.nextChk();
                            }
                            if (b < 0 || b > 255 || i < 2) {
                                throw new RuntimeException("An illegal byte specified in hexadecimal");
                            }
                            sb.append((char)b);
                            continue block11;
                        }
                        default: {
                            int b;
                            if (this.isOctDigit()) {
                                b = 0;
                                for (i = 0; this.isOctDigit() && i < 3; ++i) {
                                    b = b * 8 + (this.ch - 48);
                                    this.nextChk();
                                }
                                if (b < 0 || b > 255 || i < 3) {
                                    throw new RuntimeException("An illegal string byte specified in octal");
                                }
                                sb.append((char)b);
                                continue block11;
                            }
                            throw new RuntimeException("Invalid escape sequence '\\" + this.ch + "'");
                        }
                    }
                }
                if (!(this.ch != '\n' && this.ch != '\r' || multiline)) {
                    throw new RuntimeException("End of line in non-multiline string \"" + sb.toString() + "\"");
                }
                if (multiline && this.ch == delim) {
                    if (dcounter == 0) {
                        endshift = this.stream.posNum;
                    }
                    ++dcounter;
                } else {
                    if (this.ch == delim && !multiline) {
                        this.nextValid();
                        break;
                    }
                    for (i = 0; i < dcounter; ++i) {
                        sb.append(delim);
                    }
                    dcounter = 0;
                    sb.append(this.ch);
                }
            }
            this.nextChk();
        }
        this.eatSpaces();
        if (multiline && startshift > 0) {
            int i;
            if (endshift - 2 < startshift) {
                startshift = endshift - 2;
            }
            boolean cantrim = true;
            int cnt = 0;
            ArrayList<Integer> holes = new ArrayList<Integer>();
            if (startshift > 0) {
                for (i = 0; i < sb.length(); ++i) {
                    if (sb.charAt(i) == '\n' || sb.charAt(i) == '\r') {
                        holes.add(i);
                        cnt = 0;
                        continue;
                    }
                    if (!Character.isWhitespace(sb.charAt(i)) && cnt <= startshift) {
                        cantrim = false;
                        break;
                    }
                    ++cnt;
                }
            } else {
                cantrim = false;
            }
            if (cantrim) {
                char c;
                for (i = holes.size() - 1; i >= 0; --i) {
                    char c2;
                    int pos = (Integer)holes.get(i) + 1;
                    for (cnt = 0; cnt < startshift && pos < sb.length() && cnt < startshift && Character.isWhitespace(c2 = sb.charAt(pos)) && c2 != '\n' && c2 != '\r'; ++cnt) {
                        sb.deleteCharAt(pos);
                    }
                }
                cantrim = false;
                for (i = 0; i < sb.length() && Character.isWhitespace(c = sb.charAt(i)); ++i) {
                    if (c != '\n' && c != '\r') continue;
                    cantrim = true;
                    break;
                }
                if (cantrim) {
                    while (sb.charAt(0) != '\n' && sb.charAt(0) == '\r') {
                        sb.deleteCharAt(0);
                    }
                    sb.deleteCharAt(0);
                }
            }
        }
        return sb;
    }

    public void setCollectBuffer() {
        this.stream.setCollectBuffer();
    }

    public String getCollectBuffer() {
        String s = this.stream.getCollectBuffer();
        s = s.substring(0, s.lastIndexOf(59) + 1);
        return s;
    }

    public int getFilePos() {
        return this.stream.filePos;
    }
}

