/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.helper;

import java.util.Collections;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.OntCollection;

public class JsonHelper {
    public static String toJsonString(BoxWorker worker, Object val) {
        return JSONValue.toJSONString((Object)JsonHelper.toJson(worker, val));
    }

    protected static Object toJson(BoxWorker worker, Object val) {
        if (val instanceof OntCollection) {
            OntCollection collection = (OntCollection)val;
            if (collection.isEmpty()) {
                return new JSONObject();
            }
            if (collection.size() == 1) {
                return JsonHelper.toJson(worker, collection.get(0));
            }
            JSONArray ret = new JSONArray();
            for (Object o : collection) {
                ret.add(JsonHelper.toJson(worker, o));
            }
            return ret;
        }
        if (val instanceof String[]) {
            String[] array = (String[])val;
            if (array.length == 0) {
                return new JSONObject();
            }
            if (array.length == 1) {
                return JsonHelper.toJson(worker, array[0]);
            }
            JSONArray ret = new JSONArray();
            Collections.addAll(ret, array);
            return ret;
        }
        if (val instanceof int[]) {
            int[] array = (int[])val;
            if (array.length == 0) {
                return new JSONObject();
            }
            if (array.length == 1) {
                return JsonHelper.toJson(worker, ObjectId.newId(worker, array[0]));
            }
            JSONArray ret = new JSONArray();
            for (int i : array) {
                ret.add(JsonHelper.toJson(worker, ObjectId.newId(worker, i)));
            }
            return ret;
        }
        if (val instanceof String) {
            return val;
        }
        if (val instanceof Number) {
            return val;
        }
        if (val instanceof ObjectId) {
            String key;
            Object values;
            JSONObject ret = new JSONObject();
            int id = ((ObjectId)val).id();
            for (int tprop : worker.tprops(id)) {
                values = JsonHelper.toJson(worker, worker.strings(id, tprop));
                key = MapHelper.name(worker, tprop);
                if (key == null) {
                    ret.put((Object)worker.name(tprop), values);
                    continue;
                }
                ret.put((Object)key, values);
            }
            for (int oprop : worker.oprops(id)) {
                values = JsonHelper.toJson(worker, worker.objects(id, oprop));
                key = MapHelper.name(worker, oprop);
                if (key == null) {
                    ret.put((Object)worker.name(oprop), values);
                    continue;
                }
                ret.put((Object)key, values);
            }
            return ret;
        }
        throw new IllegalStateException("Unsupported value cannot be serialized to JSON (" + String.valueOf(val) + ")");
    }
}

