/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.metalang.xml;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.metalang.EmbeddedLanguage;
import org.ontobox.libretto.parser.Token;

public class XmlEL
extends EmbeddedLanguage {
    static final String XML_URI = "http://xml.ontobox.org/";
    private static final String ENTITY_URI = XmlEL.fullName("Entity");
    private static final String ELEMENT_URI = XmlEL.fullName("Element");
    private static final String TEXT_URI = XmlEL.fullName("Text");
    private static final String ATTR_URI = XmlEL.fullName("Attr");
    private static final char selector = '|';
    private static final char bell = '\u0007';
    private static final String XML_PREFIX = "x";
    private CharStream in;
    private boolean awaken;
    private static final Map<String, Character> entities = new HashMap<String, Character>();
    ClassId elementc;
    ClassId textc;
    ClassId attrc;

    private static String fullName(String name) {
        return "http://xml.ontobox.org/#" + name;
    }

    public XmlEL(Handler handler, String prefix) {
        super("xml", handler, XML_URI, prefix);
        handler.addBuiltin(new FunToXML0());
        this.awaken = false;
    }

    @Override
    public void wakeUp(LocalContext lc) {
        this.ontology = lc.getOntology(this.namespace);
        if (!this.awaken) {
            this.awaken = true;
            this.ontology = lc.getOntology(this.namespace);
            try {
                BoxWorker worker = lc.getWorker();
                MapHelper.initIfNeed(worker);
                int map = worker.resolve("http://ontobox.org/map#Map");
                int entity = worker.write().newClass(worker.name(this.ontology.id(), "Entity"));
                worker.write().addSubclass(map, entity);
                int element = worker.write().newClass(worker.name(this.ontology.id(), "Element"));
                worker.write().addSubclass(map, element);
                int attr = worker.write().newClass(worker.name(this.ontology.id(), "Attr"));
                worker.write().addSubclass(map, attr);
                int text = worker.write().newClass(worker.name(this.ontology.id(), "Text"));
                worker.write().addSubclass(map, text);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to install embedded XML");
            }
        }
    }

    @Override
    public Object parse(LocalContext lc, Reader reader) {
        this.in = CharStream.createCharStream();
        this.in.rewindCharStream(reader);
        this.in.eatSpacesChk();
        return this.readDocument(lc);
    }

    private List readDocument(LocalContext lc) {
        if (this.in.ch != '<') {
            throw new RuntimeException("'<' not found in the opening tag");
        }
        ArrayList doc = new ArrayList();
        this.in.nextChk();
        return this.getElement(lc, doc);
    }

    private List getElement(LocalContext lc, List parent) {
        ArrayList<Object> element = new ArrayList<Object>();
        parent.add(element);
        Object name = this.getName(lc, element);
        while (this.in.ch != '>') {
            if (this.in.ch == '/') {
                this.in.nextChk();
                if (this.in.ch != '>') {
                    throw new RuntimeException("'>' not found in the void element");
                }
                element.add(null);
                return element;
            }
            this.in.eatSpacesChk();
            this.getName(lc, element);
            if (this.in.ch != '=') {
                throw new RuntimeException("'=' in the opening tag");
            }
            this.in.nextValidChk();
            if (this.in.ch == '|') {
                this.getEmbeddedOx(lc, element);
                continue;
            }
            this.getString(lc, element);
        }
        this.in.nextChk();
        this.getBody(lc, element, name);
        return element;
    }

    private void getString(LocalContext lc, List parent) {
        if (this.in.ch != '\'' && this.in.ch != '\"') {
            throw new RuntimeException("String not found in attribute value");
        }
        char delim = this.in.ch;
        this.in.nextChk();
        this.getText(lc, parent, delim);
        this.in.nextValidChk();
    }

    private void getText(LocalContext lc, List parent, char delim) {
        ArrayList<String> content = new ArrayList<String>();
        parent.add(content);
        StringBuilder sb = new StringBuilder();
        while (this.in.ch != delim || delim == '<') {
            if (this.in.ch == '&') {
                if (sb.length() > 0) {
                    content.add(sb.toString());
                    sb.setLength(0);
                }
                this.getEntity(content);
                continue;
            }
            if (this.in.ch == '|') {
                if (sb.length() > 0) {
                    content.add(sb.toString());
                    sb.setLength(0);
                }
                this.getEmbeddedOx(lc, content);
                continue;
            }
            if ((this.in.ch == '\n' || this.in.ch == '\r') && delim != '<') {
                throw new RuntimeException("XML parser: invalid new line in the string");
            }
            if (this.in.ch == '<' && delim == '<') {
                this.in.nextChk();
                if (sb.length() > 0) {
                    content.add(sb.toString());
                    sb.setLength(0);
                }
                if (this.in.ch == '/') {
                    this.in.nextChk();
                    break;
                }
                this.getElement(lc, content);
                this.in.nextChk();
                continue;
            }
            sb.append(this.in.ch);
            this.in.nextChk();
        }
        if (sb.length() > 0) {
            content.add(sb.toString());
        }
    }

    private void getBody(LocalContext lc, List parent, Object opening) {
        this.getText(lc, parent, '<');
        if (this.in.ch == '>') {
            if (!(opening instanceof Token)) {
                throw new RuntimeException("'</>' can be used only in elements with parametrized names");
            }
        } else if (this.in.isFirstNameLetter()) {
            if (opening instanceof Token) {
                throw new RuntimeException("'</>' not found as the closing tag of the parametrized element");
            }
            String closing = this.readName();
            if (!closing.equals(opening)) {
                throw new RuntimeException("The closing tag name does not correspond to the opening tag name (\"" + opening + "\" and \"" + closing + "\")");
            }
            if (this.in.ch != '>') {
                throw new RuntimeException("'>' not found in the closing tag");
            }
        }
    }

    private Object getName(LocalContext lc, List parent) {
        Object name;
        if (this.in.ch == '|') {
            name = this.getEmbeddedOx(lc, parent);
            this.in.eatSpacesChk();
        } else {
            name = this.readName();
            parent.add(name);
        }
        return name;
    }

    private String readName() {
        if (!this.in.isFirstNameLetter()) {
            throw new RuntimeException("XML element id not found");
        }
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(this.in.ch);
            this.in.nextChk();
        } while (this.in.isNextNameLetter());
        this.in.eatSpacesChk();
        return sb.toString();
    }

    private Object getEmbeddedOx(LocalContext lc, List parent) {
        Token code;
        try {
            code = this.getCode(lc, XmlEL.readToStick(this.in.getReader()).toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read the query language code: " + e.getMessage());
        }
        this.in.nextChk();
        if (parent != null) {
            parent.add(code);
        }
        return code;
    }

    private Object getEntity(List parent) {
        char ch;
        StringBuilder sb = new StringBuilder();
        this.in.nextChk();
        int radix = 0;
        if (this.in.ch == '#') {
            this.in.nextChk();
            if (this.in.ch == 'x') {
                radix = 16;
                this.in.nextChk();
            } else {
                radix = 10;
            }
        }
        while (this.in.ch != ';') {
            if (this.in.ch == '\n' || this.in.ch == '\r') {
                throw new RuntimeException("XML parser: invalid &...;");
            }
            sb.append(this.in.ch);
            this.in.nextChk();
        }
        this.in.nextChk();
        String str = sb.toString();
        if (radix > 0) {
            try {
                ch = (char)Integer.parseInt(str, radix);
            }
            catch (Exception e) {
                throw new RuntimeException("XML parser: invalid &...;");
            }
        } else if (entities.containsKey(str)) {
            ch = entities.get(str).charValue();
        } else {
            throw new RuntimeException("XML parser: invalid &...;");
        }
        str = String.valueOf(ch);
        parent.add(str);
        return str;
    }

    private Token getCode(LocalContext lc, String code) {
        return this.qlParse(lc, new StringReader(code));
    }

    private static ClassId classId(BoxWorker worker, OntologyId ont, String shortName) {
        return ClassId.newId(worker.id(worker.name(ont.id(), shortName)));
    }

    private static ObjectId objectId(BoxWorker worker, OntologyId ont, ClassId cl) {
        BoxWriter writer = worker.write();
        int obj = writer.newObject(writer.newName(ont.id()));
        writer.addObjectClass(obj, cl.id());
        return ObjectId.newId(worker, obj);
    }

    @Override
    public OntCollection execute(LocalContext lc, Object code, OntCollection context) {
        List list = (List)code;
        this.ontology = lc.getOntology(this.namespace);
        this.elementc = XmlEL.classId(lc.getWorker(), this.ontology, "Element");
        this.textc = XmlEL.classId(lc.getWorker(), this.ontology, "Text");
        this.attrc = XmlEL.classId(lc.getWorker(), this.ontology, "Attr");
        return OntCC.singleton(this.createElement(lc, list, context));
    }

    private String createName(LocalContext lc, Object nameobj, Object context) {
        String name;
        if (nameobj instanceof Token) {
            Object r = this.qlExecute(lc, nameobj, context);
            if (r instanceof OntCollection) {
                if (((OntCollection)r).size() == 1) {
                    r = ((OntCollection)r).get(0);
                } else {
                    throw new RuntimeException("Ambitious or no value for xml name " + r);
                }
            }
            if (!(r instanceof String)) {
                throw new RuntimeException("Xml name must be a string");
            }
            name = (String)r;
        } else if (nameobj instanceof String) {
            name = (String)nameobj;
        } else {
            throw new RuntimeException("Something wrong in xml name");
        }
        return name;
    }

    private ObjectId createElement(LocalContext lc, List list, Object context) {
        int i = 0;
        String name = this.createName(lc, list.get(i), context);
        ++i;
        ObjectId elem = XmlEL.objectId(lc.getWorker(), this.ontology, this.elementc);
        ObjectId attr = XmlEL.objectId(lc.getWorker(), this.ontology, this.attrc);
        lc.setMapValue(elem, "attr", attr);
        lc.setMapValue(elem, "name", name);
        while (i < list.size() - 1) {
            String key = this.createName(lc, list.get(i), context);
            StringBuilder value = new StringBuilder();
            Object val = list.get(i + 1);
            if (val instanceof Token) {
                value.append(this.createName(lc, val, context));
            } else {
                for (Object o : (List)val) {
                    value.append(o.toString());
                }
            }
            lc.setMapValue(attr, key, value.toString());
            i += 2;
        }
        List contents = (List)list.get(list.size() - 1);
        if (contents != null) {
            for (Object c : contents) {
                if (c instanceof String) {
                    lc.setMapValue(elem, "content", this.getText(lc, (String)c));
                    continue;
                }
                if (c instanceof Token) {
                    Object r = this.qlExecute(lc, c, context);
                    if (r instanceof OntCollection && ((OntCollection)r).size() == 1) {
                        r = ((OntCollection)r).get(0);
                    }
                    lc.setMapValue(elem, "content", this.getText(lc, r.toString()));
                    continue;
                }
                lc.setMapValue(elem, "content", this.createElement(lc, (List)c, context));
            }
        }
        return elem;
    }

    private ObjectId getText(LocalContext lc, String text) {
        ObjectId t = XmlEL.objectId(lc.getWorker(), this.ontology, this.textc);
        lc.setMapValue(t, "text", text);
        return t;
    }

    static {
        entities.put("amp", Character.valueOf('&'));
        entities.put("lt", Character.valueOf('<'));
        entities.put("gt", Character.valueOf('>'));
        entities.put("apos", Character.valueOf('\''));
        entities.put("quot", Character.valueOf('\"'));
        entities.put("selector", Character.valueOf('|'));
    }

    class FunToXML0
    extends LibrettoFunction {
        FunToXML0() {
            super("to-xml", 0, T.ELEMENT_WISE, XmlEL.XML_URI, null);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            if (!(e instanceof ObjectId)) {
                throw new RuntimeException("The context of 'to-xml/0 must be the collection of maps");
            }
            StringBuilder sb = new StringBuilder();
            this.drawElem(lc, (ObjectId)e, sb);
            result.addAllTyped(sb.toString());
            return result;
        }

        void drawElem(LocalContext lc, ObjectId elem, StringBuilder sb) {
            BoxWorker worker = lc.getWorker();
            if (!MapHelper.isTkey(worker, elem.id(), "name")) {
                throw new RuntimeException("Element does not have key 'name' in to-xml/0");
            }
            OntCollection names = lc.getMapKeyValues(elem, "name");
            Object name = names.get(0);
            if (!(name instanceof String)) {
                throw new RuntimeException("The name value is not string in element");
            }
            sb.append('<');
            sb.append(name);
            if (MapHelper.isOkey(worker, elem.id(), "attr")) {
                sb.append(' ');
                OntCollection attrs = lc.getMapKeyValues(elem, "attr");
                Object attr = attrs.get(0);
                if (!(attr instanceof ObjectId)) {
                    throw new RuntimeException("attr not ontobject");
                }
                ObjectId a = (ObjectId)attr;
                if (!MapHelper.isMap(worker, a.id())) {
                    throw new RuntimeException("attr not map");
                }
                Collection<String> keys = lc.getAllMapTKeys(a);
                for (String key : keys) {
                    OntCollection vals = lc.getMapKeyValues(a, key);
                    String val = (String)vals.get(0);
                    sb.append(' ');
                    sb.append(key);
                    sb.append("=\"");
                    sb.append(val);
                    sb.append('\"');
                }
            }
            if (MapHelper.isOkey(worker, elem.id(), "content")) {
                sb.append('>');
                OntCollection conts = lc.getMapKeyValues(elem, "content");
                for (Object cont : conts) {
                    ObjectId ob = (ObjectId)cont;
                    if (MapHelper.isTkey(worker, ob.id(), "text")) {
                        OntCollection texts = lc.getMapKeyValues(ob, "text");
                        String text = (String)texts.get(0);
                        sb.append(text);
                        continue;
                    }
                    if (!MapHelper.isTkey(worker, ob.id(), "name")) continue;
                    this.drawElem(lc, ob, sb);
                }
                sb.append("</").append(name).append('>');
            } else {
                sb.append("/>");
            }
        }
    }
}

