/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.Property;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.box2model.BoxConnection;

public class Box2Libretto {
    Writer writer;
    Character prefix;
    final Map<String, Ontology> pr2ont;
    final Map<Ontology, String> ont2pr;
    final BoxWorker worker;

    public Box2Libretto(BoxWorker w) {
        this.worker = w;
        this.prefix = Character.valueOf('a');
        this.pr2ont = new HashMap<String, Ontology>();
        this.ont2pr = new HashMap<Ontology, String>();
    }

    public void generate(Writer w, boolean structureOnly) {
        this.writer = w;
        try {
            String classname;
            BoxConnection con = new BoxConnection(this.worker);
            Collection<Ontology> ontcol = con.getOntologies();
            HashMap class2prop = new HashMap();
            OntClass tempor = (OntClass)con.getEntity("http://ontobox.org/#Temporary");
            this.writer.append("# Ontology declarations\n\n");
            for (Ontology ontology : ontcol) {
                String onturi = ontology.getURI();
                if (onturi.equals("http://www.w3.org/2001/XMLSchema") || onturi.equals("http://ontobox.org/bxq/builtins")) continue;
                if (onturi.equals("http://ontobox.org/map")) {
                    this.ont2pr.put(ontology, String.valueOf("map"));
                    continue;
                }
                if (onturi.equals("http://ontobox.org/")) {
                    this.ont2pr.put(ontology, String.valueOf("fn"));
                    continue;
                }
                if (onturi.equals("http://ontobox.org/")) {
                    this.ont2pr.put(ontology, String.valueOf("box"));
                    continue;
                }
                if (this.prefix.charValue() > 'z') {
                    throw new RuntimeException("Too many ontologies");
                }
                this.writer.append("ontology ").append(String.valueOf(this.prefix)).append(" \"").append(onturi).append("\";\n");
                this.pr2ont.put(String.valueOf(this.prefix), ontology);
                this.ont2pr.put(ontology, String.valueOf(this.prefix));
                Character c = this.prefix;
                Character c2 = this.prefix = Character.valueOf((char)(this.prefix.charValue() + '\u0001'));
            }
            this.writer.append("\n");
            for (Map.Entry entry : this.pr2ont.entrySet()) {
                Ontology ont = (Ontology)entry.getValue();
                Collection<OntClass> classes = ont.getOntClasses();
                for (OntClass cls : classes) {
                    class2prop.put(cls, new HashSet());
                }
            }
            for (Ontology ontology : ontcol) {
                if (ontology.getURI().equals("http://ontobox.org/map")) continue;
                Collection<OProperty> coloprop = ontology.getAllOProperties();
                for (OProperty op : coloprop) {
                    ((Set)class2prop.get(op.getDomain())).add(op);
                }
                Collection<TProperty> coltprop = ontology.getAllTProperties();
                for (TProperty tp : coltprop) {
                    ((Set)class2prop.get(tp.getDomain())).add(tp);
                }
            }
            this.writer.append("\n# Class declarations\n\n");
            for (Map.Entry entry : class2prop.entrySet()) {
                classname = this.getQName((NamedEntity)entry.getKey());
                this.writer.append("class ").append(classname).append(";\n");
            }
            this.writer.append("\n\n# Class definitions\n\n");
            for (Map.Entry entry : class2prop.entrySet()) {
                classname = this.getQName((NamedEntity)entry.getKey());
                this.writer.append("class ").append(classname).append("\n{\n");
                Collection<OntClass> scs = ((OntClass)entry.getKey()).getSuperClasses();
                int num = 0;
                for (OntClass sc : scs) {
                    if (num > 0) {
                        this.writer.append(",\n");
                    }
                    this.writer.append("\t").append(this.getQName(sc));
                    ++num;
                }
                Set set = (Set)entry.getValue();
                for (Property p : set) {
                    String card;
                    Integer max;
                    Integer min;
                    if (num > 0) {
                        this.writer.append(",\n");
                    }
                    ++num;
                    if (p instanceof OProperty) {
                        OntClass range;
                        OProperty op = (OProperty)p;
                        min = op.getMinCardinality();
                        max = op.getMaxCardinality();
                        if (min == null) {
                            min = 0;
                        }
                        if (max == null) {
                            max = -1;
                        }
                        card = "";
                        if (min != 0 || max != -1) {
                            card = min != 0 ? "[" + min + "," : "[,";
                            card = max != -1 ? card + max + "] " : card + "] ";
                        }
                        String rangename = (range = op.getRange()) == null ? "" : "" + this.getQName(range);
                        String opropname = this.getQName(op);
                        this.writer.append("\t").append(opropname).append(card).append(" {").append(rangename).append("}");
                        continue;
                    }
                    TProperty tp = (TProperty)p;
                    min = tp.getMinCardinality();
                    max = tp.getMaxCardinality();
                    if (min == null) {
                        min = 0;
                    }
                    if (max == null) {
                        max = -1;
                    }
                    card = "";
                    if (min != 0 || max != -1) {
                        card = min != 0 ? "[" + min + "," : "[,";
                        card = max != -1 ? card + max + "] " : card + "] ";
                    }
                    String tpropname = this.getQName(tp);
                    Type t = tp.getRange();
                    String rangename = t == null ? "xsd:string" : "xsd:" + tp.getRange().getName();
                    this.writer.append("\t").append(tpropname).append(card).append(" {").append(rangename).append("}");
                }
                this.writer.append("\n};\n\n");
            }
            if (!structureOnly) {
                Collection<OntObject> objs;
                this.writer.append("\n\n# Object declarations\n\n");
                for (Ontology ontology : ontcol) {
                    objs = ontology.getAllOntObjects();
                    for (OntObject obj : objs) {
                        Collection<OntClass> ocs = obj.getOntClasses();
                        int num = 0;
                        for (OntClass oc : ocs) {
                            if (oc.getOntology().getURI().equals("http://ontobox.org/map") && (oc.getName().startsWith("ocl-") || oc.getName().startsWith("tcl-")) || oc.getFullName().equals("http://ontobox.org/#Temporary")) continue;
                            if (num > 0) {
                                this.writer.append(" ");
                            }
                            this.writer.append(this.getQName(oc));
                            ++num;
                        }
                        this.writer.append(" &");
                        if (obj.isInstanceOf(tempor)) {
                            this.writer.append("&");
                        }
                        this.writer.append(this.getQName(obj));
                        this.writer.append(";\n");
                    }
                }
                this.writer.append("\n\n# Object definitions\n\n");
                for (Ontology ontology : ontcol) {
                    objs = ontology.getAllOntObjects();
                    for (OntObject obj : objs) {
                        List<Object> vals;
                        Collection<TProperty> tps = obj.getAllTProperties();
                        Collection<OProperty> ops = obj.getAllOProperties();
                        if (tps.size() == 0 && ops.size() == 0) continue;
                        this.writer.append("&").append(this.getQName(obj)).append("\n{\n");
                        int num = 0;
                        for (TProperty tp : tps) {
                            try {
                                vals = obj.getTPropertyStrings(tp);
                                for (Object val : vals) {
                                    if (num > 0) {
                                        this.writer.append(",\n");
                                    }
                                    ++num;
                                    this.writer.append("\t").append(this.getMapPropName(tp)).append(" += \"").append((CharSequence)val).append("\"");
                                }
                            }
                            catch (Exception e) {
                            }
                        }
                        for (OProperty op : ops) {
                            try {
                                vals = obj.getOPropertyValues(op);
                                for (Object val : vals) {
                                    if (num > 0) {
                                        this.writer.append(",\n");
                                    }
                                    ++num;
                                    this.writer.append("\t").append(this.getQName(op)).append(" += &").append(this.getQName((NamedEntity)val));
                                }
                            }
                            catch (Exception e) {
                            }
                        }
                        this.writer.append("\n};\n\n");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getMapPropName(NamedEntity ne) {
        Ontology ont = ne.getOntology();
        String pn = ne.getName();
        if (ont.getURI().equals("http://ontobox.org/map") && (pn.startsWith("tprop-") || pn.startsWith("oprop-"))) {
            pn = pn.substring(6, pn.length());
            return pn;
        }
        return this.ont2pr.get(ne.getOntology()) + ':' + pn;
    }

    private String getQName(NamedEntity ne) {
        return this.ont2pr.get(ne.getOntology()) + ':' + ne.getName();
    }
}

