/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.util.HashMap;
import java.util.Map;
import org.meta2project.fast.adapter.FastSession;
import org.meta2project.model.Connection;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.Property;
import org.meta2project.model.Session;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.ontobox.box.exception.NotFoundException;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.getchar.NameTable;
import org.ontobox.libretto.parser.KeyWord;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public class Interpreter {
    final CharStream in = CharStream.createCharStream();
    final Session ses = new FastSession();
    final Connection con = this.ses.openConnection();
    final Map<String, Ontology> mapping;
    final Map<String, String> datatypes;
    final NameTable names = new NameTable();
    final Map<TProperty, String> tdefValues;
    final Map<OProperty, OntObject> odefValues;
    Ontology defaultOntology;
    final LocalContext konto;

    public Interpreter(LocalContext kt) {
        this.mapping = new HashMap<String, Ontology>();
        this.datatypes = new HashMap<String, String>();
        this.tdefValues = new HashMap<TProperty, String>();
        this.odefValues = new HashMap<OProperty, OntObject>();
        this.konto = kt;
        this.createDatatypes();
    }

    public void applyOntologyModifier(Token ontModifier) {
        Sequence seq = ontModifier.getSeq();
        String uri = seq.get((int)1).name;
        KeyWord modifier = KeyWord.values()[ontModifier.value];
        Ontology ont = this.getOntology(uri, modifier);
        this.mapping.put(uri, ont);
    }

    public void applyClassModifier(Token classModifier) {
        Sequence seq = classModifier.getSeq();
        Token selector = seq.get(0);
        KeyWord modifier = KeyWord.values()[classModifier.value];
        boolean create = true;
        if (selector.value == KeyWord.UPDATE.ordinal()) {
            create = false;
        }
        OntClass cl = this.getClass(selector, modifier);
        for (int i = 1; i < seq.size(); ++i) {
            Token dflt;
            NamedEntity range;
            int max;
            int min;
            Ontology ont;
            String uri;
            String name;
            Property prop;
            Token updater = seq.get(i);
            Sequence qseq = updater.getSeq();
            if (updater.type == TokenType.CLASS_NAME) {
                OntClass sup = this.getClass(updater, modifier);
                if (cl.isSubclassOf(sup)) continue;
                sup.addSubClass(cl);
                continue;
            }
            if (updater.type == TokenType.TPROP_UPDATER) {
                prop = null;
                name = qseq.get((int)0).name;
                uri = this.konto.getTokenURI(qseq.get(0));
                ont = this.getOntByURI(uri);
                min = qseq.get((int)1).value;
                max = qseq.get((int)2).value;
                range = this.getDatatype(qseq.get(3));
                prop = ont.createTProperty(name, cl, (Type)range, (Integer)min, (Integer)max);
                dflt = qseq.get(4);
                if (dflt == null) continue;
                this.tdefValues.put((TProperty)prop, dflt.toString());
                continue;
            }
            prop = null;
            name = qseq.get((int)0).name;
            uri = this.konto.getTokenURI(qseq.get(0));
            ont = this.getOntByURI(uri);
            min = qseq.get((int)1).value;
            max = qseq.get((int)2).value;
            range = this.getClass(qseq.get(3), KeyWord.UPDATE);
            prop = ont.createOProperty(name, cl, (OntClass)range, min, max);
            dflt = qseq.get(4);
            if (dflt == null) continue;
            this.odefValues.put((OProperty)prop, this.getObject(dflt, KeyWord.UPDATE));
        }
    }

    public OntObject applyObjecModifier(Token objModifier) {
        KeyWord modifier = KeyWord.values()[objModifier.value];
        Sequence seq = objModifier.getSeq();
        String name = seq.get((int)0).name;
        Ontology ont = this.getOntByURI(this.konto.getTokenURI(seq.get(0)));
        OntObject obj = this.getObject(seq.get(0), modifier);
        for (int i = 1; i < seq.size(); ++i) {
            OntClass sup;
            Token updater = seq.get(i);
            Sequence qseq = updater.getSeq();
            if (updater.type != TokenType.CLASS_NAME || obj.isInstanceOf(sup = this.getClass(updater, KeyWord.UPDATE))) continue;
            obj.addOntClass(sup);
        }
        return null;
    }

    public void applyOPropCommand(OntObject obj, OProperty prop, OntObject val, int command) {
    }

    OntObject getObject(Token objectToken, KeyWord modifier) {
        Ontology ont = this.getOntByURI(this.konto.getTokenURI(objectToken));
        String name = objectToken.name;
        OntObject obj = null;
        try {
            obj = ont.getOntObject(name);
            if (modifier == KeyWord.CREATE) {
                throw new RuntimeException("Created object " + objectToken.toString() + " already exists");
            }
        }
        catch (NotFoundException e) {
            if (modifier != KeyWord.UPDATE) {
                obj = ont.createOntObject(name, new Object[0]);
            }
            throw new RuntimeException("Object " + objectToken.toString() + " not found");
        }
        return obj;
    }

    OProperty getOProperty(Token propertyToken, OntClass domain, OntClass range, int min, int max, boolean create) {
        OProperty prop;
        block4: {
            Ontology ont = this.getOntByURI(this.konto.getTokenURI(propertyToken));
            String name = propertyToken.name;
            prop = null;
            try {
                prop = ont.getOProperty(name);
                if (!prop.getDomain().equals(domain)) {
                    throw new RuntimeException("Wrong domain for t-property " + name);
                }
                if (!prop.getRange().equals(range)) {
                    throw new RuntimeException("Wrong range for t-property " + name);
                }
            }
            catch (NotFoundException e) {
                if (!create) break block4;
                Integer imax = max > 0 ? Integer.valueOf(max) : null;
                prop = ont.createOProperty(name, domain, range, min, imax);
            }
        }
        return prop;
    }

    TProperty getTProperty(Token propertyToken, OntClass domain, Type range, int min, int max, boolean create) {
        TProperty prop;
        block4: {
            Ontology ont = this.getOntByURI(this.konto.getTokenURI(propertyToken));
            String name = propertyToken.name;
            prop = null;
            try {
                prop = ont.getTProperty(name);
                if (!prop.getDomain().equals(domain)) {
                    throw new RuntimeException("Wrong domain for t-property " + name);
                }
                if (!prop.getRange().equals(range)) {
                    throw new RuntimeException("Wrong range for t-property " + name);
                }
            }
            catch (NotFoundException e) {
                if (!create) break block4;
                Integer imax = max > 0 ? Integer.valueOf(max) : null;
                prop = ont.createTProperty(name, domain, range, (Integer)min, imax);
            }
        }
        return prop;
    }

    Type getDatatype(Token dt) {
        if (this.datatypes.containsKey(dt.name)) {
            return this.con.getTypeByFullName(this.datatypes.get(dt.name));
        }
        throw new RuntimeException("Datatype '" + dt.name + "' not found");
    }

    void createDatatypes() {
        this.datatypes.put("int", "http://ontobox.org/#int");
        this.datatypes.put("double", "http://ontobox.org/#double");
        this.datatypes.put("string", "http://ontobox.org/#string");
    }

    OntClass getClass(Token classToken, KeyWord modifier) {
        Ontology ont = this.getOntByURI(classToken.prefix);
        String name = classToken.name;
        OntClass oclass = null;
        try {
            oclass = ont.getOntClass(name);
            if (modifier == KeyWord.CREATE) {
                throw new RuntimeException("Created class " + classToken.toString() + "already exists");
            }
        }
        catch (NotFoundException e) {
            if (modifier != KeyWord.UPDATE) {
                oclass = ont.createOntClass(name, new OntClass[0]);
            }
            throw new RuntimeException("Class '" + name + "' not found in ontology '" + classToken + '\'');
        }
        return oclass;
    }

    Ontology getOntology(String uri, KeyWord modifier) {
        Ontology ont = null;
        try {
            ont = this.con.getOntology(uri);
            if (modifier == KeyWord.CREATE) {
                throw new RuntimeException("Created ontology '" + ont.getURI() + "' already exists");
            }
        }
        catch (NotFoundException e) {
            if (modifier != KeyWord.UPDATE) {
                this.con.createOntology(uri);
            }
            throw new RuntimeException("Updated ontology '" + uri + "' does not exist");
        }
        return ont;
    }

    Ontology getOntByURI(String uri) {
        if (this.mapping.containsKey(uri)) {
            return this.mapping.get(uri);
        }
        throw new RuntimeException("Ontology with URI '" + uri + "' not found");
    }
}

