/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;
import org.ontobox.libretto.LibrettoEnv;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.function.FunctionDef;
import org.ontobox.libretto.function.FunctionType;
import org.ontobox.libretto.function.StringFuncs;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.metalang.EmbeddedLanguage;
import org.ontobox.libretto.parser.Asterisk;
import org.ontobox.libretto.parser.Delimiter;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.Instruction;
import org.ontobox.libretto.parser.IterProg;
import org.ontobox.libretto.parser.KeyWord;
import org.ontobox.libretto.parser.Operation;
import org.ontobox.libretto.parser.Operator;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;
import org.ontobox.libretto.parser.Tokens;
import org.ontobox.libretto.parser.VarTable;
import org.ontobox.libretto.parser.XMLCompiler;

public class Parser {
    public static ObjectId debug;
    private final Tokens tokens;
    private Token current;
    private Token oldcurrent = null;
    private final FunctionTable functions;
    final VarTable vars;
    private final LocalContext konto;
    private int questionVarNum;
    private int questionVarNumNumber = 9;
    public int filePosition;
    public Set<String> loadnameset = null;
    private static final Token allObj;
    private static final Token tzero;
    private static final Token tinf;
    public static final Token thingType;
    public static final Pattern wordPattern;
    public static final Pattern intPattern;
    public static final Pattern prefixPattern;
    public HashMap<String, Integer> varnums;
    int varnum;
    int embeddingLevel = 0;
    String functionclass = null;
    boolean functionBody = false;
    public Map<Integer, Token> varsinanonym = null;
    private int idgencounter = 0;
    private int yields = -1;
    private Deque<StreamState> streamStack = new ArrayDeque<StreamState>();
    public static String URI_REGEXP;
    public static Pattern NEW_TYPE;
    public static String URIP_REGEXP;
    public static Pattern uripattern;
    public static Pattern urippattern;

    public Parser(LocalContext konto) {
        this.konto = konto;
        this.functions = konto.getHandler().getFunctions();
        this.vars = konto.getVars();
        this.tokens = new Tokens(konto);
    }

    public void reset(CharStream in) {
        this.tokens.setInput(in);
        this.next();
    }

    public boolean isSpecVar(Token v) {
        int value = v.value;
        return value >= 0 && value <= this.konto.getHandler().specialVarsNumber;
    }

    public void resetQuestionVarNum() {
        this.questionVarNum = 0;
    }

    public FunctionTable getFunctions() {
        return this.functions;
    }

    public final Token getQuery(Sequence seq, Token pathToken) {
        if (this.current.isQueryKw()) {
            this.next();
        }
        Sequence qseq = Parser.createToken(TokenType.QUERY_INSTR, seq, this.tokens.in);
        if (pathToken != null) {
            qseq.addToken(pathToken);
        } else {
            Token t;
            this.getPathTerm(qseq);
            Sequence s = qseq.get(0).getSeq();
            if (s.size() == 1 && s.parent.type != TokenType.QUOTED_EXP && (t = s.get(0)).getType() == TokenType.PATH_EXP) {
                seq.remove(seq.size() - 1);
                qseq = Parser.createToken(TokenType.QUERY_INSTR, seq, this.tokens.in);
                qseq.addToken(t);
            }
        }
        if (!this.current.isDelim(';')) {
            if (this.current.isEOF()) {
                return qseq.parent;
            }
            if (this.current.type == TokenType.PROP_OPERATOR) {
                throw new RuntimeException("Misplaced assignment, probably variable is not declared with 'var");
            }
            throw new RuntimeException("Invalid token '" + this.current + "'  or ';' missed in query " + this.current.getPosition());
        }
        this.next();
        return qseq.parent;
    }

    public final Token getCaseSwitch(Sequence seq) {
        Sequence qseq = Parser.createToken(TokenType.SWITCH, seq, this.tokens.in);
        Token caseswitch = qseq.parent;
        qseq.parent.type = TokenType.SWITCH;
        boolean dflt = false;
        while (!this.current.isDelim('}')) {
            if (!this.current.isWord("case")) {
                throw new RuntimeException("'case' not found in the switch expression");
            }
            this.next();
            if (this.is(TokenType.GEN_RULE)) {
                qseq.addToken(null);
                dflt = true;
            } else {
                this.getPathTerm(qseq);
                if (!this.is(TokenType.GEN_RULE)) {
                    throw new RuntimeException((Object)((Object)this.current.type) + " found instead of => in the switch " + this.current.getPosition());
                }
            }
            this.next();
            this.getObjectUpdater(qseq, false);
            if (this.current.isDelim('}') || this.current.isDelim(']')) break;
            if (dflt) {
                throw new RuntimeException("Unreachable code in the switch " + this.current.getPosition());
            }
            if (!this.current.isDelim(';')) {
                throw new RuntimeException("Neither '}' nor ';' found in the switch " + this.current.getPosition());
            }
            this.next();
        }
        this.next();
        return qseq.parent;
    }

    public final Token getAutomatum(Sequence seq) {
        Token generator;
        block25: {
            Sequence qseq = Parser.createToken(TokenType.AUTOMATA, seq, this.tokens.in);
            generator = qseq.parent;
            Token tmptoken = new Token(TokenType.AUTOMATA, 0, null);
            if (this.current.isDelim('}')) {
                throw new RuntimeException("The iteration rule for state 'start' not found " + this.current.getPosition());
            }
            if (!this.isState() || !this.current.getName().equals("start")) {
                throw new RuntimeException("Instruction for state 'start' not found " + this.current.getPosition());
            }
            IterProg ip = new IterProg();
            generator.setObj(ip);
            ip.code = new HashMap<String, List<Instruction>>();
            block0: while (true) {
                List<Object> list;
                if (!this.isState()) {
                    throw new RuntimeException("The current state of the instruction not found " + this.current.getPosition());
                }
                Instruction instr = new Instruction();
                instr.state = this.current.getName();
                instr.thesame = false;
                instr.newvalues = new Sequence(tmptoken, 1);
                if (!ip.code.containsKey(instr.state)) {
                    list = new ArrayList();
                    ip.code.put(instr.state, list);
                } else {
                    list = ip.code.get(instr.state);
                }
                list.add(instr);
                this.next();
                instr.condition = !this.is(TokenType.GEN_RULE) ? this.getPathTerm(null) : null;
                if (!this.is(TokenType.GEN_RULE)) {
                    throw new RuntimeException("Iteration rule operator '-->' not found " + this.current.getPosition());
                }
                this.next();
                if (this.isState("error")) {
                    instr.newstate = "error";
                    this.next();
                    if (this.current.isDelim(',')) {
                        this.next();
                    }
                    this.getPathTerm(instr.newvalues);
                    if (this.current.isDelim('}')) {
                        this.next();
                        break block25;
                    }
                    if (this.current.isDelim(';')) {
                        this.next();
                        continue;
                    }
                    throw new RuntimeException("Neither ';' nor '{' found in the 'error' rule " + this.current.getPosition());
                }
                if (!instr.state.equals("stop")) {
                    if (!this.isState()) {
                        throw new RuntimeException("New state constant not found in the iteration rule " + this.current.getPosition());
                    }
                    instr.newstate = this.current.getName();
                    this.next();
                    if (this.isState("same")) {
                        instr.thesame = true;
                        this.next();
                    }
                    if (this.current.isDelim('}')) {
                        this.next();
                        break block25;
                    }
                    if (this.current.isDelim(';')) {
                        this.next();
                        continue;
                    }
                    if (!this.current.isDelim(',') && instr.newstate.equals("yield")) {
                        throw new RuntimeException("misplaced 'yield'. Probably new state name missed");
                    }
                    this.getDelim(',', "sequence generator (collection-wise function)");
                } else {
                    instr.newstate = null;
                }
                while (true) {
                    if (this.isYieldKw()) {
                        Token yield = this.current;
                        this.current.type = TokenType.YIELD;
                        this.next();
                        this.getPathTerm(yield.getSeq());
                        instr.newvalues.addToken(yield);
                    } else {
                        Token tk = this.getPathTerm(instr.newvalues);
                        if (tk.type == TokenType.TERM_EXP && tk.getSeq().size() == 1) {
                            Token as = tk.getSub(0);
                            if (as.type == TokenType.ASSIGN_INSTR) {
                                tk.copyFrom(as);
                            }
                        }
                    }
                    if (this.current.isDelim('}')) {
                        this.next();
                        break block25;
                    }
                    if (this.current.isDelim(';')) {
                        this.next();
                        continue block0;
                    }
                    if (!this.current.isDelim(',')) break block0;
                    this.next();
                }
                break;
            }
            throw new RuntimeException("Neither '}' nor ';' ',' found in sequence generator");
        }
        return generator;
    }

    public final Token getObjectModifier(Sequence seq, boolean inCreator) {
        Token modifier;
        block9: {
            block10: {
                if (this.current.type == TokenType.MAP || this.current.type == TokenType.ANONYM_FUN) {
                    this.next();
                } else if (this.current.isDelim('{')) {
                    this.next();
                }
                if (this.isState("start")) {
                    return this.getAutomatum(seq);
                }
                if (this.current.isWord("case")) {
                    return this.getCaseSwitch(seq);
                }
                Sequence qseq = Parser.createToken(TokenType.OBJ_MODIFIER, seq, this.tokens.in);
                modifier = qseq.parent;
                modifier.value = 0;
                if (this.current.isDelim('}') || this.current.isDelim(']')) {
                    this.next();
                    return modifier;
                }
                do {
                    this.getObjectUpdater(qseq, inCreator);
                    if (this.current.isDelim('}') || this.current.isDelim(']')) {
                        this.next();
                        break block9;
                    }
                    if (!this.current.isDelim(';')) break block10;
                    this.next();
                } while (!this.current.isDelim('}') && !this.current.isDelim(']'));
                this.next();
                break block9;
            }
            if (this.current.isDelim(',')) {
                throw new RuntimeException("Use ';' instead of ',' in modifiers");
            }
            throw new RuntimeException("\"}\", \"]\" or \";\" was expected; \"" + this.current + "\" was found " + this.current.getPosition());
        }
        return modifier;
    }

    private void getType(List<String> argtype, List<T> argcard) {
        String type = null;
        T card = T.ELEMENT_WISE;
        BoxWorker w = this.konto.getWorker();
        if (this.current.type == TokenType.CLASS_NAME || this.current.type == TokenType.DATATYPE_NAME) {
            type = this.konto.getFullName(this.current);
            this.next();
        } else if (this.current.type == TokenType.PROP_NAME) {
            type = this.konto.getFullName(this.current);
            if (w.entity(type) != Entity.TYPE) {
                throw new RuntimeException("Invalid context type declaration (" + this.konto.getFullName(this.current) + "): not a class/type or prefix missed.");
            }
            this.next();
        }
        if (this.current.type == TokenType.OPER) {
            card = T.COLLECTION_WISE;
            this.next();
        }
        argtype.add(type);
        argcard.add(card);
    }

    public Token getFunctionDeclaration(Sequence seq, String classname, String keyword) {
        ArrayList<String> argtype = new ArrayList<String>();
        ArrayList<T> argcard = new ArrayList<T>();
        this.embeddingLevel = 1;
        this.functionBody = true;
        HashMap<String, Integer> localvarnums = this.varnums;
        this.varnums = new HashMap();
        Sequence qseq = Parser.createToken(TokenType.DECLARE_INSTR, seq, this.tokens.in);
        Token fundec = qseq.parent;
        boolean generator = this.current.isKw(KeyWord.GENERATOR);
        if (keyword.equals("def")) {
            this.next();
            if (this.current.getName().equals("_")) {
                throw new RuntimeException("Function name \"_\" is reserved for anonymous functions " + this.current.getPosition());
            }
        }
        if (classname == null) {
            this.getType(argtype, argcard);
            this.functionclass = (String)argtype.get(0);
            if (generator) {
                if (argtype.get(0) != null) {
                    throw new RuntimeException("Context type declarations are impossible in the generator definitions. Generators work with general sequences. " + this.current.getPosition());
                }
                argcard.set(0, T.COLLECTION_WISE);
            } else if (argcard.get(0) == T.COLLECTION_WISE) {
                throw new RuntimeException("Collection-wise functions must be defined as generators (started with keyword 'gen') " + this.current.getPosition());
            }
        } else {
            if (generator) {
                throw new RuntimeException("Generators can not be defined within class declarations " + this.current.getPosition());
            }
            argtype.add(classname);
            argcard.add(T.ELEMENT_WISE);
            this.functionclass = classname;
        }
        if (this.current.getType() != TokenType.FUNCTOR) {
            throw new RuntimeException("Functor not found in the function definition (" + (Object)((Object)this.current.getType()) + " found)");
        }
        if (keyword.equals("ano") && !this.current.name.equals("_")) {
            throw new RuntimeException("Superfluous function name (" + this.current.name + ") in anonymous function");
        }
        Token head = this.getFunHead(qseq, argtype, argcard);
        FunctionType ft = new FunctionType(argtype, argcard);
        if (!this.current.isDelim('{')) {
            throw new RuntimeException("Openning '{' not found in function declaration" + this.current.getPosition());
        }
        if (ft.getCard(0) == T.COLLECTION_WISE) {
            this.yields = 0;
        }
        Token modif = this.getObjectModifier(qseq, false);
        this.yields = -1;
        if (this.current.isDelim(';') && keyword.equals("def")) {
            this.getDelim(';', "function declaration (" + head.name + ')');
        }
        this.varnum = ft.getCard(0) == T.COLLECTION_WISE ? -2 : -1;
        Sequence varseq = qseq.get(0).getSeq();
        for (Token var : varseq.sequence) {
            if (this.varnums.containsKey(var.name)) {
                throw new RuntimeException("Double occurrence of variable $" + var.name + " in the function declaration head " + var.getPosition());
            }
            this.varnums.put(var.name, this.varnum);
            var.value = this.varnum--;
        }
        for (Token tk : modif.getSeq()) {
            if (tk == null) continue;
            if (tk.getType() == TokenType.ASSIGN_INSTR) {
                Token var = tk.getSub(0);
                if (!this.varnums.containsKey(var.name)) {
                    this.varnums.put(var.name, this.varnum);
                    var.value = this.varnum--;
                } else {
                    var.value = this.varnums.get(var.name);
                }
                this.funVarsChk(tk.getSub(1), this.varnums);
                continue;
            }
            if (tk.getType() == TokenType.PROPERTY_COMMAND) {
                this.funVarsChk(tk, this.varnums);
                continue;
            }
            this.funVarsChk(tk, this.varnums);
        }
        if (modif.obj instanceof IterProg) {
            Map<String, List<Instruction>> code = ((IterProg)modif.obj).code;
            List<Instruction> li = code.get("start");
            for (Instruction instr : li) {
                if (instr.condition instanceof Token) {
                    this.funVarsChk((Token)instr.condition, this.varnums);
                }
                for (Token tk : instr.newvalues) {
                    if (tk.getType() == TokenType.ASSIGN_INSTR) {
                        Token var = tk.getSub(0);
                        if (!this.varnums.containsKey(var.name)) {
                            this.varnums.put(var.name, this.varnum);
                            var.value = this.varnum--;
                        } else {
                            var.value = this.varnums.get(var.name);
                        }
                        this.funVarsChk(tk.getSub(1), this.varnums);
                        continue;
                    }
                    if (tk.type == TokenType.YIELD) {
                        this.funVarsChk(tk.getSub(0), this.varnums);
                        continue;
                    }
                    this.funVarsChk(tk, this.varnums);
                }
            }
            Set<String> lit = code.keySet();
            for (String state : lit) {
                if (state.equals("start")) continue;
                li = code.get(state);
                for (Instruction instr : li) {
                    if (instr.condition instanceof Token) {
                        this.funVarsChk((Token)instr.condition, this.varnums);
                    }
                    for (Token tk : instr.newvalues) {
                        if (tk.getType() == TokenType.ASSIGN_INSTR) {
                            Token var = tk.getSub(0);
                            if (!this.varnums.containsKey(var.name)) {
                                this.varnums.put(var.name, this.varnum);
                                var.value = this.varnum--;
                            } else {
                                var.value = this.varnums.get(var.name);
                            }
                            this.funVarsChk(tk.getSub(1), this.varnums);
                            continue;
                        }
                        if (tk.type == TokenType.YIELD) {
                            this.funVarsChk(tk.getSub(0), this.varnums);
                            continue;
                        }
                        this.funVarsChk(tk, this.varnums);
                    }
                }
            }
        }
        fundec.number = this.varnums.size();
        fundec.obj = this.varnums;
        fundec.value = this.functions.pushFunction(fundec, this.konto.getFullName(head), ft);
        this.embeddingLevel = 0;
        this.functionBody = false;
        this.functionclass = null;
        this.varnums = localvarnums;
        return fundec;
    }

    public void funVarsChk(Token tok, Map<String, Integer> varnums) {
        if (tok == null) {
            return;
        }
        if (tok.type == TokenType.DECLARE_INSTR) {
            return;
        }
        if (tok.type == TokenType.QUOTED_EXP && varnums != null) {
            tok = tok.getSub(0);
            Map varanonym = (Map)tok.getInfo();
            Iterator i$ = varanonym.keySet().iterator();
            while (i$.hasNext()) {
                int vnum = (Integer)i$.next();
                Token var = (Token)varanonym.get(vnum);
                if (!varnums.containsKey(var.name)) {
                    varnums.put(var.name, this.varnum);
                    if (this.varsinanonym != null) {
                        Token virtvar = new Token(TokenType.VAR_REF, this.varnum, null);
                        virtvar.name = var.name;
                        virtvar.obj = var.obj;
                        this.varsinanonym.put(-this.varnum, virtvar);
                    }
                    var.obj = this.varnum;
                    --this.varnum;
                    continue;
                }
                var.obj = varnums.get(var.name);
            }
        } else if (tok.type == TokenType.VAR_REF) {
            if (this.isSpecVar(tok)) {
                return;
            }
            if (!varnums.containsKey(tok.name)) {
                varnums.put(tok.name, this.varnum);
                if (this.varsinanonym != null) {
                    tok.obj = tok.value;
                    this.varsinanonym.put(-this.varnum, tok);
                }
                tok.value = this.varnum--;
            } else {
                tok.value = varnums.get(tok.name);
            }
        } else if (tok.type == TokenType.SET_FIELD) {
            if (this.isSpecVar(tok)) {
                throw new RuntimeException("System variable " + tok + " can not be a field");
            }
            String varname = tok.getName();
            if (varnums.containsKey(varname)) {
                tok.value = varnums.get(varname);
            } else {
                varnums.put(tok.name, this.varnum);
                if (this.varsinanonym != null) {
                    tok.obj = tok.value;
                    this.varsinanonym.put(-this.varnum, tok);
                }
                tok.value = this.varnum--;
            }
        } else if (tok.type == TokenType.OPER && tok.value == Operation.IN.ordinal()) {
            this.funVarsChk((Token)tok.obj, varnums);
        } else if (tok.type == TokenType.EMBEDDED_LANG) {
            List l = (List)tok.obj;
            List lt = (List)l.get(2);
            for (Token tn : lt) {
                this.funVarsChk(tn, varnums);
            }
        } else {
            Sequence s = tok.getSeq();
            for (Token t : s.sequence) {
                this.funVarsChk(t, varnums);
            }
        }
    }

    private boolean getVarAssignmentOrTerm(Sequence seq, String where) {
        if (this.current.isVar() && this.tokens.in.ch == '=') {
            this.getVar(seq, true);
            if (!this.current.isAssignment()) {
                throw new RuntimeException("Assignment operator not found in " + where + " " + this.current.getPosition());
            }
            this.next();
            this.getPathTerm(seq);
            if (this.current.isDelim(',')) {
                this.next();
            }
            return true;
        }
        this.getPathTerm(seq);
        return false;
    }

    private Token getVar(Sequence seq, boolean check) {
        Token cur;
        if (this.current.isKw(KeyWord.VARKW)) {
            check = false;
            this.next();
        }
        if (this.current.type == TokenType.PROP_NAME) {
            if (check) {
                throw new RuntimeException("Variable not found (" + this.current.name + ") " + this.current.getPosition());
            }
            if (this.current.prefix != null) {
                throw new RuntimeException("Variables with qualified names are not allowed (" + this.current + ") " + this.current.getPosition());
            }
            this.current.value = this.vars.putVar(this.current.name);
            this.current.type = TokenType.VAR_REF;
            seq.addToken(this.current);
            cur = this.current;
            this.next();
        } else if (this.current.isVar()) {
            seq.addToken(this.current);
            this.current.value = this.vars.putVar(this.current.name);
            cur = this.current;
            this.next();
        } else {
            throw new RuntimeException("Variable not found at " + this.current.getPosition());
        }
        return cur;
    }

    Token getForExpression(Sequence seq) {
        if (this.embeddingLevel == 0) {
            this.varnums = new HashMap();
        }
        ++this.embeddingLevel;
        Sequence qseq = Parser.createToken(TokenType.FOR_EXP, 0, seq, this.tokens.in);
        if (!this.current.isForKw()) {
            throw new RuntimeException("'for' keyword not found " + this.current.getPosition());
        }
        this.next();
        this.getDelim('(', "for-expression");
        this.getVar(qseq, false);
        if (!this.current.isInOp()) {
            throw new RuntimeException("operation 'in' not found in the for-expression " + this.current.getPosition());
        }
        this.next();
        this.getPathTerm(qseq);
        this.getDelim(')', "for-expression");
        while (this.getVarAssignmentOrTerm(qseq, "for-expression")) {
        }
        --this.embeddingLevel;
        if (this.embeddingLevel == 0) {
            this.funVarsChk(qseq.parent, this.varnums);
            qseq.parent.value = this.varnums.size();
        } else {
            qseq.parent.value = 0;
        }
        return qseq.parent;
    }

    void getVarAssignment(Sequence seq) {
        Sequence qseq = Parser.createToken(TokenType.ASSIGN_INSTR, seq, this.tokens.in);
        this.getVar(qseq, true);
        if (!this.current.isAssignment()) {
            throw new RuntimeException("= not found in variable assignment " + this.current.getPosition());
        }
        this.next();
        this.getPathTerm(qseq);
    }

    public static String createTempOntology(BoxWorker w) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd/HH-mm");
        String tonto = "http://temp.ontobox.org/" + f.format(new Date());
        w.write().newOntology(tonto);
        return tonto;
    }

    public Token getNamespaces(Sequence seq) {
        boolean setwasempty;
        if (this.loadnameset == null) {
            this.loadnameset = new HashSet<String>();
            setwasempty = true;
        } else {
            setwasempty = false;
        }
        Sequence qseq = Parser.createToken(TokenType.NAMESPACES, 0, seq, this.tokens.in);
        this.next();
        if (!Parser.isString(this.current)) {
            throw new RuntimeException("Non-string parameter in namespases operator" + this.current.getPosition());
        }
        qseq.addToken(this.current);
        String progname = (String)this.current.getObj();
        if (this.loadnameset.contains(progname)) {
            throw new RuntimeException("Loop in loading " + progname + this.current.getPosition());
        }
        this.loadnameset.add(progname);
        Token prog = new Token(TokenType.PROGRAM, 0, null);
        CharStream in = CharStream.createCharStream();
        this.konto.pushIn1(in);
        try {
            InputStream is = Helper.getProtocolStream(progname);
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, "utf-8"));
            in.rewindCharStream(rd);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not open namespaces resource " + progname + " " + e.getMessage());
        }
        boolean currentonlynamespaces = this.konto.getHandler().onlynamespaces;
        this.konto.getHandler().onlynamespaces = true;
        Map<String, String> m = this.konto.getHandler().setNewMapping();
        try {
            this.konto.getHandler().execute(prog, this.konto, in).iterator();
        }
        catch (Exception e) {
            this.konto.getHandler().onlynamespaces = currentonlynamespaces;
            in.close();
            this.konto.popIn1();
            throw new RuntimeException("namespaces " + progname + ") reports: " + e.getMessage());
        }
        this.loadnameset.remove(progname);
        this.konto.getHandler().onlynamespaces = currentonlynamespaces;
        this.konto.getHandler().setMapping(m);
        this.konto.popIn1();
        if (setwasempty) {
            this.loadnameset = null;
        }
        return qseq.parent;
    }

    Token getPrefix() {
        if (this.tokens.in.ch == '.') {
            this.tokens.in.nextChk();
            if (!Character.isSpaceChar(this.tokens.in.ch) && this.tokens.in.ch != ';') {
                throw new RuntimeException("Invalid prefix in prefix modifier " + this.current.getPosition());
            }
            this.tokens.in.eatSpacesChk();
            return new Token(TokenType.ASTERISK, Asterisk.AST_NS.ordinal(), null);
        }
        if (this.tokens.in.isFirstNameLetter()) {
            String[] p = this.tokens.in.getQName();
            if (p[0] != null || p[1] == null || p[1] == "") {
                throw new RuntimeException("Invalid prefix in prefix modifier " + this.current.getPosition());
            }
            return new Token(TokenType.PROP_NAME, null, p[1], null);
        }
        throw new RuntimeException("Ontology prefix not found in the prefix/ontology modifier " + this.current.getPosition());
    }

    public Token modifyOntology(Sequence seq) {
        OntologyId ont;
        String uri;
        String prefix;
        Sequence qseq = Parser.createToken(TokenType.ONT_MODIFY_INSTR, 0, seq, this.tokens.in);
        if (this.current.getType() != TokenType.KEYWORD || this.current.getValue() != KeyWord.ONTOLOGY.ordinal()) {
            throw new RuntimeException("Ontology keyword not found" + this.current.getPosition());
        }
        if (this.tokens.in.ch == ';') {
            prefix = "";
            uri = Parser.createTempOntology(this.konto.getWorker());
            qseq.addToken(new Token(TokenType.DOT, 0, this.tokens.in));
            qseq.addToken(new Token(TokenType.BASIC_TYPE, 0, (Object)uri, this.tokens.in));
            this.next();
        } else {
            this.current = this.getPrefix();
            qseq.addToken(this.current);
            if (this.current.type == TokenType.PROP_NAME) {
                prefix = this.current.name;
            } else if (this.current.type == TokenType.ASTERISK) {
                prefix = "";
            } else {
                throw new RuntimeException("Ontology prefix not found in the ontology modifier " + this.current.getPosition());
            }
            this.next();
            if (!Parser.isString(this.current)) {
                throw new RuntimeException("Ontology URI not found in the ontology modifier " + this.current.getPosition());
            }
            qseq.addToken(this.current);
            uri = (String)this.current.obj;
            this.next();
            if (this.konto.getHandler().getMapping().containsKey(uri)) {
                ont = this.konto.getOntologyFromMap(uri);
                uri = this.konto.getWorker().name(ont.id());
            }
        }
        ont = this.konto.getOntology(uri);
        this.konto.putOntologyInMap(prefix, ont);
        if (this.current.isDelim(';')) {
            this.next();
        }
        qseq.parent.name = "ontology";
        return qseq.parent;
    }

    public Token modifyPrefix(Sequence seq) {
        String uri;
        Sequence qseq = Parser.createToken(TokenType.ONT_MODIFY_INSTR, 0, seq, this.tokens.in);
        qseq.addToken(this.current);
        this.current = this.getPrefix();
        String prefix = this.current.type == TokenType.PROP_NAME ? this.current.name : "";
        if (this.tokens.in.isFirstNameLetter() || this.tokens.in.ch == '*') {
            this.current = this.getPrefix();
        } else {
            this.next();
        }
        qseq.addToken(this.current);
        qseq.parent.name = "prefix";
        if (this.current.type == TokenType.DOT || this.current.type == TokenType.ASTERISK) {
            uri = this.konto.getHandler().getUriByPrefix("");
        } else if (this.current.type == TokenType.PROP_NAME) {
            uri = this.konto.getHandler().getUriByPrefix(this.current.name);
        } else if (Parser.isString(this.current)) {
            uri = (String)this.current.obj;
        } else {
            throw new RuntimeException("Ontology URI not found in the prefix modifier " + this.current.getPosition());
        }
        Entity e = this.konto.getWorker().entity(uri);
        if (e != Entity.ONTOLOGY && !uri.equals("org.ontobox.java")) {
            throw new RuntimeException("Ontology " + uri + " does not exist");
        }
        this.next();
        this.konto.getHandler().putUriInMap(prefix, uri);
        if (this.current.isDelim(';')) {
            this.next();
        }
        return qseq.parent;
    }

    public Token getRequire(Sequence seq) {
        String xheapuri;
        Sequence qseq = Parser.createToken(TokenType.REQUIRE_INSTR, 0, seq, this.tokens.in);
        qseq.addToken(this.current);
        this.current = this.getPrefix();
        String prefix = this.current.type == TokenType.PROP_NAME ? this.current.name : "";
        this.next();
        qseq.addToken(this.current);
        qseq.parent.name = "require";
        if (!Parser.isString(this.current)) {
            throw new RuntimeException("Ontology URI not found in the require instruction " + this.current.getPosition());
        }
        String uri = (String)this.current.obj;
        this.konto.getWorker().write().require(uri);
        Entity e = this.konto.getWorker().entity(uri);
        if (e != Entity.ONTOLOGY) {
            throw new RuntimeException("Ontology " + uri + " does not exist");
        }
        this.next();
        this.konto.getHandler().putUriInMap(prefix, uri);
        if (this.current.isDelim(';')) {
            this.next();
        }
        if (uri.equals("http://xml.ontobox.org/") && (xheapuri = this.konto.getHandler().getMapping().get("xheap")) == null) {
            xheapuri = this.konto.getHandler().getMapping().get("");
            if (xheapuri != null) {
                this.konto.getLE();
                LibrettoEnv.setXMLHeap(this.konto, xheapuri);
            } else {
                xheapuri = "http://xml.ontobox.org/heap";
                this.konto.getLE();
                LibrettoEnv.setXMLHeap(this.konto, xheapuri);
            }
        }
        return qseq.parent;
    }

    public Token getClassModifier(Sequence seq) {
        Integer cl;
        Sequence qseq = Parser.createToken(TokenType.CLS_MODIFY_INSTR, KeyWord.CREATE_OR_UPDATE.ordinal(), seq, this.tokens.in);
        BoxWorker worker = this.konto.getWorker();
        this.next();
        String shortname = Helper.shortName(this.konto, this.current);
        String classname = this.konto.getFullName(this.current);
        String constrN = null;
        if (this.is(TokenType.FUNCTOR)) {
            cl = worker.id(classname);
            if (cl == null) {
                cl = worker.write().newClass(classname);
                this.current.type = TokenType.CLASS_NAME;
            } else {
                if (worker.entity(cl) != Entity.ONTCLASS) {
                    throw new RuntimeException("The name " + classname + " is occupied by another entity (" + (Object)((Object)worker.entity(cl)) + ")" + this.current.getPosition());
                }
                this.current.type = TokenType.CLASS_NAME;
            }
            qseq.addToken(this.current);
            this.next();
            while (!this.current.isDelim(')')) {
                this.getClassUpdater(qseq, classname, false);
                if (this.current.isDelim(',')) {
                    this.next();
                } else if (!this.current.isKw(KeyWord.FUNCTION)) {
                    if (this.current.isDelim(';')) {
                        throw new RuntimeException("Use ',' instead of ';'");
                    }
                    if (!this.current.isDelim(')')) {
                        if (this.current.type == TokenType.CLASS_NAME || this.current.type == TokenType.DATATYPE_NAME) {
                            throw new RuntimeException("Misplaced class/datatype name " + this.konto.getFullName(this.current) + ". The syntax should be <property> <class/datatype name (optional)> <cardinality (optional)>. " + this.current.getPosition());
                        }
                        throw new RuntimeException("Neither ',' nor ')' found in class modifier " + this.current.getPosition());
                    }
                }
                if (!this.current.isDelim(')')) continue;
            }
            String attr = "";
            String modif = "";
            int i = 0;
            for (Token up : qseq) {
                if (up.getType() != TokenType.TPROP_UPDATER && up.getType() != TokenType.OPROP_UPDATER) continue;
                String nm = up.getSub(0).getName();
                Token tp = up.getSub(3);
                attr = attr + ", " + "_var_" + nm;
                if (!tp.equals(thingType)) {
                    attr = attr + " " + Helper.shortName(this.konto, tp) + "+";
                }
                if (i > 0) {
                    modif = modif + "; ";
                }
                modif = modif + nm + " = " + "_var_" + nm;
                ++i;
            }
            if (i > 0) {
                constrN = "def " + shortname + "(ont" + attr + ") {v:newObject(ont) as newobjectvalue / v:addObjectClass(%" + shortname + ") / {" + modif + "}; newobjectvalue };";
            }
        } else {
            if (!this.is(TokenType.PROP_NAME) && !this.is(TokenType.CLASS_NAME)) {
                throw new RuntimeException("Class name not found in the class modifier " + this.current.getPosition());
            }
            if (this.is(TokenType.PROP_NAME)) {
                String uri = this.konto.getTokenURI(this.current);
                cl = this.konto.getClass(this.current.name, uri, KeyWord.CREATE_OR_UPDATE).id();
                this.current.type = TokenType.CLASS_NAME;
            } else {
                cl = worker.id(classname);
            }
            qseq.addToken(this.current);
        }
        this.next();
        if (this.is(TokenType.KEYWORD) && this.current.name.equals("extends") && this.current.prefix == null) {
            this.next();
            while (true) {
                if (!this.is(TokenType.CLASS_NAME)) {
                    if (!this.is(TokenType.PROP_NAME)) break;
                    throw new RuntimeException("Class not found '" + this.konto.getFullName(this.current) + "'");
                }
                qseq.addToken(this.current);
                Integer sup = worker.id(this.konto.getFullName(this.current));
                if (!RHelper.isSubclassOf(worker, cl, sup)) {
                    worker.write().addSubclass(sup, cl);
                }
                this.next();
                if (!this.current.isDelim(',')) continue;
                this.next();
            }
        }
        for (Token up : qseq) {
            if (up.getType() != TokenType.TPROP_UPDATER && up.getType() != TokenType.OPROP_UPDATER) continue;
            this.propUpdate(up, cl);
        }
        if (this.current.isDelim(';')) {
            this.next();
        } else if (this.current.isDelim('{')) {
            this.next();
            if (!this.current.isDelim('}')) {
                do {
                    this.getClassUpdater(qseq, classname, true);
                    if (this.current.isDelim(';')) {
                        this.next();
                        continue;
                    }
                    if (this.current.isKw(KeyWord.FUNCTION)) continue;
                    if (this.current.isDelim(',')) {
                        throw new RuntimeException("Use ';' instead of ',' in modifiers");
                    }
                    if (this.current.isDelim('}')) continue;
                    if (this.current.type == TokenType.CLASS_NAME || this.current.type == TokenType.DATATYPE_NAME) {
                        throw new RuntimeException("Misplaced class/datatype name " + this.konto.getFullName(this.current) + ". The syntax should be <property> <class/datatype name (optional)> <cardinality (optional)>. " + this.current.getPosition());
                    }
                    throw new RuntimeException("Neither ';' nor '}' found in class modifier " + this.current.getPosition());
                } while (!this.current.isDelim('}'));
            }
            this.getDelim('}', "class modifier");
            if (this.current.isDelim(';')) {
                this.next();
            }
        }
        if (constrN == null) {
            constrN = "def " + shortname + "(ont) {v:newObject(ont)/v:addObjectClass(%" + shortname + ")};";
        }
        this.addFunction(constrN);
        return qseq.parent;
    }

    Token getClassUpdater(Sequence seq, String classname, boolean check) {
        Token cur = null;
        BoxWorker worker = this.konto.getWorker();
        String shortname = Helper.shortName(this.konto, classname);
        String uri = worker.name(worker.ontology(worker.id(classname)));
        String prefix = this.konto.getHandler().getPrefixByURI(uri);
        if (this.is(TokenType.PROP_NAME)) {
            Token max;
            Token min;
            TokenType updater;
            Token name = this.current;
            this.next();
            Token defval = null;
            Token type = this.current;
            if (this.is(TokenType.DATATYPE_NAME)) {
                updater = TokenType.TPROP_UPDATER;
                this.next();
            } else if (this.is(TokenType.CLASS_NAME)) {
                this.next();
                updater = TokenType.OPROP_UPDATER;
            } else if (this.current.isDelim(',') || this.current.isDelim(')') || this.current.isDelim('}') || this.current.isDelim(';') || this.current.isDelim('[')) {
                updater = TokenType.OPROP_UPDATER;
                type = thingType;
            } else {
                if (this.is(TokenType.PROP_NAME)) {
                    throw new RuntimeException("Invalid property declaration: probably \"" + this.konto.getFullName(this.current) + "\" is not declared as class" + this.current.getPosition());
                }
                throw new RuntimeException("Invalid property declaration: expected for either class name, datatype name or '}' " + this.current.getPosition());
            }
            if (this.current.isDelim('[')) {
                this.next();
                if (Parser.isInt(this.current)) {
                    min = this.current;
                    this.next();
                } else {
                    min = tzero;
                }
                if (!this.current.isDelim(',')) {
                    throw new RuntimeException("',' not found in cardinality declaration " + this.current.getPosition());
                }
                this.next();
                if (Parser.isInt(this.current)) {
                    max = this.current;
                    this.next();
                } else {
                    max = tinf;
                }
                if (!this.current.isDelim(']')) {
                    throw new RuntimeException("']' not found in cardinality declaration " + this.current.getPosition());
                }
                this.next();
            } else {
                min = tzero;
                max = tinf;
            }
            boolean setter = false;
            boolean getter = false;
            Sequence qseq = Parser.createToken(updater, 0, seq, this.tokens.in);
            cur = qseq.parent;
            qseq.addToken(name);
            qseq.addToken(min);
            qseq.addToken(max);
            qseq.addToken(type);
            qseq.addToken(defval);
            String fullname = this.konto.getFullName(name);
            int cid = worker.id(classname);
            if (check) {
                this.propUpdate(cur, cid);
            }
        } else if (this.current.isKw(KeyWord.FUNCTION)) {
            int startpos = this.tokens.in.getFilePos() - 1;
            Token fundec = this.getFunctionDeclaration(seq, classname, "def");
            int endpos = this.filePosition - 1;
            int length = endpos - startpos;
            char[] code = new char[length];
            this.konto.getHandler().progtext.getChars(startpos, endpos, code, 0);
            String cd = "def " + shortname + " " + new String(code);
            Token head = fundec.getSub(0);
            String name = head.getName();
            int arity = head.getSeq().size();
        } else {
            if (this.current.isKw(KeyWord.GENERATOR)) {
                throw new RuntimeException("Generators can not be defined within class declarations");
            }
            String nm = "";
            if (this.current.name != null) {
                nm = "\"" + this.current.name + "\" is ";
            } else if (this.current.obj != null) {
                nm = "\"" + this.current.obj + "\" is ";
            }
            throw new RuntimeException("Invalid property name (" + nm + (Object)((Object)this.current.type) + ")");
        }
        return cur;
    }

    public void propUpdate(Token updater, Integer cid) {
        Sequence qseq = updater.getSeq();
        if (updater.getType() == TokenType.CLASS_NAME) {
            ClassId sup = this.konto.getClass(updater.getName(), this.konto.getTokenURI(updater), KeyWord.UPDATE);
            BoxWorker worker = this.konto.getWorker();
            if (!RHelper.isSubclassOf(worker, cid, sup.id())) {
                worker.write().addSubclass(sup.id(), cid);
            }
        } else if (updater.getType() == TokenType.TPROP_UPDATER) {
            Integer prop;
            BoxWriter writer;
            BoxWorker worker;
            TypeId range;
            int max;
            int min;
            block24: {
                String name = qseq.get(0).getName();
                String uri = this.konto.getTokenURI(qseq.get(0));
                OntologyId ont = this.konto.getOntology(uri);
                min = (Integer)qseq.get(1).getObj();
                max = (Integer)qseq.get(2).getObj();
                range = Helper.getDatatype(this.konto, qseq.get(3));
                worker = this.konto.getWorker();
                writer = worker.write();
                String propname = worker.name(ont.id(), name);
                try {
                    prop = writer.newTProperty(propname);
                }
                catch (Exception e) {
                    prop = worker.id(propname);
                    boolean check = false;
                    if (prop != null) {
                        int[] tpr;
                        if (worker.entity(prop) != Entity.TPROPERTY) {
                            throw new RuntimeException("Entity named " + propname + " already exists (" + (Object)((Object)worker.entity(prop)) + ")");
                        }
                        for (int t : tpr = worker.tprops(cid)) {
                            if (t != prop) continue;
                            if (worker.range(prop).intValue() != range.id()) {
                                throw new RuntimeException("Invalid range for property " + worker.name(prop));
                            }
                            check = true;
                            break;
                        }
                    }
                    if (check) break block24;
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (worker.domain(prop) == null) {
                writer.setDomain(prop, cid);
            }
            if (worker.range(prop) == null) {
                writer.setRange(prop, range.id());
            }
            if (min != 0) {
                writer.annotate(prop, "http://ontobox.org/#mincard", String.valueOf(min));
            }
            if (max != -1) {
                writer.annotate(prop, "http://ontobox.org/#maxcard", String.valueOf(max));
            }
        } else {
            Integer prop;
            BoxWriter writer;
            ClassId range;
            int max;
            int min;
            block25: {
                String name = qseq.get(0).getName();
                String uri = this.konto.getTokenURI(qseq.get(0));
                OntologyId ont = this.konto.getOntology(uri);
                min = (Integer)qseq.get(1).getObj();
                max = (Integer)qseq.get(2).getObj();
                Token t = qseq.get(3);
                range = t.equals(thingType) ? null : this.konto.getClass(t.getName(), this.konto.getTokenURI(t), KeyWord.UPDATE);
                BoxWorker worker = this.konto.getWorker();
                writer = worker.write();
                String propname = worker.name(ont.id(), name);
                try {
                    prop = writer.newOProperty(worker.name(ont.id(), name));
                }
                catch (Exception e) {
                    prop = worker.id(propname);
                    boolean check = false;
                    if (prop != null) {
                        int[] opr;
                        if (worker.entity(prop) != Entity.OPROPERTY) {
                            throw new RuntimeException("Entity named " + propname + " already exists (" + (Object)((Object)worker.entity(prop)) + ")");
                        }
                        for (int o : opr = worker.oprops(cid)) {
                            Integer r2;
                            if (o != prop) continue;
                            Integer r1 = worker.range(prop);
                            Integer n = r2 = range == null ? null : Integer.valueOf(range.id());
                            if (!Parser.compare(r1, r2)) {
                                throw new RuntimeException("Invalid range for property " + worker.name(prop));
                            }
                            check = true;
                            break;
                        }
                    }
                    if (check) break block25;
                    throw new RuntimeException(e.getMessage());
                }
            }
            writer.setDomain(prop, cid);
            if (range != null) {
                writer.setRange(prop, range.id());
            }
            if (min != 0) {
                writer.annotate(prop, "http://ontobox.org/#mincard", String.valueOf(min));
            }
            if (max != -1) {
                writer.annotate(prop, "http://ontobox.org/#maxcard", String.valueOf(max));
            }
            Token dflt = qseq.get(4);
        }
    }

    public static <T> boolean compare(T i1, T i2) {
        if (i1 == null) {
            return i2 == null;
        }
        return i1.equals(i2);
    }

    public Token getMapObject(Sequence seq, Token cltoken) {
        Sequence qseq = Parser.createToken(TokenType.MAP_OBJECT_CREATOR, KeyWord.CREATE_OR_UPDATE.ordinal(), seq, this.tokens.in);
        if (cltoken != null) {
            qseq.addToken(cltoken);
        }
        while (this.is(TokenType.CLASS_NAME)) {
            qseq.addToken(this.current);
            this.next();
        }
        boolean out = true;
        while (out) {
            if (this.current.type == TokenType.MAP) {
                qseq.addToken(this.current);
                this.getObjectModifier(qseq, true);
            } else if (this.current.type == TokenType.OBJ_NAME) {
                this.getObjectSelector(qseq);
                if (this.current.isDelim('{')) {
                    this.getObjectModifier(qseq, true);
                }
            } else {
                out = false;
            }
            if (!this.current.isDelim(',')) continue;
            this.next();
        }
        return qseq.parent;
    }

    Token getObjectSelector(Sequence seq) {
        if (!this.is(TokenType.OBJ_NAME)) {
            throw new RuntimeException("Object name not found " + this.current.getPosition());
        }
        seq.addToken(this.current);
        Token cur = this.current;
        this.next();
        return cur;
    }

    final void getObjectUpdater(Sequence seq, boolean inCreator) {
        if (this.current.isVar() && this.tokens.in.ch == '=') {
            this.getVarAssignment(seq);
        } else {
            this.getPropCommand(seq, inCreator);
            ++seq.parent.value;
        }
    }

    private Token getPath(Sequence seq, Token head) {
        Sequence qseq;
        if (head == null) {
            qseq = Parser.createToken(TokenType.PATH_EXP, 0, seq, this.tokens.in);
            if (this.current.isSlash()) {
                qseq.addToken(allObj);
                this.next();
            }
        } else {
            Token cp = head.copy(this.tokens.in);
            head.type = TokenType.PATH_EXP;
            qseq = head.getNewSeq();
            qseq.addToken(cp);
            if (this.is(TokenType.OPER, Operation.FIELD)) {
                this.next();
                Token field = this.getVar(qseq, false);
                field.type = TokenType.SET_FIELD;
            }
        }
        while (true) {
            this.getStep(qseq, head != null);
            if (this.current.isSlash()) {
                this.next();
            } else {
                if (this.current.type != TokenType.EMPTY_CONTEXT) break;
                qseq.addToken(this.current);
                this.next();
            }
            head = null;
        }
        return qseq.parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token getStep(Sequence seq, boolean hashead) {
        boolean key;
        Token cur = null;
        boolean indexopernumber = false;
        if (this.is(TokenType.OPER, Operation.MULT)) {
            this.current.type = TokenType.ASTERISK;
            this.current.value = Asterisk.AST_NS.ordinal();
            this.current.prefix = null;
            if (this.konto.getTokenURI(this.current) == null) {
                throw new RuntimeException("Can not use '*' because default ontology is not defined " + this.current.getPosition());
            }
        }
        if (!hashead) {
            if (this.is(TokenType.CLASS_NAME) && this.tokens.isQueueEmpty() && (this.tokens.in.ch == '&' || this.tokens.in.isFirstNameLetter())) {
                hashead = true;
                Token cltok = this.current;
                this.next();
                if (this.is(TokenType.CLASS_NAME) || this.is(TokenType.MAP) || this.is(TokenType.OBJ_NAME)) {
                    this.getMapObject(seq, cltok);
                } else {
                    if (!this.is(TokenType.OPER, Operation.FIELD) && !this.is(TokenType.INDX_OPER)) throw new RuntimeException("Misplaced property name" + this.current.getPosition());
                    seq.addToken(cltok);
                }
            } else if (this.is(TokenType.PROP_NAME) || this.is(TokenType.OBJ_NAME) || this.is(TokenType.CLASS_NAME) || this.is(TokenType.DATATYPE_NAME) || this.is(TokenType.ASTERISK) || this.is(TokenType.EMBEDDED_LANG) || this.is(TokenType.DOT) || this.is(TokenType.DDOT) || this.is(TokenType.EMPTY_CONTEXT)) {
                if (this.is(TokenType.PROP_NAME)) {
                    if (this.current.isWord("_")) {
                        if (this.tokens.in.ch != '{') {
                            throw new RuntimeException("'{' is missed in the anonymous block");
                        }
                        this.next();
                        Sequence qseq = Parser.createPolishToken(TokenType.QUOTED_EXP, 0, seq, this.tokens.in);
                        Token af = this.getObjectModifier(qseq, false);
                        if (af.type == TokenType.OBJ_MODIFIER) {
                            af.type = TokenType.ANONYM_FUN;
                        }
                        HashMap<String, Integer> localvarnums = this.varnums;
                        this.varnums = new HashMap();
                        Map<Integer, Token> localvarsinanonym = this.varsinanonym;
                        this.varsinanonym = new HashMap<Integer, Token>();
                        this.varnum = -1;
                        this.funVarsChk(af, this.varnums);
                        af.info = this.varsinanonym;
                        af.number = -this.varnum - 1;
                        this.varnums = localvarnums;
                        this.varsinanonym = localvarsinanonym;
                    } else {
                        this.checkProtected();
                        cur = this.current;
                        seq.addToken(this.current);
                        this.next();
                    }
                } else {
                    cur = this.current;
                    seq.addToken(this.current);
                    this.next();
                }
            } else if (this.is(TokenType.QUESTION)) {
                cur = this.current;
                cur.type = TokenType.VAR_REF;
                if (this.questionVarNum > this.questionVarNumNumber) {
                    throw new RuntimeException("Too many question marks in the path " + this.current.getPosition());
                }
                String v = String.valueOf(this.questionVarNum);
                ++this.questionVarNum;
                cur.name = v;
                cur.value = this.vars.checkVar(cur.name);
                seq.addToken(this.current);
                this.next();
            } else if (this.is(TokenType.VAR_REF)) {
                cur = this.current;
                int varnum = this.vars.putVar(cur.name);
                if (varnum == -1) {
                    throw new RuntimeException("Variable " + cur.name + " is undefined " + this.current.getPosition());
                }
                cur.value = varnum;
                System.out.println("Variable " + cur.name + " " + varnum);
                seq.addToken(this.current);
                this.next();
            } else if (this.is(TokenType.FUNCTOR)) {
                cur = this.getFunCall(seq);
            } else if (this.current.isDelim('(')) {
                cur = this.getPathSet(seq);
            } else if (this.is(TokenType.OPER, Operation.INVERSE)) {
                this.next();
                if (!this.is(TokenType.PROP_NAME)) {
                    throw new RuntimeException("Inversed property id not found " + this.current.getPosition());
                }
                String fn = this.konto.getFullName(this.current);
                Entity pe = this.konto.getWorker().entity(fn);
                if (this.current.isKey()) {
                    this.current.type = TokenType.INVERSE_KEY;
                } else if (pe == Entity.TPROPERTY) {
                    this.current.type = TokenType.INVERSE_TPROP_NAME;
                } else {
                    if (pe != Entity.OPROPERTY) throw new RuntimeException("The inverse operator must be applied to a property (" + (Object)((Object)pe) + " found)");
                    this.current.type = TokenType.INVERSE_OPROP_NAME;
                }
                cur = this.current;
                seq.addToken(this.current);
                this.next();
            } else if (this.is(TokenType.OPER, Operation.EVAL)) {
                this.next();
                if (!this.is(TokenType.PROP_NAME)) {
                    throw new RuntimeException("evaluated property id not found " + this.current.getPosition());
                }
                this.current.type = TokenType.GET_FIELD;
                cur = this.current;
                seq.addToken(this.current);
                this.next();
            } else if (this.is(TokenType.MAP)) {
                cur = this.getMapObject(seq, null);
            } else if (this.current.isKw(KeyWord.BREAKKW)) {
                this.current.type = TokenType.BREAK;
                seq.addToken(this.current);
                this.next();
            } else if (this.current.isKw(KeyWord.RETURNKW)) {
                this.current.type = TokenType.RETURN;
                seq.addToken(this.current);
                Token retn = this.current;
                this.next();
                if (!(this.current.isKw(KeyWord.ELSE) || this.current.isDelim(',') || this.current.isDelim(';') || this.current.isDelim('}') || this.current.isDelim(')') || this.current.isDelim(']'))) {
                    if (this.current.isSlash()) {
                        throw new RuntimeException("Unreachable path step after 'return' " + this.current.getPosition());
                    }
                    if (this.current.isDelim('{')) {
                        throw new RuntimeException("Object modifiers {...} are not allowed as 'return' parameters. Use anonymous functions `{...}! instead." + this.current.getPosition());
                    }
                    this.getPathTerm(retn.getSeq());
                }
            } else if (this.is(TokenType.INDX_OPER)) {
                cur = this.current;
                seq.addToken(cur);
                this.getPathTerm(cur.getSeq());
            } else if (this.is(TokenType.ENTITY_TYPE) || this.is(TokenType.STRING_SEGMENT) || this.is(TokenType.BASIC_TYPE) || this.is(TokenType.LIB_TYPE)) {
                Sequence qseq = Parser.createToken(TokenType.SET_EXP, 0, seq, this.tokens.in);
                Token set = qseq.parent;
                qseq.addToken(this.current);
                this.next();
            } else if (this.is(TokenType.ENTITY_TYPE)) {
                seq.addToken(this.current);
                this.next();
            } else if (this.is(TokenType.ANONYM_FUN)) {
                Token af = this.getObjectModifier(seq, false);
                af.type = TokenType.ANONYM_FUN;
            } else if (this.current.isDelim('{')) {
                Token cl = seq.getLast();
                if (cl != null && cl.type == TokenType.CLASS_NAME) {
                    throw new RuntimeException("Libretto is asked to modify all values of class " + this.konto.getFullName(cl) + " " + cl.getPosition() + ". For safety reasons, please confirm it by inserting the dot between the class and the bracket, like \"" + cl.name + " / . {...\"");
                }
                Token fun = this.getObjectModifier(seq, false);
                if (fun.type == TokenType.OBJ_MODIFIER) {
                    fun.type = TokenType.ANONYM_FUN;
                }
            } else {
                if (this.is(TokenType.INDX)) {
                    throw new RuntimeException("Misplaced 'index' expression (can not be used in paths " + this.current.getPosition());
                }
                if (!this.is(TokenType.OPER) || this.current.value != Operation.LT.ordinal()) throw new RuntimeException("Invalid path step (" + (Object)((Object)this.current.type) + ") " + this.current.getPosition());
                new XMLCompiler(this.konto, seq, this.tokens.in);
                this.next();
            }
        }
        do {
            key = false;
            if (this.current.isDelim('[')) {
                this.next();
                if (this.tokens.in.ch == ']' && this.current.getType() == TokenType.BASIC_TYPE && this.current.getObj() instanceof Integer && (Integer)this.current.getObj() >= 0) {
                    Sequence qseq = Parser.createToken(TokenType.PREDICATE, 0, seq, this.tokens.in);
                    Sequence s = Parser.createPolishToken(TokenType.TERM_EXP, 0, qseq, this.tokens.in);
                    Token eq = new Token(TokenType.OPER, Operation.EQ.ordinal(), (Object)"=", null);
                    Token idx = new Token(TokenType.VAR_REF, this.konto.getHandler().indexVarNumber, (Object)"i_", null);
                    idx.name = "_i";
                    s.addToken(this.current);
                    s.addToken(eq);
                    s.addToken(idx);
                    this.next();
                    this.next();
                } else {
                    this.getPredicate(seq, "in path step");
                }
                key = true;
            }
            if (this.is(TokenType.ESCAPER)) {
                int arity;
                Token last = seq.getLast();
                if (last == null) {
                    throw new RuntimeException("Escaped expression missed " + this.current.getPosition());
                }
                Token escape = this.current;
                String prefix = this.konto.getHandler().getPrefixByURI("http://ontobox.org/");
                Token fun = new Token(TokenType.FUN_CALL, prefix, StringFuncs.EVAL_FUN, null);
                fun.getSeq().addToken(last.copy(null));
                if (this.tokens.in.ch == '(') {
                    Token quoted;
                    this.next();
                    if (last.getType() == TokenType.QUOTED_EXP && (quoted = last.getSub(0)).getType() != TokenType.DECLARE_INSTR) {
                        throw new RuntimeException("Parameters in !(..) can be applied only to anonymous functions" + this.current.getPosition());
                    }
                    Sequence qseq = Parser.createPolishToken(TokenType.QUOTED_EXP, 0, fun.getSeq(), this.tokens.in);
                    Token af = this.getPathSet(qseq);
                    this.checkVarsInQuoted(af);
                    arity = 2;
                } else if (last.getType() == TokenType.QUOTED_EXP) {
                    Token quoted = last.getSub(0);
                    arity = 1;
                    this.next();
                } else if (escape.obj == null) {
                    arity = 1;
                    this.next();
                } else {
                    fun.getSeq().addToken((Token)escape.obj);
                    arity = 2;
                    this.next();
                }
                int numb = this.functions.checkFunction(this.konto.getFullName(fun), arity);
                if (numb == -1) {
                    throw new RuntimeException("Something wrong in the escaper, can not find the predefined function " + StringFuncs.EVAL_FUN + "/" + arity);
                }
                fun.value = numb;
                fun.obj = this.varnums;
                last.copyFrom(fun);
            }
            if (this.current.isDelim('<')) {
                this.getSorter(seq);
                key = true;
            }
            if (this.current.isDelim('{')) {
                Token cl = seq.getLast();
                if (cl != null && cl.type == TokenType.CLASS_NAME) {
                    throw new RuntimeException("Libretto is asked to modify all values of class " + this.konto.getFullName(cl) + " " + cl.getPosition() + ". For safety reasons, please confirm it by inserting the dot between the class and the bracket, like \"" + cl.name + " / . {...\"");
                }
                Token modif = this.getObjectModifier(seq, false);
                if (modif.type == TokenType.SWITCH) {
                    modif.type = TokenType.MODIF_SWITCH;
                }
                key = true;
            }
            if (this.current.type == TokenType.INDX_OPER) {
                cur = this.current;
                seq.addToken(this.current);
                this.next();
                if (this.current.isAtomic()) {
                    if (this.current.isVar()) {
                        this.current.value = this.vars.putVar(this.current.name);
                    }
                    cur.getSeq().addToken(this.current);
                    this.next();
                } else if (this.current.type == TokenType.FUNCTOR) {
                    this.getFunCall(cur.getSeq());
                } else {
                    if (!this.current.isDelim('(')) throw new RuntimeException("Something wrong in the index operation " + this.current.getPosition());
                    this.getPathSet(cur.getSeq());
                }
                key = true;
            }
            if (!this.is(TokenType.OPER, Operation.FIELD)) continue;
            this.next();
            Token field = this.getVar(seq, false);
            field.type = TokenType.SET_FIELD;
            key = true;
        } while (key);
        return cur;
    }

    private void checkProtected() {
        if (this.current.name.charAt(0) == '_') {
            int pid;
            int rid;
            BoxWorker worker = this.konto.getWorker();
            if (this.functionclass == null || worker.entity(this.functionclass) != Entity.ONTCLASS) {
                throw new RuntimeException("No access to protected property " + this.current.getName() + " " + this.current.getPosition());
            }
            int cid = worker.id(this.functionclass);
            if (cid != (rid = worker.domain(pid = this.konto.getProperty(this.current).id()).intValue())) {
                boolean check = false;
                for (int i : worker.subclasses(rid)) {
                    if (i != cid) continue;
                    check = true;
                    break;
                }
                if (!check) {
                    throw new RuntimeException("No access to external protected property " + this.current.getName() + " from this function definition" + this.current.getPosition());
                }
            }
        }
    }

    Token getFunCall(Sequence seq) {
        if (!this.is(TokenType.FUNCTOR)) {
            throw new RuntimeException("Function id not found " + this.current.getPosition());
        }
        if (this.current.getName().equals("_")) {
            Sequence qseq = Parser.createPolishToken(TokenType.QUOTED_EXP, 0, seq, this.tokens.in);
            this.getQuotedPar(qseq);
            return qseq.parent;
        }
        this.current.type = TokenType.FUN_CALL;
        seq.addToken(this.current);
        Sequence qseq = this.current.getSeq();
        Token funcall = this.current;
        this.next();
        int arity = 0;
        boolean notfirst = false;
        while (!this.current.isDelim(')')) {
            if (notfirst) {
                if (this.current.isDelim(',')) {
                    this.next();
                } else if (!this.current.isDelim(')')) {
                    throw new RuntimeException("Comma  or ')' missed in function call (" + funcall.name + ") " + this.current.getPosition());
                }
            } else {
                notfirst = true;
            }
            this.getPathTerm(qseq);
            ++arity;
        }
        this.next();
        int numb = this.functions.checkFunction(this.konto.getFullName(funcall), arity);
        if (numb == -1) {
            numb = this.functions.pushFunction(this.konto.getFullName(funcall), arity);
        }
        funcall.value = numb;
        return funcall;
    }

    Token getIfExpression(Sequence seq) {
        Sequence qseq = Parser.createToken(TokenType.IF_EXP, 0, seq, this.tokens.in);
        if (!this.current.isIfKw()) {
            throw new RuntimeException("'if' keyword not found " + this.current.getPosition());
        }
        this.next();
        if (!this.current.isDelim('(')) {
            throw new RuntimeException("If-condition must be enclosed in parentheses " + this.current.getPosition());
        }
        this.next();
        this.getPathTerm(qseq);
        if (!this.current.isDelim(')')) {
            if (this.current.type == TokenType.PROP_OPERATOR) {
                throw new RuntimeException("Misplaced assignment in if-condition");
            }
            throw new RuntimeException("If-condition closing parenthesis not found " + this.current.getPosition());
        }
        this.next();
        this.getPathTerm(qseq);
        if (this.current.isElseKw()) {
            this.next();
        } else if (this.current.isDelim(',')) {
            this.next();
        }
        this.getPathTerm(qseq);
        return qseq.parent;
    }

    private Token getPathSet(Sequence seq) {
        if (!this.current.isDelim('(')) {
            throw new RuntimeException("set opening parenthesis not found " + this.current.getPosition());
        }
        this.next();
        Sequence qseq = Parser.createToken(TokenType.SET_EXP, 0, seq, this.tokens.in);
        if (this.current.isDelim(')')) {
            this.next();
            return qseq.parent;
        }
        this.getPathTerm(qseq);
        if (this.is(TokenType.GEN_RULE)) {
            throw new RuntimeException("The switch syntax has been changed. Now it is {case cond1 => expr1; ...}");
        }
        while (!this.current.isDelim(')')) {
            if (this.current.isDelim(',')) {
                this.next();
            }
            this.getPathTerm(qseq);
        }
        this.next();
        return qseq.parent;
    }

    private Token getQuotedPar(Sequence seq) {
        Map<Integer, Token> localvarsinanonym = this.varsinanonym;
        this.varsinanonym = new HashMap<Integer, Token>();
        Token qfun = this.getFunctionDeclaration(seq, null, "ano");
        qfun.info = this.varsinanonym;
        this.varsinanonym = localvarsinanonym;
        return qfun;
    }

    private Token getPredicate(Sequence seq, String where) {
        Sequence qseq = Parser.createToken(TokenType.PREDICATE, 0, seq, this.tokens.in);
        Token cur = this.getPathTerm(qseq);
        this.getDelim(']', "predicate (" + where + ")");
        return cur;
    }

    Token getSorter(Sequence seq) {
        Token father = seq.parent;
        Token path = father.copy(this.tokens.in);
        seq = father.clear();
        Sequence qseq = Parser.createToken(TokenType.SORTER, 0, seq, this.tokens.in);
        qseq.addToken(path);
        Sequence ss = new Sequence(null, 1);
        if (!this.is(TokenType.DELIM, Delimiter.LANGLE)) {
            throw new RuntimeException("Opening '<[' for sorter not found " + this.current.getPosition());
        }
        this.next();
        while (true) {
            this.getPathTerm(ss);
            if (!this.current.isDelim(',')) break;
            this.next();
        }
        qseq.parent.obj = ss;
        if (!this.is(TokenType.DELIM, Delimiter.RANGLE)) {
            throw new RuntimeException("Closing ']>' for sorter not found " + this.current.getPosition());
        }
        this.next();
        return qseq.parent;
    }

    Token getPropOperator() {
        Token cur = this.current;
        if (!this.is(TokenType.PROP_OPERATOR)) {
            throw new RuntimeException("Operator ('=', '+=', '.=', '--') not found, or no space between property id and '--' in object modifier " + this.current.getPosition());
        }
        this.next();
        return cur;
    }

    Token getPropCommand(Sequence seq, boolean inCreator) {
        Sequence qseq = Parser.createToken(TokenType.PROPERTY_COMMAND, 0, seq, this.tokens.in);
        Token cur = qseq.parent;
        Token t = this.getPathTerm(qseq);
        if (!this.is(TokenType.PROP_OPERATOR)) {
            seq.substituteLast(t);
            return cur;
        }
        if (t.seq.size() > 1) {
            throw new RuntimeException("Expression instead of path found in the left part of the property command " + this.current.getPosition());
        }
        Token p = t.getSeq().getLast();
        if (p.getType() == TokenType.PROP_NAME) {
            t.type = TokenType.PATH_EXP;
            t.seq.type = 1;
        } else if (p.getType() == TokenType.PATH_EXP) {
            qseq.substituteLast(p);
        }
        Token path = qseq.get(0);
        Sequence pseq = path.getSeq();
        Token edited = null;
        block5: for (int i = pseq.size() - 1; i >= 0; --i) {
            Token tok = pseq.get(i);
            switch (tok.type) {
                case PREDICATE: {
                    continue block5;
                }
                case INVERSE_OPROP_NAME: {
                    throw new RuntimeException("Inverse o-properties can not be modified by property commands " + this.current.getPosition());
                }
                case PROP_NAME: {
                    tok.type = TokenType.EDITED_PROP_NAME;
                    edited = tok;
                    break block5;
                }
                default: {
                    throw new RuntimeException("Invalid (e.g. collection-wise) path step after the modified property in the assignment command " + this.current.getPosition());
                }
            }
        }
        if (edited == null) {
            throw new RuntimeException("Modified property not found in the path of the property command " + this.current.getPosition());
        }
        Token op = this.getPropOperator();
        op.type = TokenType.OBJ_MODIFY_INSTR;
        if (pseq.getLast().getType() == TokenType.EDITED_PROP_NAME) {
            op.setRightmostEditedProp();
            edited.setRightmostEditedProp();
            if (inCreator) {
                edited.setAsPropInObjCreator();
                op.setAsPropInObjCreator();
            }
        }
        pseq.addToken(op);
        if (op.value != Operator.DELETE_VALUE.ordinal()) {
            this.getPathTerm(op.getSeq());
        }
        return cur;
    }

    private void checkVarsInQuoted(Token af) {
        HashMap<String, Integer> localvarnums = this.varnums;
        this.varnums = new HashMap();
        Map<Integer, Token> localvarsinanonym = this.varsinanonym;
        this.varsinanonym = new HashMap<Integer, Token>();
        this.varnum = -1;
        this.funVarsChk(af, this.varnums);
        af.info = this.varsinanonym;
        af.number = -this.varnum - 1;
        this.varnums = localvarnums;
        this.varsinanonym = localvarsinanonym;
    }

    Token getFunHead(Sequence seq, List<String> argtype, List<T> argcard) {
        if (this.current.type != TokenType.FUNCTOR) {
            throw new RuntimeException("Functor not found in function declaration (" + (Object)((Object)this.current.type) + ") " + this.current.getPosition());
        }
        Token head = this.current;
        seq.addToken(head);
        Sequence qseq = head.getSeq();
        this.next();
        int arity = 0;
        if (!this.current.isDelim(')')) {
            while (true) {
                this.getVar(qseq, false);
                ++arity;
                this.getType(argtype, argcard);
                if (!this.current.isDelim(',')) break;
                this.next();
            }
        }
        head.value = arity;
        this.getDelim(')', "function head");
        return head;
    }

    public Token getPathTerm(Sequence seq) {
        Sequence pseq;
        block75: {
            boolean waitingForValue = true;
            pseq = Parser.createPolishToken(TokenType.TERM_EXP, 0, seq, this.tokens.in);
            while (true) {
                Sequence qseq;
                Token head = pseq.getLast();
                if (this.current.isKw(KeyWord.VARKW)) {
                    this.next();
                    if (this.current.type != TokenType.PROP_NAME && this.current.type != TokenType.VAR_REF) {
                        throw new RuntimeException("Variable name not found at " + this.current.getPosition());
                    }
                    if (this.current.prefix != null) {
                        throw new RuntimeException("Qualified names for variables are not allowed at " + this.current.getPosition());
                    }
                    this.current.type = TokenType.VAR_REF;
                }
                if (this.current.isDelim('(')) {
                    if (waitingForValue) {
                        this.getPathSet(pseq);
                        waitingForValue = false;
                        continue;
                    }
                    break block75;
                }
                if (this.current.type == TokenType.VAR_REF) {
                    if (waitingForValue) {
                        int varnum;
                        this.current.value = varnum = this.vars.putVar(this.current.name);
                        Token cur = this.current;
                        this.next();
                        if (this.is(TokenType.PROP_OPERATOR, Operator.ASSIGN)) {
                            qseq = Parser.createToken(TokenType.ASSIGN_INSTR, pseq, this.tokens.in);
                            qseq.addToken(cur);
                            this.next();
                            this.getPathTerm(qseq);
                        } else {
                            pseq.addToken(cur);
                        }
                        waitingForValue = false;
                        continue;
                    }
                    break block75;
                }
                if (this.current.isValue()) {
                    if (!waitingForValue) {
                        throw new RuntimeException("Misplaced value '" + this.current + "' " + this.current.getPosition());
                    }
                    if (this.current.type == TokenType.MAP) {
                        this.getMapObject(pseq, null);
                        waitingForValue = false;
                        continue;
                    }
                    if (this.is(TokenType.CLASS_NAME) && this.tokens.isQueueEmpty() && (this.tokens.in.ch == '&' || this.tokens.in.isFirstNameLetter())) {
                        Token cltok = this.current;
                        this.next();
                        if (this.is(TokenType.CLASS_NAME) || this.is(TokenType.OBJ_NAME) || this.is(TokenType.MAP)) {
                            this.getMapObject(pseq, cltok);
                        } else if (this.is(TokenType.OPER, Operation.FIELD) || this.is(TokenType.INDX_OPER)) {
                            pseq.addToken(cltok);
                            head = pseq.getLast();
                            this.getPath(pseq, head);
                        } else {
                            pseq.addToken(cltok);
                        }
                        waitingForValue = false;
                        continue;
                    }
                    if (this.is(TokenType.ANONYM_FUN)) {
                        this.getPath(pseq, head);
                        waitingForValue = false;
                        continue;
                    }
                    if (this.current.type == TokenType.QUESTION) {
                        if (this.questionVarNum > this.questionVarNumNumber) {
                            throw new RuntimeException("Too many question marks in the path " + this.current.getPosition());
                        }
                        this.current.type = TokenType.VAR_REF;
                        String v = "_" + String.valueOf(this.questionVarNum);
                        ++this.questionVarNum;
                        this.current.name = v;
                        this.current.value = this.vars.checkVar(this.current.name);
                    }
                    if (this.is(TokenType.PROP_NAME)) {
                        if (this.current.isWord("_")) {
                            if (this.tokens.in.ch != '{') {
                                throw new RuntimeException("'{' is missed in the anonymous block");
                            }
                            this.next();
                            Sequence qseq2 = Parser.createPolishToken(TokenType.QUOTED_EXP, 0, pseq, this.tokens.in);
                            Token af = this.getObjectModifier(qseq2, false);
                            if (af.type == TokenType.OBJ_MODIFIER) {
                                af.type = TokenType.ANONYM_FUN;
                            }
                            this.checkVarsInQuoted(af);
                            waitingForValue = false;
                            continue;
                        }
                        this.checkProtected();
                    }
                    pseq.addToken(this.current);
                    Token former = this.current.copy(null);
                    this.next();
                    if (former.type == TokenType.PROP_NAME && this.current.type == TokenType.OBJ_NAME) {
                        throw new RuntimeException("Misplaced property name " + this.konto.getFullName(former) + ". Probably, error in a class name");
                    }
                    waitingForValue = false;
                    continue;
                }
                if (this.is(TokenType.OPER, Operation.INVERSE)) {
                    if (waitingForValue) {
                        this.getPath(pseq, null);
                        waitingForValue = false;
                        continue;
                    }
                    break block75;
                }
                if (this.isYieldKw()) {
                    if (this.yields < 0) {
                        throw new RuntimeException("Misplaced yield operator (can be only in collection-wise function declarations and sequence generators" + this.current.getPosition());
                    }
                    ++this.yields;
                    Token yield = this.current;
                    this.current.type = TokenType.YIELD;
                    this.next();
                    this.getPathTerm(yield.getSeq());
                    pseq.addToken(yield);
                    continue;
                }
                if (this.current.isKw(KeyWord.BREAKKW)) {
                    this.current.type = TokenType.BREAK;
                    pseq.addToken(this.current);
                    this.next();
                    continue;
                }
                if (this.current.isKw(KeyWord.RETURNKW)) {
                    this.current.type = TokenType.RETURN;
                    pseq.addToken(this.current);
                    Token retn = this.current;
                    this.next();
                    if (this.current.isKw(KeyWord.ELSE) || this.current.isDelim(',') || this.current.isDelim(';') || this.current.isDelim('}') || this.current.isDelim(')') || this.current.isDelim(']')) continue;
                    if (this.current.isSlash()) {
                        throw new RuntimeException("Unreachable path step after 'return' " + this.current.getPosition());
                    }
                    this.getPathTerm(retn.getSeq());
                    continue;
                }
                if (this.is(TokenType.OPER) && this.current.value != Operation.FIELD.ordinal()) {
                    if (waitingForValue && this.current.value == Operation.MULT.ordinal()) {
                        this.current.setType(TokenType.ASTERISK);
                        this.current.value = Asterisk.AST_NS.ordinal();
                        waitingForValue = false;
                    } else if (waitingForValue && this.current.value == Operation.MINUS.ordinal()) {
                        this.current.value = Operation.UMINUS.ordinal();
                    } else {
                        if (waitingForValue && this.current.isInfixOp() && this.current.value == Operation.LT.ordinal()) {
                            new XMLCompiler(this.konto, pseq, this.tokens.in);
                            waitingForValue = false;
                            this.next();
                            continue;
                        }
                        if (this.current.isInfixOp()) {
                            if (waitingForValue) {
                                throw new RuntimeException("Left argument missed for infix operation '" + this.current.obj + "' " + this.current.getPosition());
                            }
                            waitingForValue = true;
                        } else if (this.current.isPrefixOp() && !waitingForValue) break block75;
                    }
                    pseq.addToken(this.current);
                    this.next();
                    continue;
                }
                if (this.isYieldKw()) {
                    throw new RuntimeException("Operation yield can not be a path step. Please use parentheses, if necessary.");
                }
                if (this.is(TokenType.ESCAPER)) {
                    int arity;
                    if (waitingForValue) {
                        throw new RuntimeException("Misplaced escaper '!' " + this.current.getPosition());
                    }
                    Token last = pseq.getLast();
                    if (last == null) {
                        throw new RuntimeException("Escaped expression missed " + this.current.getPosition());
                    }
                    Token escape = this.current;
                    String prefix = this.konto.getHandler().getPrefixByURI("http://ontobox.org/");
                    Token fun = new Token(TokenType.FUN_CALL, prefix, StringFuncs.EVAL_FUN, null);
                    fun.getSeq().addToken(last.copy(null));
                    if (this.tokens.in.ch == '(') {
                        Token quoted;
                        this.next();
                        if (last.getType() == TokenType.QUOTED_EXP && (quoted = last.getSub(0)).getType() != TokenType.DECLARE_INSTR) {
                            throw new RuntimeException("Parameters in !(..) can be applied only to anonymous functions" + this.current.getPosition());
                        }
                        Sequence qseq3 = Parser.createPolishToken(TokenType.QUOTED_EXP, 0, fun.getSeq(), this.tokens.in);
                        Token af = this.getPathSet(qseq3);
                        this.checkVarsInQuoted(af);
                        arity = 2;
                    } else if (last.getType() == TokenType.QUOTED_EXP) {
                        Token quoted = last.getSub(0);
                        arity = 1;
                        this.next();
                    } else if (escape.obj == null) {
                        arity = 1;
                        this.next();
                    } else {
                        fun.getSeq().addToken((Token)escape.obj);
                        arity = 2;
                        this.next();
                    }
                    int numb = this.functions.checkFunction(this.konto.getFullName(fun), arity);
                    if (numb == -1) {
                        throw new RuntimeException("Something wrong in the escaper, can not find the predefined function " + StringFuncs.EVAL_FUN + "/" + arity);
                    }
                    fun.value = numb;
                    fun.obj = this.varnums;
                    last.copyFrom(fun);
                    continue;
                }
                if (this.is(TokenType.FORALL_QUANT)) {
                    if (waitingForValue) {
                        throw new RuntimeException("The left part of forall-quantifier is missed " + this.current.getPosition());
                    }
                    Token last = pseq.getLast();
                    if (last == null) {
                        throw new RuntimeException("Path for for-all quantifier missed " + this.current.getPosition());
                    }
                    if (last.type != TokenType.PATH_EXP && !Parser.isAllowedPathHeader(last)) {
                        throw new RuntimeException("Invalid left argument of the for-all quantifier " + this.current.getPosition());
                    }
                    Token path = last.copy(this.tokens.in);
                    last.copyFrom(this.current);
                    qseq = last.getNewSeq();
                    qseq.addToken(path);
                    this.next();
                    this.getPredicate(qseq, "in for-all operator");
                    waitingForValue = false;
                    continue;
                }
                if (this.is(TokenType.FUNCTOR)) {
                    if (waitingForValue) {
                        this.getFunCall(pseq);
                        waitingForValue = false;
                        continue;
                    }
                } else {
                    if (this.current.isDelim('{')) {
                        this.getPath(pseq, head);
                        waitingForValue = false;
                        continue;
                    }
                    if (this.is(TokenType.SLASH) || this.is(TokenType.EMPTY_CONTEXT) || this.current.isDelim('[') || this.current.isDelim('<') || this.current.isDelim('{') || this.is(TokenType.OPER, Operation.FIELD) || this.is(TokenType.INDX_OPER)) {
                        if (!Parser.isAllowedPathHeader(head)) {
                            Token tk;
                            if (!this.is(TokenType.SLASH) && !this.is(TokenType.EMPTY_CONTEXT)) {
                                throw new RuntimeException("Misplaced term or predicate " + this.current.getPosition());
                            }
                            if (this.is(TokenType.SLASH)) {
                                tk = allObj.copy(this.tokens.in);
                            } else {
                                tk = this.current.copy(this.tokens.in);
                                this.current.type = TokenType.SLASH;
                            }
                            pseq.addToken(tk);
                            this.getPath(pseq, tk);
                        } else {
                            this.getPath(pseq, head);
                        }
                        waitingForValue = false;
                        continue;
                    }
                    if (this.current.isIfKw()) {
                        if (waitingForValue) {
                            this.getIfExpression(pseq);
                            waitingForValue = false;
                            continue;
                        }
                    } else {
                        if (!this.current.isForKw()) break;
                        if (waitingForValue) {
                            this.getForExpression(pseq);
                            waitingForValue = false;
                            continue;
                        }
                    }
                }
                break block75;
                break;
            }
            if (this.is(TokenType.QUOTE)) {
                throw new RuntimeException("Misplaced quote '`' " + this.current.getPosition());
            }
        }
        pseq.piChecker();
        Parser.inAsCatcher(pseq);
        return pseq.parent;
    }

    private static void inAsCatcher(Sequence seq) {
        for (int i = 0; i < seq.size(); ++i) {
            if (!seq.get(i).isInOp()) continue;
            seq.get((int)i).obj = new Token(TokenType.BASIC_TYPE, 0, 0, null).copyFrom(seq.get(i + 1));
            seq.get((int)(i + 1)).type = TokenType.BASIC_TYPE;
            seq.get((int)(i + 1)).obj = 0;
        }
    }

    private static boolean isAllowedPathHeader(Token tok) {
        return tok != null && (tok.type == TokenType.PROP_NAME || tok.type == TokenType.FUN_CALL || tok.type == TokenType.SET_EXP || tok.type == TokenType.OBJ_NAME || tok.type == TokenType.ASTERISK || tok.type == TokenType.CLASS_NAME || tok.type == TokenType.VAR_REF || tok.type == TokenType.INVERSE_OPROP_NAME || tok.type == TokenType.DOT || tok.type == TokenType.DDOT || tok.type == TokenType.EMPTY_CONTEXT || tok.type == TokenType.TERM_EXP || tok.type == TokenType.PATH_EXP || tok.type == TokenType.GET_FIELD || tok.type == TokenType.MAP_OBJECT_CREATOR || tok.type == TokenType.QUESTION || tok.type == TokenType.BASIC_TYPE || tok.type == TokenType.STRING_SEGMENT || tok.type == TokenType.EMBEDDED_LANG || tok.type == TokenType.QUOTED_EXP || tok.type == TokenType.ENTITY_TYPE);
    }

    void getDelim(char d, String where) {
        if (!this.current.isDelim(d)) {
            throw new RuntimeException("Missing '" + d + "' in " + where + " " + this.current.getPosition());
        }
        this.next();
    }

    void getKeyword(KeyWord kw, String where) {
        if (this.current.type != TokenType.KEYWORD || this.current.value != kw.ordinal()) {
            throw new RuntimeException("Missing keyword'" + kw.name() + "' in " + where + " " + this.current.getPosition());
        }
        this.next();
    }

    void getWord(String word, boolean optional, String msg) {
        if (this.current.type == TokenType.PROP_NAME && this.current.prefix == null && this.current.name.equals(word)) {
            this.next();
        } else if (!optional) {
            throw new RuntimeException("Missing '" + word + "' in " + msg + " " + this.current.getPosition());
        }
    }

    public static Sequence createToken(TokenType type, Sequence seq, CharStream in) {
        return Parser.createToken(type, 0, seq, in);
    }

    public static Sequence createToken(TokenType type, int value, Sequence seq, CharStream in) {
        Token qu = new Token(type, value, in);
        seq.addToken(qu);
        return qu.getSeq();
    }

    public static Sequence createPolishToken(TokenType type, int value, Sequence seq, CharStream in) {
        Token qu = new Token(type, value, in);
        if (seq != null) {
            seq.addToken(qu);
        }
        qu.seq = new Sequence(qu, 2);
        return qu.seq;
    }

    boolean is(TokenType tp, KeyWord v) {
        int vl = v.ordinal();
        return this.current.type == tp && this.current.value == vl;
    }

    boolean is(TokenType tp, Delimiter v) {
        int vl = v.ordinal();
        return this.current.type == tp && this.current.value == vl;
    }

    boolean is(TokenType tp, Operation v) {
        int vl = v.ordinal();
        return this.current.type == tp && this.current.value == vl;
    }

    boolean is(TokenType tp, Operator v) {
        int vl = v.ordinal();
        return this.current.type == tp && this.current.value == vl;
    }

    boolean is(TokenType tp) {
        return this.current.type == tp;
    }

    boolean isState() {
        return this.current.getType() == TokenType.PROP_NAME && this.current.getPrefix() == null;
    }

    boolean isState(String name) {
        return this.isState() && this.current.getName().equals(name);
    }

    public boolean isEOF() {
        return this.current.isEOF();
    }

    public static boolean isInt(Token tp) {
        return tp.getType() == TokenType.BASIC_TYPE && tp.getObj() instanceof Integer;
    }

    public static boolean isLong(Token tp) {
        return tp.getType() == TokenType.BASIC_TYPE && tp.getObj() instanceof Long;
    }

    public static boolean isDouble(Token tp) {
        return tp.getType() == TokenType.BASIC_TYPE && tp.getObj() instanceof Double;
    }

    public static boolean isString(Token tp) {
        return tp.getType() == TokenType.BASIC_TYPE && tp.getObj() instanceof String;
    }

    public boolean isQueryKw() {
        return this.current.isQueryKw();
    }

    public boolean isOntologyKw() {
        return this.current.isKw(KeyWord.ONTOLOGY);
    }

    public boolean isRequireKw() {
        return this.current.isKw(KeyWord.REQUIRE);
    }

    public boolean isClassKw() {
        return this.current.isKw(KeyWord.CLASS);
    }

    public boolean isPrefixKw() {
        return this.current.isKw(KeyWord.PREFIX);
    }

    public boolean isYieldKw() {
        return this.current.isKw(KeyWord.YIELDKW);
    }

    public boolean isFunctionDeclarationKw() {
        return this.current.isFunctionDeclarationKw();
    }

    public void next() {
        this.oldcurrent = this.current;
        this.filePosition = this.tokens.in.getFilePos();
        do {
            this.current = this.tokens.nextToken();
        } while (this.current.isComment());
        if (this.current.isOpenStringSegment()) {
            boolean issegment;
            Token tmpoldcurrent = this.oldcurrent;
            Token stringchain = new Token(TokenType.STRING_SEGMENT, 0, this.tokens.in);
            char curquote = this.current.getName().charAt(0);
            Sequence seq = stringchain.getSeq();
            this.current.setType(TokenType.BASIC_TYPE);
            seq.addToken(this.current);
            do {
                this.next();
                this.tokens.in.setSegments(false);
                this.getPathTerm(seq);
                this.tokens.in.setSegments(true);
                if (!this.current.isDelim('}')) {
                    throw new RuntimeException("Closing '}' not found in the string chain " + this.current.getPosition());
                }
                this.current = Tokens.getNextStringSegment(this.tokens.in, curquote);
                curquote = this.current.getName().charAt(0);
                seq.addToken(this.current);
                issegment = this.current.isOpenStringSegment();
                this.current.setType(TokenType.BASIC_TYPE);
            } while (issegment);
            this.current = new Token(TokenType.STRING_SEGMENT, 1, this.tokens.in);
            if (this.tokens.in.ch == '!') {
                this.tokens.in.nextChk();
                if (this.tokens.in.isFirstNameLetter()) {
                    String name;
                    String[] qname = this.tokens.in.getQName();
                    String prefix = qname[0];
                    Token fun = new Token(TokenType.FUN_CALL, prefix, name = qname[1], null);
                    int numb = this.functions.checkFunction(this.konto.getFullName(fun), 1);
                    if (numb == -1) {
                        numb = this.functions.pushFunction(this.konto.getFullName(fun), 1);
                    }
                    fun.value = numb;
                    for (Token s : seq) {
                        if (s.getType() != TokenType.TERM_EXP) continue;
                        Token nw = fun.copy(null);
                        nw.getSeq().addToken(s.copy(null));
                        s.copyFrom(nw);
                    }
                }
            }
            this.current.setSeq(seq);
            this.oldcurrent = tmpoldcurrent;
        }
    }

    public void addEmbeddedLanguage(EmbeddedLanguage el) {
        this.tokens.addEmbeddedLanguage(el);
    }

    String genID(String prefix) {
        ++this.idgencounter;
        return prefix + this.idgencounter;
    }

    public void pushIn(CharStream inin) {
        StreamState ss = new StreamState();
        ss.tmpin = this.tokens.in;
        ss.segments = this.tokens.in.areSegments();
        this.tokens.in = inin;
        ss.tmpoldcurrent = this.oldcurrent;
        this.next();
        this.streamStack.push(ss);
        ss.progtext = this.konto.getHandler().progtext;
        ss.filePosition = this.filePosition;
        this.konto.getHandler().progtext = new StringBuilder();
        this.tokens.in.setExtbuffer(this.konto.getHandler().progtext);
    }

    public void popIn() {
        StreamState ss = this.streamStack.pop();
        this.tokens.in = ss.tmpin;
        this.oldcurrent = ss.tmpoldcurrent;
        this.tokens.in.setSegments(ss.segments);
        this.konto.getHandler().progtext = ss.progtext;
        this.filePosition = ss.filePosition;
    }

    public void pushIn1(CharStream inin, boolean next) {
        StreamState ss = new StreamState();
        ss.tmpin = this.tokens.in;
        ss.segments = this.tokens.in.areSegments();
        this.tokens.in = inin;
        ss.tmpoldcurrent = this.current;
        if (next) {
            this.next();
        }
        this.streamStack.push(ss);
        ss.progtext = this.konto.getHandler().progtext;
        ss.filePosition = this.filePosition;
        this.konto.getHandler().progtext = new StringBuilder();
        this.tokens.in.setExtbuffer(this.konto.getHandler().progtext);
    }

    public void popIn1() {
        StreamState ss = this.streamStack.pop();
        this.tokens.in = ss.tmpin;
        this.current = ss.tmpoldcurrent;
        this.tokens.in.setSegments(ss.segments);
        this.konto.getHandler().progtext = ss.progtext;
        this.filePosition = ss.filePosition;
    }

    protected static boolean isNewType(String uri) {
        return NEW_TYPE.matcher(uri).matches();
    }

    public static boolean checkURI(String uri) {
        return Parser.isNewType(uri) || uripattern.matcher(uri).matches();
    }

    public static boolean checkURIP(String uri) {
        return urippattern.matcher(uri).matches();
    }

    void setCollectionWiseTok(Token tok) {
        boolean cw = false;
        Sequence seq = tok.getSeq();
        if (tok.getType() == TokenType.FUN_CALL && !this.isElementWiseFun(tok)) {
            cw = true;
        }
        if (!cw && seq != null) {
            cw = this.isCollectionWiseSeq(seq);
        }
        if (cw) {
            tok.setAsCollectionWise();
        } else {
            tok.setAsElementWise();
        }
    }

    private boolean isCollectionWiseSeq(Sequence sequence) {
        block9: for (Token tok : sequence) {
            if (tok == null) continue;
            switch (tok.getType()) {
                case ANONYM_FUN: 
                case QUOTED_EXP: {
                    if (!this.isCollectionWiseSeq(tok.getSeq())) break;
                    return true;
                }
                case PREDICATE: {
                    tok = tok.getSub();
                }
                case TERM_EXP: 
                case SET_EXP: 
                case STRING_SEGMENT: 
                case SWITCH: 
                case IF_EXP: {
                    if (!this.isCollectionWiseSeq(tok.getSeq())) break;
                    return true;
                }
                case OBJ_MODIFIER: {
                    Sequence mseq = tok.getSeq();
                    for (int i = 0; i < mseq.size(); ++i) {
                        Token varvalue;
                        Token mtok = mseq.get(i);
                        if (!(mtok.isVar() ? this.isCollectionWiseSeq((varvalue = mseq.get(++i)).getSeq()) : mtok.getType() == TokenType.PROPERTY_COMMAND && this.isCollectionWiseSeq(mtok.getSub(0).getSeq()))) continue;
                        return true;
                    }
                    continue block9;
                }
                case DDOT: {
                    return true;
                }
                case FUN_CALL: {
                    if (this.isElementWiseFun(tok)) break;
                    return true;
                }
                case PATH_EXP: {
                    return this.isCollectionWiseSeq(tok.getSeq().get(0).createSingleton());
                }
            }
        }
        return false;
    }

    public boolean isElementWiseFun(Token cur) {
        int fnum = cur.getValue();
        FunctionDef fd = this.functions.getDefinition(fnum);
        if (fd == null) {
            throw new RuntimeException("Function " + this.konto.getFullName(cur) + "/" + cur.getSeq().size() + " not defined " + cur.getPosition());
        }
        return !fd.isCollectionWise();
    }

    public void addFunction(String funcode) {
        CharStream in = CharStream.createCharStream();
        in.rewindString(funcode);
        this.konto.pushIn0(in);
        this.next();
        int startpos = 0;
        Sequence qseq = new Sequence(new Token(TokenType.FUN_CALL, 0, null));
        Token instruction = this.getFunctionDeclaration(qseq, null, "def");
        int endpos = this.filePosition - 1;
        int length = endpos - startpos;
        Token head = instruction.getSub(0);
        String name = head.getName();
        String uri = this.konto.getTokenURI(head);
        int arity = head.getSeq().size();
        this.konto.popIn1();
    }

    static {
        allObj = new Token(TokenType.ASTERISK, Asterisk.AST_ALL.ordinal(), null);
        tzero = new Token(TokenType.BASIC_TYPE, 0, 0, null);
        tinf = new Token(TokenType.BASIC_TYPE, 0, -1, null);
        thingType = new Token(TokenType.PROP_NAME, null, "", null);
        wordPattern = Pattern.compile("^[a-zA-Z][a-zA-Z\\d]*$");
        intPattern = Pattern.compile("[1-9][0-9]*");
        prefixPattern = Pattern.compile("^[_a-zA-Z][_\\-a-zA-Z\\d]*$");
        URI_REGEXP = "(http|ftp|https):\\/\\/[\\w\\-_]+(\\.[\\w\\-_]+)*([\\w\\-\\.,@?^=%&amp;:/~\\+]*[\\w\\-\\@?^=%&amp;/~\\+])?";
        NEW_TYPE = Pattern.compile("(\\w+\\.)*\\w+");
        URIP_REGEXP = URI_REGEXP + "#[\\w\\-_]+";
        uripattern = Pattern.compile(URI_REGEXP);
        urippattern = Pattern.compile(URIP_REGEXP);
    }

    private class StreamState {
        CharStream tmpin;
        Token tmpoldcurrent;
        boolean segments;
        StringBuilder progtext;
        int filePosition;

        private StreamState() {
        }
    }
}

