/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.util.ArrayList;
import java.util.Iterator;
import org.ontobox.libretto.parser.Asterisk;
import org.ontobox.libretto.parser.Display;
import org.ontobox.libretto.parser.Operation;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public class Sequence
implements Iterable<Token> {
    final ArrayList<Token> sequence;
    short state;
    int last;
    Token parent;
    short type;
    static final short SEQUENTIAL = 1;
    static final short POLISH = 2;
    static final short S_OPER = 1;
    static final short S_VALUE = 2;
    static final int MAX_PRIOR = 1000000;

    private static int getPrior(Token tok) {
        if (tok.type == TokenType.OPER) {
            return Operation.values()[tok.value].getPriority();
        }
        return 0;
    }

    public Sequence(Token prnt, short tp) {
        this.sequence = new ArrayList();
        this.state = 1;
        this.last = -1;
        this.parent = prnt;
        this.type = tp;
    }

    public Sequence(Token prnt) {
        this(prnt, 1);
    }

    public Sequence(Sequence original) {
        this.sequence = new ArrayList<Token>(original.sequence);
        this.state = original.state;
        this.last = original.last;
        this.parent = original.parent;
        this.type = original.type;
    }

    public int addToken(Token tok) {
        if (this.type == 1) {
            this.sequence.add(tok);
            this.last = this.sequence.size() - 1;
            return this.last;
        }
        return this.pushToken(tok);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pushToken(Token tok) {
        if (tok.isValue() || tok.type == TokenType.EMPTY_CONTEXT) {
            if (this.state == 2) {
                throw new RuntimeException("Misplaced value (" + (Object)((Object)tok.getType()) + ") in path term");
            }
            if (this.last >= 0) {
                Token lt = this.sequence.get(this.last);
                if (lt.type == TokenType.OPER && lt.value == Operation.UMINUS.ordinal() && tok.type == TokenType.BASIC_TYPE) {
                    Object obj = tok.obj;
                    if (obj instanceof Integer) {
                        lt.type = TokenType.BASIC_TYPE;
                        lt.obj = -((Integer)tok.obj).intValue();
                        this.state = (short)2;
                        return this.last;
                    }
                    if (obj instanceof Double) {
                        lt.type = TokenType.BASIC_TYPE;
                        lt.obj = -((Double)tok.obj).doubleValue();
                        this.state = (short)2;
                        return this.last;
                    }
                    if (obj instanceof Long) {
                        lt.type = TokenType.BASIC_TYPE;
                        lt.obj = -((Long)tok.obj).longValue();
                        this.state = (short)2;
                        return this.last;
                    }
                }
            }
            this.state = (short)2;
        } else if (tok.isInfixOp()) {
            if (this.state == 1) {
                if (tok.value == Operation.MINUS.ordinal()) {
                    tok.value = Operation.UMINUS.ordinal();
                } else {
                    if (tok.value != Operation.MULT.ordinal()) throw new RuntimeException("Misplaced infix operator in path term '" + Display.opshow[tok.value] + '\'');
                    tok.type = TokenType.ASTERISK;
                    tok.value = Asterisk.AST_NS.ordinal();
                    tok.prefix = null;
                    this.state = (short)2;
                }
            } else {
                this.state = 1;
            }
        } else {
            if (!tok.isPrefixOp()) throw new RuntimeException("Undefined Polish inverse sequence state for " + tok);
            if (this.state == 2) {
                throw new RuntimeException("Misplaced prefix operator in path term" + Display.opshow[tok.value] + '\'');
            }
            this.state = 1;
        }
        tok.prior = Sequence.getPrior(tok);
        int pos = -1;
        for (int i = 0; i < this.sequence.size(); ++i) {
            Token checked = this.sequence.get(i);
            if (checked.prior > tok.prior) continue;
            pos = i;
            this.sequence.add(i, tok);
            checked.prior = 0;
            break;
        }
        if (pos == -1) {
            this.sequence.add(tok);
            pos = this.sequence.size() - 1;
        }
        this.last = pos;
        return pos;
    }

    boolean piChecker() {
        int pl = this.sequence.size() - 1;
        for (int i = this.sequence.size() - 1; i >= 0; --i) {
            Token tok = this.sequence.get(i);
            if (tok.isInfixOp()) {
                if (pl - i < 2) {
                    throw new RuntimeException("The lack of arguments in predicate");
                }
                pl -= 2;
                continue;
            }
            if (!tok.isPrefixOp()) continue;
            if (pl - i < 1) {
                throw new RuntimeException("The lack of arguments in term or predicate");
            }
            --pl;
        }
        if (pl != 0) {
            throw new RuntimeException("Something wrong in term or predicate " + this.sequence);
        }
        return true;
    }

    public Token getParent() {
        return this.parent;
    }

    public Token getLast() {
        if (this.last == -1) {
            return null;
        }
        return this.sequence.get(this.last);
    }

    @Override
    public Iterator<Token> iterator() {
        return this.sequence.iterator();
    }

    public Token get(int n) {
        if (n >= 0 && n <= this.sequence.size()) {
            return this.sequence.get(n);
        }
        return null;
    }

    public final Token getFast(int n) {
        return this.sequence.get(n);
    }

    public int size() {
        return this.sequence.size();
    }

    public boolean isSingle() {
        return this.sequence.size() == 1;
    }

    public boolean isAbsolutePath() {
        return this.get((int)0).type == TokenType.ASTERISK && this.get((int)0).value == Asterisk.AST_ALL.ordinal();
    }

    public void substituteLast(Token tok) {
        Token last = this.getLast();
        last.copyFrom(tok);
    }

    public void remove(int n) {
        this.sequence.remove(n);
    }

    public void clear() {
        this.sequence.clear();
        this.last = -1;
        this.state = 1;
    }

    public Sequence copy() {
        return new Sequence(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, null);
        return sb.toString();
    }

    public void toString(StringBuilder sb, Object[] args) {
        boolean next = false;
        if (this.type == 1) {
            for (Token t : this.sequence) {
                if (next && t.type != TokenType.PREDICATE && t.type != TokenType.OBJ_MODIFIER && t.type != TokenType.OBJ_MODIFY_INSTR && t.type != TokenType.INDX_OPER && t.type != TokenType.SET_FIELD && t.type != TokenType.EMPTY_CONTEXT) {
                    sb.append(" / ");
                } else if (next) {
                    sb.append(" ");
                }
                t.pathToString(sb, args);
                next = true;
                if (t.type != TokenType.EMPTY_CONTEXT) continue;
                next = false;
            }
        } else {
            Iterator<Token> it = this.sequence.iterator();
            this.constructPolish(sb, it, 1000000, args);
        }
    }

    public void constructPolish(StringBuilder sb, Iterator<Token> cur, int priority, Object[] args) {
        Token tok = cur.next();
        StringBuilder sbloc = new StringBuilder();
        if (tok.isInfixOp()) {
            sbloc.setLength(0);
            this.constructPolish(sbloc, cur, tok.prior, args);
            this.constructPolish(sb, cur, tok.prior, args);
            sb.append(' ');
            sb.append(tok.obj);
            sb.append(' ');
            sb.append((CharSequence)sbloc);
        } else if (tok.isPrefixOp()) {
            sb.append(tok.obj);
            sb.append(' ');
            this.constructPolish(sb, cur, tok.prior, args);
        } else {
            tok.pathToString(sb, args);
        }
    }
}

