/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.util.ArrayList;
import org.ontobox.libretto.T;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.metalang.EmbeddedLanguage;
import org.ontobox.libretto.parser.Asterisk;
import org.ontobox.libretto.parser.Delimiter;
import org.ontobox.libretto.parser.KeyWord;
import org.ontobox.libretto.parser.Operation;
import org.ontobox.libretto.parser.Operator;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.TokenType;

public class Token {
    public static final int KEY_PROPERTY = 115;
    TokenType type;
    int value;
    String name;
    String prefix;
    String uri;
    String position;
    Object obj;
    Object info;
    int prior;
    int number;
    Sequence seq;
    private int checkbox = 0;
    private static final int COLLECTION_WISE = 3;
    private static final int ELEMENT_WISE = 1;
    private static int EDITED_PROP_IS_RIGHTMOST = 4;
    private static int TEMPORARY_OBJECT = 8;
    private static int EDITED_PROP_IN_OBJ_CREATOR = 16;

    public Token(TokenType tokenType, int v, CharStream in) {
        this.type = tokenType;
        this.value = v;
        this.seq = null;
        this.position = in != null ? in.getPosition() : "";
    }

    public Token(TokenType tokenType, String n, CharStream in) {
        this.type = tokenType;
        this.name = n;
        this.position = in != null ? in.getPosition() : "";
    }

    public Token(TokenType tokenType, int v, Object o, CharStream in) {
        this.type = tokenType;
        this.value = v;
        this.obj = o;
        this.seq = null;
        this.position = in != null ? in.getPosition() : "";
    }

    public Token(TokenType tokenType, String pr, String nm, CharStream in) {
        this.type = tokenType;
        this.prefix = pr;
        this.name = nm;
        this.seq = null;
        this.position = in != null ? in.getPosition() : "";
    }

    public Token(TokenType tokenType, int val, String pr, String nm, Object o, CharStream in) {
        this.type = tokenType;
        this.value = val;
        this.prefix = pr;
        this.name = nm;
        this.obj = o;
        this.seq = null;
        this.position = in != null ? in.getPosition() : "";
    }

    public Sequence getSeq() {
        if (this.seq == null) {
            this.seq = new Sequence(this, 1);
        }
        return this.seq;
    }

    public void setSeq(Sequence s) {
        this.seq = s;
    }

    public void setType(TokenType tt) {
        this.type = tt;
    }

    public void setValue(int v) {
        this.value = v;
    }

    public void setUri(String u) {
        this.uri = u;
    }

    public String getUri() {
        return this.uri;
    }

    public Token getSub() {
        if (this.seq == null) {
            return null;
        }
        if (this.seq.size() == 0) {
            return null;
        }
        return this.seq.get(0);
    }

    public Token getSub(int i) {
        if (this.seq == null) {
            return null;
        }
        if (this.seq.size() <= i) {
            return null;
        }
        return this.seq.get(i);
    }

    public Sequence getNewSeq() {
        this.seq = new Sequence(this, 1);
        return this.seq;
    }

    public boolean isUpdateKw() {
        if (this.type != TokenType.KEYWORD) {
            return false;
        }
        KeyWord v = KeyWord.values()[this.value];
        return v == KeyWord.UPDATE;
    }

    public boolean isQueryKw() {
        return this.type == TokenType.KEYWORD && this.value == KeyWord.QUERY.ordinal();
    }

    public boolean isFunctionDeclarationKw() {
        return this.type == TokenType.KEYWORD && (this.value == KeyWord.FUNCTION.ordinal() || this.value == KeyWord.GENERATOR.ordinal());
    }

    public boolean isIfKw() {
        return this.type == TokenType.KEYWORD && this.value == KeyWord.IF.ordinal();
    }

    public boolean isElseKw() {
        return this.type == TokenType.KEYWORD && this.value == KeyWord.ELSE.ordinal();
    }

    public boolean isForKw() {
        return this.type == TokenType.KEYWORD && this.value == KeyWord.FOR.ordinal();
    }

    public boolean isInOp() {
        return this.type == TokenType.OPER && this.value == Operation.IN.ordinal();
    }

    public boolean isKw(KeyWord kw) {
        return this.type == TokenType.KEYWORD && this.value == kw.ordinal();
    }

    public boolean isEOF() {
        return this.type == TokenType.DELIM && this.value == Delimiter.EOF.ordinal();
    }

    public boolean isDelim(char d) {
        if (this.type != TokenType.DELIM) {
            return false;
        }
        switch (d) {
            case '(': {
                return this.value == Delimiter.OPEN_PARENTH.ordinal();
            }
            case ')': {
                return this.value == Delimiter.CLOSE_PARENTH.ordinal();
            }
            case '{': {
                return this.value == Delimiter.OPEN_CURLY.ordinal();
            }
            case '}': {
                return this.value == Delimiter.CLOSE_CURLY.ordinal();
            }
            case '[': {
                return this.value == Delimiter.OPEN_BRACKET.ordinal();
            }
            case ']': {
                return this.value == Delimiter.CLOSE_BRACKET.ordinal();
            }
            case ',': {
                return this.value == Delimiter.COMMA.ordinal();
            }
            case ';': {
                return this.value == Delimiter.SEMICOLON.ordinal();
            }
            case '<': {
                return this.value == Delimiter.LANGLE.ordinal();
            }
            case '>': {
                return this.value == Delimiter.RANGLE.ordinal();
            }
        }
        return false;
    }

    public boolean isClosingDelim() {
        return this.type == TokenType.DELIM && (this.value == Delimiter.CLOSE_PARENTH.ordinal() || this.value == Delimiter.CLOSE_CURLY.ordinal() || this.value == Delimiter.CLOSE_BRACKET.ordinal() || this.value == Delimiter.COMMA.ordinal() || this.value == Delimiter.SEMICOLON.ordinal() || this.value == Delimiter.RANGLE.ordinal());
    }

    public boolean isSlash() {
        return this.type == TokenType.SLASH;
    }

    public boolean isDSlash() {
        return this.type == TokenType.DSLASH;
    }

    public boolean isOpenStringSegment() {
        return this.type == TokenType.STRING_SEGMENT && this.value == 0;
    }

    public boolean isAssignment() {
        return this.type == TokenType.PROP_OPERATOR && this.value == Operator.ASSIGN.ordinal();
    }

    public boolean isValue() {
        switch (this.type) {
            case BASIC_TYPE: 
            case ENTITY_TYPE: 
            case LIB_TYPE: 
            case QNAME: 
            case OBJ_NAME: 
            case VAR_REF: 
            case QUESTION: 
            case DOT: 
            case DDOT: 
            case PROP_NAME: 
            case PATH_EXP: 
            case QUOTED_EXP: 
            case ASTERISK: 
            case SET_EXP: 
            case ASSIGN_INSTR: 
            case CLASS_NAME: 
            case GET_FIELD: 
            case FUN_CALL: 
            case YIELD: 
            case MAP_OBJECT_CREATOR: 
            case MAP: 
            case IF_EXP: 
            case FOR_EXP: 
            case STRING_SEGMENT: 
            case EMBEDDED_LANG: 
            case OBJ_MODIFIER: 
            case INDX: 
            case ANONYM_FUN: 
            case BREAK: 
            case RETURN: 
            case SWITCH: 
            case DECLARE_INSTR: {
                return true;
            }
        }
        return false;
    }

    public boolean isAtomic() {
        switch (this.type) {
            case BASIC_TYPE: 
            case ENTITY_TYPE: 
            case LIB_TYPE: 
            case QNAME: 
            case OBJ_NAME: 
            case VAR_REF: 
            case QUESTION: 
            case DOT: 
            case DDOT: 
            case PROP_NAME: 
            case ASTERISK: 
            case STRING_SEGMENT: {
                return true;
            }
        }
        return false;
    }

    public boolean isInfixOp() {
        return this.type == TokenType.OPER && (this.value == Operation.PLUS.ordinal() || this.value == Operation.PPLUS.ordinal() || this.value == Operation.MINUS.ordinal() || this.value == Operation.MULT.ordinal() || this.value == Operation.DIV.ordinal() || this.value == Operation.MOD.ordinal() || this.value == Operation.GEQ.ordinal() || this.value == Operation.GT.ordinal() || this.value == Operation.LEQ.ordinal() || this.value == Operation.LT.ordinal() || this.value == Operation.NEQ.ordinal() || this.value == Operation.EQ.ordinal() || this.value == Operation.AND.ordinal() || this.value == Operation.OR.ordinal() || this.value == Operation.IN.ordinal());
    }

    public boolean isPrefixOp() {
        return this.type == TokenType.OPER && (this.value == Operation.NOT.ordinal() || this.value == Operation.UMINUS.ordinal() || this.value == Operation.EVAL.ordinal());
    }

    public boolean isUnQName() {
        return this.type == TokenType.PROP_NAME && this.prefix == null;
    }

    public boolean isComment() {
        return this.type == TokenType.COMMENT;
    }

    public boolean isVar() {
        return this.type == TokenType.VAR_REF;
    }

    public boolean isWord(String word) {
        return (this.type == TokenType.PROP_NAME || this.type == TokenType.CLASS_NAME || this.type == TokenType.ENTITY_TYPE) && word.equals(this.name) && this.prefix == null;
    }

    public final TokenType getType() {
        return this.type;
    }

    public final int getValue() {
        return this.value;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String n) {
        this.name = n;
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public final void setPrefix(String p) {
        this.prefix = p;
    }

    public final Object getObj() {
        return this.obj;
    }

    public final Object getInfo() {
        return this.info;
    }

    public final void setInfo(Object o) {
        this.info = o;
    }

    public final void setNumber(int num) {
        this.number = num;
    }

    public final void setObj(Object o) {
        this.obj = o;
    }

    public final int getNumber() {
        return this.number;
    }

    public final String getPosition() {
        return this.position;
    }

    public final void setPosition(String pos) {
        this.position = pos;
    }

    public Sequence createSingleton() {
        Sequence seq = new Sequence(null, 1);
        seq.sequence.add(this);
        return seq;
    }

    public Token copy(CharStream in) {
        Token tk = new Token(this.type, this.value, this.prefix, this.name, this.obj, in);
        tk.position = this.position;
        tk.uri = this.uri;
        tk.number = this.number;
        if (this.seq != null) {
            tk.seq = this.seq.copy();
            tk.seq.parent = tk;
        }
        return tk;
    }

    public Token copyFrom(Token tok) {
        this.type = tok.type;
        this.value = tok.value;
        this.prefix = tok.prefix;
        this.name = tok.name;
        this.obj = tok.obj;
        this.seq = tok.seq;
        this.uri = tok.uri;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.pathToString(sb, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
        return sb.toString();
    }

    public void pathToString(StringBuilder sb, Object[] args) {
        switch (this.type) {
            case QUERY_INSTR: {
                this.seq.toString(sb, args);
                sb.append(';');
                break;
            }
            case OBJ_NAME: 
            case PROP_NAME: 
            case CLASS_NAME: 
            case INVERSE_OPROP_NAME: 
            case EDITED_PROP_NAME: {
                if (this.type == TokenType.OBJ_NAME) {
                    sb.append('&');
                    if (this.isTemporaryObj()) {
                        sb.append('&');
                    }
                }
                if (this.type == TokenType.INVERSE_OPROP_NAME) {
                    sb.append('~');
                }
                if (this.isKey()) {
                    sb.append("@");
                }
                if (this.prefix != null) {
                    sb.append(this.prefix).append(':');
                } else if (this.name.length() == 0) {
                    this.name = this.name;
                } else if (this.type == TokenType.PROP_NAME && this.name.length() > 0 && !Helper.isFirstNameLetter(Character.valueOf(this.name.charAt(0)))) {
                    sb.append(':');
                }
                sb.append(this.name);
                break;
            }
            case CLS_MODIFY_INSTR: {
                sb.append("class ");
                this.seq.get(0).pathToString(sb, args);
                sb.append(" {");
                for (int i = 1; i < this.seq.size(); ++i) {
                    if (i > 1) {
                        sb.append(", ");
                    }
                    this.seq.get(i).pathToString(sb, args);
                }
                sb.append("};");
                break;
            }
            case FOR_EXP: {
                sb.append("for (");
                this.seq.get(0).pathToString(sb, args);
                sb.append(" in ");
                this.seq.get(1).pathToString(sb, args);
                sb.append(") ");
                for (int i = 2; i < this.seq.size() - 1; i += 2) {
                    if (i > 3) {
                        sb.append(", ");
                    }
                    this.seq.get(i).pathToString(sb, args);
                    sb.append(" := ");
                    this.seq.get(i + 1).pathToString(sb, args);
                }
                sb.append(" ");
                this.seq.get(this.seq.size() - 1).pathToString(sb, args);
                break;
            }
            case ONT_MODIFY_INSTR: {
                sb.append(this.name);
                sb.append(' ');
                this.seq.get(0).pathToString(sb, args);
                sb.append(' ');
                this.seq.get(1).pathToString(sb, args);
                sb.append(';');
                break;
            }
            case DECLARE_INSTR: {
                sb.append("def ");
                sb.append(' ');
                if (this.value == T.COLLECTION_WISE.ordinal()) {
                    sb.append("all ");
                }
                this.seq.get(0).pathToString(sb, args);
                sb.append(' ');
                for (int i = 1; i < this.seq.size() - 1; i += 2) {
                    if (i > 1) {
                        sb.append(", ");
                    }
                    this.seq.get(i).pathToString(sb, args);
                    sb.append(" := ");
                    this.seq.get(i + 1).pathToString(sb, args);
                }
                if (this.seq.size() > 2) {
                    sb.append(", ");
                } else {
                    sb.append(" ");
                }
                this.seq.get(this.seq.size() - 1).pathToString(sb, args);
                break;
            }
            case FUNCTOR: {
                String funname = this.prefix == null ? this.name : this.prefix + ":" + this.name;
                sb.append(funname);
                sb.append('(');
                boolean next = false;
                if (this.seq != null) {
                    for (Token t : this.seq) {
                        if (next) {
                            sb.append(", ");
                        }
                        next = true;
                        t.pathToString(sb, args);
                    }
                }
                sb.append(")");
                break;
            }
            case TPROP_UPDATER: 
            case OPROP_UPDATER: {
                this.seq.get(0).pathToString(sb, args);
                int min = this.seq.get((int)1).value;
                int max = this.seq.get((int)2).value;
                if (min != 0 || max != -1) {
                    sb.append('[');
                    sb.append(min);
                    sb.append(", ");
                    sb.append(max);
                    sb.append(']');
                }
                sb.append(" {");
                this.seq.get(3).pathToString(sb, args);
                sb.append("}");
                break;
            }
            case VAR_REF: {
                sb.append('$');
                String s = this.name;
                sb.append(s);
                if (args == null || this.obj == null) break;
                sb.append('(');
                Object o = args[-this.value];
                if (o == null) {
                    sb.append('?');
                } else {
                    if (o instanceof OntCollection && ((OntCollection)o).size() == 1) {
                        o = ((OntCollection)o).get(0);
                    }
                    sb.append(o.toString());
                }
                sb.append(')');
                break;
            }
            case PREDICATE: {
                sb.append('[');
                this.seq.toString(sb, args);
                sb.append(']');
                break;
            }
            case TERM_EXP: {
                this.seq.toString(sb, args);
                break;
            }
            case SET_EXP: {
                sb.append('(');
                for (int i = 0; i < this.seq.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.seq.get(i).pathToString(sb, args);
                }
                sb.append(')');
                break;
            }
            case SORTER: {
                Token ordered = this.getSub();
                ordered.pathToString(sb, args);
                sb.append("<<");
                Sequence srt = (Sequence)this.obj;
                for (int j = 0; j < srt.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    srt.get(j).pathToString(sb, args);
                }
                sb.append(">>");
                break;
            }
            case ASTERISK: {
                if (this.value == Asterisk.AST_ALL.ordinal()) {
                    sb.append("*");
                } else if (this.value == Asterisk.AST_NS.ordinal() && this.prefix != null && !this.prefix.equals("")) {
                    sb.append(this.prefix);
                }
                sb.append('*');
                break;
            }
            case DOT: {
                sb.append('.');
                break;
            }
            case EMPTY_CONTEXT: {
                sb.append("// ");
                break;
            }
            case ASSIGN_INSTR: {
                this.seq.get(0).pathToString(sb, args);
                sb.append(" := ");
                this.seq.get(1).pathToString(sb, args);
                break;
            }
            case INDX: {
                sb.append("at ");
                break;
            }
            case INDX_OPER: {
                sb.append("at ");
                this.seq.get(0).pathToString(sb, args);
                break;
            }
            case DDOT: {
                sb.append("..");
                break;
            }
            case OBJ_MODIFIER: 
            case ANONYM_FUN: {
                sb.append("{");
                for (int i = 0; i < this.seq.size(); ++i) {
                    if (i > 0) {
                        sb.append("; ");
                    }
                    if (this.seq.get(i).isVar()) {
                        this.seq.get(i).pathToString(sb, args);
                        sb.append(" := ");
                        this.seq.get(++i).pathToString(sb, args);
                        continue;
                    }
                    this.seq.get(i).pathToString(sb, args);
                }
                sb.append('}');
                break;
            }
            case BREAK: {
                sb.append("break ");
                break;
            }
            case RETURN: {
                sb.append("return ");
                if (this.getSeq().size() != 1) break;
                sb.append(this.getSub(0));
                break;
            }
            case YIELD: {
                sb.append("yield ");
                sb.append(this.getSub(0));
                break;
            }
            case SWITCH: {
                sb.append("{");
                for (int i = 0; i < this.seq.size(); i += 2) {
                    if (i > 0) {
                        sb.append("; ");
                    }
                    sb.append("case ");
                    if (this.seq.get(i) != null) {
                        this.seq.get(i).pathToString(sb, args);
                    }
                    sb.append(" => ");
                    this.seq.get(i + 1).pathToString(sb, args);
                }
                sb.append('}');
                break;
            }
            case MAP: {
                sb.append('&');
                break;
            }
            case MAP_OBJECT_CREATOR: {
                int ii = 0;
                for (Token tk : this.seq) {
                    if (ii > 0) {
                        sb.append(' ');
                    }
                    ++ii;
                    tk.pathToString(sb, args);
                }
                break;
            }
            case STRING_SEGMENT: {
                sb.append('\"');
                sb.append(this.seq.get((int)0).name);
                for (int i = 1; i < this.seq.size() - 1; i += 2) {
                    sb.append('{');
                    this.seq.get(i).pathToString(sb, args);
                    sb.append('}');
                    sb.append(this.seq.get((int)(i + 1)).name);
                }
                sb.append('\"');
                break;
            }
            case PROPERTY_COMMAND: {
                this.seq.get(0).pathToString(sb, args);
                break;
            }
            case OBJ_MODIFY_INSTR: {
                if (this.value == Operator.ASSIGN.ordinal()) {
                    sb.append(":= ");
                } else if (this.value == Operator.INSERT_BEFORE.ordinal()) {
                    sb.append(".= ");
                } else if (this.value == Operator.INSERT_AFTER.ordinal()) {
                    sb.append("+= ");
                } else {
                    sb.append("-- ");
                }
                if (this.value == Operator.DELETE_VALUE.ordinal()) break;
                this.getSub(0).pathToString(sb, args);
                break;
            }
            case FORALL_QUANT: {
                this.getSub(0).pathToString(sb, args);
                if (this.value == 1) {
                    sb.append(" ! ");
                } else {
                    sb.append(" !! ");
                }
                sb.append(this.getSub(1));
                break;
            }
            case FUN_CALL: {
                String funname = this.prefix == null || this.prefix.equals("") ? this.name : this.prefix + ":" + this.name;
                this.seqToString(sb, funname + '(', ")", ", ", args);
                break;
            }
            case PATH_EXP: {
                this.seq.toString(sb, args);
                break;
            }
            case IF_EXP: {
                sb.append("if (");
                this.getSub(0).pathToString(sb, args);
                sb.append(") ");
                this.getSub(1).pathToString(sb, args);
                sb.append(" else ");
                this.getSub(2).pathToString(sb, args);
                break;
            }
            case OPER: {
                sb.append(this.obj);
                break;
            }
            case BASIC_TYPE: {
                if (this.obj instanceof String) {
                    sb.append('\"').append(this.escaped((String)this.obj)).append('\"');
                    break;
                }
                sb.append(this.obj);
                break;
            }
            case QUOTED_EXP: {
                sb.append('`');
                this.seq.toString(sb, args);
                break;
            }
            case CLOSURE: {
                Object[] rargs1 = (Object[])this.obj;
                this.seq.toString(sb, rargs1);
                boolean i = false;
                break;
            }
            case SET_FIELD: {
                sb.append("as $");
                sb.append(this.name);
                break;
            }
            case EMBEDDED_LANG: {
                ArrayList objs = (ArrayList)this.obj;
                String id = ((EmbeddedLanguage)objs.get(0)).getID();
                sb.append(id);
                sb.append("::_<a/>_");
                break;
            }
            case PROP_OPERATOR: {
                if (this.value == Operator.ASSIGN.ordinal()) {
                    sb.append(":= ");
                    break;
                }
                if (this.value == Operator.INSERT_BEFORE.ordinal()) {
                    sb.append(".= ");
                    break;
                }
                if (this.value == Operator.INSERT_AFTER.ordinal()) {
                    sb.append("+= ");
                    break;
                }
                sb.append("-- ");
                break;
            }
            case DELIM: {
                sb.append(this.obj);
                break;
            }
            default: {
                sb.append((Object)this.type).append("?");
            }
        }
    }

    private void seqToString(StringBuilder sb, String open, String close, String delim, Object[] args) {
        sb.append(open);
        for (int i = 0; i < this.seq.size(); ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            this.seq.get(i).pathToString(sb, args);
        }
        sb.append(close);
    }

    Sequence clear() {
        this.seq.clear();
        return this.seq;
    }

    String escaped(String str) {
        char[] cs = str.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (char c : cs) {
            if (c == '\r') {
                sb.append("\\r");
            } else if (c == '\n') {
                sb.append("\\n");
            } else if (c == '\t') {
                sb.append("\\t");
            } else {
                sb.append(c);
            }
            if (c != '\\') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void setAsCollectionWise() {
        this.checkbox |= 3;
    }

    public void setAsElementWise() {
        this.checkbox |= 1;
    }

    public boolean isCollectionWise(Parser parser) {
        int check = this.checkbox & 3;
        if (check == 0) {
            parser.setCollectionWiseTok(this);
        }
        return (this.checkbox & 3) == 3;
    }

    public void setRightmostEditedProp() {
        this.checkbox |= EDITED_PROP_IS_RIGHTMOST;
    }

    public boolean isRightmostEditedProp() {
        return (this.checkbox & EDITED_PROP_IS_RIGHTMOST) != 0;
    }

    public void setAsTemporaryObj() {
        this.checkbox |= TEMPORARY_OBJECT;
    }

    public boolean isTemporaryObj() {
        return (this.checkbox & TEMPORARY_OBJECT) != 0;
    }

    public void setAsPropInObjCreator() {
        this.checkbox |= EDITED_PROP_IN_OBJ_CREATOR;
    }

    public boolean isPropInObjCreator() {
        return (this.checkbox & EDITED_PROP_IN_OBJ_CREATOR) != 0;
    }

    public boolean isKey() {
        return this.value == 115;
    }

    public void setKey() {
        this.value = 115;
    }

    public Token quote() {
        Token t = new Token(TokenType.QUOTED_EXP, 0, null);
        t.getSeq().addToken(this);
        return t;
    }
}

