/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.libretto.LibrettoEnv;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.adapter.FunctionId;
import org.ontobox.libretto.function.BaseFuncs;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.metalang.EmbeddedLanguage;
import org.ontobox.libretto.parser.Asterisk;
import org.ontobox.libretto.parser.Delimiter;
import org.ontobox.libretto.parser.Display;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.KeyWord;
import org.ontobox.libretto.parser.Operation;
import org.ontobox.libretto.parser.Operator;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenQueue;
import org.ontobox.libretto.parser.TokenType;

public class Tokens {
    CharStream in;
    private final TokenQueue queue;
    private final HashMap<String, KeyWord> keywords;
    private final HashMap<String, Operation> ops;
    public final Display display;
    private final LocalContext konto;
    private final Map<String, EmbeddedLanguage> embeddedLangs;
    private boolean CREATE_TEMP_ONTOLOGY = false;

    public Tokens(LocalContext knt) {
        this.konto = knt;
        this.embeddedLangs = new HashMap<String, EmbeddedLanguage>();
        this.queue = new TokenQueue(this);
        this.keywords = new HashMap();
        this.ops = new HashMap();
        this.display = new Display(this);
        this.keywords.put("if", KeyWord.IF);
        this.keywords.put("else", KeyWord.ELSE);
        this.keywords.put("ontology", KeyWord.ONTOLOGY);
        this.keywords.put("prefix", KeyWord.PREFIX);
        this.keywords.put("class", KeyWord.CLASS);
        this.keywords.put("require", KeyWord.REQUIRE);
        this.keywords.put("extends", KeyWord.EXTENDS);
        this.keywords.put("yield", KeyWord.YIELDKW);
        this.keywords.put("break", KeyWord.BREAKKW);
        this.keywords.put("return", KeyWord.RETURNKW);
        this.keywords.put("var", KeyWord.VARKW);
        this.keywords.put("def", KeyWord.FUNCTION);
        this.keywords.put("gen", KeyWord.GENERATOR);
        this.ops.put("div", Operation.DIV);
        this.ops.put("mod", Operation.MOD);
        this.ops.put("and", Operation.AND);
        this.ops.put("or", Operation.OR);
        this.ops.put("not", Operation.NOT);
        this.ops.put("in", Operation.IN);
        this.ops.put("as", Operation.FIELD);
    }

    public void setInput(CharStream input) {
        this.in = input;
    }

    public Token nextToken() {
        return this.queue.poll();
    }

    public boolean isQueueEmpty() {
        return this.queue.isEmpty();
    }

    private void operEntity(String name, int arity, Token et) {
        boolean wasempty = false;
        if (et == null) {
            wasempty = true;
        }
        FunctionTable functions = this.konto.getHandler().getFunctions();
        int fnum = functions.checkFunction(name, arity);
        String prefix = this.konto.getHandler().getPrefixByURI("http://ontobox.org/");
        if (et == null) {
            et = this.qadd(TokenType.ENTITY_TYPE, fnum, prefix, null, null);
        } else {
            et.type = TokenType.ENTITY_TYPE;
            et.value = fnum;
            et.prefix = prefix;
        }
        this.konto.getLE();
        String methname = LibrettoEnv.mmethObjectName(name, 2);
        et.obj = FunctionId.newId(fnum, methname);
        if (wasempty) {
            this.in.nextValid();
        }
    }

    public void addEmbeddedLanguage(EmbeddedLanguage el) {
        this.embeddedLangs.put(el.getID(), el);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void nextToQueue() {
        if (this.in.isFirstNameLetter()) {
            this.getName(TokenType.PROP_NAME);
            return;
        }
        if (this.in.ch == '@') {
            this.in.nextValidChk();
            this.getName(TokenType.KEY_PROP);
            return;
        }
        if (this.in.isDigit()) {
            Object num = this.in.getNumber();
            this.qadd(TokenType.BASIC_TYPE, 0, num);
            return;
        }
        if (Tokens.isOp(this.in.ch)) {
            if (this.in.ch == ':') {
                this.in.nextChk();
                if (this.in.isNextNameLetter()) {
                    Token nmt = this.getName(TokenType.PROP_NAME);
                    nmt.uri = this.konto.getHandler().getUriByPrefix("");
                    nmt.prefix = "";
                    if (nmt.type != TokenType.KEYWORD) {
                        if (nmt.type != TokenType.OPER) return;
                    }
                    if (this.in.ch == '(') {
                        nmt.type = TokenType.FUNCTOR;
                        this.in.nextValidChk();
                        return;
                    }
                    nmt.type = TokenType.PROP_NAME;
                    return;
                }
                if (!this.in.isQuote()) {
                    if (!this.in.isDoubleQuote()) throw new RuntimeException("Misplaced ':' or invalid symbol after it " + this.in.getPosition());
                }
                String s = this.in.getString();
                this.qadd(TokenType.PROP_NAME, null, s);
                return;
            }
            if (this.in.ch == '\u00b7') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, Operation.MULT.ordinal(), (Object)"*");
                return;
            }
            if (this.in.ch == '*') {
                this.in.next();
                if (this.in.ch != ':') {
                    this.in.eatSpaces();
                    this.qadd(TokenType.OPER, Operation.MULT.ordinal(), (Object)"*");
                    return;
                }
                this.in.nextChk();
                if (this.in.ch != '*') {
                    throw new RuntimeException("Invalid char sequence. Must be '*:*'? " + this.in.getPosition());
                }
                this.qadd(TokenType.ASTERISK, Asterisk.AST_ALL.ordinal(), "", "*", null);
                this.in.nextValid();
                return;
            }
            if (this.in.ch == '+') {
                this.in.nextChk();
                if (this.in.ch == '=') {
                    this.in.nextValidChk();
                    this.qadd(TokenType.PROP_OPERATOR, Operator.INSERT_AFTER.ordinal());
                    return;
                }
                if (this.in.ch == '+') {
                    this.in.nextValidChk();
                    this.qadd(TokenType.OPER, Operation.PPLUS.ordinal(), (Object)"++");
                    return;
                }
                this.in.eatSpacesChk();
                this.qadd(TokenType.OPER, Operation.PLUS.ordinal(), (Object)"+");
                return;
            }
            if (this.in.ch == '-') {
                this.in.nextChk();
                if (this.in.ch != '-') {
                    this.in.eatSpacesChk();
                    this.qadd(TokenType.OPER, Operation.MINUS.ordinal(), (Object)"-");
                    return;
                }
                this.in.nextChk();
                if (this.in.ch == '>') {
                    this.qadd(TokenType.GEN_RULE, 0, (Object)"-->");
                    this.in.nextValidChk();
                    return;
                }
                this.in.eatSpacesChk();
                this.qadd(TokenType.PROP_OPERATOR, Operator.DELETE_VALUE.ordinal());
                return;
            }
            if (this.in.ch == '\u2265') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, Operation.GEQ.ordinal(), (Object)">=");
                return;
            }
            if (this.in.ch == '>') {
                this.in.nextChk();
                if (this.in.ch == '=') {
                    this.in.nextValidChk();
                    this.qadd(TokenType.OPER, Operation.GEQ.ordinal(), (Object)">=");
                    return;
                }
                if (this.in.ch == '>') {
                    this.in.nextValid();
                    this.qadd(TokenType.DELIM, Delimiter.RANGLE.ordinal(), (Object)">>");
                    return;
                }
                this.in.eatSpacesChk();
                this.qadd(TokenType.OPER, Operation.GT.ordinal(), (Object)">");
                return;
            }
            if (this.in.ch == '\u2208') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, Operation.IN.ordinal(), (Object)"in");
                return;
            }
            if (this.in.ch == '\u2264') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, Operation.LEQ.ordinal(), (Object)"<=");
                return;
            }
            if (this.in.ch == '<') {
                this.in.nextChk();
                if (this.in.ch == '=') {
                    this.in.nextValidChk();
                    this.qadd(TokenType.OPER, Operation.LEQ.ordinal(), (Object)"<=");
                    return;
                }
                if (this.in.ch == '<') {
                    this.in.nextValidChk();
                    this.qadd(TokenType.DELIM, Delimiter.LANGLE.ordinal(), (Object)"<<");
                    return;
                }
                this.in.eatSpacesChk();
                this.qadd(TokenType.OPER, Operation.LT.ordinal(), (Object)"<");
                return;
            }
            if (this.in.ch == '%') {
                this.in.nextChk();
                if (this.in.ch == ':') {
                    this.in.nextChk();
                    if (!this.in.isNextNameLetter()) return;
                    Token et = this.getName(TokenType.ENTITY_TYPE);
                    et.uri = this.konto.getHandler().getUriByPrefix("");
                    if (et.type == TokenType.KEYWORD || et.type == TokenType.OPER) {
                        et.type = TokenType.ENTITY_TYPE;
                    }
                    et.obj = Helper.getEntityByToken(this.konto, et);
                    return;
                }
                if (this.in.ch == '+') {
                    this.operEntity(BaseFuncs.PLUS_FUN, 2, null);
                    return;
                }
                if (this.in.ch == '-') {
                    this.operEntity(BaseFuncs.MINUS_FUN, 2, null);
                    return;
                }
                if (this.in.ch == '\u00b7') {
                    this.operEntity(BaseFuncs.MULT_FUN, 2, null);
                    return;
                }
                Token et = this.getName(TokenType.ENTITY_TYPE);
                if (et.isWord("mod")) {
                    this.operEntity(BaseFuncs.MOD_FUN, 2, et);
                } else if (et.isWord("div")) {
                    this.operEntity(BaseFuncs.DIV_FUN, 2, et);
                } else if (this.in.ch == '^') {
                    this.in.nextChk();
                    if (!Character.isDigit(this.in.ch)) {
                        throw new RuntimeException("Number of arguments not found in the function entity " + this.in.getPosition());
                    }
                    Object arity = this.in.getNumber();
                    if (!(arity instanceof Integer)) {
                        throw new RuntimeException("Invalid number of arguments in the function entity " + this.in.getPosition());
                    }
                    int ar = (Integer)arity;
                    String fname = this.konto.getFullName(et);
                    this.konto.getLE();
                    String methname = LibrettoEnv.mmethObjectName(fname, ar);
                    int fnum = this.konto.getHandler().getFunctions().checkFunction(fname, ar);
                    if (fnum == -1) {
                        throw new RuntimeException("The function " + fname + "/" + ar + " does not exist in the function entity " + this.in.getPosition());
                    }
                    et.obj = FunctionId.newId(fnum, methname);
                } else {
                    et.obj = Helper.getEntityByToken(this.konto, et);
                }
                if (et.obj != null) return;
                throw new RuntimeException("The entity " + this.konto.getFullName(et) + " not found " + this.in.getPosition());
            }
            if (this.in.ch == '\u00ac') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, this.ops.get("not").ordinal(), (Object)"not");
                return;
            }
            if (this.in.ch == '\u2227') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, this.ops.get("and").ordinal(), (Object)"and");
                return;
            }
            if (this.in.ch == '\u2228') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, this.ops.get("or").ordinal(), (Object)"or");
                return;
            }
            if (this.in.ch == '\u2260') {
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, Operation.NEQ.ordinal(), (Object)"!=");
                return;
            }
            if (this.in.ch == '!') {
                this.in.next();
                if (this.in.ch == '=') {
                    this.in.nextValidChk();
                    this.qadd(TokenType.OPER, Operation.NEQ.ordinal(), (Object)"!=");
                    return;
                }
                String name = null;
                if (this.in.isFirstNameLetter()) {
                    String[] qname = this.in.getQName();
                    String prefix = qname[0];
                    name = qname[1];
                    if (prefix != null) {
                        name = prefix + ":" + name;
                    }
                } else {
                    this.in.eatSpaces();
                }
                Token nametoken = null;
                if (name != null) {
                    nametoken = new Token(TokenType.BASIC_TYPE, 0, (Object)name, this.in);
                }
                this.qadd(TokenType.ESCAPER, 0, nametoken);
                return;
            }
            if (this.in.ch != '=') {
                if (this.in.ch != '~') return;
                this.in.nextValidChk();
                this.qadd(TokenType.OPER, Operation.INVERSE.ordinal(), (Object)"~");
                return;
            }
            this.in.nextChk();
            if (this.in.ch == '>') {
                this.qadd(TokenType.GEN_RULE, 0, (Object)"=>");
                this.in.nextValidChk();
                return;
            }
            if (this.in.ch == '=') {
                this.qadd(TokenType.OPER, Operation.EQ.ordinal(), (Object)"==");
                this.in.nextValidChk();
                return;
            }
            this.in.eatSpacesChk();
            this.qadd(TokenType.PROP_OPERATOR, Operator.ASSIGN.ordinal());
            return;
        }
        if (this.in.isQuote() || this.in.isDoubleQuote()) {
            StringBuilder sb = new StringBuilder();
            do {
                char curquote = this.in.ch;
                this.in.nextChk();
                sb.append((CharSequence)this.in.getFxStringSegment(curquote));
                if (this.in.ch != '{') continue;
                this.queue.add(new Token(TokenType.STRING_SEGMENT, 0, "", "" + curquote, sb.toString(), this.in));
                this.in.nextValid();
                return;
            } while (this.in.isQuote() || this.in.isDoubleQuote());
            this.queue.add(new Token(TokenType.BASIC_TYPE, 0, (Object)sb.toString(), this.in));
            return;
        }
        if (this.in.ch == '^') {
            this.in.nextChk();
            if (this.in.ch != '\"') {
                if (this.in.ch != '\'') throw new RuntimeException("Misplaced '^' " + this.in.getPosition());
            }
            char quote = this.in.ch;
            this.in.nextChk();
            StringBuilder sb = this.in.getQuoteBrackets(quote);
            this.queue.add(new Token(TokenType.BASIC_TYPE, 0, (Object)sb.toString(), this.in));
            this.in.nextValid();
            return;
        }
        if (this.in.ch == '\u00ab') {
            this.in.nextChk();
            StringBuilder sb = this.in.getQuoteBrackets('\u00bb');
            this.queue.add(new Token(TokenType.BASIC_TYPE, 0, (Object)sb.toString(), this.in));
            this.in.nextValid();
            return;
        }
        if (this.in.ch == '&') {
            this.in.nextChk();
            boolean tempo = false;
            if (this.in.ch == '&') {
                this.in.nextChk();
                tempo = true;
            }
            if (this.in.ch == ':') {
                this.in.nextChk();
                if (!(this.in.isNextNameLetter() || this.in.isQuote() || this.in.isDoubleQuote())) {
                    throw new RuntimeException("The wrong object name '&:" + this.in.ch + "'");
                }
            }
            this.in.eatSpacesChk();
            if (this.in.ch == '{') {
                Token map = this.qadd(TokenType.MAP, 0);
                if (tempo) {
                    map.setAsTemporaryObj();
                }
                this.in.nextValidChk();
                return;
            }
            if (!this.in.isQuote() && !this.in.isDoubleQuote()) {
                Token obj = this.getName(TokenType.OBJ_NAME);
                if (!tempo) return;
                obj.setAsTemporaryObj();
                return;
            }
            String s = this.in.getString();
            this.qadd(TokenType.OBJ_NAME, null, s);
            return;
        }
        if (this.in.ch == '$') {
            this.in.nextChk();
            if (!this.in.isNextNameLetter()) {
                throw new RuntimeException("Invalid variable name");
            }
            this.getName(TokenType.VAR_REF);
            return;
        }
        if (this.in.ch == '/') {
            this.in.next();
            if (this.in.ch == '/') {
                throw new RuntimeException("Double slash is not allowed " + this.in.getPosition());
            }
            this.in.eatSpaces();
            this.qadd(TokenType.SLASH, 0);
            return;
        }
        if (this.in.ch == '.') {
            this.in.next();
            if (this.in.ch == '.') {
                this.qadd(TokenType.DDOT, 0);
                this.in.nextValid();
                return;
            }
            if (this.in.ch == '=') {
                this.in.nextValidChk();
                this.qadd(TokenType.PROP_OPERATOR, Operator.INSERT_BEFORE.ordinal());
                return;
            }
            this.qadd(TokenType.DOT, 0);
            this.in.eatSpaces();
            return;
        }
        if (this.in.ch == '(') {
            this.in.nextValidChk();
            this.qadd(TokenType.DELIM, Delimiter.OPEN_PARENTH.ordinal(), (Object)"(");
            return;
        }
        if (this.in.ch == ')') {
            this.in.nextValid();
            this.qadd(TokenType.DELIM, Delimiter.CLOSE_PARENTH.ordinal(), (Object)")");
            return;
        }
        if (this.in.ch == '[') {
            this.in.nextValidChk();
            this.qadd(TokenType.DELIM, Delimiter.OPEN_BRACKET.ordinal(), (Object)"[");
            return;
        }
        if (this.in.ch == ']') {
            this.in.nextValid();
            this.qadd(TokenType.DELIM, Delimiter.CLOSE_BRACKET.ordinal(), (Object)"]");
            return;
        }
        if (this.in.ch == '{') {
            this.in.nextValidChk();
            this.qadd(TokenType.DELIM, Delimiter.OPEN_CURLY.ordinal(), (Object)"{");
            return;
        }
        if (this.in.ch == '}') {
            this.in.nextValid();
            this.qadd(TokenType.DELIM, Delimiter.CLOSE_CURLY.ordinal(), (Object)"}");
            return;
        }
        if (this.in.ch == ';') {
            this.in.nextValid();
            this.qadd(TokenType.DELIM, Delimiter.SEMICOLON.ordinal(), (Object)";");
            return;
        }
        if (this.in.ch == ',') {
            this.in.nextValidChk();
            this.qadd(TokenType.DELIM, Delimiter.COMMA.ordinal(), (Object)",");
            return;
        }
        if (this.in.ch == '?') {
            this.in.nextValid();
            this.qadd(TokenType.QUESTION, 0);
            return;
        }
        if (this.in.ch == '#') {
            String str = this.in.collectLine();
            this.queue.add(new Token(TokenType.COMMENT, null, str, this.in));
            return;
        }
        if (this.in.ch == '`') {
            throw new RuntimeException("Quote symbol ` is not used in Libretto " + this.in.getPosition());
        }
        if (!this.in.isEndOfStream()) throw new RuntimeException("Unrecognized symbol '" + this.in.ch + '\'' + this.in.getPosition());
        this.qadd(TokenType.DELIM, Delimiter.EOF.ordinal());
    }

    static boolean isOp(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '~': 
            case '\u00ac': 
            case '\u00b7': 
            case '\u2208': 
            case '\u2227': 
            case '\u2228': 
            case '\u2260': 
            case '\u2264': 
            case '\u2265': {
                return true;
            }
        }
        return false;
    }

    Token getName(TokenType type) {
        Token nmt;
        StringBuilder identChars = new StringBuilder();
        identChars.setLength(0);
        String nsprefix = null;
        do {
            identChars.append(this.in.ch);
            this.in.next();
            if (!this.in.isColon() || nsprefix != null || identChars.length() <= 0) continue;
            this.in.next();
            if (this.in.ch == ':') {
                nsprefix = identChars.toString();
                try {
                    this.getEmbedded(nsprefix);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error in embedded code: " + e.getMessage() + " " + this.in.getPosition(), e);
                }
                return null;
            }
            if (type == TokenType.ONTO_NAME || type == TokenType.VAR_REF) {
                throw new RuntimeException("Ontology names and variables can not be qualified names (with prefixes) " + this.in.getPosition());
            }
            nsprefix = identChars.toString();
            identChars.delete(0, identChars.length());
            if (this.in.isQuote() || this.in.isDoubleQuote()) {
                String s = this.in.getString();
                identChars = new StringBuilder(s);
                break;
            }
            if (this.in.ch == '*') {
                this.in.nextValid();
                if (type == TokenType.ENTITY_TYPE) {
                    return this.qadd(TokenType.ENTITY_TYPE, nsprefix, null);
                }
                return this.qadd(TokenType.ASTERISK, Asterisk.AST_NS.ordinal(), nsprefix, "*", null);
            }
            if (this.in.isNextNameLetter()) continue;
            throw new RuntimeException("Something wrong in id \"" + nsprefix + ":\" " + this.in.getPosition());
        } while (this.in.isNextNameLetter() || this.in.isColon());
        String name = identChars.toString();
        this.in.eatSpaces();
        if (this.in.isLeftPr()) {
            if (type == TokenType.ENTITY_TYPE) {
                throw new RuntimeException("Invalid combination of entity name and function call " + this.in.getPosition());
            }
            if (nsprefix == null) {
                if (this.keywords.containsKey(name) && type == TokenType.PROP_NAME) {
                    Token nmt2 = this.qadd(TokenType.KEYWORD, this.keywords.get(name).ordinal());
                    nmt2.name = name;
                    return nmt2;
                }
                if (this.ops.containsKey(name) && type == TokenType.PROP_NAME) {
                    Token nmt3 = this.qadd(TokenType.OPER, this.ops.get(name).ordinal(), (Object)name);
                    nmt3.name = name;
                    return nmt3;
                }
                if (name.equals("at") && type == TokenType.PROP_NAME) {
                    Token nmt4 = this.qadd(TokenType.INDX_OPER, 1);
                    return nmt4;
                }
                if (name.equals("case") && type == TokenType.PROP_NAME) {
                    Token nmt5 = this.qadd(type, null, name);
                    return nmt5;
                }
            }
            this.in.nextValidChk();
            nmt = this.qadd(TokenType.FUNCTOR, nsprefix, name);
        } else if (nsprefix != null) {
            nmt = this.qadd(type, nsprefix, name);
        } else if (this.keywords.containsKey(name) && type == TokenType.PROP_NAME) {
            nmt = this.qadd(TokenType.KEYWORD, this.keywords.get(name).ordinal());
            nmt.name = name;
        } else if (this.ops.containsKey(name) && type == TokenType.PROP_NAME) {
            nmt = this.qadd(TokenType.OPER, this.ops.get(name).ordinal(), (Object)name);
            nmt.name = name;
        } else {
            nmt = type == TokenType.PROP_NAME && this.konto.getVars().checkVar(name) != -1 ? this.qadd(TokenType.VAR_REF, null, name) : (name.equals("at") && type == TokenType.PROP_NAME ? this.qadd(TokenType.INDX_OPER, 1) : this.qadd(type, null, name));
        }
        return nmt;
    }

    public Token getUnqName() {
        if (!this.in.isFirstNameLetter()) {
            throw new RuntimeException("Failed to get unqualified id " + this.in.getPosition());
        }
        return new Token(TokenType.PROP_NAME, this.in.getName(), this.in);
    }

    public void getEmbedded(String lang) {
        this.in.nextChk();
        ArrayList<Character> term = new ArrayList<Character>();
        this.konto.embeddedExp = new ArrayList<Token>();
        if (this.in.isSymbol()) {
            do {
                if (this.in.ch == '|') {
                    throw new RuntimeException("'|' is not allowed in the terminator " + this.in.getPosition());
                }
                term.add(Character.valueOf(this.in.ch));
                this.in.nextChk();
            } while (this.in.isSymbol());
        } else if (this.in.isFirstNameLetter()) {
            do {
                term.add(Character.valueOf(this.in.ch));
                this.in.nextChk();
            } while (this.in.isNextNameLetter());
        }
        EmbeddedLanguage el = this.embeddedLangs.get(lang);
        if (el == null) {
            throw new RuntimeException("Embedded language \"" + lang + "\" not found " + this.in.getPosition());
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < term.size()) {
            if (((Character)term.get(i)).charValue() == this.in.ch) {
                ++i;
                this.in.nextChk();
                continue;
            }
            if (i > 0) {
                for (int j = 0; j < i; ++j) {
                    sb.append(term.get(j));
                }
                i = 0;
            }
            sb.append(this.in.ch);
            this.in.nextChk();
        }
        CharStream tmpin = this.in;
        BoxWorker worker = this.konto.getWorker();
        el.wakeUp(this.konto);
        Object code = el.parse(this.konto, new StringReader(sb.toString()));
        this.in = tmpin;
        this.in.eatSpacesChk();
        ArrayList<Object> insertion = new ArrayList<Object>();
        insertion.add(el);
        insertion.add(code);
        insertion.add(this.konto.embeddedExp);
        this.konto.embeddedExp = null;
        Token ntk = new Token(TokenType.EMBEDDED_LANG, 0, insertion, this.in);
        this.queue.add(ntk);
    }

    public StringBuilder getEaten() {
        return this.in.getEaten();
    }

    public static Token getNextStringSegment(CharStream in, char curquote) {
        TokenType tp;
        StringBuilder sb;
        block2: {
            sb = new StringBuilder(in.getEaten());
            while (true) {
                sb.append((CharSequence)in.getFxStringSegment(curquote));
                if (in.ch == '{') break;
                tp = TokenType.BASIC_TYPE;
                if (in.isQuote() || in.isDoubleQuote()) {
                    curquote = in.ch;
                    in.nextChk();
                    continue;
                }
                break block2;
                break;
            }
            tp = TokenType.STRING_SEGMENT;
            in.nextValidChk();
        }
        return new Token(tp, 0, "", "" + curquote, sb.toString(), in);
    }

    private Token qadd(TokenType tp, int val) {
        Token nmt = new Token(tp, val, this.in);
        this.queue.add(nmt);
        return nmt;
    }

    private Token qadd(TokenType tp, int val, Object obj) {
        Token nmt = new Token(tp, val, obj, this.in);
        this.queue.add(nmt);
        return nmt;
    }

    private Token qadd(TokenType tp, String pr, String nm) {
        boolean iskeyprop = false;
        if (tp == TokenType.KEY_PROP) {
            iskeyprop = true;
            tp = TokenType.PROP_NAME;
        }
        Token nmt = new Token(tp, pr, nm, this.in);
        if (iskeyprop) {
            nmt.setKey();
        } else {
            nmt.value = 0;
        }
        if (tp == TokenType.FUNCTOR || tp == TokenType.PROP_NAME || tp == TokenType.CLASS_NAME || tp == TokenType.OBJ_NAME) {
            String uri;
            nmt.uri = uri = this.getURI(pr, nm);
            if (uri == null) {
                if (this.CREATE_TEMP_ONTOLOGY && (pr == null || pr.length() == 0)) {
                    uri = Parser.createTempOntology(this.konto.getWorker());
                    this.konto.getOntology(uri);
                    this.konto.getHandler().getMapping().put("", uri);
                } else if (!iskeyprop) {
                    if (pr == null || pr.equals("")) {
                        throw new RuntimeException("The default ontology not defined for name '" + nm + "'" + this.in.getPosition());
                    }
                    throw new RuntimeException("The ontology with prefix '" + pr + "' not defined for name '" + nm + "'" + this.in.getPosition());
                }
            }
        }
        if (!iskeyprop && !this.checkClass(nmt)) {
            this.checkType(nmt);
        }
        this.queue.add(nmt);
        return nmt;
    }

    private Token qadd(TokenType tp, int val, String pr, String nm, Object obj) {
        Token nmt = new Token(tp, val, pr, nm, obj, this.in);
        this.queue.add(nmt);
        return nmt;
    }

    private boolean checkClass(Token tok) {
        if (tok.type == TokenType.CLASS_NAME) {
            return true;
        }
        if (tok.type != TokenType.PROP_NAME) {
            return false;
        }
        String fullname = this.konto.getFullName(tok);
        String uri = this.konto.getTokenURI(tok);
        Integer ne = this.konto.getEntity(fullname);
        BoxWorker worker = this.konto.getWorker();
        if (ne == null) {
            if (fullname.equals("http://ontobox.org/map#Map")) {
                tok.type = TokenType.CLASS_NAME;
                MapHelper.initIfNeed(this.konto.getWorker());
                return true;
            }
            return false;
        }
        if (worker.entity(worker.name(ne)) == Entity.ONTCLASS) {
            tok.type = TokenType.CLASS_NAME;
            return true;
        }
        return false;
    }

    private boolean checkType(Token tok) {
        if (tok.type == TokenType.DATATYPE_NAME) {
            return true;
        }
        if (tok.type != TokenType.PROP_NAME) {
            return false;
        }
        String fullname = this.konto.getFullName(tok);
        Integer ne = this.konto.getEntity(fullname);
        BoxWorker worker = this.konto.getWorker();
        if (ne == null) {
            return false;
        }
        if (worker.entity(worker.name(ne)) == Entity.TYPE) {
            tok.type = TokenType.DATATYPE_NAME;
            return true;
        }
        return false;
    }

    private String getURI(String pr, String nm) {
        if (pr == null) {
            pr = "";
        }
        String uri = null;
        if (pr.equals("")) {
            uri = this.konto.checkLocalInOntologies(nm);
        }
        if (uri != null) {
            return uri;
        }
        try {
            return this.konto.getHandler().getMapping().get(pr);
        }
        catch (Exception e) {
            if (pr == null || pr.isEmpty()) {
                throw new RuntimeException("Default ontology is not defined " + this.in.getPosition());
            }
            throw new RuntimeException("Failed to find ontology with prefix '" + pr + "' " + this.in.getPosition());
        }
    }
}

