/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser.sql;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.meta2project.model.Connection;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.parser.sql.SQL2OntoBox;
import org.ontobox.libretto.parser.sql.SQL2Path;
import org.ontobox.libretto.parser.sql.SQLKey;
import org.ontobox.libretto.parser.sql.SQLToken;
import org.ontobox.libretto.parser.sql.SQLTokens;
import org.ontobox.libretto.parser.sql.SQLType;

public class SQLParser {
    private final SQLTokens tokens = new SQLTokens();
    private SQLToken current;
    private final SQL2Path trans;

    public SQLParser(CharStream in) {
        this.tokens.setInput(in);
        this.current = this.next();
        this.trans = new SQL2Path();
    }

    public void reset(CharStream in) {
        this.tokens.setInput(in);
        this.current = this.next();
    }

    public void sql2path(Writer writer, String ontology) {
        try {
            writer.append("create : {\"").append(ontology).append("\"}\n");
            writer.append("::d {\"http://www.w3.org/2001/XMLSchema\"}\n\n");
            while (this.current.type != SQLType.EOF) {
                SQLToken exp = this.getExpression();
                writer.append(this.trans.trans(exp));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sql2ontobox(String ontology, Connection con) {
        SQL2OntoBox sob = new SQL2OntoBox(ontology, con);
        while (this.current.type != SQLType.EOF) {
            SQLToken exp = this.getExpression();
            sob.trans(exp);
        }
    }

    SQLToken getExpression() {
        if (this.isKW(SQLKey.CREATE)) {
            return this.getCreate();
        }
        if (this.isKW(SQLKey.INSERT)) {
            return this.getInsert();
        }
        if (this.isKW(SQLKey.COMMIT)) {
            return this.getCommit();
        }
        throw new RuntimeException("Unknown expression " + this.current.name);
    }

    SQLToken getCreate() {
        SQLToken create = new SQLToken(SQLType.CREATE);
        ArrayList<SQLToken> al = new ArrayList<SQLToken>();
        this.getKW(SQLKey.CREATE);
        this.getKW(SQLKey.TABLE);
        create.name = this.getID().name;
        this.getLPAR();
        do {
            al.add(this.getID());
            SQLToken dt = this.getDatatype();
            if (dt.isKW(SQLKey.VARCHAR)) {
                this.getLPAR();
                dt.value = this.getInteger().value;
                this.getRPAR();
            }
            al.add(dt);
            if (!this.isComma()) continue;
            this.next();
        } while (!this.isRPAR());
        this.getRPAR();
        this.getSemicolon();
        create.sub = al;
        return create;
    }

    SQLToken getInsert() {
        SQLToken insert = new SQLToken(SQLType.INSERT);
        this.getKW(SQLKey.INSERT);
        this.getKW(SQLKey.INTO);
        insert.name = this.getID().name;
        insert.obj = this.getColumnList();
        this.getKW(SQLKey.VALUES);
        insert.sub = new ArrayList();
        while (!this.isSemicolon()) {
            insert.sub.add(this.getRecord());
            if (!this.isComma()) continue;
            this.next();
        }
        this.getSemicolon();
        return insert;
    }

    SQLToken getCommit() {
        this.getKW(SQLKey.COMMIT);
        this.getSemicolon();
        return new SQLToken(SQLType.COMMIT);
    }

    List getColumnList() {
        ArrayList<SQLToken> al = new ArrayList<SQLToken>();
        this.getLPAR();
        while (!this.isRPAR()) {
            al.add(this.getID());
            if (!this.isComma()) continue;
            this.next();
        }
        this.getRPAR();
        return al;
    }

    SQLToken getRecord() {
        ArrayList<SQLToken> al = new ArrayList<SQLToken>();
        if (this.current.type != SQLType.LPAR) {
            throw new RuntimeException("'(' not found in a record");
        }
        this.next();
        do {
            al.add(this.getValue());
            if (!this.isComma()) continue;
            this.next();
        } while (!this.isRPAR());
        this.getRPAR();
        return new SQLToken(SQLType.RECORD, al);
    }

    SQLToken getValue() {
        if (!this.isValue()) {
            throw new RuntimeException("Invalid value");
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getKW(SQLKey kw) {
        if (!this.isKW(kw)) {
            throw new RuntimeException("Keyword '" + kw.toString() + "' missed");
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getLPAR() {
        if (this.current.type != SQLType.LPAR) {
            throw new RuntimeException("'(' not found");
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getRPAR() {
        if (this.current.type != SQLType.RPAR) {
            throw new RuntimeException("')' not found");
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getComma() {
        if (this.current.type != SQLType.COMMA) {
            throw new RuntimeException("',' not found");
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getSemicolon() {
        if (this.current.type != SQLType.SEMICOLON) {
            throw new RuntimeException("';' not found");
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getDatatype() {
        if (!(this.isKW(SQLKey.INTEGER) || this.isKW(SQLKey.FLOAT) || this.isKW(SQLKey.VARCHAR) || this.isKW(SQLKey.SMALLINT) || this.isKW(SQLKey.DATETIME) || this.isKW(SQLKey.BLOB) || this.isKW(SQLKey.LONGBLOB))) {
            throw new RuntimeException("Expected datatype, but found " + (Object)((Object)this.current.type));
        }
        this.current.type = SQLType.DTYPE;
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getID() {
        if (this.current.type != SQLType.NAME) {
            throw new RuntimeException("Expected identifier, but found " + (Object)((Object)this.current.type));
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken getInteger() {
        if (this.current.type != SQLType.INTEGER) {
            throw new RuntimeException("Integer not found");
        }
        SQLToken cur = this.current;
        this.next();
        return cur;
    }

    SQLToken next() {
        this.current = this.tokens.getNext();
        return this.current;
    }

    boolean isKW(SQLKey kw) {
        return this.current.type == SQLType.KEYWORD && this.current.key == kw;
    }

    boolean isRPAR() {
        return this.current.type == SQLType.RPAR;
    }

    boolean isComma() {
        return this.current.type == SQLType.COMMA;
    }

    boolean isSemicolon() {
        return this.current.type == SQLType.SEMICOLON;
    }

    boolean isValue() {
        return this.current.type == SQLType.INTEGER || this.current.type == SQLType.FLOAT || this.current.type == SQLType.STRING || this.current.type == SQLType.INTEGER || this.current.type == SQLType.LONGBLOB || this.current.type == SQLType.BLOB || this.current.type == SQLType.SMALLINT || this.current.type == SQLType.NULL;
    }
}

