/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.test;

import com.teacode.code.java.JavaString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.meta2project.fast.adapter.FastSession;
import org.meta2project.model.Connection;
import org.meta2project.model.OntObject;
import org.ontobox.libretto.FieldContainer;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.parser.Token;

public class Test
extends TestCase {
    private static String collectionToJavaAssertion(Collection<Collection> col) {
        StringBuilder sb = new StringBuilder();
        int row = 0;
        for (Collection c : col) {
            sb.append("expected.add(");
            sb.append(Test.convertLine(c));
            sb.append("); // ").append(row).append('\n');
            ++row;
        }
        return sb.toString();
    }

    private static String convertLine(Collection c) {
        StringBuilder sb = new StringBuilder();
        if (c == null) {
            sb.append("null");
        } else {
            boolean ordered = false;
            sb.append("new CH(").append(ordered);
            for (Object o : c) {
                sb.append(", ");
                sb.append(Test.convertObject(o));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private static String convertObject(Object o) {
        if (o instanceof FieldContainer) {
            FieldContainer fc = (FieldContainer)o;
            o = fc.getObject();
        }
        if (o instanceof OntObject) {
            OntObject obj = (OntObject)o;
            String name = obj.getFullName();
            if (name != null) {
                int loc = name.indexOf(35);
                if (loc != -1 && name.charAt(loc + 1) == '_') {
                    return "new TempH()";
                }
                return "new OH(\"" + name + "\")";
            }
            return "new OH(null)";
        }
        if (o instanceof String) {
            return JavaString.javaString((String)((String)o));
        }
        if (o instanceof Integer || o instanceof Boolean) {
            return o.toString();
        }
        if (o instanceof Double) {
            return o + "f";
        }
        if (o instanceof Token) {
            return "new TokenH()";
        }
        if (o instanceof OH) {
            return "new OH(\"" + ((OH)o).objectFullName + "\")";
        }
        if (o instanceof TempH) {
            return "new TempH()";
        }
        throw new RuntimeException("Unknown data: " + o + " (" + o.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFully(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMain() throws IOException {
        FastSession ses = new FastSession();
        try {
            Connection con = ses.openConnection();
            try {
                String program = Test.readFully(new File("benchmarks-junit.bxq"));
                Handler handler = new Handler();
                long t1 = System.currentTimeMillis();
                Collection<Collection> result = handler.executeOld(new LocalContext(handler, con.getWorker()), program);
                Test.assertResult(con, result);
                System.out.println(System.currentTimeMillis() - t1 + " ms");
            }
            finally {
                con.close();
            }
        }
        finally {
            ses.close();
        }
    }

    private static void printError(int row, String msg, Collection expected, Collection actual) {
        System.out.println(row + ":: " + msg);
        System.out.println("Expected: " + Test.convertLine(expected));
        System.out.println("Expected: " + expected);
        System.out.println("Actual  : " + Test.convertLine(actual));
        System.out.println("Actual  : " + actual);
        System.out.println();
    }

    private static void assertCollection(Connection con, List<CH> expected, Collection<Collection> result) {
        boolean failed = false;
        Test.assertEquals((int)expected.size(), (int)result.size());
        int row = 0;
        for (Collection r : result) {
            try {
                CH ch = expected.get(row);
                if (ch == null) {
                    Test.assertNull((Object)r);
                } else if (ch.col.size() != r.size()) {
                    Test.printError(row, "Size incorrect. Expected " + ch.col.size() + ", actual " + r.size(), ch.col, r);
                    failed = true;
                } else {
                    for (Object o : r) {
                        int loc;
                        OntObject ontObject;
                        String name;
                        if (o instanceof FieldContainer) {
                            o = ((FieldContainer)o).getObject();
                        }
                        int index = o instanceof OntObject ? ((name = (ontObject = (OntObject)o).getFullName()) != null ? ((loc = name.indexOf(35)) != -1 && name.charAt(loc + 1) == '_' ? ch.col.indexOf(new TempH()) : ch.col.indexOf(new OH(name))) : ch.col.indexOf(new OH(null))) : (o instanceof Token ? ch.col.indexOf(new TokenH()) : ch.col.indexOf(o));
                        if (index == -1) {
                            Test.printError(row, "Not found " + o + " (" + o.getClass() + ')', ch.col, r);
                            failed = true;
                        }
                        if (ch.ordered && index != 0) {
                            Test.printError(row, "Found " + o + " (" + o.getClass() + "), but wrong order", ch.col, r);
                            failed = true;
                        }
                        if (index == -1) continue;
                        ch.col.remove(index);
                    }
                    if (!ch.col.isEmpty()) {
                        Test.printError(row, "Remain " + ch.col.size(), ch.col, r);
                        failed = true;
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e.getMessage() + " (row " + row + ')', e);
            }
            ++row;
        }
        Test.assertFalse((boolean)failed);
    }

    /*
     * Opcode count of 17971 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void assertResult(Connection con, Collection<Collection> result) {
        ArrayList<CH> expected = new ArrayList<CH>();
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul")}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#tongo")}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#mongo")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/tribe#tongo")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/tribe#tongo")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#mongo")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#mongo")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{"Mongogo", "Paul", "Tom", "Ann", "John", "Marie", "Tim", "Tongoga"}));
        expected.add(new CH(false, new Object[]{200, 300, 400}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{"Tom", "Ann", "John", "Marie", "Tim"}));
        expected.add(new CH(false, new Object[]{20, 40, 42, 41}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/tribe#tongo")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{"Star", "Back"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/tribe#tongo")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann")}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{"Paul", "Tom", "Ann", "John", "Marie", "Tim"}));
        expected.add(new CH(false, new Object[]{"Paul", "Tom", "Ann", "John", "Marie", "Tim"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{"Tim"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{"Mongogo", "Ann", "Marie"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/tribe#mongo")}));
        expected.add(new CH(false, new Object[]{"Ann", "Marie", "Mongogo"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/tribe#mongo")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{40, 41}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{"Back Tom", "Land Ann", "Land John", "Land Marie", "Land Tim", "Star Paul"}));
        expected.add(new CH(false, new Object[]{"Tom", "Ann", "John", "Marie", "Tim", "Paul"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{2}));
        expected.add(new CH(false, new Object[]{"yes"}));
        expected.add(new CH(false, new Object[]{"no"}));
        expected.add(new CH(false, new Object[]{"Star", "Tom", "Ann", "John", "Marie", "Tim"}));
        expected.add(new CH(false, new Object[]{2}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{10, 20, 30}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{2}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{4}));
        expected.add(new CH(false, new Object[]{5}));
        expected.add(new CH(false, new Object[]{6}));
        expected.add(new CH(false, new Object[]{7}));
        expected.add(new CH(false, new Object[]{8}));
        expected.add(new CH(false, new Object[]{9}));
        expected.add(new CH(false, new Object[]{10}));
        expected.add(new CH(false, new Object[]{11}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{3}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{120}));
        expected.add(new CH(false, new Object[]{120}));
        expected.add(new CH(false, new Object[]{240}));
        expected.add(new CH(false, new Object[]{240}));
        expected.add(new CH(false, new Object[]{24}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{15}));
        expected.add(new CH(false, new Object[]{0}));
        expected.add(new CH(false, new Object[]{15}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{15}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{5}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[0]));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{2, 4, 6}));
        expected.add(new CH(false, new Object[0]));
        expected.add(null);
        expected.add(new CH(false, new Object[]{15}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{15}));
        expected.add(new CH(false, new Object[]{55}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{1, 1, 2, 2}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{1, 1, 2, 6, 24, 120}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"Paul", "Tom", "Tim"}));
        expected.add(new CH(false, new Object[]{"Paul", "Tom"}));
        expected.add(new CH(false, new Object[]{"Tim"}));
        expected.add(new CH(false, new Object[0]));
        expected.add(null);
        expected.add(new CH(false, new Object[]{5040, 720, 120, 24, 6, 2, 1}));
        expected.add(new CH(false, new Object[]{1, 2, 6, 24, 120, 720, 5040}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{10}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"yes"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"no"}));
        expected.add(new CH(false, new Object[]{"yes"}));
        expected.add(null);
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{"Paul", "Tom", "Ann", "John", "Marie", "Tim", "Mongogo", "Tongoga"}));
        expected.add(new CH(false, new Object[]{"Ann", "John", "Marie", "Mongogo", "Paul", "Tim", "Tom", "Tongoga"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{"Ann", "John", "Marie", "Paul", "Tim", "Tom"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{4}));
        expected.add(new CH(false, new Object[]{2, 3, 4, 5, 6}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim"), new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/tribe#tongo")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{"Tom", "John", "Mongogo", "Tongoga"}));
        expected.add(new CH(false, new Object[]{"Integer", "Integer", "String", "Float"}));
        expected.add(new CH(false, new Object[]{"Object"}));
        expected.add(new CH(false, new Object[]{"3"}));
        expected.add(new CH(false, new Object[]{"paul", "john"}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{"http://teacode.com/people#paul", "http://teacode.com/people#john"}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{"http://teacode.com/people#Man"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{"http://teacode.com/people#Man", "http://teacode.com/people#Employee"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#paul")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{"Object", "Object", "Object", "Object", "Object", "Object"}));
        expected.add(new CH(false, new Object[]{"Object", "Class"}));
        expected.add(new CH(false, new Object[]{"http://teacode.com/people#john"}));
        expected.add(new CH(false, new Object[]{"http://teacode.com/people#child", "http://teacode.com/people#spouse", "http://teacode.com/people#position", "http://teacode.com/people#salary", "http://teacode.com/people#age", "http://teacode.com/people#name", "http://teacode.com/people#surname"}));
        expected.add(new CH(false, new Object[]{"http://teacode.com/people#position", "http://teacode.com/people#salary", "http://teacode.com/people#age", "http://teacode.com/people#name", "http://teacode.com/people#surname"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{"200", "300", "400"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tim")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{"http://teacode.com/people#tom"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#marie")}));
        expected.add(new CH(false, new Object[]{"1", "1", "1.2"}));
        expected.add(new CH(false, new Object[]{Float.valueOf(1.2f)}));
        expected.add(new CH(false, new Object[]{3, 3, 3, 3, 3, 3}));
        expected.add(new CH(false, new Object[]{"def"}));
        expected.add(new CH(false, new Object[]{100, 101, 102}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{"e", "f", "g"}));
        expected.add(new CH(false, new Object[]{101, 100, 102, 100, 103}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{97, 98, 99, 100, 101, 102}));
        expected.add(new CH(false, new Object[]{97, 98, 99, 100, 101, 102}));
        expected.add(new CH(false, new Object[]{"def"}));
        expected.add(new CH(false, new Object[]{97, 98, 99, 0, 100, 101, 102}));
        expected.add(new CH(false, new Object[]{115}));
        expected.add(new CH(false, new Object[]{"abc", "def"}));
        expected.add(new CH(false, new Object[]{101, 102}));
        expected.add(new CH(false, new Object[]{-1, 0, 1}));
        expected.add(new CH(false, new Object[]{"a", "b"}));
        expected.add(new CH(false, new Object[]{"a - b - c"}));
        expected.add(new CH(false, new Object[]{"a", "b", "c"}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{"john", "james", "jan"}));
        expected.add(new CH(false, new Object[]{"john", "james", "jan"}));
        expected.add(new CH(false, new Object[]{"john", "jan"}));
        expected.add(new CH(false, new Object[]{"john", "jan"}));
        expected.add(new CH(false, new Object[]{"34"}));
        expected.add(new CH(false, new Object[]{"345"}));
        expected.add(new CH(false, new Object[]{"67"}));
        expected.add(new CH(false, new Object[]{"3456789"}));
        expected.add(new CH(false, new Object[]{"1234567"}));
        expected.add(new CH(false, new Object[]{"567", "bsc"}));
        expected.add(new CH(false, new Object[]{"abscde"}));
        expected.add(new CH(false, new Object[]{"567", "bsc"}));
        expected.add(new CH(false, new Object[]{1, 2, 3, 4}));
        expected.add(new CH(false, new Object[]{"123", "1234"}));
        expected.add(new CH(false, new Object[]{"123"}));
        expected.add(new CH(false, new Object[]{"    "}));
        expected.add(new CH(false, new Object[]{"AABBCC", "12AAB"}));
        expected.add(new CH(false, new Object[]{"aabbcc", "12aab"}));
        expected.add(new CH(false, new Object[]{"aaaaa", "bcbcbcbcbc"}));
        expected.add(new CH(false, new Object[]{"a"}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"Aaaaab"}));
        expected.add(new CH(false, new Object[]{"Aaaaa"}));
        expected.add(new CH(false, new Object[]{"b"}));
        expected.add(new CH(false, new Object[]{"1234"}));
        expected.add(new CH(false, new Object[]{2}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{"...210...b1a...", " d1D "}));
        expected.add(new CH(false, new Object[]{"012"}));
        expected.add(new CH(false, new Object[]{"...", "", "", "...a", "b", "-D", "d-"}));
        expected.add(new CH(false, new Object[]{"...012...a1b"}));
        expected.add(new CH(false, new Object[]{"40", "Ann", "Land"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#john")}));
        expected.add(new CH(false, new Object[]{"--- MAPS "}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"Tom is the parent! of Tim", "Ann is the parent! of Tom", "John is the parent! of Paul", "John is the parent! of Tom", "Marie is the parent! of Paul"}));
        expected.add(new CH(false, new Object[]{":-Tim", ":-Tom", ":-Paul", ":-Tom", ":-Paul"}));
        expected.add(new CH(false, new Object[]{"Tom is the parent!! of Tim", "Ann is the parent!! of Tom", "John is the parent!! of Paul", "John is the parent!! of Tom", "Marie is the parent!! of Paul"}));
        expected.add(new CH(false, new Object[]{"Tom is the parent!! of Tim", "Ann is the parent!! of Tom", "John is the parent!! of Paul", "John is the parent!! of Tom", "Marie is the parent!! of Paul"}));
        expected.add(new CH(false, new Object[]{"Tom is the parent of Tim", "Ann is the parent of Tom", "John is the parent of Paul", "John is the parent of Tom", "Marie is the parent of Paul"}));
        expected.add(new CH(false, new Object[]{"Tom-Tim", "John-(\"Paul\", \"Tom\")"}));
        expected.add(new CH(false, new Object[]{"Tom-Tim", "John-Paul", "John-Tom"}));
        expected.add(new CH(false, new Object[]{"Tom is the parent of Tim", "John is the parent of Paul", "John is the parent of Tom"}));
        expected.add(new CH(false, new Object[]{"Tim is a child of Tom and grandchild of Ann", "Tim is a child of Tom and grandchild of John"}));
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{"<< - >>"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{"uhuhuh", "ohohoh", "<< - >>", "hohoho", "huhuhu"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{0, 1, 2, 3, 4}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{5}));
        expected.add(new CH(false, new Object[]{5, 6, 7, 8, 9}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{0, 1, 2, 111, 4}));
        expected.add(new CH(false, new Object[]{"uhuhuh", "ohohoh", "<< - >>", "hohoho", "huhuhu"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{"uhuhuh", "ohohoh***", "<< - >>", "hohoho***", "huhuhu"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{"uhuhuh", "ohohoh***", ">> - <<", "hohoho***", "huhuhu"}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{"uhuhuh", "ohohoh***", "!!ohohoh***", "??ohohoh***", ">> - <<", "hohoho***", "!!hohoho***", "??hohoho***", "huhuhu"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{"uhuhuh", ">> - <<", "huhuhu"}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj2")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj1")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj2"), new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj2"), new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj2"), new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj2"), new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj2"), new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/prop-management#obj2"), new OH("http://teacode.com/prop-management#obj3")}));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH(null)}));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{"aa"}));
        expected.add(new CH(false, new Object[]{"bb"}));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{"11"}));
        expected.add(new CH(false, new Object[]{"pp"}));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{1, 2, 3, 4, 5}));
        expected.add(new CH(false, new Object[]{5}));
        expected.add(new CH(false, new Object[]{6, 7, 8, 9, 10}));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{4, 5, 6, 7, 8}));
        expected.add(new CH(false, new Object[]{"a2", "b2", "c2", "a3", "b3", "c3", "a4", "b4", "c4"}));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://temp#ob1")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#ob2")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#ob1"), new OH("http://temp#ob2")}));
        expected.add(new CH(false, new Object[]{"ob2------------http://aa#ob1"}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://temp#ob2")}));
        expected.add(new CH(false, new Object[]{"ob1------------http://aa#ob2"}));
        expected.add(new CH(false, new Object[]{2, 4}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{"::"}));
        expected.add(new CH(false, new Object[]{"::a2", "::b2", "::c2", "::a3", "::b3", "::c3", "::a4", "::b4", "::c4"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"------", "++++++"}));
        expected.add(new CH(false, new Object[]{"aa22", "bb22", "cc22", "aa33", "bb33", "cc33", "aa44", "bb44", "cc44"}));
        expected.add(new CH(false, new Object[]{1, 2, 3, 4, 5}));
        expected.add(new CH(false, new Object[]{5}));
        expected.add(new CH(false, new Object[]{6, 7, 8, 9, 10}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{4, 5, 6, 7, 8}));
        expected.add(new CH(false, new Object[]{"a1", "b1", "c1", "a2", "b2", "c2", "a3", "b3", "c3", "a4", "b4", "c4", "a5", "b5", "c5"}));
        expected.add(null);
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://temp#oo")}));
        expected.add(new CH(false, new Object[]{"111", "112"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{2, 3, 4}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{1, 2, 3}));
        expected.add(new CH(false, new Object[]{2}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"2, 3"}));
        expected.add(new CH(false, new Object[]{"1", "2"}));
        expected.add(new CH(false, new Object[]{"1", "2"}));
        expected.add(new CH(false, new Object[]{"1", "2"}));
        expected.add(new CH(false, new Object[]{"1", "2"}));
        expected.add(new CH(false, new Object[]{101, 102, 103, 102, 103, 104, 103, 104, 105}));
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{2}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{120}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"1"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj0")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{"000000", "111111"}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{"(\"000\", \"AAA\")(\"000\", \"AAA\")", "111111"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{"<< - >>"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{"uhuhuh", "ohohoh", "<< - >>", "hohoho", "huhuhu"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj2")}));
        expected.add(new CH(false, new Object[]{0, 1, 2, 3, 4}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{100, 200, 1, 100, 200, 3, 100, 200}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{1, 3}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{"000", "AAA", "uhuhuh", "ohohoh", "<< - >>", "hohoho", "huhuhu", "000"}));
        expected.add(new CH(false, new Object[]{"(\"000\", \"AAA\") (\"000\", \"AAA\")", "(\"uhuhuh\", \"ohohoh\", \"<< - >>\", \"hohoho\", \"huhuhu\") (\"uhuhuh\", \"ohohoh\", \"<< - >>\", \"hohoho\", \"huhuhu\")", "000 000"}));
        expected.add(new CH(false, new Object[]{"000 000", "AAA AAA", "uhuhuh uhuhuh", "ohohoh ohohoh", "<< - >> << - >>", "hohoho hohoho", "huhuhu huhuhu", "000 000"}));
        expected.add(new CH(false, new Object[]{"yes", "no", "yes"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj0")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj2")}));
        expected.add(new CH(false, new Object[]{"name2 : name2", "name0 : name0", "name1 : name1"}));
        expected.add(new CH(false, new Object[]{"name0 - name0", "name1 - name1", "name2 - name2"}));
        expected.add(new CH(false, new Object[]{"name0", "name1", "name2"}));
        expected.add(new CH(false, new Object[]{"name0 is dad of name1", "name1 is dad of name2"}));
        expected.add(new CH(false, new Object[]{"name0 is grandpa of name2"}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"John Smith tel. 33-21-78"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"Java - haha"}));
        expected.add(new CH(false, new Object[]{1, 1}));
        expected.add(new CH(false, new Object[]{"http://aa#obj1"}));
        expected.add(new CH(false, new Object[]{"aaa1"}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"aa"}));
        expected.add(new CH(false, new Object[]{"M = (1,3,5) or M = (5,7,9)\r\nand = [(1,3,5)] M = (5,7,9) M\r\n\t\t\t3\t3\t7       7\r\n\r\npush M\r\npush (5 7 9)\r\n\r\n\r\nr[car]\r\n\r\npush\r\n\r\ncar = (Toyota) and car = GM\r\n\r\nand = Toyota car = GM car\r\n\r\npushregisters 2\r\npushreg r[car]\r\npush GM\r\noper = \r\nget r[car]\r\npush Toyota\r\noper = \r\noper and\r\n\r\n\r\n\r\n\r\n\r\n5 7 9\r\n1 3 5\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n%%% 1 Accessors\r\n\r\n*** value-kind/0\r\nvalue-kind() as String\r\nThis function returns a String representing the values's kind: either Object, String, or Integer\r\n& Element-wise\r\n% Examples\r\n(1, 2, \"3\", 1.2)/value-kind(); # = {\"Integer\", \"Integer\", \"String\", \"Float\"}\r\n&p:john/value-kind(); # = {\"Object\"}\r\n(1, 2, \"3\")[value-kind() # = \"String\"]; = {\"3\"}\r\n\r\n*** object-id/0\r\nobject-id() as String\r\nThis function returns the ID (short name) of the entity in its ontology\r\n& Element-wise\r\n% Examples\r\n(&p:paul, &p:john)/object-id(); # = {\"paul\", \"john\"} \r\n(1,2,3)/object-id(); # = {} # data do not have ID\r\n(&p:paul, &p:john)[object-id()/contains(\"oh\")]; # = {john}\r\n\r\n*** object-uri/0\r\nobject-uri() as String\r\nThis function returns the URI (full name) of the entity.\r\n& Element-wise\r\n% Examples\r\n(&p:paul, &p:john)/object-uri(); # = {\"http://teacode.com/people#paul\", \"http://teacode.com/people#john\"}\r\n(1, 2, 3)/object-uri(); # = {}\r\n(&p:paul, &p:john)[object-uri()/contains(\"#\")]; # = {paul, john} \r\n\r\n--- entity-ont() as String\r\nThis function returns the ontology URI to which this entity belongs\r\n& Element-wise\r\n\r\n--- entity-project() as String\r\nThis function returns the name of the project to which this entity belongs\r\n& Element-wise\r\n\r\n*** object-classes/0\r\nobject-classes() as String\r\nThis function returns the URI of the classes to which this object belongs\r\n& Element-wise\r\n% Examples\r\n(&p:paul, &p:john)/object-classes()/distinct-values(); # = {\"http://teacode.com/people#man\"}\r\n(&p:paul, b:yes)[object-classes()[contains(\"ers\")]]; # = {}\r\n&p:tom/object-classes(); = {\"http://teacode.com/people#man\", \"http://teacode.com/people#employee\"}\r\n*[object-classes()/contains(\"ee\")]; # = {tom} # Only Tom is employEE\r\n\r\n*** uri-object/0\r\nuri-object() as Object\r\nReturns the object identified by this URI string\r\n& Element-wise\r\n% Examples\r\n(\"http://teacode.com/people#paul\")/uri-object(); # = {paul}\r\n&p:paul/object-uri()/uri-object(); # = {paul}\r\n*/object-uri()[contains(\"joh\")]/uri-object(); = {john}\r\n\r\n*** uri-kind/0\r\nuri-kind() as Boolean\r\nIf the input string is an entity uri, returns the role of this entity in the project, either \"Class\", \"Object\", \"TProperty\", \"OProperty\". Returns nil otherwise.\r\n& Element-wise\r\n% Examples\r\n*/object-uri()/uri-kind(); # = {\"Object\", \"Object\", \"Object\", \"Object\", \"Object\", \"Object\", \"Object\", \"Object\", \"Object\", \"Object\"}\r\n(&p:john/object-uri(), &p:john/object-classes())/uri-kind(); # = {\"Object\", \"Class\"}\r\n(&p:john/object-uri(), &p:john/object-classes())[uri-kind()=\"Object\"]; # = {\"http://teacode.com/people#john\"}\r\n\r\n*** object-properties/0\r\nobject-properties() as String \r\nReturns the collection of URI strings identifying the properties of the input object\r\n& Element-wise\r\n% Examples\r\n&p:tom/object-properties(); # = {\"http://teacode.com/people#spouse\", \"http://teacode.com/people#hasChild\", \"http://teacode.com/people#position\", \"http://teacode.com/people#salary\", \"http://teacode.com/people#age\", \"http://teacode.com/people#name\", \"http://teacode.com/people#surname\"}\r\n&p:tom/object-properties()[uri-kind()=\"TProperty\"]; # = {\"http://teacode.com/people#position\", \"http://teacode.com/people#salary\", \"http://teacode.com/people#age\", \"http://teacode.com/people#name\", \"http://teacode.com/people#surname\"}\r\n*[object-properties()/contains(\"#position\")]; # = {tom}\r\n\r\n\r\n*** apply-property/1\r\napply-property($propertyURI)\r\nApplies the property to the input object.\r\n& Element-wise\r\n% Examples\r\n&p:tom/apply-property(\"http://teacode.com/people#salary\");        # = {\"200\", \"300\", \"400\"}\r\n*[apply-property(\"http://teacode.com/people#salary\")];            # = {tom}\r\n&p:tom/apply-property(\"http://teacode.com/people#hasChild\");      # = {tim}\r\n*[apply-property(\"http://teacode.com/people#hasChild\") = &p:tom]; # = {john, ann}\r\n\r\n\r\n*** to-string/0\r\nto-string() as String\r\nReturns the string representation of the entity or data\r\n& Element-wise\r\n% Examples\r\n&p:tom/to-string();                          # = {\"http://teacode.com/people#tom\"}\r\n*[to-string()/uri-object()/@name = \"Marie\"]; # = {marie}\r\n(1, \"1\", 1.2)/to-string();                   # = {\"1\", \"1\", \"1.2\"}\r\n(1, \"1\", 1.2)[to-string()/contains(\".\")];    # = {1.2}\r\n\r\n%%% 2 Constructor Functions\r\n\r\n%%% 3 Functions and Operators on Numerics\r\n\r\n%%% 3.1 Operators on Numeric Values\r\n\r\n... +\r\nSum\r\n& Element-wise\r\n\r\n... -\r\nSubtract\r\n& Element-wise\r\n\r\n... /-/\r\nUnary minus\r\n& Element-wise\r\n\r\n... *\r\nMultiplication\r\n& Element-wise\r\n\r\n... div\r\nDivision\r\n& Element-wise\r\n\r\n... mod\r\nMod operator\r\n& Element-wise\r\n\r\n%%% 3.2 Comparison of Numeric Values\r\n\r\n... =\r\nEquality\r\n& Element-wise\r\n\r\n... !=\r\nInequality\r\n& Element-wise\r\n\r\n... <\r\nLess\r\n& Element-wise\r\n\r\n... >\r\nGreater\r\n& Element-wise\r\n\r\n... <=\r\nLEQ\r\n& Element-wise\r\n\r\n... >=\r\nGEQ\r\n& Element-wise\r\n\r\n%%% 3.3 Functions on Numeric Values\r\n\r\n--- abs() \r\nReturns the absolute value of the input number\r\n& Element-wise\r\n\r\n--- floor()\r\nReturns the largest number with no fractional part that is less than or equal to the argument\r\n& Element-wise\r\n\r\n--- ceiling()\r\nReturns the smallest number with no fractional part that is greater than or equal to the argument\r\n& Element-wise\r\n\r\n--- round($precision as Integer)\r\nIf $presition = 0, then rounds to the nearest number with no fractional part. If $presition>0, the value returned is the nearest numeric that is a multiple of ten to the power of minus $precision. \r\n& Element-wise\r\n\r\n%%% 4 Functions on Strings\r\n\r\n%%% 4.1 Assemble and Disassemble String Funcitons\r\n\r\n*** codes-to-string/0\r\ncodes-to-string() as String\r\nReturns the string obtained from the ordered collection of integers. \r\n& Colection-wise\r\n% Examples\r\n(100, 101, 102)/codes-to-string();        # = {\"def\"}\r\n(100, 101, 102)[codes-to-string()=\"def\"]; # = {100, 101, 102}\r\n(100, 101, 102)[codes-to-string()=\"efg\"]; # = {}\r\n\r\n*** codes-to-strings/1\r\ncodes-to-strings($separator as Integer)\r\nReturns the collection of strings obtained from the ordered collection of integers. $separator is an integer, which separates strings.\r\n& Collection-wise\r\n% Examples\r\n(101, 100, 102, 100, 103)/codes-to-strings(100); # = {\"e\", \"f\", \"g\"}\r\n(101, 100, 102, 100, 103)[codes-to-strings(100) = \"f\"]; # = {101, 100, 102, 100, 103}\r\n(101, 100, 102, 100, 103)[codes-to-strings(100) = \"h\"]; # = {}\r\n\r\n\r\n*** string-to-codes/0\r\nstring-to-codes()\r\nReturns the ordered collection of integers obtained by decoding the strings of the input collection\r\n& Element-wise\r\n% Examples\r\n(\"abc\", \"def\")/string-to-codes();      # = {97, 98, 99, 100, 101, 102}\r\n(\"abc\", 1, \"def\")/string-to-codes();   # = {97, 98, 99, 100, 101, 102} # integer is ignored\r\n(\"abc\", \"def\")[string-to-codes()=100]; # = {\"def\"} # 100 is code for 'd'. Strings encoded separately in the predicate, because the function is element-wise. \r\n\r\n*** strings-to-codes/1\r\nstrings-to-codes($separator as Integer)\r\nReturns the ordered collection of integers by decoding the strings of the input collection and separating them with $separator\r\n& Collection-wise\r\n% Examples\r\n(\"abc\", \"def\")/strings-to-codes(0);          # = {97, 98, 99, 0, 100, 101, 102}\r\n(\"\", 1, \"\")/strings-to-codes(115);           # = {115} # integer is ignored\r\n(\"abc\", \"def\")[strings-to-codes(0) > 100];   # = {\"abc\", \"def\"} # checks the whole\r\n(\"abc\", \"def\")/strings-to-codes(0)[. > 100]; # = {101, 102}\r\n\r\n%%% 4.2 Equality and Comparison of Strings\r\n\r\n*** compare/1\r\ncompare($str as String)\r\nReturns -1, 0, 1 if the context string is less than, equal to or greater than $str, respectively \r\nIf the context object or the argument is not a string, nil is returned\r\n& Element-wise\r\n% Examples\r\n(\"a\", \"b\", \"c\")/compare(\"b\");     # = {-1, 0, 1}\r\n(\"a\", \"b\", \"c\")[compare(\"b\")<=0]; # = {\"a\", \"b\"}\r\n\r\n... = \r\nReturns true if the strings are equal\r\n& Element-wise\r\n\r\n... != \r\nReturns true if unequal\r\n& Element-wise\r\n\r\n... >\r\nGreater predicate on strings\r\n& Element-wise\r\n\r\n... <\r\nLess predicate on strings\r\n& Element-wise\r\n\r\n... >=\r\nGEQ on strings\r\n& Element-wise\r\n\r\n... <=\r\nLEQ on strings\r\n& Element-wise\r\n\r\n%%% 4.3 Functions on Strings\r\n\r\n... + \r\nConcatenation on strings\r\n& Element-wise\r\n\r\n*** join/1\r\njoin($separator as String) as String\r\nJoins the collection of stings with optional separator. If no separator needed, use $separator = \"\".\r\n& Collection-wise\r\n% Examples\r\n(\"a\", \"b\", \"c\")/join(\" - \");                # = {\"a - b - c\"}\r\n(\"a\", \"b\", \"c\")[join(\" - \") = \"a - b - c\"]; # = {\"a\", \"b\", \"c\"}\r\n(\"a\", \"b\", \"c\")[join(\" = \") = \"a - b - c\"]; # = {}\r\n\r\n*** starts-with/1\r\nstarts-with($str as String) as String\r\nthe context string value, if it starts with $str, false otherwise\r\n& Element-wise\r\n% Examples\r\n(\"john\", \"paul\", \"james\", \"tom\", \"jan\")/starts-with(\"j\");  # = {\"john\", \"james\", \"jan\"}\r\n(\"john\", \"paul\", \"james\", \"tom\", \"jan\")[starts-with(\"j\")]; # = {\"john\", \"james\", \"jan\"}\r\n\r\n*** ends-with/1\r\nends-with($str as String)\r\nthe context string value, if it ends with $str, false otherwise\r\n& Element-wise\r\n% Examples\r\n(\"john\", \"paul\", \"james\", \"tom\", \"jan\")/ends-with(\"n\");  # = {\"john\", \"jan\"}\r\n(\"john\", \"paul\", \"james\", \"tom\", \"jan\")[ends-with(\"n\")]; # = {\"john\", \"jan\"}\r\n\r\n*** nl/0\r\nnl()\r\nreturns a new line string (Java's System.getProperty(\"line.separator\"))\r\n& Static\r\n\r\n*** contains/1\r\ncontains($str as String)\r\ntrue if the input string contains $str as a substring\r\n& Element-wise\r\n% Examples\r\n\r\n*** substring/2\r\nsubstring($location as Digital, $length as Digital)\r\nReturns a substring of the input string starting at $location and continuing for $length characters. If the location and length are not integers then those chars are selected, whose   position $p obeys\r\n\tround($location) <= $p < round($location) + round($length)\r\nThe first character starts at position 1.\r\nif $location < 0 then starts from the end of the string\r\nif $length < 0 then continues till the end (the beginning in case $location < 0) of the string\r\n& Element-wise\r\n% Examples\r\n(\"123456789\")/substring(3, 2);                    # = {\"34\"}\r\n(\"123456789\")/substring(3.2, 2.7);                # = {\"345\"}\r\n(\"123456789\")/substring(-3, 2);                   # = {\"67\"}\r\n(\"123456789\")/substring(3, -1);                   # = {\"3456789\"}\r\n(\"123456789\")/substring(-3, -1);                  # = {\"1234567\"}\r\n(\"123456789\", \"abscde\")/substring(-3, 3);         # = {\"567\", \"bsc\"}\r\n(\"123456789\", \"abscde\")[substring(-3, 3)=\"bsc\"];  # = {\"abscde\"}\r\n(\"123456789\", \"abscde\", \"a\", 2)/substring(-3, 3); # = {\"567\", \"bsc\"} # string \"a\" is too short, thus ignored. Integer is also ignored. \r\n\r\n*** string-length/0\r\nstring-length() as Integer\r\nReturns the length of the input string\r\n& Element-wise\r\n% Examples\r\n(\"1\", \"12\", \"123\", \"1234\")/string-length();      # = {1, 2, 3, 4}\r\n(\"1\", \"12\", \"123\", \"1234\")[string-length() > 2]; # = {\"123\", \"1234\"}\r\n\r\n--- substring-before/2\r\nsubstring-before($substring as String, $count as Integer)\r\nReturns a substring of the input string which continues from the beginning of the input string to the first ($count-th) occurrence of the $substring. If $count < 0 then the position calculates from the end of the input string\r\n& Element-wise\r\n\r\n--- substring-after/2\r\nsubstring-after($substring as String, $count as Integer)\r\nReturns a substring of the input string which continues from the the first ($count-th) occurrence of the $substring to the end of the input string. If $count < 0 then the position of $substring calculates from the end of the input string\r\n& Element-wise\r\n\r\n*** trim/0\r\ntrim() as String\r\nReturns a copy of the string, with leading and trailing whitespace omitted.\r\n& Element-wise\r\n% Examples\r\n(\"  123  \")/trim();           # = {\"123\"}\r\n(\"    \", \" 123 \")[trim()=\"\"]; # = {\"    \"}\r\n\r\n--- normalize-space/0\r\nnormalize-space() as String\r\nReturns the value of the input string with whitespace normalized by stripping leading and trailing whitespace and replacing sequences of more than one whitespace character by a single space, #x20. \r\n& Element-wise\r\n\r\n--- normalize-unicode/1\r\nnormalize-unicode($normalizationForm as String) as String\r\nReturns the input string normalized according to the normalization criteria for a normalization form identified by the value of $normalizationForm. The effective value of the $normalizationForm is computed by removing leading and trailing blanks, if present, and converting to upper case.\r\n- If the $normalizationForm is absent, as in the first format above, it shall be assumed to be \"NFC\"\r\n- If the effective value of $normalizationForm is \"NFC\", then the value returned by the function is the value of $srcval in Unicode Normalization Form C (NFC).\r\n- If the effective value of $normalizationForm is \"NFD\", then the value returned by the function is the value of $srcval in Unicode Normalization Form D (NFD).\r\n- If the effective value of $normalizationForm is \"NFKC\", then the value returned by the function is the value of $srcval in Unicode Normalization Form KC (NFKC).\r\n- If the effective value of $normalizationForm is \"NFKD\", then the value returned by the function is the value of $srcval in Unicode Normalization Form KD (NFKD).\r\n- If the effective value of $normalizationForm is \"W3C\", then the value returned by the function is the value of $srcval is the fully normalized form. See [Character Model for the World Wide Web 1.0].\r\n- If the effective value of $normalizationForm is the zero-length string, no normalization is performed and $srcval is returned.\r\nIf the effective value of the $normalizationForm is other than one of the values supported by the implementation, then an error is raised (\"Unsupported normalization form\").\r\n&Element-wise\r\n\r\n*** upper-case/0\r\nupper-case() as String\r\nReturns the modified input string, in which each lower-case letter is replaced with its upper-case correspondent. All the other characters stay in their original form. \r\n&Element-wise\r\n% Examples\r\n(\"AaBbCc\", \"12Aab\")/upper-case(); # = {\"AABBCC\", \"12AAB\"}\r\n\r\n*** lower-case/0\r\nlower-case() as String\r\nReturns the modified input string, in which each upper-case letter is replaced with its lower-case counterpart. All the other characters stay in their original form. \r\n&Element-wise\r\n% Examples\r\n(\"AaBbCc\", \"12Aab\")/lower-case(); # = {\"aabbcc\", \"12aab\"}\r\n\r\n--- translate/2\r\ntranslate($mapString as String, $transString as String) as String\r\nReturns the  modified input string in which every character that occurs at some position N in the value of $mapString has been replaced by the character that occurs at position N in the value of $transString.\r\n\tEvery character in the input string that does not appear in the value of $mapString is unchanged.\r\n\tEvery character in the value of the input string that appears at some position M > length($transString), is omitted from the returned value.\r\n&Element-wise\r\n\r\n*** string-pad/1\r\nstring-pad($counter as Integer) as String\r\nReturns a string  consisting of $counter copies of the input string concatenated together without any separators. Returns the zero-length string if $counter = 0.\r\n&Element-wise\r\n% Examples\r\n(\"a\", \"bc\")/string-pad(5);                      # = {\"aaaaa\", \"bcbcbcbcbc\"}\r\n(\"a\", \"bc\")[string-pad(5)/string-length() = 5]; # = {\"a\"}\r\n\r\n--- escape-uri/1\r\nescape-uri($uri-string as String) as String\r\nThis function applies the URI escaping rules defined in section 2 of RFC 2396 as amended by (RFC 2732) to $uri-string. The effect of the function is to replace any special character in the string by an escape sequence of the form %xx%yy..., where xxyy... is the hexadecimal representation of the octets used to represent the character in UTF-8.\r\n&Element-wise\r\n\r\n%%% 4.4 Pattern Matching\r\n\r\n*** matches/2\r\nmatches($pattern as String, $flags as String) as String\r\n\r\nThe function returns true if $input  matches the regular expression supplied as $pattern; otherwise, it returns false.\r\n\tUnless the metacharacters ^ and $ are used as anchors, the string is considered to match the pattern if any substring matches the pattern. But if anchors are used, the anchors must match the start/end of the string (in string mode), or the start/end of a line (in multiline mode).\r\n\tSpecial variables $0, $1,..., $9 are assigned substrings of the input string matching the segments   of $pattern encloded in (...), as usual. Variables $0, ... are global in the context of meta2path. \r\n\tFlags:\r\n- m: If present, the match operates in multiline mode. Otherwise, the match operates in string mode.\r\n- i: If present, the match operates in case-insensitive mode. Otherwise, the match operates in case-sensitive mode. In case-sensitive mode, a character in the input string matches a character specified by the pattern only if the Unicode code-points match. In case-insensitive mode, a character in the input string matches a character specified by the pattern if there is a canonical caseless match between the two characters as defined in section 2.5 of Unicode Case Mappings.\r\n& Element-wise\r\n% Examples\r\n(\"Aaaaab\")/matches(\"(a*)(b)\", \"i\");                # = {\"Aaaaab\"}\r\n$0; # = {\"Aaaaab\"}\r\n$1; # = {\"Aaaaa\"}\r\n$2; # = {\"b\"}\r\n(\"1234\", \"abcd\")[matches(\"(.*)(.)\", \"\")[$2 = \"4\"]]; # = {\"1234\"}\r\n$0; # = {\"abcd\"}\r\n$1; # = {\"abc\"}\r\n$2; # = {\"d\"}\r\n\r\n*** replace/3\r\nreplace($pattern as String, $replacement as String, $flags as String) as String\r\nThe function returns the String that is obtained by replacing all non-overlapping substrings of this string, that match the given $pattern with the instantiated $replacement string.\r\n\tIf two overlapping substrings of the context string both match the $pattern, then only the first one (that is, the one whose first character comes first in the $input string) is replaced.\r\n\tWithin the $replacement string, the variables $1 to $9 may be used to refer to the substring captured by each of the first nine parenthesized sub-expressions in the regular expression. A literal $ symbol must be written as \\$. For each match of the pattern, these variables are assigned the value of the content of the relevant captured sub-expression, and the modified replacement string is then substituted for the characters in $input that matched the pattern.\r\n\tFlags are the same as for matches/2\r\n& Element-wise\r\n% Examples\r\n(\"...012...a1b...\", \" D1d \")/replace(\"(.)1(.)\", \"$21$1\", \"\");  # = {\"...210...b1a...\", \" d1D \"}\r\n(\"012\", \"D1d\")[replace(\"(.)1(.)\", \"$21$1\", \"\")/contains(\"2\")]; # = {\"012\"}\r\n\r\n*** split/2\r\nsplit($pattern as String, $flags as String) as Collection\r\nSplits the context string into a collection of strings, treating any substring which matches $pattern as a separator. Flags are interpreted as in matches/2\r\n& Element-wise\r\n% Examples\r\n(\"...012...a1b\", \"-D1d-\")/split(\"\\d\", \"\"); # = {\"...\", \"\", \"\", \"...a\", \"b\", \"-D\", \"d-\"}\r\n(\"...012...a1b\", \"-D1d-\")[split(\"\\d\", \"\")/string-length() = 1]; # = {\"...012...a1b\"} # the split collection of the first string contains \"b\".\r\n\r\n%%% 5 Collection and Boolean Operations\r\n\r\n... and \r\nReturns the collection of exactly those values, which satisfy both arguments of 'and'\r\n& Collection-wise\r\n\r\n... or \r\nReturns the collection of exactly those values, which satisfy at least one argument of 'or'\r\n& Collection-wise\r\n\r\n... not\r\nReturns the collection of those elements of the input collection which do NOT satisfy the argument of 'not'\r\n& Collection-wise\r\n\r\n*** index/1\r\nindex($i as Integer) as Value\r\nReturns $i'th element of the collection\r\n& Collection-wise\r\n\r\n*** count/0\r\ncount() as Integer\r\nCounts the number of elements in the collection\r\n& Collection-wise\r\n\r\n*** all-distinct/0\r\nall-distinct() as Colleciton\r\nRemoves the repetitions of values in the collection\r\n& Collection-wise\r\n\r\n*** last/0\r\nlast() as Value\r\nReturns the last element of the collection\r\n& Collection-wise\r\n\r\n*** iterator/1\r\niterator(col as Collection) as Value (with additional features for iteration)\r\nCreates a hidden iterator and returns the first value of the collection. \r\n& Static\r\n\r\n*** next/1\r\nnext(val as IteratedValue)\r\nReturns the next value of the iteratation hidden in val\r\n& Static\r\n\r\n*** eval/1\r\neval(pt as PathTerm) as Collection\r\nIn bxq it is possible to block the evaluation of a term by putting \"`\" before it. In this case the path term becomes an ordinary datum. For evaluation of the suspended expression, the function eval/1 is used. To evaluate <pt> in the context of C, we write C/evaluate(pt). \r\n& Element-wise\r\n% Example\r\nset $term {`. + 1}\r\n(1, 2)/eval($term); # = (2, 3)\r\n\r\n\r\n*** o-all/0\r\no-all() as Collection of Object\r\nCollects all objects, the values of all o-properties of the current context object.\r\n& Element-wise\r\n\r\n*** t-all/0\r\nt-all() as Collection of Data\r\nCollects all data, the values of all t-properties of the current context object.\r\n& Element-wise\r\n\r\n\r\n\r\n--- subset-of/2\r\nsubset-of(col1 as Collection, col2 as Collection) as Boolean\r\nChecks if the collection col1 is a subset of col2.\r\n& Static\r\n\r\n--- equal-sets/2\r\nequal-sets(col1 as Collection, col2 as Collection) as Boolean\r\n\r\n%%% 6 Type Operations\r\n\r\n*** is-integer/0\r\nis-integer()\r\nChecks if the context element is integer\r\n& Element-wise\r\n\r\n*** is-string/0\r\nis-string()\r\nChecks if the context element is string\r\n& Element-wise\r\n\r\n--- is-date/0\r\nis-date()\r\nChecks if the context element is data\r\n& Element-wise\r\n\r\n--- is-object/0\r\nis-object()\r\nChecks if the context element is object\r\n& Element-wise\r\n\r\n*** is-map/0\r\nis-map()\r\nChecks if the context element is map\r\n& Element-wise\r\n\r\n*** get-tkeys/0\r\nget-tkeys()\r\n\r\n& Element-wise\r\n\r\n*** t-okeys/0\r\nt-okeys()\r\n\r\n& Element-wise\r\n\r\n*** get-key/1\r\nget-key(key as String)\r\n\r\n& Element-wise\r\n\r\n\r\n%%% 7 Map Object Operations\r\n\r\n*** key-remove/1\r\nCollection of Map / key-remove(key as String) as String\r\nRemoves the key with its values from the context map element\r\n& Element-wise\r\n\r\n*** key-set/2\r\nCollection of Map / key-set(key as String, value as Object) as String\r\nSets new values to the key of the context map element, removing previous values (if there any).\r\n& Element-wise\r\n\r\n*** range/2\r\nCollection / range(start as Integer, length as Integer)\r\nReturns the subcollection of the context collection starting at the position start\r\n(the first position number is 0) and having length length. If length < 0, the function collects all elements from the start position to the end of the collection. If start < 0, the function counts down the starting position from the end of the collection (the last element has number -1). \r\n& Collection-wise\r\n%Example\r\n(1,2,3,4,5,6,7)/range(2, 3)  # = (3,4,5)\r\n(1,2,3,4,5,6,7)/range(3, -1)  # = (4,5,6,7)\r\n(1,2,3,4,5,6,7)/range(-2, 2)  # = (5,6)\r\n(1,2,3,4,5,6,7)/range(-2, -1)  # = (1,2,3,4,5,6)\r\n\r\n*** split-col/1\r\nsplit-col(lng as Integer) as Collection of Map\r\nSplits the context collection by portions of lng elements. Each portion is formed as a map object with two properties: \"key\" contains the number of the starting element in the initial collection; \"value\" contains the collection containing the current portion of elements\r\n& Collection-wise\r\n% Examples\r\n(1,2,3,4,5,6,7)/split-col(3)/(\"[\" + key + \"] \" + value/join(\"-\")); # = {\"[0] 1-2-3\", \"[3] 4-5-6\", \"[6] 7\"}\r\n\r\n*** map-split-starts/3\r\nmap-split-starts(modified as Path, check-path as Path, new-key as String)\r\n\r\n& Collection-wise\r\n\r\n*** split-col/3\r\nsplit-col(chkpath as PathTerm, keypath as PathTerm, type as String) as Collection of Map\r\nSplits the context collection by portions depending on the splitting <type>:\r\nEach portion is represented by a map element\r\n&{key := eval(<keypath>), value := <the portion of elements>}\r\n\r\n\"different\" - the initial collection is splitted between two neighbor elements, if the value of path on them is different\r\n\"starts.with\" - the element starts new portion if path on it is true (non-empty)\r\n\"starts.after\" - the next portion starts immediately after the elements, on which <path> is true (non-empty)\r\n<chkpath> selects elements determining splitting\r\n<key> \r\n& Collection-wise\r\n% Examples\r\n\r\n*** split-col/5\r\nsplit-col(chkpath as PathTerm, key as PathTerm, type as String, keyname as String, valuename) as Collection of Map\r\nThe same as split-col/3 but the user can determine his/her own property names of map objects:\r\n&{<keyname> := eval(<keypath>), <valuename> := <the portion of elements>}\r\n& Collection-wise\r\n% Examples\r\n\r\n%%% 8 Ontobox Model Operations\r\n\r\n*** get-uri/0\r\n[`ont* | `Cls | &obj | `&obj | `prop] get-uri();\r\nGets URI of the Ontobox entity represented by the context value. \r\n& Element-wise\r\n\r\n*** get-entity-by-uri/0\r\n[xsd:string] get-entity-by-uri();\r\nGets the entity in the Ontobox corresponding to the URI represented by the context string.  \r\n& Element-wise\r\n\r\n*** set-uri/1\r\n[`ont*] set-uri(URI as xsd:string);\r\nSets the URI of the ontology.\r\n& Element-wise\r\n\r\n*** set-name/1\r\n[&obj | `Cls | `&obj | `prop] set-name(name as xsd:string);\r\nSets the new name of the Ontobox entity represented by the context value.\r\n& Element-wise\r\n\r\n*** get-name/0\r\n[`Cls | &obj | `&obj | `prop] get-name();\r\nGets the name of the Ontobox entity represented by the context value.\r\n\r\n\r\n*** get-ontology/0\r\n[`Cls | &obj | `&obj | `prop] get-ontology();\r\nGets the ontology in which the Ontobox entity represented by the context value is defined.\r\n& Element-wise\r\n\r\n*** create-class/1\r\n[`ont*] create-class(name as xsd:string);\r\nCreates a new class in the ontology represented by the context value. The argument name is the short name of the new class within the ontology.\r\n& Element-wise\r\n\r\n*** get-all-classes/0\r\n[`ont*] get-all-classes();\r\nGets all classes defined in the ontology represented by the context value.\r\n& Element-wise\r\n\r\n*** add-subclass/1\r\n[`Cls1] add-subclass(`Cls2);\r\nDeclares the class in the argument as the subclass of the class represented by the context value. \r\n& Element-wise\r\n\r\n*** get-all-oprops/0\r\n[`ont* | `Cls | `&obj | &obj] get-all-oprops();\r\nGets all properties of the context value, which can be a quoted ontology, a quoted class, a quoted or ordinary object. \r\n& Element-wise\r\n\r\n*** get-all-tprops/0\r\n[`ont* | `Cls | `&obj | &obj] get-all-tprops();\r\nGets all t-properties of the ontology or entity in the context.\r\n& Element-wise\r\n\r\n*** get-all-superclasses/0\r\n[`Cls] get-all-superclasses();\r\nGets all superclasses (direct and indirect) of the quoted class in the context.\r\n& Element-wise\r\n\r\n*** get-all-subclasses/0\r\n[`Cls] get-all-subclasses();\r\nGet all subclasses (direct and indirect) of the quoted class in the context.\r\n& Element-wise\r\n\r\n*** get-direct-objects/0\r\n[`Cls] get-direct-objects();\r\nGets all direct objects of the quoted class in the context (i.e. those explicitly defined in the class).\r\n& Element-wise\r\n\r\n*** get-direct-oprops/0\r\n[`Cls] get-direct-oprops();\r\nGet direct o-properties of the class (i.e. for which the class is declared as their domain).\r\n& Element-wise\r\n\r\n*** get-direct-tprops/1\r\n[`Cls] get-direct-tprops();\r\nGet direct t-properties of the class (i.e. for which the class is declared as their domain).\r\n& Element-wise\r\n\r\n*** get-direct-superclasses/0\r\n[`Cls] get-direct-superclasses();\r\nGet direct superclasses of the class (i.e. those for which the current class is explicitly declared as their subclass).\r\n& Element-wise\r\n\r\n*** get-direct-subclasses/0\r\n[`Cls] get-direct-subclasses();\r\nGet direct superclasses of the class (i.e. those for which the current class is explicitly declared as their superclass).\r\n& Element-wise\r\n\r\n*** delete/0\r\n[`ont* | `Cls | &obj | `&obj | `prop] delete();\r\nRemoves from the Ontobox the ontology or entity. This operation succeeds only if no other entity stored in the Ontobox depends on the deleted entity.\r\n& Element-wise \r\n\r\n*** is-subclass-of/1\r\n[`Cls1] is-subclass-of(`Cls2);\r\nTrue if the context class is the (direct or indirect) subclass of the class in the argument. \r\n& Element-wise\r\n\r\n*** get-domain/0\r\n[`prop] get-domain();\r\nGets the domain class of the property.\r\n& Element-wise\r\n\r\n*** get-range/0\r\n[`prop] get-range();\r\nGets the range of the property (a class in case of o-properties and datatype in case of t-properties).\r\n& Element-wise\r\n\r\n*** get-max-card/0\r\n[`prop] get-max-card();\r\nGets max cardinality of the property (default value: infinity denoted by -1).\r\n& Element-wise\r\n\r\n*** get-min-card/0\r\n[`prop] get-min-card();\r\nGets min cardinality of the property (default value: 0).\r\n& Element-wise\r\n\r\n*** annotate/2 \r\n[`ont* | `C | `&obj | &obj] annotate(key as xsd:string*, value as xsd:string*);\r\nSets annotation named key and valued value to the current context object. If key and value are collections then sets as annotations the pairs key[i]/value[i].\r\n& Element-wise\r\n\r\n*** get-annotation/1\r\n[`ont* | `C | `&obj | &obj] get-annotation(key as xsd:string);\r\nReturns the value of the annotation named key assigned to the context object.\r\n& Element-wise\r\n\r\n%%% 9 Input/Output Operations\r\n\r\n*** read/1\r\nread(filename as String) as String\r\nReads a string from the file\r\n& Static\r\n\r\n*** write/2\r\nwrite(filename as String, output as Value)\r\nWrites the context value to the new file\r\n& Static\r\n\r\n*** print/0\r\n[.] print() as Value\r\nPrints the context value in stdout stream. Returns the input value.\r\n& Element-wise\r\n\r\n*** println/0\r\nprintln() as Value\r\nPrints the context value in stdout stream with finishing new line. Returns the input value.\r\n& Element-wise\r\n\r\n--- error($message as String)\r\nReturns nothing. $message is published in error stream.\r\n& Element-wise\r\n\r\n--- trace($val as Value, comment as String)\r\nReturns $val. Puts in trace stream the value of $any and the comment. \r\n& Element-wise\r\n\r\n"}));
        expected.add(new CH(false, new Object[]{"*** add-subclass/1", "*** all-distinct/0", "*** annotate/2", "*** apply-property/1", "*** codes-to-string/0", "*** codes-to-strings/1", "*** compare/1", "*** contains/1", "*** count/0", "*** create-class/1", "*** delete/0", "*** ends-with/1", "*** eval/1", "*** get-all-classes/0", "*** get-all-oprops/0", "*** get-all-subclasses/0", "*** get-all-superclasses/0", "*** get-all-tprops/0", "*** get-annotation/1", "*** get-direct-objects/0", "*** get-direct-oprops/0", "*** get-direct-subclasses/0", "*** get-direct-superclasses/0", "*** get-direct-tprops/1", "*** get-domain/0", "*** get-entity-by-uri/0", "*** get-key/1", "*** get-max-card/0", "*** get-min-card/0", "*** get-name/0", "*** get-ontology/0", "*** get-range/0", "*** get-tkeys/0", "*** get-uri/0", "*** index/1", "*** is-integer/0", "*** is-map/0", "*** is-string/0", "*** is-subclass-of/1", "*** iterator/1", "*** join/1", "*** key-remove/1", "*** key-set/2", "*** last/0", "*** lower-case/0", "*** map-split-starts/3", "*** matches/2", "*** next/1", "*** nl/0", "*** o-all/0", "*** object-classes/0", "*** object-id/0", "*** object-properties/0", "*** object-uri/0", "*** print/0", "*** println/0", "*** range/2", "*** read/1", "*** replace/3", "*** set-name/1", "*** set-uri/1", "*** split-col/1", "*** split-col/3", "*** split-col/5", "*** split/2", "*** starts-with/1", "*** string-length/0", "*** string-pad/1", "*** string-to-codes/0", "*** strings-to-codes/1", "*** substring/2", "*** t-all/0", "*** t-okeys/0", "*** to-string/0", "*** trim/0", "*** upper-case/0", "*** uri-kind/0", "*** uri-object/0", "*** value-kind/0", "*** write/2"}));
        expected.add(new CH(false, new Object[]{"add-subclass/1\r\nall-distinct/0\r\nannotate/2\r\napply-property/1\r\ncodes-to-string/0\r\ncodes-to-strings/1\r\ncompare/1\r\ncontains/1\r\ncount/0\r\ncreate-class/1\r\ndelete/0\r\nends-with/1\r\neval/1\r\nget-all-classes/0\r\nget-all-oprops/0\r\nget-all-subclasses/0\r\nget-all-superclasses/0\r\nget-all-tprops/0\r\nget-annotation/1\r\nget-direct-objects/0\r\nget-direct-oprops/0\r\nget-direct-subclasses/0\r\nget-direct-superclasses/0\r\nget-direct-tprops/1\r\nget-domain/0\r\nget-entity-by-uri/0\r\nget-key/1\r\nget-max-card/0\r\nget-min-card/0\r\nget-name/0\r\nget-ontology/0\r\nget-range/0\r\nget-tkeys/0\r\nget-uri/0\r\nindex/1\r\nis-integer/0\r\nis-map/0\r\nis-string/0\r\nis-subclass-of/1\r\niterator/1\r\njoin/1\r\nkey-remove/1\r\nkey-set/2\r\nlast/0\r\nlower-case/0\r\nmap-split-starts/3\r\nmatches/2\r\nnext/1\r\nnl/0\r\no-all/0\r\nobject-classes/0\r\nobject-id/0\r\nobject-properties/0\r\nobject-uri/0\r\nprint/0\r\nprintln/0\r\nrange/2\r\nread/1\r\nreplace/3\r\nset-name/1\r\nset-uri/1\r\nsplit-col/1\r\nsplit-col/3\r\nsplit-col/5\r\nsplit/2\r\nstarts-with/1\r\nstring-length/0\r\nstring-pad/1\r\nstring-to-codes/0\r\nstrings-to-codes/1\r\nsubstring/2\r\nt-all/0\r\nt-okeys/0\r\nto-string/0\r\ntrim/0\r\nupper-case/0\r\nuri-kind/0\r\nuri-object/0\r\nvalue-kind/0\r\nwrite/2"}));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{"[0] 1-2-3", "[3] 4-5-6", "[6] 7"}));
        expected.add(new CH(false, new Object[]{"[0] 1-2-3", "[3] 4-5-6", "[6] 7"}));
        expected.add(new CH(false, new Object[]{"[0] 1-2", "[2] 3-4", "[4] 5-6", "[6] 7"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj0"), new OH("http://temp#new-name"), new OH("http://temp#obj2")}));
        expected.add(new CH(false, new Object[]{"name0", "name1", "name2"}));
        expected.add(new CH(false, new Object[]{"name0", "name1", "name2"}));
        expected.add(new CH(false, new Object[]{"name1", "name2"}));
        expected.add(new CH(false, new Object[]{"name1", "name2"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj0")}));
        expected.add(new CH(false, new Object[]{"name0", "name1", 115, "name2", 2}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{"a1: 1-2", "a3: 3"}));
        expected.add(new CH(false, new Object[]{"115-name1-name1"}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name"), new OH("http://temp#obj2")}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{2, 3}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"1"}));
        expected.add(new CH(false, new Object[]{"1"}));
        expected.add(new CH(false, new Object[]{"act", "aet", "agt", "art", "ast", "africa/abidjan", "africa/accra", "africa/addis_ababa", "africa/algiers", "africa/asmara", "africa/asmera", "africa/bamako", "africa/bangui", "africa/banjul", "africa/bissau", "africa/blantyre", "africa/brazzaville", "africa/bujumbura", "africa/cairo", "africa/casablanca", "africa/ceuta", "africa/conakry", "africa/dakar", "africa/dar_es_salaam", "africa/djibouti", "africa/douala", "africa/el_aaiun", "africa/freetown", "africa/gaborone", "africa/harare", "africa/johannesburg", "africa/kampala", "africa/khartoum", "africa/kigali", "africa/kinshasa", "africa/lagos", "africa/libreville", "africa/lome", "africa/luanda", "africa/lubumbashi", "africa/lusaka", "africa/malabo", "africa/maputo", "africa/maseru", "africa/mbabane", "africa/mogadishu", "africa/monrovia", "africa/nairobi", "africa/ndjamena", "africa/niamey", "africa/nouakchott", "africa/ouagadougou", "africa/porto-novo", "africa/sao_tome", "africa/timbuktu", "africa/tripoli", "africa/tunis", "africa/windhoek", "america/adak", "america/anchorage", "america/anguilla", "america/antigua", "america/araguaina", "america/argentina/buenos_aires", "america/argentina/catamarca", "america/argentina/comodrivadavia", "america/argentina/cordoba", "america/argentina/jujuy", "america/argentina/la_rioja", "america/argentina/mendoza", "america/argentina/rio_gallegos", "america/argentina/salta", "america/argentina/san_juan", "america/argentina/san_luis", "america/argentina/tucuman", "america/argentina/ushuaia", "america/aruba", "america/asuncion", "america/atikokan", "america/atka", "america/bahia", "america/barbados", "america/belem", "america/belize", "america/blanc-sablon", "america/boa_vista", "america/bogota", "america/boise", "america/buenos_aires", "america/cambridge_bay", "america/campo_grande", "america/cancun", "america/caracas", "america/catamarca", "america/cayenne", "america/cayman", "america/chicago", "america/chihuahua", "america/coral_harbour", "america/cordoba", "america/costa_rica", "america/cuiaba", "america/curacao", "america/danmarkshavn", "america/dawson", "america/dawson_creek", "america/denver", "america/detroit", "america/dominica", "america/edmonton", "america/eirunepe", "america/el_salvador", "america/ensenada", "america/fort_wayne", "america/fortaleza", "america/glace_bay", "america/godthab", "america/goose_bay", "america/grand_turk", "america/grenada", "america/guadeloupe", "america/guatemala", "america/guayaquil", "america/guyana", "america/halifax", "america/havana", "america/hermosillo", "america/indiana/indianapolis", "america/indiana/knox", "america/indiana/marengo", "america/indiana/petersburg", "america/indiana/tell_city", "america/indiana/vevay", "america/indiana/vincennes", "america/indiana/winamac", "america/indianapolis", "america/inuvik", "america/iqaluit", "america/jamaica", "america/jujuy", "america/juneau", "america/kentucky/louisville", "america/kentucky/monticello", "america/knox_in", "america/la_paz", "america/lima", "america/los_angeles", "america/louisville", "america/maceio", "america/managua", "america/manaus", "america/marigot", "america/martinique", "america/mazatlan", "america/mendoza", "america/menominee", "america/merida", "america/mexico_city", "america/miquelon", "america/moncton", "america/monterrey", "america/montevideo", "america/montreal", "america/montserrat", "america/nassau", "america/new_york", "america/nipigon", "america/nome", "america/noronha", "america/north_dakota/center", "america/north_dakota/new_salem", "america/panama", "america/pangnirtung", "america/paramaribo", "america/phoenix", "america/port-au-prince", "america/port_of_spain", "america/porto_acre", "america/porto_velho", "america/puerto_rico", "america/rainy_river", "america/rankin_inlet", "america/recife", "america/regina", "america/resolute", "america/rio_branco", "america/rosario", "america/santarem", "america/santiago", "america/santo_domingo", "america/sao_paulo", "america/scoresbysund", "america/shiprock", "america/st_barthelemy", "america/st_johns", "america/st_kitts", "america/st_lucia", "america/st_thomas", "america/st_vincent", "america/swift_current", "america/tegucigalpa", "america/thule", "america/thunder_bay", "america/tijuana", "america/toronto", "america/tortola", "america/vancouver", "america/virgin", "america/whitehorse", "america/winnipeg", "america/yakutat", "america/yellowknife", "antarctica/casey", "antarctica/davis", "antarctica/dumontdurville", "antarctica/mawson", "antarctica/mcmurdo", "antarctica/palmer", "antarctica/rothera", "antarctica/south_pole", "antarctica/syowa", "antarctica/vostok", "arctic/longyearbyen", "asia/aden", "asia/almaty", "asia/amman", "asia/anadyr", "asia/aqtau", "asia/aqtobe", "asia/ashgabat", "asia/ashkhabad", "asia/baghdad", "asia/bahrain", "asia/baku", "asia/bangkok", "asia/beirut", "asia/bishkek", "asia/brunei", "asia/calcutta", "asia/choibalsan", "asia/chongqing", "asia/chungking", "asia/colombo", "asia/dacca", "asia/damascus", "asia/dhaka", "asia/dili", "asia/dubai", "asia/dushanbe", "asia/gaza", "asia/harbin", "asia/ho_chi_minh", "asia/hong_kong", "asia/hovd", "asia/irkutsk", "asia/istanbul", "asia/jakarta", "asia/jayapura", "asia/jerusalem", "asia/kabul", "asia/kamchatka", "asia/karachi", "asia/kashgar", "asia/kathmandu", "asia/katmandu", "asia/kolkata", "asia/krasnoyarsk", "asia/kuala_lumpur", "asia/kuching", "asia/kuwait", "asia/macao", "asia/macau", "asia/magadan", "asia/makassar", "asia/manila", "asia/muscat", "asia/nicosia", "asia/novosibirsk", "asia/omsk", "asia/oral", "asia/phnom_penh", "asia/pontianak", "asia/pyongyang", "asia/qatar", "asia/qyzylorda", "asia/rangoon", "asia/riyadh", "asia/riyadh87", "asia/riyadh88", "asia/riyadh89", "asia/saigon", "asia/sakhalin", "asia/samarkand", "asia/seoul", "asia/shanghai", "asia/singapore", "asia/taipei", "asia/tashkent", "asia/tbilisi", "asia/tehran", "asia/tel_aviv", "asia/thimbu", "asia/thimphu", "asia/tokyo", "asia/ujung_pandang", "asia/ulaanbaatar", "asia/ulan_bator", "asia/urumqi", "asia/vientiane", "asia/vladivostok", "asia/yakutsk", "asia/yekaterinburg", "asia/yerevan", "atlantic/azores", "atlantic/bermuda", "atlantic/canary", "atlantic/cape_verde", "atlantic/faeroe", "atlantic/faroe", "atlantic/jan_mayen", "atlantic/madeira", "atlantic/reykjavik", "atlantic/south_georgia", "atlantic/st_helena", "atlantic/stanley", "australia/act", "australia/adelaide", "australia/brisbane", "australia/broken_hill", "australia/canberra", "australia/currie", "australia/darwin", "australia/eucla", "australia/hobart", "australia/lhi", "australia/lindeman", "australia/lord_howe", "australia/melbourne", "australia/nsw", "australia/north", "australia/perth", "australia/queensland", "australia/south", "australia/sydney", "australia/tasmania", "australia/victoria", "australia/west", "australia/yancowinna", "bet", "bst", "brazil/acre", "brazil/denoronha", "brazil/east", "brazil/west", "cat", "cet", "cnt", "cst", "cst6cdt", "ctt", "canada/atlantic", "canada/central", "canada/east-saskatchewan", "canada/eastern", "canada/mountain", "canada/newfoundland", "canada/pacific", "canada/saskatchewan", "canada/yukon", "chile/continental", "chile/easterisland", "cuba", "eat", "ect", "eet", "est", "est5edt", "egypt", "eire", "etc/gmt", "etc/gmt+0", "etc/gmt+1", "etc/gmt+10", "etc/gmt+11", "etc/gmt+12", "etc/gmt+2", "etc/gmt+3", "etc/gmt+4", "etc/gmt+5", "etc/gmt+6", "etc/gmt+7", "etc/gmt+8", "etc/gmt+9", "etc/gmt-0", "etc/gmt-1", "etc/gmt-10", "etc/gmt-11", "etc/gmt-12", "etc/gmt-13", "etc/gmt-14", "etc/gmt-2", "etc/gmt-3", "etc/gmt-4", "etc/gmt-5", "etc/gmt-6", "etc/gmt-7", "etc/gmt-8", "etc/gmt-9", "etc/gmt0", "etc/greenwich", "etc/uct", "etc/utc", "etc/universal", "etc/zulu", "europe/amsterdam", "europe/andorra", "europe/athens", "europe/belfast", "europe/belgrade", "europe/berlin", "europe/bratislava", "europe/brussels", "europe/bucharest", "europe/budapest", "europe/chisinau", "europe/copenhagen", "europe/dublin", "europe/gibraltar", "europe/guernsey", "europe/helsinki", "europe/isle_of_man", "europe/istanbul", "europe/jersey", "europe/kaliningrad", "europe/kiev", "europe/lisbon", "europe/ljubljana", "europe/london", "europe/luxembourg", "europe/madrid", "europe/malta", "europe/mariehamn", "europe/minsk", "europe/monaco", "europe/moscow", "europe/nicosia", "europe/oslo", "europe/paris", "europe/podgorica", "europe/prague", "europe/riga", "europe/rome", "europe/samara", "europe/san_marino", "europe/sarajevo", "europe/simferopol", "europe/skopje", "europe/sofia", "europe/stockholm", "europe/tallinn", "europe/tirane", "europe/tiraspol", "europe/uzhgorod", "europe/vaduz", "europe/vatican", "europe/vienna", "europe/vilnius", "europe/volgograd", "europe/warsaw", "europe/zagreb", "europe/zaporozhye", "europe/zurich", "gb", "gb-eire", "gmt", "gmt0", "greenwich", "hst", "hongkong", "iet", "ist", "iceland", "indian/antananarivo", "indian/chagos", "indian/christmas", "indian/cocos", "indian/comoro", "indian/kerguelen", "indian/mahe", "indian/maldives", "indian/mauritius", "indian/mayotte", "indian/reunion", "iran", "israel", "jst", "jamaica", "japan", "kwajalein", "libya", "met", "mit", "mst", "mst7mdt", "mexico/bajanorte", "mexico/bajasur", "mexico/general", "mideast/riyadh87", "mideast/riyadh88", "mideast/riyadh89", "net", "nst", "nz", "nz-chat", "navajo", "plt", "pnt", "prc", "prt", "pst", "pst8pdt", "pacific/apia", "pacific/auckland", "pacific/chatham", "pacific/easter", "pacific/efate", "pacific/enderbury", "pacific/fakaofo", "pacific/fiji", "pacific/funafuti", "pacific/galapagos", "pacific/gambier", "pacific/guadalcanal", "pacific/guam", "pacific/honolulu", "pacific/johnston", "pacific/kiritimati", "pacific/kosrae", "pacific/kwajalein", "pacific/majuro", "pacific/marquesas", "pacific/midway", "pacific/nauru", "pacific/niue", "pacific/norfolk", "pacific/noumea", "pacific/pago_pago", "pacific/palau", "pacific/pitcairn", "pacific/ponape", "pacific/port_moresby", "pacific/rarotonga", "pacific/saipan", "pacific/samoa", "pacific/tahiti", "pacific/tarawa", "pacific/tongatapu", "pacific/truk", "pacific/wake", "pacific/wallis", "pacific/yap", "poland", "portugal", "rok", "sst", "singapore", "systemv/ast4", "systemv/ast4adt", "systemv/cst6", "systemv/cst6cdt", "systemv/est5", "systemv/est5edt", "systemv/hst10", "systemv/mst7", "systemv/mst7mdt", "systemv/pst8", "systemv/pst8pdt", "systemv/yst9", "systemv/yst9ydt", "turkey", "uct", "us/alaska", "us/aleutian", "us/arizona", "us/central", "us/east-indiana", "us/eastern", "us/hawaii", "us/indiana-starke", "us/michigan", "us/mountain", "us/pacific", "us/pacific-new", "us/samoa", "utc", "universal", "vst", "w-su", "wet", "zulu"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"utc"}));
        expected.add(new CH(false, new Object[]{"asia/irkutsk"}));
        expected.add(new CH(false, new Object[]{"europe/moscow"}));
        expected.add(new CH(false, new Object[]{"europe/moscow", "asia/irkutsk", "utc"}));
        expected.add(new CH(false, new Object[]{"2009-10-24T17:12:34.567"}));
        expected.add(new CH(false, new Object[]{"2009-10-25T01:00:00.000+0000"}));
        expected.add(new CH(false, new Object[]{"asia/irkutsk"}));
        expected.add(new CH(false, new Object[]{"2009-10-25 01:00"}));
        expected.add(new CH(false, new Object[]{"1970-10-10"}));
        expected.add(new CH(false, new Object[]{"1980-01-01T00:20:34.567Z"}));
        expected.add(new CH(false, new Object[]{2009, 1970, 70}));
        expected.add(new CH(false, new Object[]{12}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{6}));
        expected.add(new CH(false, new Object[]{20, 5}));
        expected.add(new CH(false, new Object[]{21, 2}));
        expected.add(new CH(false, new Object[]{34, 0}));
        expected.add(new CH(false, new Object[]{"09/10/1970", "11/10/2003", "12/10/2002"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://temp#a")}));
        expected.add(new CH(false, new Object[]{"2002-10-12", "2009-10-25T01:00:00.000-0500"}));
        expected.add(new CH(false, new Object[]{0, 14}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"123", "Hello", "---"}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"456", "Goodbye", "+++"}));
        expected.add(new CH(false, new Object[]{"456", "Goodbye", "+++", "123", "Hello", "---"}));
        expected.add(new CH(false, new Object[]{"text", "text"}));
        expected.add(new CH(false, new Object[]{"Hello", "---"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{5, 6, 7, 8, 9, 10}));
        expected.add(new CH(false, new Object[]{1, 2, "hello", 5, 6, 7}));
        expected.add(new CH(false, new Object[]{"Moscow"}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"address"}));
        expected.add(new CH(false, new Object[]{"Moscow+&Irkutsk"}));
        expected.add(new CH(false, new Object[]{"<town >\n\tIrkutsk\n</town>\r\n<town >\n\tParis\n</town>\r\n<town >\n\tno-town\n</town>\r\n<town >\n\tMoscow\n</town>"}));
        expected.add(new CH(false, new Object[]{"<village  location=\"near Lake Baikal\">\n    \tmy dacha\n\t</village>"}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{"<city  name=\"Irkutsk\" location=\"near Lake Baikal\">\n\t\t\tmy town\n\t</city>"}));
        expected.add(new CH(false, new Object[]{"city"}));
        expected.add(new CH(false, new Object[]{"Irkutsk"}));
        expected.add(new CH(false, new Object[]{"my town"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"<country  name=\"Russia\">\n\t\t<city  name=\"Irkutsk\" location=\"near Lake Baikal\">\n\t\t\tmy town\n\t</city>\n</country>"}));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH(null)}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d1")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d2")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d3")}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj0"), new OH("http://temp#new-name"), new OH("http://temp#obj2"), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new OH(null), new OH("http://temp#d1"), new OH("http://temp#d2"), new OH("http://temp#d3"), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new OH("http://temp#a"), new TempH(), new TempH(), new TempH(), new OH("http://temp#ob1"), new OH("http://temp#ob2"), new OH("http://temp#oo")}));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d1"), new OH("http://temp#d2"), new OH("http://temp#d3")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d1"), new OH("http://temp#d2")}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{-1}));
        expected.add(new CH(false, new Object[]{0}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{2}));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{"http://a#ququ"}));
        expected.add(new CH(false, new Object[]{"1"}));
        expected.add(null);
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{"http://aa", "http://aa#C", "http://aa#st", "http://aa#obj1"}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{"1"}));
        expected.add(new CH(false, new Object[]{"http://aa#obj1"}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{"http://temp#obj1"}));
        expected.add(new CH(false, new Object[]{"1"}));
        expected.add(null);
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{true}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#new-name")}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{1}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#obj2")}));
        expected.add(new CH(false, new Object[]{"d"}));
        expected.add(new CH(false, new Object[]{"D", "st", "new-name"}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[0]));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH(), new TokenH(), new TokenH()}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d3")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d3")}));
        expected.add(new CH(false, new Object[]{new OH("http://temp#d3")}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{new OH("http://q#newobj")}));
        expected.add(new CH(false, new Object[]{new OH("http://q#newobj")}));
        expected.add(new CH(false, new Object[]{new OH("http://q#newobj")}));
        expected.add(new CH(false, new Object[]{new OH("http://q#newobj")}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{"c"}));
        expected.add(new CH(false, new Object[]{"a", "d"}));
        expected.add(new CH(false, new Object[]{"a", "d"}));
        expected.add(new CH(false, new Object[]{40, 50}));
        expected.add(new CH(false, new Object[]{0, 4}));
        expected.add(new CH(false, new Object[]{40}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{100}));
        expected.add(new CH(false, new Object[]{3}));
        expected.add(new CH(false, new Object[]{1, 3, 5}));
        expected.add(new CH(false, new Object[]{new TokenH()}));
        expected.add(new CH(false, new Object[]{5}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{new TempH()}));
        expected.add(new CH(false, new Object[]{new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new OH("http://teacode.com/people#paul"), new OH("http://teacode.com/people#tom"), new OH("http://teacode.com/people#ann"), new OH("http://teacode.com/people#john"), new OH("http://teacode.com/people#marie"), new OH("http://teacode.com/people#tim"), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new OH("http://teacode.com/tribe#mongo"), new OH("http://teacode.com/tribe#tongo"), new OH("http://teacode.com/prop-management#obj1"), new OH("http://teacode.com/prop-management#obj2"), new OH("http://teacode.com/prop-management#obj3"), new OH("http://temp#obj0"), new OH("http://temp#new-name"), new OH("http://temp#obj2"), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new OH("http://temp#d1"), new OH("http://temp#d2"), new OH("http://temp#d3"), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new OH("http://temp#a"), new TempH(), new TempH(), new TempH(), new OH("http://temp#ob1"), new OH("http://temp#ob2"), new OH("http://temp#oo"), new TempH(), new OH("http://q#newobj"), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH(), new TempH()}));
        expected.add(new CH(false, new Object[]{"ha-2-45-b-d"}));
        expected.add(new CH(false, new Object[]{"ha", "-2-45", "-b-d"}));
        expected.add(new CH(false, new Object[]{"ha", "-2-45", "-b-d"}));
        expected.add(new CH(false, new Object[]{"a", "b", "c", "d"}));
        expected.add(new CH(false, new Object[]{"aa", "bb", "cc", "dd"}));
        expected.add(new CH(false, new Object[]{"dd", "dd", "dd", "dd"}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{5}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{5, 5, 5, 5}));
        expected.add(null);
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#haha")}));
        expected.add(new CH(false, new Object[]{1, 2}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#haha")}));
        expected.add(new CH(false, new Object[]{2, 3}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#haha")}));
        expected.add(new CH(false, new Object[]{3, 3}));
        expected.add(new CH(false, new Object[]{new TempH(), new TempH(), new TempH()}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#haha"), new TempH(), new TempH(), new TempH()}));
        expected.add(new CH(false, new Object[]{3, 3, 1, 2, 3}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#a"), new OH("http://teacode.com/2010-01-18#a"), new OH("http://teacode.com/2010-01-18#a")}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#haha"), new TempH(), new TempH(), new TempH(), new OH("http://teacode.com/2010-01-18#a")}));
        expected.add(new CH(false, new Object[]{3, 3, 1, 2, 3, 4, 5, 6}));
        expected.add(new CH(false, new Object[]{5}));
        expected.add(new CH(false, new Object[]{"5"}));
        expected.add(new CH(false, new Object[]{new TempH(), new TempH()}));
        expected.add(new CH(false, new Object[]{"1", "2"}));
        expected.add(null);
        expected.add(null);
        expected.add(new CH(false, new Object[]{1, 2, 1, 2}));
        expected.add(new CH(false, new Object[]{2, 3}));
        expected.add(new CH(false, new Object[]{115}));
        expected.add(new CH(false, new Object[]{115}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#ii"), new OH("http://teacode.com/2010-01-18#i1"), new TempH()}));
        expected.add(new CH(false, new Object[]{7}));
        expected.add(new CH(false, new Object[]{9, 10, 11}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#i1")}));
        expected.add(new CH(false, new Object[]{3, 3, 1, 2, 3, 4, 5, 6, 2, 2, 2, 9, 19, 10, 20, 11, 21, 5}));
        expected.add(new CH(false, new Object[]{new TempH(), new TempH()}));
        expected.add(new CH(false, new Object[]{new OH("http://teacode.com/2010-01-18#a"), new TempH()}));
        Test.assertCollection(con, expected, result);
    }

    private static class TempH {
        private TempH() {
        }

        public boolean equals(Object obj) {
            return obj instanceof TempH;
        }
    }

    private static class TokenH {
        private TokenH() {
        }

        public boolean equals(Object obj) {
            return obj instanceof TokenH;
        }
    }

    private static class CH {
        private final boolean ordered;
        private final List<Object> col;

        private CH(boolean ordered, Object ... objs) {
            this.ordered = ordered;
            this.col = new ArrayList<Object>();
            this.col.addAll(Arrays.asList(objs));
        }
    }

    private static class OH {
        private final String objectFullName;

        private OH(String objectFullName) {
            this.objectFullName = objectFullName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OH) {
                OH oh = (OH)obj;
                return this.objectFullName == null && oh.objectFullName == null || this.objectFullName.equals(oh.objectFullName);
            }
            return false;
        }
    }
}

